/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.actions;

import freemind.controller.actions.generated.instance.MoveNodeXmlAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapController;
import freemind.modes.mindmapmode.actions.NodeActorXml;
import freemind.modes.mindmapmode.actions.NodeGeneralAction;
import freemind.modes.mindmapmode.actions.xml.ActionPair;

public class MoveNodeAction
extends NodeGeneralAction
implements NodeActorXml {
    private final MindMapController modeController;

    public MoveNodeAction(MindMapController modeController) {
        super(modeController, "reset_node_position", (String)null);
        this.modeController = modeController;
        this.addActor(this);
    }

    public void act(XmlAction action) {
        MoveNodeXmlAction moveAction = (MoveNodeXmlAction)action;
        NodeAdapter node = this.getNodeFromID(moveAction.getNode());
        node.setHGap(moveAction.getHGap());
        node.setShiftY(moveAction.getShiftY());
        if (!node.isRoot()) {
            node.getParentNode().setVGap(moveAction.getVGap());
        }
        this.modeController.nodeChanged(node);
    }

    public Class getDoActionClass() {
        return MoveNodeXmlAction.class;
    }

    public ActionPair apply(MindMap model, MindMapNode selected) {
        if (selected.isRoot()) {
            return null;
        }
        return this.getActionPair(selected, 3, 20, 0);
    }

    private ActionPair getActionPair(MindMapNode selected, int parentVGap, int hGap, int shiftY) {
        MoveNodeXmlAction moveAction = this.moveNode(selected, parentVGap, hGap, shiftY);
        MoveNodeXmlAction undoAction = this.moveNode(selected, selected.getParentNode().getVGap(), selected.getHGap(), selected.getShiftY());
        return new ActionPair((XmlAction)moveAction, (XmlAction)undoAction);
    }

    private MoveNodeXmlAction moveNode(MindMapNode selected, int parentVGap, int hGap, int shiftY) {
        MoveNodeXmlAction moveNodeAction = new MoveNodeXmlAction();
        moveNodeAction.setNode(this.getNodeID(selected));
        moveNodeAction.setHGap(hGap);
        moveNodeAction.setVGap(parentVGap);
        moveNodeAction.setShiftY(shiftY);
        return moveNodeAction;
    }

    public void moveNodeTo(MindMapNode node, int parentVGap, int hGap, int shiftY) {
        if (parentVGap == node.getParentNode().getVGap() && hGap == node.getHGap() && shiftY == node.getShiftY()) {
            return;
        }
        this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
        this.modeController.getActionFactory().executeAction(this.getActionPair(node, parentVGap, hGap, shiftY));
        this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
    }
}

