/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode.attributeactors;

import freemind.controller.MapModuleManager;
import freemind.controller.filter.util.SortedComboBoxModel;
import freemind.main.Resources;
import freemind.main.Tools;
import freemind.modes.MindMap;
import freemind.modes.MindMapNode;
import freemind.modes.Mode;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.AttributeRegistry;
import freemind.modes.attributes.AttributeRegistryElement;
import freemind.modes.attributes.NodeAttributeTableModel;
import freemind.modes.mindmapmode.MindMapMode;
import freemind.modes.mindmapmode.attributeactors.AttributesListener;
import freemind.view.MapModule;
import freemind.view.mindmapview.MapView;
import freemind.view.mindmapview.NodeView;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import javax.swing.AbstractListModel;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;

public class AssignAttributeDialog
extends JDialog
implements AttributesListener,
MapModuleManager.MapModuleChangeObserver {
    private static final Dimension maxButtonDimension = new Dimension(1000, 1000);
    private MapView mapView;
    private JComboBox attributeNames;
    private JComboBox attributeValues;
    private JComboBox replacingAttributeNames;
    private JComboBox replacingAttributeValues;
    private JRadioButton selectedBtn;
    private JRadioButton visibleBtn;
    private JCheckBox skipRootBtn;

    public AssignAttributeDialog(MapView mapView) {
        super(JOptionPane.getFrameForComponent(mapView), Tools.removeMnemonic(Resources.getInstance().getResourceString("attributes_assign_dialog")), false);
        MatteBorder actionBorder = new MatteBorder(2, 2, 2, 2, Color.BLACK);
        EmptyBorder emptyBorder = new EmptyBorder(5, 5, 5, 5);
        EmptyBorder btnBorder = new EmptyBorder(2, 2, 2, 2);
        this.selectedBtn = new JRadioButton();
        Tools.setLabelAndMnemonic(this.selectedBtn, Resources.getInstance().getResourceString("attributes_for_selected"));
        this.selectedBtn.setSelected(true);
        this.visibleBtn = new JRadioButton();
        Tools.setLabelAndMnemonic(this.visibleBtn, Resources.getInstance().getResourceString("attributes_for_visible"));
        ButtonGroup group = new ButtonGroup();
        group.add(this.selectedBtn);
        group.add(this.visibleBtn);
        this.skipRootBtn = new JCheckBox();
        Tools.setLabelAndMnemonic(this.skipRootBtn, Resources.getInstance().getResourceString("attributes_skip_root"));
        this.skipRootBtn.setSelected(true);
        Box selectionBox = Box.createHorizontalBox();
        selectionBox.setBorder(emptyBorder);
        selectionBox.add(Box.createHorizontalGlue());
        selectionBox.add(this.selectedBtn);
        selectionBox.add(Box.createHorizontalGlue());
        selectionBox.add(this.visibleBtn);
        selectionBox.add(Box.createHorizontalGlue());
        selectionBox.add(this.skipRootBtn);
        selectionBox.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)selectionBox, "North");
        JButton addBtn = new JButton();
        Tools.setLabelAndMnemonic(addBtn, Resources.getInstance().getResourceString("filter_add"));
        addBtn.addActionListener(new AddAction());
        addBtn.setMaximumSize(maxButtonDimension);
        JButton deleteAttributeBtn = new JButton();
        Tools.setLabelAndMnemonic(deleteAttributeBtn, Resources.getInstance().getResourceString("attribute_delete"));
        deleteAttributeBtn.addActionListener(new DeleteAttributeAction());
        deleteAttributeBtn.setMaximumSize(maxButtonDimension);
        JButton deleteAttributeValueBtn = new JButton();
        Tools.setLabelAndMnemonic(deleteAttributeValueBtn, Resources.getInstance().getResourceString("attribute_delete_value"));
        deleteAttributeValueBtn.addActionListener(new DeleteValueAction());
        deleteAttributeValueBtn.setMaximumSize(maxButtonDimension);
        JButton replaceBtn = new JButton();
        Tools.setLabelAndMnemonic(replaceBtn, Resources.getInstance().getResourceString("attribute_replace"));
        replaceBtn.addActionListener(new ReplaceValueAction());
        replaceBtn.setMaximumSize(maxButtonDimension);
        Tools.addEscapeActionToDialog(this);
        String pattern = "XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
        JLabel patternLabel = new JLabel("XXXXXXXXXXXXXXXXXXXXXXXXXXXXXX");
        Dimension comboBoxMaximumSize = patternLabel.getPreferredSize();
        comboBoxMaximumSize.width += 4;
        comboBoxMaximumSize.height += 4;
        this.attributeNames = new JComboBox();
        this.attributeNames.setMaximumSize(comboBoxMaximumSize);
        this.attributeNames.setPreferredSize(comboBoxMaximumSize);
        this.attributeNames.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AssignAttributeDialog.this.selectedAttributeChanged(e.getItem(), AssignAttributeDialog.this.attributeValues);
            }
        });
        this.attributeValues = new JComboBox();
        this.attributeValues.setMaximumSize(comboBoxMaximumSize);
        this.attributeValues.setPreferredSize(comboBoxMaximumSize);
        this.replacingAttributeNames = new JComboBox();
        this.replacingAttributeNames.setMaximumSize(comboBoxMaximumSize);
        this.replacingAttributeNames.setPreferredSize(comboBoxMaximumSize);
        this.replacingAttributeNames.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                AssignAttributeDialog.this.selectedAttributeChanged(e.getItem(), AssignAttributeDialog.this.replacingAttributeValues);
            }
        });
        this.replacingAttributeValues = new JComboBox();
        this.replacingAttributeValues.setMaximumSize(comboBoxMaximumSize);
        this.replacingAttributeValues.setPreferredSize(comboBoxMaximumSize);
        Box addDeleteBtnBox = Box.createVerticalBox();
        addDeleteBtnBox.setBorder(btnBorder);
        addDeleteBtnBox.add(Box.createVerticalGlue());
        addDeleteBtnBox.add(addBtn);
        addDeleteBtnBox.add(deleteAttributeBtn);
        addDeleteBtnBox.add(deleteAttributeValueBtn);
        addDeleteBtnBox.add(Box.createVerticalGlue());
        Box addDeleteBox = Box.createHorizontalBox();
        addDeleteBox.setBorder(actionBorder);
        addDeleteBox.add(Box.createHorizontalGlue());
        addDeleteBox.add(addDeleteBtnBox);
        addDeleteBox.add(Box.createHorizontalStrut(5));
        addDeleteBox.add(this.attributeNames);
        addDeleteBox.add(Box.createHorizontalStrut(5));
        addDeleteBox.add(this.attributeValues);
        addDeleteBox.add(Box.createHorizontalStrut(5));
        Box outerReplaceBox = Box.createVerticalBox();
        outerReplaceBox.setBorder(actionBorder);
        Box replaceBox = Box.createHorizontalBox();
        replaceBox.setBorder(btnBorder);
        replaceBox.add(Box.createHorizontalGlue());
        replaceBox.add(replaceBtn);
        replaceBox.add(Box.createHorizontalStrut(5));
        replaceBox.add(this.replacingAttributeNames);
        replaceBox.add(Box.createHorizontalStrut(5));
        replaceBox.add(this.replacingAttributeValues);
        replaceBox.add(Box.createHorizontalStrut(5));
        outerReplaceBox.add(Box.createVerticalGlue());
        outerReplaceBox.add(replaceBox);
        outerReplaceBox.add(Box.createVerticalGlue());
        Box actionBox = Box.createVerticalBox();
        actionBox.add(Box.createVerticalGlue());
        actionBox.add(addDeleteBox);
        actionBox.add(Box.createVerticalStrut(5));
        actionBox.add(outerReplaceBox);
        actionBox.add(Box.createVerticalGlue());
        this.getContentPane().add((Component)actionBox, "Center");
        JButton closeBtn = new JButton();
        Tools.setLabelAndMnemonic(closeBtn, Resources.getInstance().getResourceString("close"));
        closeBtn.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                AssignAttributeDialog.this.dispose();
            }
        });
        Box bottomBox = Box.createHorizontalBox();
        bottomBox.setBorder(emptyBorder);
        bottomBox.add(Box.createHorizontalGlue());
        bottomBox.add(closeBtn);
        bottomBox.add(Box.createHorizontalGlue());
        this.getContentPane().add((Component)bottomBox, "South");
        this.pack();
        comboBoxMaximumSize.width = 1000;
        this.attributeNames.setMaximumSize(comboBoxMaximumSize);
        this.attributeValues.setMaximumSize(comboBoxMaximumSize);
        this.replacingAttributeNames.setMaximumSize(comboBoxMaximumSize);
        this.replacingAttributeValues.setMaximumSize(comboBoxMaximumSize);
        this.mapChanged(mapView);
        mapView.getController().getMapModuleManager().addListener(this);
    }

    public void mapChanged(MapView currentMapView) {
        if (this.mapView != null) {
            this.mapView.getModel().getRegistry().getAttributes().removeAttributesListener(this);
        }
        this.mapView = currentMapView;
        MindMap map = currentMapView.getModel();
        AttributeRegistry attributes = map.getRegistry().getAttributes();
        attributes.addAttributesListener(this);
        this.attributesChanged();
    }

    private void selectedAttributeChanged(Object selectedAttributeName, JComboBox values) {
        AttributeRegistry attributes = this.mapView.getModel().getRegistry().getAttributes();
        try {
            AttributeRegistryElement element = attributes.getElement((Comparable)((Object)selectedAttributeName.toString()));
            SortedComboBoxModel selectedValues = element.getValues();
            values.setModel(new ClonedComboBoxModel(selectedValues));
            try {
                Object firstValue = selectedValues.getElementAt(0);
                values.setSelectedItem(firstValue);
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                // empty catch block
            }
            values.setEditable(!element.isRestricted());
        }
        catch (NoSuchElementException ex) {
            values.setEditable(!selectedAttributeName.toString().equals(""));
        }
    }

    public void attributesChanged(ChangeEvent e) {
        this.attributesChanged();
    }

    private void attributesChanged() {
        AttributeRegistry attributes = this.mapView.getModel().getRegistry().getAttributes();
        ComboBoxModel names = attributes.getComboBoxModel();
        this.attributeNames.setModel(new ClonedComboBoxModel(names));
        this.attributeNames.setEditable(!attributes.isRestricted());
        this.replacingAttributeNames.setModel(new ClonedComboBoxModel(names));
        this.replacingAttributeNames.setEditable(!attributes.isRestricted());
        if (attributes.size() > 0) {
            Object first = names.getElementAt(0);
            this.attributeNames.setSelectedItem(first);
            this.replacingAttributeNames.setSelectedItem(first);
            this.selectedAttributeChanged(this.attributeNames.getSelectedItem(), this.attributeValues);
            this.selectedAttributeChanged(this.replacingAttributeNames.getSelectedItem(), this.replacingAttributeValues);
        } else {
            this.attributeValues.setModel(new DefaultComboBoxModel());
            this.attributeValues.setEditable(false);
            this.replacingAttributeValues.setModel(new DefaultComboBoxModel());
            this.replacingAttributeValues.setEditable(false);
        }
    }

    public boolean isMapModuleChangeAllowed(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        return !this.isVisible() || newMode instanceof MindMapMode;
    }

    public void beforeMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
    }

    public void afterMapModuleChange(MapModule oldMapModule, Mode oldMode, MapModule newMapModule, Mode newMode) {
        if (newMapModule != null) {
            this.mapChanged(newMapModule.getView());
        }
    }

    public void numberOfOpenMapInformation(int number) {
    }

    public void afterMapClose(MapModule pOldMapModule, Mode pOldMode) {
    }

    private class ReplaceValueAction
    extends IteratingAction {
        private String name;
        private String value;
        private String replacingName;
        private String replacingValue;

        private ReplaceValueAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AssignAttributeDialog.this.attributeNames.getSelectedItem() == null) {
                this.showEmptyStringErrorMessage();
                return;
            }
            if (AssignAttributeDialog.this.replacingAttributeNames.getSelectedItem() == null) {
                this.showEmptyStringErrorMessage();
                return;
            }
            this.name = AssignAttributeDialog.this.attributeNames.getSelectedItem().toString();
            if (this.name.equals("")) {
                this.showEmptyStringErrorMessage();
                return;
            }
            this.replacingName = AssignAttributeDialog.this.replacingAttributeNames.getSelectedItem().toString();
            if (this.replacingName.equals("")) {
                this.showEmptyStringErrorMessage();
                return;
            }
            Object valueSelectedItem = AssignAttributeDialog.this.attributeValues.getSelectedItem();
            this.value = valueSelectedItem != null ? valueSelectedItem.toString() : "";
            Object replacingValueSelectedItem = AssignAttributeDialog.this.replacingAttributeValues.getSelectedItem();
            this.replacingValue = replacingValueSelectedItem != null ? replacingValueSelectedItem.toString() : "";
            super.actionPerformed(e);
        }

        protected void performAction(MindMapNode model) {
            NodeAttributeTableModel attributes = model.getAttributes();
            for (int i = attributes.getRowCount() - 1; i >= 0; --i) {
                Attribute attribute = attributes.getAttribute(i);
                if (!attribute.getName().equals(this.name) || !attribute.getValue().equals(this.value)) continue;
                attributes.getAttributeController().performRemoveRow(attributes, i);
                attributes.insertRow(i, this.replacingName, this.replacingValue);
            }
        }
    }

    private class DeleteValueAction
    extends IteratingAction {
        private String name;
        private String value;

        private DeleteValueAction() {
        }

        public void actionPerformed(ActionEvent e) {
            if (AssignAttributeDialog.this.attributeNames.getSelectedItem() == null) {
                this.showEmptyStringErrorMessage();
                return;
            }
            this.name = AssignAttributeDialog.this.attributeNames.getSelectedItem().toString();
            if (this.name.equals("")) {
                this.showEmptyStringErrorMessage();
                return;
            }
            Object valueSelectedItem = AssignAttributeDialog.this.attributeValues.getSelectedItem();
            this.value = valueSelectedItem != null ? valueSelectedItem.toString() : "";
            super.actionPerformed(e);
        }

        protected void performAction(MindMapNode model) {
            NodeAttributeTableModel attributes = model.getAttributes();
            for (int i = attributes.getRowCount() - 1; i >= 0; --i) {
                Attribute attribute = attributes.getAttribute(i);
                if (!attribute.getName().equals(this.name) || !attribute.getValue().equals(this.value)) continue;
                attributes.getAttributeController().performRemoveRow(attributes, i);
            }
        }
    }

    private class DeleteAttributeAction
    extends IteratingAction {
        private String name;

        private DeleteAttributeAction() {
        }

        public void actionPerformed(ActionEvent e) {
            Object selectedItem = AssignAttributeDialog.this.attributeNames.getSelectedItem();
            if (selectedItem == null) {
                this.showEmptyStringErrorMessage();
                return;
            }
            this.name = selectedItem.toString();
            if (this.name.equals("")) {
                this.showEmptyStringErrorMessage();
                return;
            }
            super.actionPerformed(e);
        }

        protected void performAction(MindMapNode model) {
            NodeAttributeTableModel attributes = model.getAttributes();
            for (int i = attributes.getRowCount() - 1; i >= 0; --i) {
                if (!attributes.getAttribute(i).getName().equals(this.name)) continue;
                attributes.getAttributeController().performRemoveRow(attributes, i);
            }
        }
    }

    private class AddAction
    extends IteratingAction {
        private String name;
        private String value;

        private AddAction() {
        }

        protected void performAction(MindMapNode model) {
            model.createAttributeTableModel();
            NodeAttributeTableModel attributes = model.getAttributes();
            attributes.getAttributeController().performInsertRow(attributes, attributes.getRowCount(), this.name, this.value);
        }

        public void actionPerformed(ActionEvent e) {
            if (AssignAttributeDialog.this.attributeNames.getSelectedItem() == null) {
                this.showEmptyStringErrorMessage();
                return;
            }
            this.name = AssignAttributeDialog.this.attributeNames.getSelectedItem().toString();
            if (this.name.equals("")) {
                this.showEmptyStringErrorMessage();
                return;
            }
            Object valueSelectedItem = AssignAttributeDialog.this.attributeValues.getSelectedItem();
            this.value = valueSelectedItem != null ? valueSelectedItem.toString() : "";
            super.actionPerformed(e);
            if (valueSelectedItem == null) {
                AssignAttributeDialog.this.selectedAttributeChanged(this.name, AssignAttributeDialog.this.attributeValues);
            }
        }
    }

    private abstract class IteratingAction
    implements ActionListener {
        private IteratingAction() {
        }

        public void actionPerformed(ActionEvent e) {
            try {
                if (AssignAttributeDialog.this.selectedBtn.getModel().isSelected()) {
                    LinkedList selecteds = AssignAttributeDialog.this.mapView.getSelecteds();
                    ListIterator iterator = selecteds.listIterator();
                    while (iterator.hasNext()) {
                        NodeView selectedNodeView = (NodeView)iterator.next();
                        this.performAction(selectedNodeView);
                    }
                    return;
                }
                NodeView nodeView = AssignAttributeDialog.this.mapView.getRoot();
                this.iterate(nodeView);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }

        private void iterate(NodeView nodeView) {
            int n = nodeView.getComponentCount();
            if (nodeView.isVisible()) {
                this.performAction(nodeView);
            }
            for (int i = 0; i < n; ++i) {
                Component component = nodeView.getComponent(i);
                if (!(component instanceof NodeView)) continue;
                this.iterate((NodeView)component);
            }
        }

        private void performAction(NodeView selectedNodeView) {
            if (!selectedNodeView.isRoot() || !AssignAttributeDialog.this.skipRootBtn.isSelected()) {
                this.performAction(selectedNodeView.getModel());
            }
        }

        protected abstract void performAction(MindMapNode var1);

        protected void showEmptyStringErrorMessage() {
            JOptionPane.showMessageDialog(AssignAttributeDialog.this, Resources.getInstance().getResourceString("attributes_adding_empty_attribute_error"), Resources.getInstance().getResourceString("error"), 0);
        }
    }

    private static class ClonedComboBoxModel
    extends AbstractListModel
    implements ComboBoxModel {
        private AbstractListModel sharedListModel;
        private Object selectedItem;
        private ListDataEvent ev = null;

        public ClonedComboBoxModel(ComboBoxModel sharedListModel) {
            this.sharedListModel = (AbstractListModel)((Object)sharedListModel);
        }

        public void addListDataListener(ListDataListener l) {
            super.addListDataListener(l);
            this.sharedListModel.addListDataListener(l);
        }

        public Object getElementAt(int index) {
            return this.sharedListModel.getElementAt(index);
        }

        public int getSize() {
            return this.sharedListModel.getSize();
        }

        public void removeListDataListener(ListDataListener l) {
            super.removeListDataListener(l);
            this.sharedListModel.removeListDataListener(l);
        }

        public void setSelectedItem(Object anItem) {
            this.selectedItem = anItem;
            this.fireContentsChanged(this, -1, -1);
        }

        private ListDataEvent getContentChangedEvent() {
            if (this.ev == null) {
                this.ev = new ListDataEvent(this, 0, -1, -1);
            }
            return this.ev;
        }

        public Object getSelectedItem() {
            return this.selectedItem;
        }
    }
}

