/*
 * Decompiled with CFR 0.152.
 */
package org.jibx.runtime.impl;

public class StringIntHashMap {
    public static final int DEFAULT_NOT_FOUND = Integer.MIN_VALUE;
    protected static final double DEFAULT_FILL = 0.3;
    protected static final int MINIMUM_SIZE = 31;
    protected final double m_fillFraction;
    protected int m_entryCount;
    protected int m_entryLimit;
    protected int m_arraySize;
    protected int m_hitOffset;
    protected String[] m_keyTable;
    protected int[] m_valueTable;
    protected int m_notFoundValue;

    public StringIntHashMap(int n, double d, int n2) {
        if (d <= 0.0 || d >= 1.0) {
            throw new IllegalArgumentException("fill value out of range");
        }
        this.m_fillFraction = d;
        this.m_arraySize = Math.max((int)((double)n / this.m_fillFraction), 31);
        this.m_arraySize += (this.m_arraySize + 1) % 2;
        this.m_entryLimit = (int)((double)this.m_arraySize * this.m_fillFraction);
        this.m_hitOffset = this.m_arraySize / 2;
        this.m_keyTable = new String[this.m_arraySize];
        this.m_valueTable = new int[this.m_arraySize];
        this.m_notFoundValue = n2;
    }

    public StringIntHashMap(int n, double d) {
        this(n, d, Integer.MIN_VALUE);
    }

    public StringIntHashMap(int n) {
        this(n, 0.3);
    }

    public StringIntHashMap() {
        this(0, 0.3);
    }

    public StringIntHashMap(StringIntHashMap stringIntHashMap) {
        this.m_fillFraction = stringIntHashMap.m_fillFraction;
        this.m_entryCount = stringIntHashMap.m_entryCount;
        this.m_entryLimit = stringIntHashMap.m_entryLimit;
        this.m_arraySize = stringIntHashMap.m_arraySize;
        this.m_hitOffset = stringIntHashMap.m_hitOffset;
        this.m_notFoundValue = stringIntHashMap.m_notFoundValue;
        this.m_keyTable = new String[this.m_arraySize];
        System.arraycopy(stringIntHashMap.m_keyTable, 0, this.m_keyTable, 0, this.m_arraySize);
        this.m_valueTable = new int[this.m_arraySize];
        System.arraycopy(stringIntHashMap.m_valueTable, 0, this.m_valueTable, 0, this.m_arraySize);
    }

    private final int stepSlot(int n) {
        return (n + this.m_hitOffset) % this.m_arraySize;
    }

    private final int freeSlot(int n) {
        while (this.m_keyTable[n] != null) {
            n = this.stepSlot(n);
        }
        return n;
    }

    private final int standardSlot(Object object) {
        return (object.hashCode() & Integer.MAX_VALUE) % this.m_arraySize;
    }

    private int standardFind(Object object) {
        int n = this.standardSlot(object);
        while (this.m_keyTable[n] != null) {
            if (this.m_keyTable[n].equals(object)) {
                return n;
            }
            n = this.stepSlot(n);
        }
        return -n - 1;
    }

    private boolean reinsert(int n) {
        String string = this.m_keyTable[n];
        this.m_keyTable[n] = null;
        return this.assignSlot(string, this.m_valueTable[n]) != n;
    }

    protected void internalRemove(int n) {
        this.m_keyTable[n] = null;
        --this.m_entryCount;
        while (this.m_keyTable[n = this.stepSlot(n)] != null) {
            this.reinsert(n);
        }
    }

    private void restructure(String[] stringArray, int[] nArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i] == null) continue;
            this.assignSlot(stringArray[i], nArray[i]);
        }
    }

    private int assignSlot(String string, int n) {
        int n2 = this.freeSlot(this.standardSlot(string));
        this.m_keyTable[n2] = string;
        this.m_valueTable[n2] = n;
        return n2;
    }

    public int add(String string, int n) {
        int n2;
        int n3;
        if (string == null) {
            throw new IllegalArgumentException("null key not supported");
        }
        if (n == this.m_notFoundValue) {
            throw new IllegalArgumentException("value matching not found return not supported");
        }
        int n4 = this.m_entryCount + 1;
        if (n4 > this.m_entryLimit) {
            n3 = this.m_arraySize;
            n2 = this.m_entryLimit;
            while (n2 < n4) {
                n3 = n3 * 2 + 1;
                n2 = (int)((double)n3 * this.m_fillFraction);
            }
            this.m_arraySize = n3;
            this.m_entryLimit = n2;
            this.m_hitOffset = n3 / 2;
            String[] stringArray = this.m_keyTable;
            this.m_keyTable = new String[this.m_arraySize];
            int[] nArray = this.m_valueTable;
            this.m_valueTable = new int[this.m_arraySize];
            this.restructure(stringArray, nArray);
        }
        if ((n3 = this.standardFind(string)) >= 0) {
            n2 = this.m_valueTable[n3];
            this.m_valueTable[n3] = n;
            return n2;
        }
        ++this.m_entryCount;
        n3 = -n3 - 1;
        this.m_keyTable[n3] = string;
        this.m_valueTable[n3] = n;
        return this.m_notFoundValue;
    }

    public final boolean containsKey(String string) {
        return this.standardFind(string) >= 0;
    }

    public final int get(String string) {
        int n = this.standardFind(string);
        if (n >= 0) {
            return this.m_valueTable[n];
        }
        return this.m_notFoundValue;
    }

    public int remove(String string) {
        int n = this.standardFind(string);
        if (n >= 0) {
            int n2 = this.m_valueTable[n];
            this.internalRemove(n);
            return n2;
        }
        return this.m_notFoundValue;
    }

    public Object clone() {
        return new StringIntHashMap(this);
    }
}

