/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.attributes;

import freemind.controller.filter.util.SortedComboBoxModel;
import freemind.controller.filter.util.SortedListModel;
import freemind.controller.filter.util.SortedMapVector;
import freemind.main.XMLElement;
import freemind.modes.MapRegistry;
import freemind.modes.attributes.Attribute;
import freemind.modes.attributes.AttributeController;
import freemind.modes.attributes.AttributeRegistryComboBoxColumnModel;
import freemind.modes.attributes.AttributeRegistryElement;
import freemind.modes.attributes.AttributeRegistryTableModel;
import freemind.modes.mindmapmode.attributeactors.AttributesListener;
import java.io.IOException;
import java.io.Writer;
import java.util.NoSuchElementException;
import javax.swing.ComboBoxModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;

public class AttributeRegistry {
    private static final int CAPACITY_INCREMENT = 10;
    protected int visibleElementsNumber;
    protected MapRegistry registry;
    protected SortedMapVector elements;
    private AttributeRegistryComboBoxColumnModel myComboBoxColumnModel = null;
    private AttributeRegistryTableModel myTableModel = null;
    private EventListenerList listenerList = null;
    private Boolean restrictionModel;
    private boolean isRestricted;
    public static final int GLOBAL = -1;
    private static final int TABLE_FONT_SIZE = 12;
    private int fontSize = 12;
    protected boolean isAttributeLayoutChanged;
    private ChangeEvent changeEvent;
    private ChangeEvent attributesEvent;
    private String attributeViewType;

    public AttributeRegistry() {
    }

    public int size() {
        return this.elements.size();
    }

    public AttributeRegistry(MapRegistry registry) {
        this.listenerList = new EventListenerList();
        this.isAttributeLayoutChanged = false;
        this.registry = registry;
        this.visibleElementsNumber = 0;
        this.elements = new SortedMapVector();
        this.myTableModel = new AttributeRegistryTableModel(this);
        this.isRestricted = false;
        this.restrictionModel = Boolean.FALSE;
        this.attributeViewType = "extended";
    }

    public Comparable getKey(int index) {
        return this.elements.getKey(index);
    }

    public AttributeRegistryElement getElement(int index) {
        return (AttributeRegistryElement)this.elements.getValue(index);
    }

    public AttributeController getAttributeController() {
        return this.registry.getModeController().getAttributeController();
    }

    void removeAtribute(Object o) {
        this.getAttributeController().performRemoveAttribute(o.toString());
    }

    public boolean containsElement(String name) {
        return this.elements.containsKey((Comparable)((Object)name));
    }

    private AttributeRegistryComboBoxColumnModel getCombinedModel() {
        if (this.myComboBoxColumnModel == null) {
            this.myComboBoxColumnModel = new AttributeRegistryComboBoxColumnModel(this);
        }
        return this.myComboBoxColumnModel;
    }

    public ComboBoxModel getComboBoxModel() {
        return this.getCombinedModel();
    }

    public SortedListModel getListBoxModel() {
        return this.getCombinedModel();
    }

    public ComboBoxModel getDefaultComboBoxModel(Comparable attrName) {
        try {
            AttributeRegistryElement elem = this.getElement(attrName);
            return elem.getValues();
        }
        catch (NoSuchElementException ex) {
            return this.getComboBoxModel();
        }
    }

    public AttributeRegistryElement getElement(Comparable attrName) {
        AttributeRegistryElement elem = (AttributeRegistryElement)this.elements.getValue(attrName);
        return elem;
    }

    public int getVisibleElementsNumber() {
        return this.visibleElementsNumber;
    }

    public void addChangeListener(ChangeListener l) {
        this.listenerList.add(ChangeListener.class, l);
    }

    public void removeChangeListener(ChangeListener l) {
        this.listenerList.remove(ChangeListener.class, l);
    }

    public void addAttributesListener(AttributesListener l) {
        this.listenerList.add(AttributesListener.class, l);
    }

    public void removeAttributesListener(AttributesListener l) {
        this.listenerList.remove(AttributesListener.class, l);
    }

    public void fireAttributeLayoutChanged() {
        this.setAttributeLayoutChanged();
    }

    public void fireStateChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$javax$swing$event$ChangeListener == null ? AttributeRegistry.class$("javax.swing.event.ChangeListener") : class$javax$swing$event$ChangeListener)) continue;
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            ((ChangeListener)listeners[i + 1]).stateChanged(this.changeEvent);
        }
    }

    protected void fireAttributesChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != (class$freemind$modes$mindmapmode$attributeactors$AttributesListener == null ? AttributeRegistry.class$("freemind.modes.mindmapmode.attributeactors.AttributesListener") : class$freemind$modes$mindmapmode$attributeactors$AttributesListener)) continue;
            if (this.attributesEvent == null) {
                this.attributesEvent = new ChangeEvent(this);
            }
            ((AttributesListener)listeners[i + 1]).attributesChanged(this.changeEvent);
        }
    }

    public int indexOf(String string) {
        return this.elements.indexOf((Comparable)((Object)string));
    }

    public void setVisibilityModel(int row, Boolean visible) {
        AttributeRegistryElement element = this.getElement(row);
        if (!element.getVisibilityModel().equals(visible)) {
            element.setVisibilityModel(visible);
            this.setAttributeLayoutChanged();
            this.myTableModel.fireVisibilityUpdated(row);
        }
    }

    public AttributeRegistryTableModel getTableModel() {
        return this.myTableModel;
    }

    public void setRestrictionModel(int row, Boolean value) {
        if (row == -1) {
            this.restrictionModel = value;
        } else {
            this.getElement(row).setRestrictionModel(value);
        }
        this.setAttributeLayoutChanged();
        this.myTableModel.fireRestrictionsUpdated(row);
    }

    Boolean getRestriction(int row) {
        if (row == -1) {
            return this.restrictionModel;
        }
        return this.getElement(row).getRestriction();
    }

    public boolean isRestricted(String s) {
        return this.getRestriction(this.indexOf(s));
    }

    public void setRestricted(String s, boolean b) {
        this.setRestricted(this.indexOf(s), b);
    }

    private void setRestricted(int row, boolean b) {
        this.getElement(row).setRestriction(b);
    }

    public SortedListModel getValues(int row) {
        if (row == -1) {
            return this.getListBoxModel();
        }
        return this.getElement(row).getValues();
    }

    public boolean isRestricted() {
        return this.isRestricted;
    }

    public void setRestricted(boolean b) {
        this.isRestricted = b;
        this.restrictionModel = this.isRestricted;
        this.fireAttributesChanged();
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int size) {
        if (this.fontSize != size) {
            this.fontSize = size;
            this.fireAttributeLayoutChanged();
        }
    }

    public void save(Writer fileout) throws IOException {
        XMLElement attributeRegistry = new XMLElement();
        boolean toBeSaved = false;
        if (this.isRestricted()) {
            attributeRegistry.setAttribute("RESTRICTED", "true");
            toBeSaved = true;
        }
        if (!this.attributeViewType.equals("extended")) {
            attributeRegistry.setAttribute("SHOW_ATTRIBUTES", this.attributeViewType);
            toBeSaved = true;
        }
        if (this.getFontSize() != 12) {
            attributeRegistry.setIntAttribute("FONT_SIZE", this.getFontSize());
            toBeSaved = true;
        }
        for (int i = 0; i < this.size(); ++i) {
            AttributeRegistryElement element = this.getElement(i);
            if (!element.isRestricted() && !element.isVisible()) continue;
            XMLElement attributeData = element.save();
            attributeRegistry.addChild(attributeData);
            toBeSaved = true;
        }
        if (toBeSaved) {
            attributeRegistry.setName("attribute_registry");
            attributeRegistry.write(fileout);
        }
    }

    public void resetChanges() {
        if (!this.isAttributeLayoutChanged) {
            return;
        }
        this.restrictionModel = this.isRestricted;
        for (int i = 0; i < this.elements.size(); ++i) {
            AttributeRegistryElement element = this.getElement(i);
            element.setVisibilityModel(element.isVisible());
            element.setRestrictionModel(element.isRestricted());
        }
        this.isAttributeLayoutChanged = false;
    }

    public void applyChanges() {
        if (!this.isAttributeLayoutChanged) {
            return;
        }
        this.getAttributeController().performSetRestriction(-1, this.restrictionModel);
        for (int i = 0; i < this.elements.size(); ++i) {
            AttributeRegistryElement element = this.getElement(i);
            this.getAttributeController().performSetVisibility(i, element.getVisibilityModel());
            this.getAttributeController().performSetRestriction(i, element.getRestriction());
        }
        this.isAttributeLayoutChanged = false;
    }

    public boolean exist(String attributeName, Object element) {
        int index = this.indexOf(attributeName);
        if (index == -1) {
            return false;
        }
        SortedComboBoxModel values = this.getElement(index).getValues();
        for (int i = 0; i < values.getSize(); ++i) {
            if (!element.equals(values.getElementAt(i))) continue;
            return true;
        }
        return false;
    }

    public SortedMapVector getElements() {
        return this.elements;
    }

    public void decrementVisibleElementsNumber() {
        --this.visibleElementsNumber;
    }

    public void incrementVisibleElementsNumber() {
        ++this.visibleElementsNumber;
    }

    public void registry(Attribute newAttribute) {
        String name = newAttribute.getName();
        if (name.equals("")) {
            return;
        }
        String value = newAttribute.getValue();
        try {
            AttributeRegistryElement elem = this.getElement((Comparable)((Object)name));
            elem.addValue(value);
        }
        catch (NoSuchElementException ex) {
            AttributeRegistryElement attributeRegistryElement = new AttributeRegistryElement(this, name);
            attributeRegistryElement.addValue(value);
            int index = this.getElements().add((Comparable)((Object)name), attributeRegistryElement);
            this.getTableModel().fireTableRowsInserted(index, index);
        }
        this.fireAttributesChanged();
    }

    public void registry(String name) {
        AttributeRegistryElement attributeRegistryElement = new AttributeRegistryElement(this, name);
        int index = this.getElements().add((Comparable)((Object)name), attributeRegistryElement);
        this.getTableModel().fireTableRowsInserted(index, index);
    }

    public void setAttributeLayoutChanged() {
        this.isAttributeLayoutChanged = true;
    }

    public void unregistry(String name) {
        int index = this.elements.indexOf((Comparable)((Object)name));
        if (this.getElement(index).isVisible()) {
            this.decrementVisibleElementsNumber();
        }
        this.elements.remove(index);
        this.getTableModel().fireTableRowsDeleted(index, index);
        this.fireAttributesChanged();
    }

    public String getAttributeViewType() {
        return this.attributeViewType;
    }

    public void setAttributeViewType(String attributeViewType) {
        this.attributeViewType = attributeViewType;
        this.fireStateChanged();
    }
}

