/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.SAXParserFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.BFEntry;
import org.apache.fop.fonts.CIDFontType;
import org.apache.fop.fonts.CustomFont;
import org.apache.fop.fonts.FontType;
import org.apache.fop.fonts.MultiByteFont;
import org.apache.fop.fonts.SingleByteFont;
import org.apache.fop.fonts.Typeface;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class FontReader
extends DefaultHandler {
    private Locator locator = null;
    private boolean isCID = false;
    private CustomFont returnFont = null;
    private MultiByteFont multiFont = null;
    private SingleByteFont singleFont = null;
    private StringBuffer text = new StringBuffer();
    private List cidWidths = null;
    private int cidWidthIndex = 0;
    private Map currentKerning = null;
    private List bfranges = null;

    public FontReader(String path) throws FOPException {
        this.createFont(path);
    }

    public void characters(char[] ch, int start, int length) {
        this.text.append(ch, start, length);
    }

    private void createFont(String path) throws FOPException {
        XMLReader parser = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setNamespaceAware(true);
            parser = factory.newSAXParser().getXMLReader();
        }
        catch (Exception e) {
            throw new FOPException((Throwable)e);
        }
        if (parser == null) {
            throw new FOPException("Unable to create SAX parser");
        }
        try {
            parser.setFeature("http://xml.org/sax/features/namespace-prefixes", false);
        }
        catch (SAXException e) {
            throw new FOPException("You need a SAX parser which supports SAX version 2", (Throwable)e);
        }
        parser.setContentHandler(this);
        try {
            parser.parse(path);
        }
        catch (SAXException e) {
            throw new FOPException((Throwable)e);
        }
        catch (IOException e) {
            throw new FOPException((Throwable)e);
        }
    }

    public void endElement(String uri, String localName, String qName) {
        if ("font-name".equals(localName)) {
            this.returnFont.setFontName(this.text.toString());
        } else if ("ttc-name".equals(localName) && this.isCID) {
            this.multiFont.setTTCName(this.text.toString());
        } else if ("cap-height".equals(localName)) {
            this.returnFont.setCapHeight(this.getInt(this.text.toString()));
        } else if ("x-height".equals(localName)) {
            this.returnFont.setXHeight(this.getInt(this.text.toString()));
        } else if ("ascender".equals(localName)) {
            this.returnFont.setAscender(this.getInt(this.text.toString()));
        } else if ("descender".equals(localName)) {
            this.returnFont.setDescender(this.getInt(this.text.toString()));
        } else if ("left".equals(localName)) {
            int[] bbox = this.returnFont.getFontBBox();
            bbox[0] = this.getInt(this.text.toString());
            this.returnFont.setFontBBox(bbox);
        } else if ("bottom".equals(localName)) {
            int[] bbox = this.returnFont.getFontBBox();
            bbox[1] = this.getInt(this.text.toString());
            this.returnFont.setFontBBox(bbox);
        } else if ("right".equals(localName)) {
            int[] bbox = this.returnFont.getFontBBox();
            bbox[2] = this.getInt(this.text.toString());
            this.returnFont.setFontBBox(bbox);
        } else if ("top".equals(localName)) {
            int[] bbox = this.returnFont.getFontBBox();
            bbox[3] = this.getInt(this.text.toString());
            this.returnFont.setFontBBox(bbox);
        } else if ("first-char".equals(localName)) {
            this.returnFont.setFirstChar(this.getInt(this.text.toString()));
        } else if ("last-char".equals(localName)) {
            this.returnFont.setLastChar(this.getInt(this.text.toString()));
        } else if ("flags".equals(localName)) {
            this.returnFont.setFlags(this.getInt(this.text.toString()));
        } else if ("stemv".equals(localName)) {
            this.returnFont.setStemV(this.getInt(this.text.toString()));
        } else if ("italic-angle".equals(localName)) {
            this.returnFont.setItalicAngle(this.getInt(this.text.toString()));
        } else if ("missing-width".equals(localName)) {
            this.returnFont.setMissingWidth(this.getInt(this.text.toString()));
        } else if ("cid-type".equals(localName)) {
            this.multiFont.setCIDType(CIDFontType.byName(this.text.toString()));
        } else if ("default-width".equals(localName)) {
            this.multiFont.setDefaultWidth(this.getInt(this.text.toString()));
        } else if ("cid-widths".equals(localName)) {
            int[] wds = new int[this.cidWidths.size()];
            int j = 0;
            int count = 0;
            while (count < this.cidWidths.size()) {
                Integer i = (Integer)this.cidWidths.get(count);
                wds[j++] = i;
                ++count;
            }
            this.multiFont.setWidthArray(wds);
        } else if ("bfranges".equals(localName)) {
            this.multiFont.setBFEntries(this.bfranges.toArray(new BFEntry[0]));
        }
        this.text.setLength(0);
    }

    public Typeface getFont() {
        return this.returnFont;
    }

    private int getInt(String str) {
        int ret = 0;
        try {
            ret = Integer.parseInt(str);
        }
        catch (Exception exception) {}
        return ret;
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    public void setFontEmbedPath(String path) {
        this.returnFont.setEmbedFileName(path);
    }

    public void setKerningEnabled(boolean enabled) {
        this.returnFont.setKerningEnabled(enabled);
    }

    public void startDocument() {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) {
        if (localName.equals("font-metrics")) {
            if ("TYPE0".equals(attributes.getValue("type"))) {
                this.multiFont = new MultiByteFont();
                this.returnFont = this.multiFont;
                this.isCID = true;
            } else if ("TRUETYPE".equals(attributes.getValue("type"))) {
                this.singleFont = new SingleByteFont();
                this.singleFont.setFontType(FontType.TRUETYPE);
                this.returnFont = this.singleFont;
                this.isCID = false;
            } else {
                this.singleFont = new SingleByteFont();
                this.singleFont.setFontType(FontType.TYPE1);
                this.returnFont = this.singleFont;
                this.isCID = false;
            }
        } else if ("embed".equals(localName)) {
            this.returnFont.setEmbedFileName(attributes.getValue("file"));
            this.returnFont.setEmbedResourceName(attributes.getValue("class"));
        } else if ("cid-widths".equals(localName)) {
            this.cidWidthIndex = this.getInt(attributes.getValue("start-index"));
            this.cidWidths = new ArrayList();
        } else if ("kerning".equals(localName)) {
            this.currentKerning = new HashMap();
            this.returnFont.putKerningEntry(new Integer(attributes.getValue("kpx1")), this.currentKerning);
        } else if ("bfranges".equals(localName)) {
            this.bfranges = new ArrayList();
        } else if ("bf".equals(localName)) {
            BFEntry entry = new BFEntry(this.getInt(attributes.getValue("us")), this.getInt(attributes.getValue("ue")), this.getInt(attributes.getValue("gi")));
            this.bfranges.add(entry);
        } else if ("wx".equals(localName)) {
            this.cidWidths.add(new Integer(attributes.getValue("w")));
        } else if (!"widths".equals(localName)) {
            if ("char".equals(localName)) {
                try {
                    this.singleFont.setWidth(Integer.parseInt(attributes.getValue("idx")), Integer.parseInt(attributes.getValue("wdt")));
                }
                catch (NumberFormatException ne) {
                    System.out.println("Malformed width in metric file: " + ne.getMessage());
                }
            } else if ("pair".equals(localName)) {
                this.currentKerning.put(new Integer(attributes.getValue("kpx2")), new Integer(attributes.getValue("kern")));
            }
        }
    }
}

