/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.image;

import org.apache.fop.image.AbstractFopImage;
import org.apache.fop.image.FopImage;

public class EPSImage
extends AbstractFopImage {
    private String docName;
    private int[] bbox;
    private EPSData epsData = null;

    public EPSImage(FopImage.ImageInfo imgInfo) {
        super(imgInfo);
        this.init("");
        if (imgInfo.data instanceof EPSData) {
            this.epsData = (EPSData)imgInfo.data;
            this.bbox = new int[4];
            this.bbox[0] = (int)this.epsData.bbox[0];
            this.bbox[1] = (int)this.epsData.bbox[1];
            this.bbox[2] = (int)this.epsData.bbox[2];
            this.bbox[3] = (int)this.epsData.bbox[3];
            this.loaded |= 2;
        }
    }

    public int[] getBBox() {
        return this.bbox;
    }

    public String getDocName() {
        return this.docName;
    }

    public byte[] getEPSImage() {
        byte[] cfr_ignored_0 = this.epsData.epsFile;
        return this.epsData.epsFile;
    }

    private void init(String name) {
        this.bbox = new int[4];
        this.bbox[0] = 0;
        this.bbox[1] = 0;
        this.bbox[2] = 0;
        this.bbox[3] = 0;
        this.docName = name;
    }

    public static class EPSData {
        public long[] bbox;
        public boolean isAscii;
        public long psStart = 0L;
        public long psLength = 0L;
        public long wmfStart = 0L;
        public long wmfLength = 0L;
        public long tiffStart = 0L;
        public long tiffLength = 0L;
        public byte[] rawEps;
        public byte[] epsFile;
        public byte[] preview = null;
    }
}

