/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.fop.pdf.PDFObject;

public class PDFEncoding
extends PDFObject {
    public static final String MAC_ROMAN_ENCODING = "MacRomanEncoding";
    public static final String MAC_EXPERT_ENCODING = "MacExpertEncoding";
    public static final String WIN_ANSI_ENCODING = "WinAnsiEncoding";
    protected String basename;
    protected Map differences;

    public PDFEncoding(String basename) {
        this.basename = basename;
        this.differences = new HashMap();
    }

    public void addDifferences(int code, List sequence) {
        this.differences.put(new Integer(code), sequence);
    }

    public String toPDFString() {
        StringBuffer p = new StringBuffer(128);
        p.append(String.valueOf(this.getObjectID()) + "<< /Type /Encoding");
        if (this.basename != null && !this.basename.equals("")) {
            p.append("\n/BaseEncoding /" + this.basename);
        }
        if (!this.differences.isEmpty()) {
            p.append("\n/Differences [ ");
            Iterator codes = this.differences.keySet().iterator();
            while (codes.hasNext()) {
                Object code = codes.next();
                p.append(" ");
                p.append(code);
                List sequence = (List)this.differences.get(code);
                int i = 0;
                while (i < sequence.size()) {
                    p.append(" /");
                    p.append((String)sequence.get(i));
                    ++i;
                }
            }
            p.append(" ]");
        }
        p.append(" >>\nendobj\n");
        return p.toString();
    }
}

