/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.pdf;

import org.apache.fop.pdf.PDFAction;
import org.apache.fop.pdf.PDFFileSpec;

public class PDFGoToRemote
extends PDFAction {
    private PDFFileSpec pdfFileSpec;
    private int pageReference = 0;
    private String destination = null;

    public PDFGoToRemote(PDFFileSpec pdfFileSpec) {
        this.pdfFileSpec = pdfFileSpec;
    }

    public PDFGoToRemote(PDFFileSpec pdfFileSpec, int page) {
        this.pdfFileSpec = pdfFileSpec;
        this.pageReference = page;
    }

    public PDFGoToRemote(PDFFileSpec pdfFileSpec, String dest) {
        this.pdfFileSpec = pdfFileSpec;
        this.destination = dest;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || !(obj instanceof PDFGoToRemote)) {
            return false;
        }
        PDFGoToRemote remote = (PDFGoToRemote)obj;
        if (!remote.pdfFileSpec.referencePDF().equals(this.pdfFileSpec.referencePDF())) {
            return false;
        }
        return !(this.destination != null ? !this.destination.equals(remote.destination) : this.pageReference != remote.pageReference);
    }

    public String getAction() {
        return this.referencePDF();
    }

    public String toPDFString() {
        StringBuffer sb = new StringBuffer(64);
        sb.append(this.getObjectID());
        sb.append("<<\n/S /GoToR\n/F " + this.pdfFileSpec.referencePDF() + "\n");
        if (this.destination != null) {
            sb.append("/D (" + this.destination + ")");
        } else {
            sb.append("/D [ " + this.pageReference + " /XYZ null null null ]");
        }
        sb.append(" \n>>\nendobj\n");
        return sb.toString();
    }
}

