/*
 * Decompiled with CFR 0.152.
 */
package accessories.plugins.util.html;

import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import java.awt.Rectangle;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Vector;
import org.apache.commons.lang.StringEscapeUtils;

public class ClickableImageCreator {
    Vector area = new Vector();
    private final MindMapNode root;
    private final ModeController controller;
    private Rectangle innerBounds;
    private final String regExpLinkReplacement;

    public ClickableImageCreator(MindMapNode root, ModeController controller, String regExpLinkReplacement) {
        this.root = root;
        this.regExpLinkReplacement = regExpLinkReplacement;
        this.innerBounds = controller.getView().getInnerBounds(root.getViewer());
        this.controller = controller;
        this.createArea();
    }

    public String generateHtml() {
        StringBuffer htmlArea = new StringBuffer();
        Iterator i = this.area.iterator();
        while (i.hasNext()) {
            AreaHolder holder = (AreaHolder)i.next();
            htmlArea.append("<area shape=\"" + holder.shape + "\" href=\"#" + holder.href.replaceFirst("^(.*)$", this.regExpLinkReplacement) + "\" alt=\"" + StringEscapeUtils.escapeHtml(holder.alt) + "\" title=\"" + StringEscapeUtils.escapeHtml(holder.title) + "\" coords=\"" + holder.coordinates.x + "," + holder.coordinates.y + "," + (holder.coordinates.width + holder.coordinates.x) + "," + (holder.coordinates.height + holder.coordinates.y) + "\" />");
        }
        return htmlArea.toString();
    }

    private void createArea() {
        this.createArea(this.root);
    }

    private void createArea(MindMapNode node) {
        if (node != null && node.getViewer() != null) {
            AreaHolder holder = new AreaHolder();
            holder.title = node.getShortText(this.controller);
            holder.alt = node.getShortText(this.controller);
            holder.href = node.getObjectId(this.controller);
            holder.coordinates.x = (int)((double)node.getViewer().getX() - this.innerBounds.getMinX());
            holder.coordinates.y = (int)((double)node.getViewer().getY() - this.innerBounds.getMinY());
            holder.coordinates.width = node.getViewer().getExtendedWidth();
            holder.coordinates.height = node.getViewer().getExtendedHeight();
            this.area.add(holder);
            ListIterator i = node.childrenUnfolded();
            while (i.hasNext()) {
                MindMapNode child = (MindMapNode)i.next();
                this.createArea(child);
            }
        }
    }

    public static class AreaHolder {
        String shape = "rect";
        String href;
        String alt;
        String title;
        Rectangle coordinates = new Rectangle();
    }
}

