/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.modes.MindMapArrowLink;
import freemind.view.mindmapview.MapView;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import javax.swing.JPopupMenu;

public class MapMouseMotionListener
implements MouseMotionListener,
MouseListener {
    private final Controller c;
    int originX = -1;
    int originY = -1;
    MindMapArrowLink draggedLink = null;
    private Point draggedLinkOldStartPoint;
    private Point draggedLinkOldEndPoint;

    public MapMouseMotionListener(Controller controller) {
        this.c = controller;
    }

    private void handlePopup(MouseEvent e) {
        if (e.isPopupTrigger()) {
            JPopupMenu popup = null;
            MindMapArrowLink obj = this.c.getView().detectCollision(e.getPoint());
            if (obj != null) {
                popup = this.c.getMode().getModeController().getPopupForModel(obj);
            }
            if (popup == null) {
                popup = this.c.getFrame().getFreeMindMenuBar().getMapsPopupMenu();
            }
            popup.show(e.getComponent(), e.getX(), e.getY());
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        if (this.originX >= 0) {
            if (this.draggedLink != null) {
                int deltaX = (int)((float)(e.getX() - this.originX) / this.c.getView().getZoom());
                int deltaY = (int)((float)(e.getY() - this.originY) / this.c.getView().getZoom());
                this.draggedLink.changeInclination(this.originX, this.originY, deltaX, deltaY);
                this.originX = e.getX();
                this.originY = e.getY();
                this.c.getView().repaint();
            } else {
                ((MapView)e.getComponent()).scrollBy(this.originX - e.getX(), this.originY - e.getY(), false);
            }
        }
    }

    public void mouseClicked(MouseEvent e) {
        this.c.getView().selectAsTheOnlyOneSelected(this.c.getView().getSelected());
    }

    public void mouseEntered(MouseEvent e) {
    }

    public void mouseExited(MouseEvent e) {
    }

    public void mousePressed(MouseEvent e) {
        if (e.isPopupTrigger()) {
            this.handlePopup(e);
        } else if (!this.c.getMode().getModeController().isBlocked() && e.getButton() == 1) {
            this.c.getView().setMoveCursor(true);
            this.originX = e.getX();
            this.originY = e.getY();
            this.draggedLink = this.c.getView().detectCollision(new Point(this.originX, this.originY));
            if (this.draggedLink != null) {
                this.draggedLinkOldStartPoint = this.draggedLink.getStartInclination();
                this.draggedLinkOldEndPoint = this.draggedLink.getEndInclination();
                this.draggedLink.showControlPoints(true);
                this.c.getView().repaint();
            }
        }
        e.consume();
    }

    public void mouseReleased(MouseEvent e) {
        this.originX = -1;
        this.originY = -1;
        if (this.draggedLink != null) {
            this.draggedLink.showControlPoints(false);
            Point draggedLinkNewStartPoint = this.draggedLink.getStartInclination();
            Point draggedLinkNewEndPoint = this.draggedLink.getEndInclination();
            this.draggedLink.setStartInclination(this.draggedLinkOldStartPoint);
            this.draggedLink.setEndInclination(this.draggedLinkOldEndPoint);
            this.c.getModeController().setArrowLinkEndPoints(this.draggedLink, draggedLinkNewStartPoint, draggedLinkNewEndPoint);
            this.c.getView().repaint();
            this.draggedLink = null;
        }
        this.handlePopup(e);
        e.consume();
        this.c.getView().setMoveCursor(false);
    }
}

