/*
 * Decompiled with CFR 0.152.
 */
package freemind.controller;

import freemind.controller.Controller;
import freemind.modes.MindMapNode;
import freemind.view.mindmapview.NodeMotionListenerView;
import freemind.view.mindmapview.NodeView;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public class NodeMotionListener
extends MouseAdapter
implements MouseMotionListener,
MouseListener {
    private final Controller c;
    private Point originalStartingPoint;
    private static Logger logger;
    private Point dragStartingPoint = null;
    private int originalHGap;
    private int originalVGap;
    private int originalShiftY;
    private int originalParentHGap;
    private int originalParentVGap;
    private int originalParentShiftY;

    public NodeMotionListener(Controller controller) {
        this.c = controller;
        if (logger == null) {
            logger = this.c.getFrame().getLogger(this.getClass().getName());
        }
    }

    public void mouseMoved(MouseEvent e) {
    }

    public void mouseDragged(MouseEvent e) {
        logger.fine("Event: mouseDragged");
        if ((e.getModifiersEx() & 0x400) == 1024) {
            NodeView nodeV = this.getNodeView(e);
            Point point = e.getPoint();
            SwingUtilities.convertPointToScreen(point, nodeV);
            if (!this.isActive()) {
                this.setDragStartingPoint(point, nodeV.getModel());
            } else {
                Point dragNextPoint = point;
                if ((e.getModifiersEx() & 0x80) == 0) {
                    MindMapNode node = nodeV.getModel();
                    node.setShiftY(this.getNodeShiftY(dragNextPoint, node, this.originalStartingPoint));
                    node.setHGap(this.getHGap(dragNextPoint, node, this.originalStartingPoint));
                    nodeV.setLocation(0, 0);
                    this.c.getModeController().nodeChanged(node);
                } else {
                    MindMapNode parentNode = nodeV.getModel().getParentNode();
                    parentNode.setVGap(this.getVGap(dragNextPoint, parentNode, this.originalStartingPoint));
                    this.c.getModel().nodeChanged(parentNode);
                }
            }
        }
    }

    private int getVGap(Point dragNextPoint, MindMapNode node, Point dragStartingPoint) {
        int oldVGap = this.originalParentVGap;
        int vGapChange = (int)((float)(dragNextPoint.y - dragStartingPoint.y) / this.c.getView().getZoom());
        oldVGap = Math.max(0, oldVGap - vGapChange);
        return oldVGap;
    }

    private int getHGap(Point dragNextPoint, MindMapNode node, Point dragStartingPoint) {
        int oldHGap = this.originalHGap;
        int hGapChange = (int)((float)(dragNextPoint.x - dragStartingPoint.x) / this.c.getView().getZoom());
        if (node.isLeft() != null && node.isLeft().getValue()) {
            hGapChange = -hGapChange;
        }
        return oldHGap += hGapChange;
    }

    private int getNodeShiftY(Point dragNextPoint, MindMapNode node, Point dragStartingPoint) {
        int shiftY = this.originalShiftY;
        int shiftYChange = (int)((float)(dragNextPoint.y - dragStartingPoint.y) / this.c.getView().getZoom());
        return shiftY += shiftYChange;
    }

    public void mouseClicked(MouseEvent e) {
        if (e.getButton() == 1 && e.getClickCount() == 2) {
            if (e.getModifiersEx() == 0) {
                NodeView nodeV = this.getNodeView(e);
                MindMapNode node = nodeV.getModel();
                nodeV.setLocation(0, 0);
                this.c.getModeController().moveNodePosition(node, node.getVGap(), 0, 0);
                return;
            }
            if (e.getModifiersEx() == 128) {
                NodeView nodeV = this.getNodeView(e);
                MindMapNode node = nodeV.getModel().getParentNode();
                this.c.getModeController().moveNodePosition(node, -1, node.getHGap(), node.getShiftY());
                return;
            }
        }
    }

    private NodeView getNodeView(MouseEvent e) {
        return ((NodeMotionListenerView)e.getSource()).getMovedView();
    }

    public void mouseEntered(MouseEvent e) {
        logger.fine("Event: mouseEntered");
        if (!this.isActive()) {
            NodeMotionListenerView v = (NodeMotionListenerView)e.getSource();
            v.setMouseEntered();
        }
    }

    public void mouseExited(MouseEvent e) {
        logger.fine("Event: mouseExited");
        if (!this.isActive()) {
            NodeMotionListenerView v = (NodeMotionListenerView)e.getSource();
            v.setMouseExited();
        }
    }

    private void stopDrag() {
        this.setDragStartingPoint(null, null);
    }

    public void mouseReleased(MouseEvent e) {
        logger.fine("Event: mouseReleased");
        NodeMotionListenerView v = (NodeMotionListenerView)e.getSource();
        if (!v.contains(e.getX(), e.getY())) {
            v.setMouseExited();
        }
        if (!this.isActive()) {
            return;
        }
        NodeView nodeV = this.getNodeView(e);
        Point point = e.getPoint();
        SwingUtilities.convertPointToScreen(point, nodeV);
        if ((e.getModifiersEx() & 0x80) == 0) {
            MindMapNode node = nodeV.getModel();
            MindMapNode parentNode = nodeV.getModel().getParentNode();
            this.resetPositions(node, parentNode);
            this.c.getModeController().moveNodePosition(node, node.getVGap(), this.getHGap(point, node, this.originalStartingPoint), this.getNodeShiftY(point, node, this.originalStartingPoint));
            this.c.getModeController().moveNodePosition(parentNode, parentNode.getVGap(), parentNode.getHGap(), parentNode.getShiftY());
        } else {
            MindMapNode node = nodeV.getModel();
            MindMapNode parentNode = nodeV.getModel().getParentNode();
            this.resetPositions(node, parentNode);
            this.c.getModeController().moveNodePosition(node, node.getVGap(), node.getHGap(), node.getShiftY());
            this.c.getModeController().moveNodePosition(parentNode, this.getVGap(point, parentNode, this.originalStartingPoint), parentNode.getHGap(), parentNode.getShiftY());
        }
        this.stopDrag();
    }

    private void resetPositions(MindMapNode node, MindMapNode parentNode) {
        node.setVGap(this.originalVGap);
        node.setHGap(this.originalHGap);
        node.setShiftY(this.originalShiftY);
        parentNode.setVGap(this.originalParentVGap);
        parentNode.setHGap(this.originalParentHGap);
        parentNode.setShiftY(this.originalParentShiftY);
    }

    public boolean isActive() {
        return this.getDragStartingPoint() != null;
    }

    void setDragStartingPoint(Point point, MindMapNode node) {
        if (this.dragStartingPoint == null) {
            this.originalStartingPoint = new Point(point);
            this.originalHGap = node.getHGap();
            this.originalVGap = node.getVGap();
            this.originalShiftY = node.getShiftY();
            if (!node.isRoot()) {
                this.originalParentHGap = node.getParentNode().getHGap();
                this.originalParentVGap = node.getParentNode().getVGap();
                this.originalParentShiftY = node.getParentNode().getShiftY();
            }
        } else if (point == null) {
            this.originalStartingPoint = null;
            this.originalHGap = 0;
            this.originalVGap = 0;
            this.originalShiftY = 0;
            this.originalParentHGap = 0;
            this.originalParentVGap = 0;
            this.originalParentShiftY = 0;
        }
        this.dragStartingPoint = point;
    }

    Point getDragStartingPoint() {
        return this.dragStartingPoint;
    }
}

