/*
 * Decompiled with CFR 0.152.
 */
package freemind.main;

import freemind.main.FreeMindMain;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;

class FreeMindSplash
extends JFrame {
    private final FreeMindMain frame;

    public FreeMindSplash(final FreeMindMain frame) {
        super("FreeMind");
        this.frame = frame;
        ImageIcon icon = new ImageIcon(frame.getResource("images/FreeMindWindowIcon.png"));
        this.setIconImage(icon.getImage());
        FreeMindSplash.setDefaultLookAndFeelDecorated(false);
        this.setUndecorated(true);
        this.getRootPane().setWindowDecorationStyle(0);
        ImageIcon splashImage = new ImageIcon(frame.getResource("images/splash.JPG"));
        JLabel l = new JLabel((Icon)splashImage){

            public void paint(Graphics g) {
                super.paint(g);
                Graphics2D g2 = (Graphics2D)g;
                g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
                Font font = new Font("Arial", 1, 16);
                g2.setFont(font);
                String freemindVersion = frame.getFreemindVersion();
                int width = g2.getFontMetrics().stringWidth(freemindVersion);
                int yCoordinate = (int)this.getSize().getHeight() - 14;
                int xCoordinate = (int)(this.getSize().getWidth() / 2.0 - (double)(width / 2));
                g2.setColor(Color.YELLOW);
                g2.drawString(freemindVersion, xCoordinate, yCoordinate);
                g2.setColor(Color.WHITE);
                g2.drawString(freemindVersion, xCoordinate + 1, yCoordinate + 1);
            }
        };
        this.getContentPane().add((Component)l, "Center");
        this.pack();
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = l.getPreferredSize();
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
    }
}

