/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.modes.MindMapLine;
import freemind.modes.MindMapNode;
import freemind.preferences.FreemindPropertyListener;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Stroke;

public abstract class LineAdapter
implements MindMapLine {
    protected FreeMindMain frame;
    protected MindMapNode target;
    protected String standardColorPropertyString;
    protected String standardStylePropertyString;
    public static final int DEFAULT_WIDTH = -1;
    protected int NORMAL_WIDTH = 1;
    protected Color color;
    protected String style;
    protected int width;
    protected Stroke stroke;

    public LineAdapter(MindMapNode target, FreeMindMain frame, String standardColorPropertyString, String standardStylePropertyString) {
        this.frame = frame;
        this.target = target;
        this.standardColorPropertyString = standardColorPropertyString;
        this.standardStylePropertyString = standardStylePropertyString;
        this.width = -1;
        this.stroke = null;
        this.updateStandards();
    }

    protected void updateStandards() {
        String stdStyle;
        if (this.getStandardColor() == null) {
            String stdColor = this.getFrame().getProperty(this.standardColorPropertyString);
            if (stdColor != null && stdColor.length() == 7) {
                this.setStandardColor(Tools.xmlToColor(stdColor));
            } else {
                this.setStandardColor(Color.RED);
            }
        }
        if (this.getStandardStyle() == null && (stdStyle = this.getFrame().getProperty(this.standardStylePropertyString)) != null) {
            this.setStandardStyle(stdStyle);
        }
    }

    public FreeMindMain getFrame() {
        return this.frame;
    }

    public Color getColor() {
        if (this.color == null) {
            return this.getStandardColor();
        }
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
    }

    public int getWidth() {
        if (this.width == -1) {
            return this.NORMAL_WIDTH;
        }
        return this.width;
    }

    public Stroke getStroke() {
        return this.stroke;
    }

    public void setWidth(int width) {
        this.width = width;
        this.stroke = new BasicStroke(this.getWidth(), 0, 0);
    }

    public String getStyle() {
        if (this.style == null) {
            return this.getStandardStyle();
        }
        return this.style;
    }

    public void setStyle(String style) {
        this.style = style;
    }

    public String toString() {
        return "";
    }

    public void setTarget(MindMapNode target) {
        this.target = target;
    }

    public MindMapNode getTarget() {
        return this.target;
    }

    public Object clone() {
        try {
            LineAdapter link = (LineAdapter)super.clone();
            link.color = this.color == null ? null : new Color(this.color.getRGB());
            return link;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    protected abstract void setStandardColor(Color var1);

    protected abstract Color getStandardColor();

    protected abstract void setStandardStyle(String var1);

    protected abstract String getStandardStyle();

    protected class LineAdapterListener
    implements FreemindPropertyListener {
        protected LineAdapterListener() {
        }

        public void propertyChanged(String propertyName, String newValue, String oldValue) {
            if (propertyName.equals(LineAdapter.this.standardColorPropertyString)) {
                LineAdapter.this.setStandardColor(Tools.xmlToColor(newValue));
            }
            if (propertyName.equals(LineAdapter.this.standardStylePropertyString)) {
                LineAdapter.this.setStandardStyle(newValue);
            }
        }
    }
}

