/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.controller.Controller;
import freemind.modes.Mode;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.logging.Logger;

public class ModesCreator {
    private Controller c;
    private Map modes;
    private Map modesTranslation;
    private static Logger logger;

    public ModesCreator(Controller c) {
        this.c = c;
    }

    public Set getAllModes() {
        if (logger == null) {
            logger = this.c.getFrame().getLogger(this.getClass().getName());
        }
        if (this.modes == null) {
            this.modes = new TreeMap();
            this.modesTranslation = new HashMap();
            String modestring = this.c.getFrame().getProperty("modes_since_0_8_0");
            StringTokenizer tokens = new StringTokenizer(modestring, ",");
            while (tokens.hasMoreTokens()) {
                String modename = tokens.nextToken();
                String modeAlias = tokens.nextToken();
                this.modes.put(modename, null);
                this.modesTranslation.put(modeAlias, modename);
            }
            logger.info("Modes:" + this.modes.keySet());
        }
        return this.modesTranslation.keySet();
    }

    public Mode getMode(String modeAlias) {
        this.getAllModes();
        Mode mode = null;
        if (!this.modesTranslation.containsKey(modeAlias)) {
            throw new IllegalArgumentException("Unknown mode " + modeAlias);
        }
        String modeName = (String)this.modesTranslation.get(modeAlias);
        if (this.modes.get(modeName) == null) {
            try {
                mode = (Mode)Class.forName(modeName).newInstance();
                logger.info("Initializing mode " + modeAlias);
                mode.init(this.c);
                logger.info("Done: Initializing mode " + modeAlias);
                this.modes.put(modeName, mode);
            }
            catch (Exception ex) {
                logger.severe("Mode " + modeName + " could not be loaded.");
                ex.printStackTrace();
            }
        }
        return (Mode)this.modes.get(modeName);
    }
}

