/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.Controller;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.generated.instance.EdgeColorFormatAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.EdgeAdapter;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapEdgeModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.swing.AbstractAction;
import javax.xml.bind.JAXBException;

public class EdgeColorAction
extends AbstractAction
implements ActorXml {
    private final ModeController controller;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$EdgeColorFormatAction;

    public EdgeColorAction(ModeController controller) {
        super(controller.getText("edge_color"));
        this.controller = controller;
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent e) {
        Color color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), this.controller.getText("choose_edge_color"), this.controller.getSelected().getEdge().getColor());
        if (color == null) {
            return;
        }
        ListIterator it = this.controller.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.setEdgeColor(selected, color);
        }
    }

    public void setEdgeColor(MindMapNode node, Color color) {
        try {
            EdgeColorFormatAction doAction = this.createEdgeColorFormatAction(node, color);
            EdgeColorFormatAction undoAction = this.createEdgeColorFormatAction(node, ((EdgeAdapter)node.getEdge()).getRealColor());
            this.controller.getActionFactory().startTransaction(this.getClass().getName());
            this.controller.getActionFactory().executeAction(new ActionPair(doAction, undoAction));
            this.controller.getActionFactory().endTransaction(this.getClass().getName());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public void act(XmlAction action) {
        NodeAdapter node;
        Color oldColor;
        EdgeColorFormatAction edgeAction;
        Color color;
        if (action instanceof EdgeColorFormatAction && !Tools.safeEquals(color = Tools.xmlToColor((edgeAction = (EdgeColorFormatAction)action).getColor()), oldColor = ((EdgeAdapter)(node = this.controller.getNodeFromID(edgeAction.getNode())).getEdge()).getRealColor())) {
            ((MindMapEdgeModel)node.getEdge()).setColor(color);
            this.controller.nodeChanged(node);
        }
    }

    public EdgeColorFormatAction createEdgeColorFormatAction(MindMapNode node, Color color) throws JAXBException {
        EdgeColorFormatAction edgeAction = this.controller.getActionXmlFactory().createEdgeColorFormatAction();
        edgeAction.setNode(node.getObjectId(this.controller));
        if (color != null) {
            edgeAction.setColor(Tools.colorToXml(color));
        }
        return edgeAction;
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$EdgeColorFormatAction == null ? (class$freemind$controller$actions$generated$instance$EdgeColorFormatAction = EdgeColorAction.class$("freemind.controller.actions.generated.instance.EdgeColorFormatAction")) : class$freemind$controller$actions$generated$instance$EdgeColorFormatAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

