/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;

public class JoinNodesAction
extends AbstractAction {
    private final ModeController controller;

    public JoinNodesAction(ModeController controller) {
        super(controller.getText("join_nodes"));
        this.controller = controller;
    }

    public void actionPerformed(ActionEvent e) {
        MindMapNode selectedNode = this.controller.getView().getSelected().getModel();
        ArrayList selectedNodes = this.controller.getView().getSelectedNodesSortedByY();
        this.joinNodes(selectedNode, selectedNodes);
    }

    public void joinNodes(MindMapNode selectedNode, List selectedNodes) {
        MindMapNode node;
        String newContent = "";
        boolean firstLoop = true;
        Iterator it = selectedNodes.iterator();
        while (it.hasNext()) {
            node = (MindMapNode)it.next();
            if (!node.hasChildren()) continue;
            JOptionPane.showMessageDialog(node.getViewer(), this.controller.getText("cannot_join_nodes_with_children"), "FreeMind", 2);
            return;
        }
        it = selectedNodes.iterator();
        while (it.hasNext()) {
            if (firstLoop) {
                firstLoop = false;
            } else {
                newContent = newContent + " ";
            }
            node = (MindMapNode)it.next();
            newContent = newContent + ((Object)node).toString();
            if (node == selectedNode) continue;
            this.controller.deleteNode(node);
        }
        this.controller.getView().selectAsTheOnlyOneSelected(selectedNode.getViewer());
        this.controller.setNodeText(selectedNode, newContent);
    }
}

