/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.Controller;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.ActorXml;
import freemind.controller.actions.FreemindAction;
import freemind.controller.actions.generated.instance.NodeColorFormatAction;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.main.Tools;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import javax.xml.bind.JAXBException;

public class NodeColorAction
extends FreemindAction
implements ActorXml {
    private final ModeController controller;
    static /* synthetic */ Class class$freemind$controller$actions$generated$instance$NodeColorFormatAction;

    public NodeColorAction(ModeController controller) {
        super("node_color", (String)null, controller);
        this.controller = controller;
        controller.getActionFactory().registerActor(this, this.getDoActionClass());
    }

    public void actionPerformed(ActionEvent e) {
        Color color = Controller.showCommonJColorChooserDialog(this.controller.getView().getSelected(), this.controller.getText("choose_node_color"), this.controller.getSelected().getColor());
        if (color == null) {
            return;
        }
        ListIterator it = this.controller.getSelecteds().listIterator();
        while (it.hasNext()) {
            MindMapNodeModel selected = (MindMapNodeModel)it.next();
            this.setNodeColor(selected, color);
        }
    }

    public void setNodeColor(MindMapNode node, Color color) {
        try {
            NodeColorFormatAction doAction = this.createNodeColorFormatAction(node, color);
            NodeColorFormatAction undoAction = this.createNodeColorFormatAction(node, node.getColor());
            this.controller.getActionFactory().startTransaction(this.getClass().getName());
            this.controller.getActionFactory().executeAction(new ActionPair(doAction, undoAction));
            this.controller.getActionFactory().endTransaction(this.getClass().getName());
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    public NodeColorFormatAction createNodeColorFormatAction(MindMapNode node, Color color) throws JAXBException {
        NodeColorFormatAction nodeAction = this.controller.getActionXmlFactory().createNodeColorFormatAction();
        nodeAction.setNode(node.getObjectId(this.controller));
        nodeAction.setColor(Tools.colorToXml(color));
        return nodeAction;
    }

    public void act(XmlAction action) {
        NodeAdapter node;
        Color oldColor;
        NodeColorFormatAction nodeColorAction;
        Color color;
        if (action instanceof NodeColorFormatAction && !Tools.safeEquals(color = Tools.xmlToColor((nodeColorAction = (NodeColorFormatAction)action).getColor()), oldColor = (node = this.controller.getNodeFromID(nodeColorAction.getNode())).getColor())) {
            node.setColor(color);
            this.controller.nodeChanged(node);
        }
    }

    public Class getDoActionClass() {
        return class$freemind$controller$actions$generated$instance$NodeColorFormatAction == null ? (class$freemind$controller$actions$generated$instance$NodeColorFormatAction = NodeColorAction.class$("freemind.controller.actions.generated.instance.NodeColorFormatAction")) : class$freemind$controller$actions$generated$instance$NodeColorFormatAction;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

