/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.actions;

import freemind.controller.actions.AbstractXmlAction;
import freemind.controller.actions.ActionPair;
import freemind.controller.actions.NodeActorXml;
import freemind.controller.actions.generated.instance.CompoundAction;
import freemind.controller.actions.generated.instance.ObjectFactory;
import freemind.controller.actions.generated.instance.XmlAction;
import freemind.modes.MindMapNode;
import freemind.modes.ModeController;
import freemind.modes.NodeAdapter;
import freemind.modes.actions.SingleNodeOperation;
import freemind.modes.mindmapmode.MindMapMapModel;
import freemind.modes.mindmapmode.MindMapNodeModel;
import java.awt.event.ActionEvent;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.xml.bind.JAXBException;

public class NodeGeneralAction
extends AbstractXmlAction {
    protected final ModeController modeController;
    private NodeActorXml actor;
    SingleNodeOperation singleNodeOperation;
    protected static Logger logger;

    protected NodeGeneralAction(ModeController modeController, String textID, String iconPath) {
        super(null, iconPath != null ? new ImageIcon(modeController.getController().getResource(iconPath)) : null, modeController);
        this.modeController = modeController;
        if (textID != null) {
            this.setName(modeController.getText(textID));
        }
        this.singleNodeOperation = null;
        this.actor = null;
        if (logger == null) {
            logger = modeController.getFrame().getLogger(this.getClass().getName());
        }
    }

    protected void setName(String name) {
        if (name != null) {
            this.putValue("Name", name);
            this.putValue("ShortDescription", name);
        }
    }

    public NodeGeneralAction(ModeController modeController, String textID, String iconPath, SingleNodeOperation singleNodeOperation) {
        this(modeController, textID, iconPath);
        this.singleNodeOperation = singleNodeOperation;
    }

    public NodeGeneralAction(ModeController modeController, String textID, String iconPath, NodeActorXml actor) {
        this(modeController, textID, iconPath);
        this.addActor(actor);
    }

    public void addActor(NodeActorXml actor) {
        this.actor = actor;
        if (actor != null) {
            super.addActor(actor);
        }
    }

    public void setSingleNodeOperation(SingleNodeOperation singleNodeOperation) {
        this.singleNodeOperation = singleNodeOperation;
    }

    public void xmlActionPerformed(ActionEvent e) {
        if (this.singleNodeOperation != null) {
            ListIterator it = this.modeController.getSelecteds().listIterator();
            while (it.hasNext()) {
                MindMapNodeModel selected = (MindMapNodeModel)it.next();
                this.singleNodeOperation.apply((MindMapMapModel)this.modeController.getMap(), selected);
            }
        } else {
            try {
                CompoundAction doAction = this.modeController.getActionXmlFactory().createCompoundAction();
                CompoundAction undo = this.modeController.getActionXmlFactory().createCompoundAction();
                ListIterator it = this.modeController.getSelecteds().listIterator();
                while (it.hasNext()) {
                    MindMapNodeModel selected = (MindMapNodeModel)it.next();
                    ActionPair pair = this.actor.apply(this.modeController.getMap(), selected);
                    if (pair == null) continue;
                    doAction.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(pair.getDoAction());
                    undo.getCompoundActionOrSelectNodeActionOrCutNodeAction().add(0, pair.getUndoAction());
                }
                this.modeController.getActionFactory().startTransaction((String)this.getValue("Name"));
                this.modeController.getActionFactory().executeAction(new ActionPair(doAction, undo));
                this.modeController.getActionFactory().endTransaction((String)this.getValue("Name"));
            }
            catch (JAXBException e1) {
                e1.printStackTrace();
            }
        }
    }

    protected void execute(ActionPair pair) {
        this.modeController.getActionFactory().executeAction(pair);
    }

    public void act(XmlAction action) {
    }

    protected NodeAdapter getNodeFromID(String string) {
        return this.modeController.getNodeFromID(string);
    }

    protected String getNodeID(MindMapNode selected) {
        return this.modeController.getNodeID(selected);
    }

    protected ObjectFactory getActionXmlFactory() {
        return this.modeController.getActionXmlFactory();
    }
}

