/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.controller.MindMapNodesSelection;
import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLParseException;
import freemind.modes.LinkRegistryAdapter;
import freemind.modes.MapAdapter;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import freemind.modes.mindmapmode.MindMapNodeModel;
import freemind.modes.mindmapmode.MindMapXMLElement;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.datatransfer.Transferable;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.nio.channels.FileLock;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Timer;
import java.util.TimerTask;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class MindMapMapModel
extends MapAdapter {
    LockManager lockManager;
    private LinkRegistryAdapter linkRegistry;
    private Timer timerForAutomaticSaving;

    public MindMapMapModel(FreeMindMain frame) {
        this(new MindMapNodeModel(frame.getResourceString("new_mindmap"), frame), frame);
    }

    public MindMapMapModel(MindMapNodeModel root, FreeMindMain frame) {
        super(frame);
        this.lockManager = frame.getProperty("experimental_file_locking_on").equals("true") ? new LockManager() : new DummyLockManager();
        this.linkRegistry = new LinkRegistryAdapter();
        this.setRoot(root);
        this.readOnly = false;
        this.timerForAutomaticSaving = new Timer();
        int delay = Integer.parseInt(this.getFrame().getProperty("time_for_automatic_save"));
        int numberOfTempFiles = Integer.parseInt(this.getFrame().getProperty("number_of_different_files_for_automatic_save"));
        boolean filesShouldBeDeletedAfterShutdown = Tools.safeEquals(this.getFrame().getProperty("delete_automatic_saves_at_exit"), "true");
        String path = this.getFrame().getProperty("path_to_automatic_saves");
        if (Tools.safeEquals(path, "default")) {
            path = null;
        }
        if (Tools.safeEquals(path, "freemind_home")) {
            path = this.getFrame().getFreemindDirectory();
        }
        File dirToStore = null;
        if (path != null && !(dirToStore = new File(path)).isDirectory()) {
            dirToStore = null;
            System.err.println("Temporary directory " + path + " not found. Disabling automatic store.");
            delay = Integer.MAX_VALUE;
        }
        this.timerForAutomaticSaving.schedule((TimerTask)new doAutomaticSave(this, numberOfTempFiles, filesShouldBeDeletedAfterShutdown, dirToStore), delay, (long)delay);
    }

    public MindMapLinkRegistry getLinkRegistry() {
        return this.linkRegistry;
    }

    public String getRestoreable() {
        return this.getFile() == null ? null : "MindMap:" + this.getFile().getAbsolutePath();
    }

    public String toString() {
        return this.getFile() == null ? null : this.getFile().getName();
    }

    public boolean saveHTML(MindMapNodeModel rootNodeOfBranch, File file) {
        try {
            boolean writeFoldingCode;
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            String el = System.getProperty("line.separator");
            fileout.write("<html>" + el + "<head>" + el + "<title>" + rootNodeOfBranch.saveHTML_escapeUnicodeAndSpecialCharacters(rootNodeOfBranch.toString()) + "</title>" + el + "<style type=\"text/css\">" + el + "    span.foldopened { color: white; font-size: xx-small;" + el + "    border-width: 1; font-family: monospace; padding: 0em 0.25em 0em 0.25em; background: #e0e0e0;" + el + "    VISIBILITY: visible;" + el + "    cursor:pointer; }" + el + "" + el + "" + el + "    span.foldclosed { color: #666666; font-size: xx-small;" + el + "    border-width: 1; font-family: monospace; padding: 0em 0.25em 0em 0.25em; background: #e0e0e0;" + el + "    VISIBILITY: hidden;" + el + "    cursor:pointer; }" + el + "" + el + "    span.foldspecial { color: #666666; font-size: xx-small; border-style: none solid solid none;" + el + "    border-color: #CCCCCC; border-width: 1; font-family: sans-serif; padding: 0em 0.1em 0em 0.1em; background: #e0e0e0;" + el + "    cursor:pointer; }" + el + "" + el + "    li { list-style: none; }" + el + "" + el + "    span.l { color: red; font-weight: bold; }" + el + "" + el + "    a:link {text-decoration: none; color: black; }" + el + "    a:visited {text-decoration: none; color: black; }" + el + "    a:active {text-decoration: none; color: black; }" + el + "    a:hover {text-decoration: none; color: black; background: #eeeee0; }" + el + "" + el + "</style>" + el + "<!-- ^ Position is not set to relative / absolute here because of Mozilla -->" + el + "</head>" + el + "<body>" + el);
            String htmlExportFoldingOption = this.getFrame().getProperty("html_export_folding");
            boolean bl = writeFoldingCode = htmlExportFoldingOption.equals("html_export_fold_currently_folded") && rootNodeOfBranch.hasFoldedStrictDescendant() || htmlExportFoldingOption.equals("html_export_fold_all");
            if (writeFoldingCode) {
                fileout.write("" + el + "<script language=\"JavaScript\">" + el + "   // Here we implement folding. It works fine with MSIE5.5, MSIE6.0 and" + el + "   // Mozilla 0.9.6." + el + "" + el + "   if (document.layers) {" + el + "      //Netscape 4 specific code" + el + "      pre = 'document.';" + el + "      post = ''; }" + el + "   if (document.getElementById) {" + el + "      //Netscape 6 specific code" + el + "      pre = 'document.getElementById(\"';" + el + "      post = '\").style'; }" + el + "   if (document.all) {" + el + "      //IE4+ specific code" + el + "      pre = 'document.all.';" + el + "      post = '.style'; }" + el + "" + el + "function layer_exists(layer) {" + el + "   try {" + el + "      eval(pre + layer + post);" + el + "      return true; }" + el + "   catch (error) {" + el + "      return false; }}" + el + "" + el + "function show_layer(layer) {" + el + "   eval(pre + layer + post).position = 'relative'; " + el + "   eval(pre + layer + post).visibility = 'visible'; }" + el + "" + el + "function hide_layer(layer) {" + el + "   eval(pre + layer + post).visibility = 'hidden';" + el + "   eval(pre + layer + post).position = 'absolute'; }" + el + "" + el + "function hide_folder(folder) {" + el + "    hide_folding_layer(folder)" + el + "    show_layer('show'+folder);" + el + "" + el + "    scrollBy(0,0); // This is a work around to make it work in Browsers (Explorer, Mozilla)" + el + "}" + el + "" + el + "function show_folder(folder) {" + el + "    // Precondition: all subfolders are folded" + el + "" + el + "    show_layer('hide'+folder);" + el + "    hide_layer('show'+folder);" + el + "    show_layer('fold'+folder);" + el + "" + el + "    scrollBy(0,0); // This is a work around to make it work in Browsers (Explorer, Mozilla)" + el + "" + el + "    var i;" + el + "    for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       show_layer('show'+folder+'_'+i); }" + el + "}" + el + "" + "function show_folder_completely(folder) {" + el + "    // Precondition: all subfolders are folded" + el + "" + el + "    show_layer('hide'+folder);" + el + "    hide_layer('show'+folder);" + el + "    show_layer('fold'+folder);" + el + "" + el + "    scrollBy(0,0); // This is a work around to make it work in Browsers (Explorer, Mozilla)" + el + "" + el + "    var i;" + el + "    for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       show_folder_completely(folder+'_'+i); }" + el + "}" + el + "" + el + "" + el + "" + el + "function hide_folding_layer(folder) {" + el + "   var i;" + el + "   for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       hide_folding_layer(folder+'_'+i); }" + el + "" + el + "   hide_layer('hide'+folder);" + el + "   hide_layer('show'+folder);" + el + "   hide_layer('fold'+folder);" + el + "" + el + "   scrollBy(0,0); // This is a work around to make it work in Browsers (Explorer, Mozilla)" + el + "}" + el + "" + el + "function fold_document() {" + el + "   var i;" + el + "   var folder = '1';" + el + "   for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       hide_folder(folder+'_'+i); }" + el + "}" + el + "" + el + "function unfold_document() {" + el + "   var i;" + el + "   var folder = '1';" + el + "   for (i=1; layer_exists('fold'+folder+'_'+i); ++i) {" + el + "       show_folder_completely(folder+'_'+i); }" + el + "}" + el + "" + el + "</script>" + el);
                fileout.write("<SPAN class=foldspecial onclick=\"fold_document()\">All +</SPAN>" + el);
                fileout.write("<SPAN class=foldspecial onclick=\"unfold_document()\">All -</SPAN>" + el);
            }
            rootNodeOfBranch.saveHTML(fileout, "1", 0, true, true, 1);
            if (writeFoldingCode) {
                fileout.write("<SCRIPT language=JavaScript>" + el);
                fileout.write("fold_document();" + el);
                fileout.write("</SCRIPT>" + el);
            }
            fileout.write("</body>" + el);
            fileout.write("</html>" + el);
            fileout.close();
            return true;
        }
        catch (Exception e) {
            System.err.println("Error in MindMapMapModel.saveHTML(): ");
            e.printStackTrace();
            return false;
        }
    }

    public String getAsPlainText(List mindMapNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter fileout = new BufferedWriter(stringWriter);
            ListIterator it = mindMapNodes.listIterator();
            while (it.hasNext()) {
                ((MindMapNodeModel)it.next()).saveTXT(fileout, 0);
            }
            fileout.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveTXT(MindMapNodeModel rootNodeOfBranch, File file) {
        try {
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            rootNodeOfBranch.saveTXT(fileout, 0);
            fileout.close();
            return true;
        }
        catch (Exception e) {
            System.err.println("Error in MindMapMapModel.saveTXT(): ");
            e.printStackTrace();
            return false;
        }
    }

    public String getAsRTF(List mindMapNodes) {
        try {
            StringWriter stringWriter = new StringWriter();
            BufferedWriter fileout = new BufferedWriter(stringWriter);
            this.saveRTF(mindMapNodes, fileout);
            fileout.close();
            return stringWriter.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public boolean saveRTF(List mindMapNodes, BufferedWriter fileout) {
        try {
            HashSet colors = new HashSet();
            ListIterator it = mindMapNodes.listIterator();
            while (it.hasNext()) {
                ((MindMapNodeModel)it.next()).collectColors(colors);
            }
            String colorTableString = "{\\colortbl;\\red0\\green0\\blue255;";
            HashMap<Color, Integer> colorTable = new HashMap<Color, Integer>();
            int colorPosition = 2;
            Iterator it2 = colors.iterator();
            while (it2.hasNext()) {
                Color color = (Color)it2.next();
                colorTableString = colorTableString + "\\red" + color.getRed() + "\\green" + color.getGreen() + "\\blue" + color.getBlue() + ";";
                colorTable.put(color, new Integer(colorPosition));
                ++colorPosition;
            }
            colorTableString = colorTableString + "}";
            fileout.write("{\\rtf1\\ansi\\ansicpg1252\\deff0\\deflang1033{\\fonttbl{\\f0\\fswiss\\fcharset0 Arial;}" + colorTableString + "}" + "\\viewkind4\\uc1\\pard\\f0\\fs20{}");
            it2 = mindMapNodes.listIterator();
            while (it2.hasNext()) {
                ((MindMapNodeModel)it2.next()).saveRTF(fileout, 0, colorTable);
            }
            fileout.write("}");
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean save(File file) {
        return this.saveInternal(file, false);
    }

    private boolean saveInternal(File file, boolean isInternal) {
        if (!isInternal && this.readOnly) {
            System.err.println("Attempt to save read-only map.");
            return false;
        }
        try {
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(file)));
            this.getXml(fileout);
            if (!isInternal) {
                this.setFile(file);
                this.setSaved(true);
            }
            return true;
        }
        catch (FileNotFoundException e) {
            String message = Tools.expandPlaceholders(this.getText("save_failed"), file.getName());
            if (!isInternal) {
                this.getFrame().getController().errorMessage(message);
            } else {
                this.getFrame().out(message);
            }
            return false;
        }
        catch (Exception e) {
            System.err.println("Error in MindMapMapModel.save(): ");
            e.printStackTrace();
            return false;
        }
    }

    public void getXml(Writer fileout) throws IOException {
        fileout.write("<map version=\"" + this.getFrame().getFreemindVersion() + "\">\n");
        fileout.write("<!-- To view this file, download free mind mapping software FreeMind from http://freemind.sourceforge.net -->\n");
        ((MindMapNodeModel)this.getRoot()).save(fileout, this.getLinkRegistry());
        fileout.write("</map>\n");
        fileout.close();
    }

    public String tryToLock(File file) throws Exception {
        String lockingUser = this.lockManager.tryToLock(file);
        String lockingUserOfOldLock = this.lockManager.popLockingUserOfOldLock();
        if (lockingUserOfOldLock != null) {
            this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("locking_old_lock_removed"), file.getName(), lockingUserOfOldLock));
        }
        if (lockingUser == null) {
            this.readOnly = false;
        }
        return lockingUser;
    }

    public void load(File file) throws FileNotFoundException, IOException, XMLParseException {
        if (!file.exists()) {
            throw new FileNotFoundException(Tools.expandPlaceholders(this.getText("file_not_found"), file.getPath()));
        }
        if (!file.canWrite()) {
            this.readOnly = true;
        } else {
            try {
                String lockingUser = this.tryToLock(file);
                if (lockingUser != null) {
                    this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("map_locked_by_open"), file.getName(), lockingUser));
                    this.readOnly = true;
                } else {
                    this.readOnly = false;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.getFrame().getController().informationMessage(Tools.expandPlaceholders(this.getText("locking_failed_by_open"), file.getName()));
                this.readOnly = true;
            }
        }
        MindMapNodeModel root = this.loadTree(file);
        if (root != null) {
            this.setRoot(root);
        }
        this.setFile(file);
        this.setSaved(true);
    }

    public void destroy() {
        super.destroy();
        this.lockManager.releaseLock();
        this.lockManager.releaseTimer();
        this.timerForAutomaticSaving.cancel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    MindMapNodeModel loadTree(File file) throws XMLParseException, IOException {
        MindMapXMLElement mapElement = new MindMapXMLElement(this.getFrame());
        String expectedStartString = "<map version=\"0.8.1\"";
        String expectedAlternativeStartString = "<map version=\"0.7.1\"";
        int versionInfoLength = expectedStartString.length();
        StringBuffer buffer = this.readFileStart(file, versionInfoLength);
        String mapStart = "";
        if (buffer.length() >= versionInfoLength) {
            mapStart = buffer.substring(0, versionInfoLength);
        }
        Reader reader = null;
        reader = mapStart.equals(expectedStartString) || mapStart.equals(expectedAlternativeStartString) ? this.getActualReader(file) : this.getUpdateReader(file);
        try {
            mapElement.parseFromReader(reader);
        }
        catch (Exception ex) {
            System.err.println("Error while parsing file:" + ex);
            ex.printStackTrace();
            MindMapNodeModel mindMapNodeModel = null;
            return mindMapNodeModel;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        mapElement.processUnfinishedLinks(this.getLinkRegistry());
        return (MindMapNodeModel)mapElement.getMapChild();
    }

    private StringBuffer readFileStart(File file, int pMinimumLength) {
        BufferedReader in = null;
        StringBuffer buffer = new StringBuffer();
        try {
            String str;
            in = new BufferedReader(new FileReader(file));
            while ((str = in.readLine()) != null) {
                buffer.append(str);
                if (buffer.length() < pMinimumLength) continue;
            }
            in.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            return new StringBuffer();
        }
        return buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Reader getUpdateReader(File file) throws IOException {
        StringWriter writer = null;
        InputStream inputStream = null;
        logger.info("Updating the file " + file.getName() + " to the current version.");
        try {
            URL updaterUrl = null;
            updaterUrl = this.getFrame().getResource("freemind/modes/mindmapmode/freemind_version_updater.xslt");
            if (updaterUrl == null) {
                throw new IllegalArgumentException("freemind_version_updater.xslt not found.");
            }
            StreamSource xsltSource = null;
            inputStream = updaterUrl.openStream();
            xsltSource = new StreamSource(inputStream);
            writer = new StringWriter();
            StreamResult result = new StreamResult(writer);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.transform(new StreamSource(file), result);
            logger.info("Updating the file " + file.getName() + " to the current version. Done.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            Reader reader = this.getActualReader(file);
            return reader;
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
        return new StringReader(writer.getBuffer().toString());
    }

    private Reader getActualReader(File file) throws FileNotFoundException {
        return new BufferedReader(new FileReader(file));
    }

    public Transferable copy(MindMapNode node) {
        StringWriter stringWriter = new StringWriter();
        try {
            ((MindMapNodeModel)node).save(stringWriter, this.getLinkRegistry());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return new MindMapNodesSelection(stringWriter.toString(), null, null, null, null, null);
    }

    private class doAutomaticSave
    extends TimerTask {
        private MindMapMapModel model;
        private Vector tempFileStack;
        private int numberOfFiles;
        private boolean filesShouldBeDeletedAfterShutdown;
        private File pathToStore;
        private int changeState;

        doAutomaticSave(MindMapMapModel model, int numberOfTempFiles, boolean filesShouldBeDeletedAfterShutdown, File pathToStore) {
            this.model = model;
            this.tempFileStack = new Vector();
            this.numberOfFiles = numberOfTempFiles > 0 ? numberOfTempFiles : 1;
            this.filesShouldBeDeletedAfterShutdown = filesShouldBeDeletedAfterShutdown;
            this.pathToStore = pathToStore;
            this.changeState = 0;
        }

        public void run() {
            if (this.model.getNumberOfChangesSinceLastSave() == this.changeState) {
                return;
            }
            this.changeState = this.model.getNumberOfChangesSinceLastSave();
            if (this.model.getNumberOfChangesSinceLastSave() == 0) {
                return;
            }
            try {
                EventQueue.invokeAndWait(new Runnable(){

                    public void run() {
                        File tempFile;
                        if (doAutomaticSave.this.tempFileStack.size() >= doAutomaticSave.this.numberOfFiles) {
                            tempFile = (File)doAutomaticSave.this.tempFileStack.remove(0);
                        } else {
                            try {
                                tempFile = File.createTempFile("FM_" + (doAutomaticSave.this.model.toString() == null ? "unnamed" : doAutomaticSave.this.model.toString()), ".mm", doAutomaticSave.this.pathToStore);
                                if (doAutomaticSave.this.filesShouldBeDeletedAfterShutdown) {
                                    tempFile.deleteOnExit();
                                }
                            }
                            catch (Exception e) {
                                System.err.println("Error in automatic MindMapMapModel.save(): " + e.getMessage());
                                e.printStackTrace();
                                return;
                            }
                        }
                        try {
                            doAutomaticSave.this.model.saveInternal(tempFile, true);
                            doAutomaticSave.this.model.getFrame().out("Map was automatically saved (using the file name " + tempFile + ") ...");
                        }
                        catch (Exception e) {
                            System.err.println("Error in automatic MindMapMapModel.save(): " + e.getMessage());
                            e.printStackTrace();
                        }
                        doAutomaticSave.this.tempFileStack.add(tempFile);
                    }
                });
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private class DummyLockManager
    extends LockManager {
        private DummyLockManager() {
        }

        public synchronized String popLockingUserOfOldLock() {
            return null;
        }

        public synchronized String tryToLock(File file) throws Exception {
            return null;
        }

        public synchronized void releaseLock() {
        }

        public synchronized void releaseTimer() {
        }

        public synchronized void run() {
        }
    }

    private class LockManager
    extends TimerTask {
        File lockedSemaphoreFile = null;
        Timer lockTimer = null;
        final long lockUpdatePeriod = 240000L;
        final long lockSafetyPeriod = 300000L;
        String lockingUserOfOldLock = null;

        private LockManager() {
        }

        private File getSemaphoreFile(File mapFile) {
            return new File(mapFile.getParent() + System.getProperty("file.separator") + "$~" + mapFile.getName() + "~");
        }

        public synchronized String popLockingUserOfOldLock() {
            String toReturn = this.lockingUserOfOldLock;
            this.lockingUserOfOldLock = null;
            return toReturn;
        }

        private void writeSemaphoreFile(File inSemaphoreFile) throws Exception {
            FileOutputStream semaphoreOutputStream = new FileOutputStream(inSemaphoreFile);
            FileLock lock = null;
            try {
                lock = semaphoreOutputStream.getChannel().tryLock();
                if (lock == null) {
                    semaphoreOutputStream.close();
                    System.err.println("Locking failed.");
                    throw new Exception();
                }
            }
            catch (UnsatisfiedLinkError eUle) {
            }
            catch (NoClassDefFoundError eDcdf) {
                // empty catch block
            }
            semaphoreOutputStream.write(System.getProperty("user.name").getBytes());
            semaphoreOutputStream.write(10);
            semaphoreOutputStream.write(String.valueOf(System.currentTimeMillis()).getBytes());
            semaphoreOutputStream.close();
            semaphoreOutputStream = null;
            Tools.setHidden(inSemaphoreFile, true, false);
            if (lock != null) {
                lock.release();
            }
        }

        public synchronized String tryToLock(File file) throws Exception {
            File semaphoreFile = this.getSemaphoreFile(file);
            if (semaphoreFile == this.lockedSemaphoreFile) {
                return null;
            }
            try {
                BufferedReader semaphoreReader = new BufferedReader(new FileReader(semaphoreFile));
                String lockingUser = semaphoreReader.readLine();
                long lockTime = new Long(semaphoreReader.readLine());
                long timeDifference = System.currentTimeMillis() - lockTime;
                if (timeDifference <= 300000L) {
                    return lockingUser;
                }
                semaphoreReader.close();
                this.lockingUserOfOldLock = lockingUser;
                semaphoreFile.delete();
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
            this.writeSemaphoreFile(semaphoreFile);
            if (this.lockTimer == null) {
                this.lockTimer = new Timer();
                this.lockTimer.schedule((TimerTask)this, 240000L, 240000L);
            }
            this.releaseLock();
            this.lockedSemaphoreFile = semaphoreFile;
            return null;
        }

        public synchronized void releaseLock() {
            if (this.lockedSemaphoreFile != null) {
                this.lockedSemaphoreFile.delete();
                this.lockedSemaphoreFile = null;
            }
        }

        public synchronized void releaseTimer() {
            if (this.lockTimer != null) {
                this.lockTimer.cancel();
                this.lockTimer = null;
            }
        }

        public synchronized void run() {
            if (this.lockedSemaphoreFile == null) {
                System.err.println("unexpected: lockedSemaphoreFile is null upon lock update");
                return;
            }
            try {
                Tools.setHidden(this.lockedSemaphoreFile, false, true);
                this.writeSemaphoreFile(this.lockedSemaphoreFile);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

