/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes.mindmapmode;

import freemind.controller.StructuredMenuHolder;
import freemind.modes.mindmapmode.MindMapController;
import java.util.HashSet;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.swing.JPopupMenu;
import javax.swing.event.MenuListener;

public class MindMapPopupMenu
extends JPopupMenu
implements StructuredMenuHolder.MenuEventSupplier {
    private HashSet listeners = new HashSet();
    private static final String MINDMAPMODE_POPUP = "mindmapmode_popup/";
    private static Logger logger = null;
    private MindMapController c;

    public MindMapPopupMenu(MindMapController c) {
        this.c = c;
        if (logger == null) {
            logger = c.getFrame().getLogger(this.getClass().getName());
        }
    }

    public void update(StructuredMenuHolder holder) {
        this.removeAll();
        this.c.createPatternSubMenu(holder, MINDMAPMODE_POPUP);
        this.c.addIconsToMenu(holder, "mindmapmode_popup/icons/");
        holder.updateMenus(this, MINDMAPMODE_POPUP);
    }

    protected void firePopupMenuWillBecomeVisible() {
        super.firePopupMenuWillBecomeVisible();
        logger.info("Popup firePopupMenuWillBecomeVisible called.");
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            MenuListener listener = (MenuListener)i.next();
            listener.menuSelected(null);
        }
    }

    public void addMenuListener(MenuListener listener) {
        this.listeners.add(listener);
    }

    public void removeMenuListener(MenuListener listener) {
        this.listeners.remove(listener);
    }

    protected void firePopupMenuCanceled() {
        super.firePopupMenuCanceled();
        logger.info("Popup firePopupMenuCanceled called.");
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            MenuListener listener = (MenuListener)i.next();
            listener.menuCanceled(null);
        }
    }

    protected void firePopupMenuWillBecomeInvisible() {
        super.firePopupMenuWillBecomeInvisible();
        logger.info("Popup firePopupMenuWillBecomeInvisible called.");
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            MenuListener listener = (MenuListener)i.next();
            listener.menuDeselected(null);
        }
    }
}

