/*
 * Decompiled with CFR 0.152.
 */
package freemind.view.mindmapview;

import freemind.main.Tools;
import freemind.modes.ModeController;
import freemind.view.mindmapview.EditNodeBase;
import freemind.view.mindmapview.NodeView;
import java.awt.Point;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class EditNodeTextField
extends EditNodeBase {
    private KeyEvent firstEvent;
    private JTextField textfield;

    public EditNodeTextField(NodeView node, String text, KeyEvent firstEvent, ModeController controller, EditNodeBase.EditControl editControl) {
        super(node, text, controller, editControl);
        this.firstEvent = firstEvent;
    }

    public void show() {
        this.textfield = this.getText().length() < 8 ? new JTextField(this.getText(), 8) : new JTextField(this.getText());
        int linkIconWidth = 16;
        int textFieldBorderWidth = 2;
        int cursorWidth = 1;
        int xOffset = -1 * textFieldBorderWidth - 1;
        int yOffset = -1;
        int widthAddition = 2 * textFieldBorderWidth + cursorWidth + 2;
        int heightAddition = 2;
        if (this.getNode().getModel().getLink() != null) {
            xOffset += linkIconWidth;
            widthAddition -= linkIconWidth;
        }
        if (this.getNode().getModel().getIcons().size() != 0) {
            xOffset += linkIconWidth * this.getNode().getModel().getIcons().size();
            widthAddition -= linkIconWidth;
        }
        int MINIMAL_LEAF_WIDTH = 150;
        int MINIMAL_WIDTH = 50;
        int xSize = this.getNode().getWidth() + widthAddition;
        int xExtraWidth = 0;
        if (150 > xSize && (this.getNode().getModel().isFolded() || !this.getNode().getModel().hasChildren())) {
            xExtraWidth = 150 - xSize;
            xSize = 150;
            if (this.getNode().isLeft()) {
                xExtraWidth = -xExtraWidth;
                this.textfield.setHorizontalAlignment(4);
            }
        } else if (50 > xSize) {
            xExtraWidth = 50 - xSize;
            xSize = 50;
            if (this.getNode().isLeft()) {
                xExtraWidth = -xExtraWidth;
                this.textfield.setHorizontalAlignment(4);
            }
        }
        this.textfield.setSize(xSize, this.getNode().getHeight() + heightAddition);
        this.textfield.setFont(this.getNode().getFont());
        this.textfield.setForeground(this.getNode().getForeground());
        this.textfield.setSelectedTextColor(this.getNode().getForeground());
        this.textfield.setSelectionColor(this.getModeController().getSelectionColor());
        boolean INIT = false;
        boolean EDIT = true;
        int CANCEL = 2;
        Tools.IntHolder eventSource = new Tools.IntHolder();
        eventSource.setValue(0);
        class TextFieldListener
        implements KeyListener,
        FocusListener,
        MouseListener {
            private final /* synthetic */ Tools.IntHolder val$eventSource;

            TextFieldListener(Tools.IntHolder intHolder) {
                this.val$eventSource = intHolder;
            }

            public void focusGained(FocusEvent e) {
                if (this.val$eventSource.getValue() == 0) {
                    this.val$eventSource.setValue(1);
                    if (EditNodeTextField.this.firstEvent instanceof KeyEvent) {
                        KeyEvent firstKeyEvent = EditNodeTextField.this.firstEvent;
                        if (firstKeyEvent.getKeyChar() == '\uffff') {
                            switch (firstKeyEvent.getKeyCode()) {
                                case 36: {
                                    EditNodeTextField.this.textfield.setCaretPosition(0);
                                    break;
                                }
                                case 35: {
                                    EditNodeTextField.this.textfield.setCaretPosition(EditNodeTextField.this.textfield.getText().length());
                                }
                            }
                        } else {
                            KeyEvent keyEv = new KeyEvent(EditNodeTextField.this.textfield, 400, firstKeyEvent.getWhen(), firstKeyEvent.getModifiers(), 0, firstKeyEvent.getKeyChar(), 0);
                            EditNodeTextField.this.textfield.selectAll();
                            EditNodeTextField.this.textfield.dispatchEvent(keyEv);
                        }
                    }
                }
            }

            public void focusLost(FocusEvent e) {
                if (e == null) {
                    EditNodeTextField.this.getEditControl().ok(EditNodeTextField.this.textfield.getText());
                    EditNodeTextField.this.hideMe();
                    this.val$eventSource.setValue(2);
                } else if (this.val$eventSource.getValue() != 2) {
                    EditNodeTextField.this.getEditControl().ok(EditNodeTextField.this.textfield.getText());
                    EditNodeTextField.this.hideMe();
                }
            }

            public void keyPressed(KeyEvent e) {
                if (e.isAltDown() || e.isControlDown() || e.isMetaDown()) {
                    return;
                }
                boolean commit = true;
                switch (e.getKeyCode()) {
                    case 27: {
                        commit = false;
                    }
                    case 10: {
                        e.consume();
                        this.val$eventSource.setValue(2);
                        if (commit) {
                            EditNodeTextField.this.getEditControl().ok(EditNodeTextField.this.textfield.getText());
                        } else {
                            EditNodeTextField.this.getEditControl().cancel();
                        }
                        EditNodeTextField.this.hideMe();
                        break;
                    }
                    case 32: {
                        e.consume();
                    }
                }
            }

            public void keyTyped(KeyEvent e) {
            }

            public void keyReleased(KeyEvent e) {
            }

            public void mouseClicked(MouseEvent e) {
            }

            public void mouseEntered(MouseEvent e) {
            }

            public void mouseExited(MouseEvent e) {
            }

            public void mousePressed(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            public void mouseReleased(MouseEvent e) {
                this.conditionallyShowPopup(e);
            }

            private void conditionallyShowPopup(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    EditNodeBase.EditPopupMenu popupMenu = new EditNodeBase.EditPopupMenu(EditNodeTextField.this.textfield);
                    popupMenu.show(e.getComponent(), e.getX(), e.getY());
                    e.consume();
                }
            }
        }
        TextFieldListener textFieldListener = new TextFieldListener(eventSource);
        this.textFieldListener = textFieldListener;
        this.textfield.addFocusListener(textFieldListener);
        this.textfield.addKeyListener(textFieldListener);
        this.textfield.addMouseListener(textFieldListener);
        this.getView().scrollNodeToVisible(this.getNode(), xExtraWidth);
        Point frameScreenLocation = this.getFrame().getLayeredPane().getLocationOnScreen();
        Point nodeScreenLocation = this.getNode().getLocationOnScreen();
        int xLeft = (int)(nodeScreenLocation.getX() - frameScreenLocation.getX() + (double)xOffset);
        if (xExtraWidth < 0) {
            xLeft += xExtraWidth;
        }
        this.textfield.setLocation(xLeft, (int)(nodeScreenLocation.getY() - frameScreenLocation.getY() + (double)yOffset));
        this.getFrame().getLayeredPane().add(this.textfield);
        this.getFrame().repaint();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                EditNodeTextField.this.textfield.requestFocus();
            }
        });
    }

    private void hideMe() {
        this.getFrame().getLayeredPane().remove(this.textfield);
        this.getFrame().repaint();
        this.textFieldListener = null;
    }
}

