/************************************************************************
 *                                                                      *
 *  FreeSynd - a remake of the classic Bullfrog game "Syndicate".       *
 *                                                                      *
 *   Copyright (C) 2005  Stuart Binge  <skbinge@gmail.com>              *
 *   Copyright (C) 2005  Joost Peters  <joostp@users.sourceforge.net>   *
 *   Copyright (C) 2006  Trent Waddington <qg@biodome.org>              *
 *   Copyright (C) 2006  Tarjei Knapstad <tarjei.knapstad@gmail.com>    *
 *                                                                      *
 *    This program is free software;  you can redistribute it and / or  *
 *  modify it  under the  terms of the  GNU General  Public License as  *
 *  published by the Free Software Foundation; either version 2 of the  *
 *  License, or (at your option) any later version.                     *
 *                                                                      *
 *    This program is  distributed in the hope that it will be useful,  *
 *  but WITHOUT  ANY WARRANTY;  without even  the implied  warranty of  *
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  *
 *  General Public License for more details.                            *
 *                                                                      *
 *    You can view the GNU  General Public License, online, at the GNU  *
 *  project's  web  site;  see <http://www.gnu.org/licenses/gpl.html>.  *
 *  The full text of the license is also included in the file COPYING.  *
 *                                                                      *
 ************************************************************************/

#include "common.h"
#include "font.h"

class SpriteManager;

class FontManager {
  public:
    FontManager();
    ~FontManager();
    bool loadFont(SpriteManager * sprites, int size, bool dark,
                  int offset = 0, char base = '!');
    void loadWidgets(SpriteManager * sprites);

    void drawText(int x, int y, const char *text, int size, bool dark,
                  bool x2 = true);
    int textWidth(const char *text, int size, bool x2 = true);
    int textHeight(int size, bool x2 = true);

  protected:
     Font * dark_fonts_[4];
    Font *light_fonts_[4];
    Sprite *dark_widgets_[3];
    Sprite *light_widgets_[7];
};
