/************************************************************************
 *                                                                      *
 *  FreeSynd - a remake of the classic Bullfrog game "Syndicate".       *
 *                                                                      *
 *   Copyright (C) 2005  Stuart Binge  <skbinge@gmail.com>              *
 *   Copyright (C) 2005  Joost Peters  <joostp@users.sourceforge.net>   *
 *   Copyright (C) 2006  Trent Waddington <qg@biodome.org>              *
 *   Copyright (C) 2006  Tarjei Knapstad <tarjei.knapstad@gmail.com>    *
 *                                                                      *
 *    This program is free software;  you can redistribute it and / or  *
 *  modify it  under the  terms of the  GNU General  Public License as  *
 *  published by the Free Software Foundation; either version 2 of the  *
 *  License, or (at your option) any later version.                     *
 *                                                                      *
 *    This program is  distributed in the hope that it will be useful,  *
 *  but WITHOUT  ANY WARRANTY;  without even  the implied  warranty of  *
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  *
 *  General Public License for more details.                            *
 *                                                                      *
 *    You can view the GNU  General Public License, online, at the GNU  *
 *  project's  web  site;  see <http://www.gnu.org/licenses/gpl.html>.  *
 *  The full text of the license is also included in the file COPYING.  *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <assert.h>
#include "app.h"
#include "file.h"
#include "mapmenu.h"


struct BlockPosition {
    int x;
    int y;
} g_blkPositions[50] = {
    {
    46, 18}, {
    90, 16}, {
    122, 6}, {
    218, 16}, {
    320, 22}, {
    370, 20}, {
    434, 10}, {
    482, 30}, {
    70, 36}, {
    290, 70}, {
    334, 54}, {
    372, 58}, {
    436, 74}, {
    434, 62}, {
    532, 76}, {
    160, 52}, {
    56, 76}, {
    76, 76}, {
    110, 76}, {
    140, 76}, {
    278, 124}, {
    288, 124}, {
    344, 116}, {
    398, 106}, {
    474, 98}, {
    56, 98}, {
    100, 106}, {
    198, 130}, {
    266, 140}, {
    336, 156}, {
    378, 146}, {
    440, 118}, {
    492, 136}, {
    66, 122}, {
    120, 172}, {
    280, 170}, {
    326, 166}, {
    370, 172}, {
    118, 206}, {
    142, 184}, {
    180, 196}, {
    328, 226}, {
    354, 212}, {
    502, 250}, {
    542, 246}, {
    542, 282}, {
    152, 230}, {
    148, 242}, {
    170, 252}, {
    504, 160}
};

struct LogoPosition {
    int x;
    int y;
} g_LogoPositions[50] = {
    {
    14, 12}, {
    14, 12}, {
    226, 78}, {
    226, 78}, {
    289, 24}, {
    353, 12}, {
    353, 12}, {
    585, 69}, {
    13, 59}, {
    243, 93}, {
    289, 22}, {
    353, 12}, {
    353, 12}, {
    585, 69}, {
    585, 69}, {
    225, 77}, {
    13, 59}, {
    13, 59}, {
    149, 123}, {
    149, 123}, {
    243, 93}, {
    243, 93}, {
    421, 185}, {
    421, 185}, {
    565, 133}, {
    13, 127}, {
    149, 123}, {
    207, 165}, {
    207, 165}, {
    243, 209}, {
    421, 185}, {
    421, 185}, {
    565, 133}, {
    13, 127}, {
    61, 179}, {
    243, 209}, {
    285, 251}, {
    421, 185}, {
    89, 257}, {
    207, 165}, {
    243, 209}, {
    285, 251}, {
    412, 249}, {
    459, 253}, {
    597, 259}, {
    597, 259}, {
    215, 265}, {
    215, 265}, {
    215, 265}, {
471, 197},};

struct BlockLineStart {
    int x;
    int y;
} g_blkLineStartPositions[50] = {
    {
    48, 32}, {
    48, 32}, {
    226, 78}, {
    245, 78}, {
    322, 52}, {
    387, 45}, {
    388, 34}, {
    583, 79}, {
    49, 73}, {
    279, 107}, {
    325, 57}, {
    381, 47}, {
    389, 45}, {
    584, 85}, {
    584, 89}, {
    224, 87}, {
    49, 83}, {
    49, 83}, {
    149, 123}, {
    163, 122}, {
    279, 123}, {
    279, 123}, {
    423, 183}, {
    435, 184}, {
    564, 143}, {
    49, 135}, {
    148, 133}, {
    217, 164}, {
    243, 177}, {
    279, 215}, {
    421, 184}, {
    449, 184}, {
    564, 149}, {
    49, 141}, {
    97, 195}, {
    279, 211}, {
    317, 250}, {
    420, 203}, {
    115, 256}, {
    206, 191}, {
    242, 225}, {
    321, 259}, {
    412, 259}, {
    495, 278}, {
    596, 275}, {
    596, 283}, {
    214, 269}, {
    214, 283}, {
    214, 277}, {
507, 211},};

struct BlockLineEnd {
    int x;
    int y;
} g_blkLineEndPositions[50] = {
    {
    76, 36}, {
    107, 40}, {
    181, 33}, {
    250, 40}, {
    344, 60}, {
    404, 62}, {
    458, 48}, {
    527, 53}, {
    100, 63}, {
    316, 97}, {
    360, 88}, {
    406, 90}, {
    452, 102}, {
    487, 81}, {
    541, 93}, {
    177, 69}, {
    74, 91}, {
    96, 93}, {
    117, 91}, {
    157, 91}, {
    300, 135}, {
    326, 153}, {
    385, 137}, {
    427, 129}, {
    511, 119}, {
    86, 113}, {
    107, 117}, {
    207, 137}, {
    284, 163}, {
    358, 167}, {
    401, 159}, {
    468, 143}, {
    509, 147}, {
    80, 135}, {
    138, 189}, {
    312, 181}, {
    352, 205}, {
    385, 203}, {
    131, 217}, {
    159, 211}, {
    195, 223}, {
    342, 249}, {
    363, 243}, {
    522, 285}, {
    569, 271}, {
    567, 293}, {
    173, 243}, {
    159, 281}, {
    179, 269}, {
536, 207},};

struct NameAndPop {
    const char *name;
    int population;
} g_blkNameAndPopulation[50] = {
    {
    "ALASKA", 46000000}, {
    "NORTHWEST TERRITORIES", 56000000}, {
    "NORTHEAST TERRITORIES", 58000000}, {
    "GREENLAND", 40000000}, {
    "SCANDINAVIA", 54000000}, {
    "URALS", 40000000}, {
    "SIBERIA", 54000000}, {
    "KAMCHATKA", 56000000}, {
    "YUKON", 58000000}, {
    "WESTERN EUROPE", 48000000}, {
    "CENTRAL EUROPE", 50000000}, {
    "EASTERN EUROPE", 52000000}, {
    "KAZAKHSTAN", 42000000}, {
    "MONGOLIA", 52000000}, {
    "FAR EAST", 42000000}, {
    "NEWFOUNDLAND", 44000000}, {
    "CALIFORNIA", 46000000}, {
    "ROCKIES", 56000000}, {
    "MID WEST", 58000000}, {
    "NEW ENGLAND", 40000000}, {
    "ALGERIA", 50000000}, {
    "LYBIA", 40000000}, {
    "IRAQ", 50000000}, {
    "IRAN", 52000000}, {
    "CHINA", 54000000}, {
    "COLORADO", 40000000}, {
    "SOUTHERN STATES", 42000000}, {
    "ATLANTIC ACCELERATOR", 44000000}, {
    "MAURITANIA", 58000453}, {
    "SUDAN", 43999510}, {
    "ARABIA", 54000471}, {
    "INDIA", 55999864}, {
    "PACIFIC RIM", 57999593}, {
    "MEXICO", 43999722}, {
    "COLOMBIA", 45999547}, {
    "NIGERIA", 48000204}, {
    "ZAIRE", 57999525}, {
    "KENYA", 47999574}, {
    "PERU", 57999719}, {
    "VENEZUALA", 40000488}, {
    "BRAZIL", 41999785}, {
    "SOUTH AFRICA", 48000138}, {
    "MOZAMBIQUE", 45999915}, {
    "WESTERN AUSTRALIA", 47999716}, {
    "NORTHERN TERRITORIES", 41999837}, {
    "NEW SOUTH WALES", 47999878}, {
    "PARAGUAY", 58000207}, {
    "ARGENTINA", 40000352}, {
    "URUGUAY", 57999681}, {
"INDONESIA", 47999794},};

extern int g_Colours[8];

MapMenu::MapMenu(MenuManager * m)
:  Menu(m, "map", "mmap.dat", "mmapout.dat"),
mapblk_data_(NULL), orig_pixels_(NULL), cur_blk_(9), tick_count_(0)
{
    addOption(53, 352, "BRIEF", 1, KEY_F4, "brief");
    addOption(535, 352, "MENU", 1, KEY_F5, "main");
    addStatic(194, 332, "POP", 1, false);
    addStatic(194, 346, "TAX", 1, false);
    addStatic(194, 360, "OWN", 1, false);

    setParentMenu("main");

    // 64 x 44 x 50
    mapblk_data_ = File::loadFile("mmapblk.dat", mapblk_size_);
    for (int i = 0; i < 50; i++) {
        do
            blk_colours_[i] = rand() % (sizeof(g_Colours) / sizeof(int));
        while (blk_colours_[i] == g_App.logoColour());
    }
}

MapMenu::~MapMenu()
{
    delete[] mapblk_data_;
    if (orig_pixels_)
        delete[] orig_pixels_;
}

void MapMenu::handleTick(int elapsed)
{
    tick_count_ += elapsed;
    if (tick_count_ > 200) {
        static int count = 0;
        tick_count_ = count++;
        drawSelector();
        tick_count_ = 0;
    }
}

void MapMenu::drawSelector()
{
    int logo_x = g_LogoPositions[cur_blk_].x;
    int logo_y = g_LogoPositions[cur_blk_].y;
    g_Screen.drawLogo(logo_x, logo_y, g_App.logo(), g_App.logoColour(),
                      true);

    // Draw box enclosing logo
    uint8 box[18 * 18];
    memset(box, 255, 18 * 18);
    for (int i = 0; i < 18; i++) {
        box[i] = 252;
        box[i + 17 * 18] = 252;
    }
    for (int j = 0; j < 18; j++) {
        box[j * 18] = 252;
        box[j * 18 + 17] = 252;
    }
    g_Screen.scale2x(logo_x - 2, logo_y - 2, 18, 18, box);

    // Draw line between country and logobox
    int blk_line_end_x = g_blkLineEndPositions[cur_blk_].x;
    int blk_line_end_y = g_blkLineEndPositions[cur_blk_].y;
    int blk_line_start_x = g_blkLineStartPositions[cur_blk_].x;
    int blk_line_start_y = g_blkLineStartPositions[cur_blk_].y;
    g_Screen.drawLine(blk_line_start_x, blk_line_start_y, blk_line_end_x,
                      blk_line_end_y, 252, 5, tick_count_ % 10);
    g_Screen.drawLine(blk_line_start_x, blk_line_start_y - 1,
                      blk_line_end_x, blk_line_end_y - 1, 252, 5,
                      tick_count_ % 10);
    g_Screen.drawLine(blk_line_start_x, blk_line_start_y, blk_line_end_x,
                      blk_line_end_y, 4, 5, tick_count_ % 10 + 5);
    g_Screen.drawLine(blk_line_start_x, blk_line_start_y - 1,
                      blk_line_end_x, blk_line_end_y - 1, 4, 5,
                      tick_count_ % 10 + 5);
}

void MapMenu::handleShow()
{
    if (orig_pixels_ == 0) {
        orig_pixels_ = new uint8[GAME_SCREEN_WIDTH * GAME_SCREEN_HEIGHT];
        memcpy(orig_pixels_, g_Screen.pixels(),
               GAME_SCREEN_WIDTH * GAME_SCREEN_HEIGHT);
    } else {
        g_Screen.blit(0, 0, GAME_SCREEN_WIDTH, 345, orig_pixels_);
    }

    for (int i = 0; i < 50; i++) {
        uint8 data[64 * 44];
        memcpy(data, mapblk_data_ + i * 64 * 44, 64 * 44);
        for (int j = 0; j < 64 * 44; j++)
            if (data[j] == 0)
                data[j] = 255;
            else
                data[j] = g_Colours[blk_colours_[i]];
        g_Screen.scale2x(g_blkPositions[i].x, g_blkPositions[i].y, 64, 44,
                         data, 64);
    }

    drawSelector();

    // Draw country info
    // TODO: Grab countryinfo and display it
    char tmp[100];
    g_App.fonts().drawText(268, 312, g_blkNameAndPopulation[cur_blk_].name, 0, false);  // countryname
    sprintf(tmp, "%i", g_blkNameAndPopulation[cur_blk_].population);
    g_App.fonts().drawText(268, 332, tmp, 0, false);    // pop
    // if (owns_ountry) {
    // TODO: Add tax adjustment buttons
    strcpy(tmp, "UNKNOWN");
    g_App.fonts().drawText(268, 346, tmp, 0, false);    // tax
    strcpy(tmp, "");
    g_App.fonts().drawText(268, 360, tmp, 0, false);    // own
    // }
}

void MapMenu::handleMouseDown(int x, int y, int button)
{
    for (int i = 0; i < 50; i++) {
        if (x > g_blkPositions[i].x && x < g_blkPositions[i].x + 64 &&
            y > g_blkPositions[i].y && y < g_blkPositions[i].y + 44) {
            if (mapblk_data_
                [i * 64 * 44 + (y - g_blkPositions[i].y) / 2 * 64 +
                 (x - g_blkPositions[i].x) / 2] != 0) {
                cur_blk_ = i;
                handleShow();
                return;
            }
        }
    }
}

void MapMenu::handleOption(Key key)
{
}

void MapMenu::handleUnknownKey(Key key, KeyMod mod, bool pressed)
{
    if (key == KEY_0)
        cur_blk_ = 0;
    if (key == KEY_LEFT && cur_blk_ > 0)
        cur_blk_--;
    if (key == KEY_RIGHT && cur_blk_ < 49)
        cur_blk_++;
    show(false);
}
