/************************************************************************
 *                                                                      *
 *  FreeSynd - a remake of the classic Bullfrog game "Syndicate".       *
 *                                                                      *
 *   Copyright (C) 2005  Stuart Binge  <skbinge@gmail.com>              *
 *   Copyright (C) 2005  Joost Peters  <joostp@users.sourceforge.net>   *
 *   Copyright (C) 2006  Trent Waddington <qg@biodome.org>              *
 *   Copyright (C) 2006  Tarjei Knapstad <tarjei.knapstad@gmail.com>    *
 *                                                                      *
 *    This program is free software;  you can redistribute it and / or  *
 *  modify it  under the  terms of the  GNU General  Public License as  *
 *  published by the Free Software Foundation; either version 2 of the  *
 *  License, or (at your option) any later version.                     *
 *                                                                      *
 *    This program is  distributed in the hope that it will be useful,  *
 *  but WITHOUT  ANY WARRANTY;  without even  the implied  warranty of  *
 *  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU  *
 *  General Public License for more details.                            *
 *                                                                      *
 *    You can view the GNU  General Public License, online, at the GNU  *
 *  project's  web  site;  see <http://www.gnu.org/licenses/gpl.html>.  *
 *  The full text of the license is also included in the file COPYING.  *
 *                                                                      *
 ************************************************************************/

#include <stdio.h>
#include <string.h>
#include <assert.h>

#include "app.h"
#include "screen.h"

Mod::Mod(const char *mod_name, int mod_cost, const char *mod_desc,
         int mod_slot, int mod_icon, int mod_iconF):name_(mod_name),
desc_(mod_desc), cost_(mod_cost), slot_(mod_slot), icon_(mod_icon),
icon_f_(mod_iconF)
{
    if (icon_f_ == 0)
        icon_f_ = icon_;
}

void Mod::drawInfo(int x, int y)
{
    g_App.fonts().drawText(x, y, name_.c_str(), 0, false);
    char tmp[100];
    sprintf(tmp, "COST   :%d", cost_);
    g_App.fonts().drawText(504, y + 14, tmp, 0, false);
    g_App.fonts().drawText(504, y + 28, desc_.c_str(), 0, false);
}
