#ifndef QCC_H
#define QCC_H

#include "cmdlib.h"
#include <stdio.h>
#include <setjmp.h>

#include "pr_comp.h"

#define STRCMP(s1,s2) strcmp(s1,s2)
#define STRNCMP(s1,s2,n) strncmp(s1,s2,n)

#ifdef WIN32
#pragma warning (disable:4244)
#endif


#ifdef WIN32GUI
extern void WinPrint(char *format, ...);
extern char summary_buf[4096];
#define print WinPrint
extern void ErrorPrint(char *fname, int line, char *format, ...);


#else
#define print putchar(10);printf
#define summary_print printf
#endif


//=============================================================================

// offsets are allways multiplied by 4 before using
typedef int	gofs_t;				// offset in global data block
typedef struct function_s function_t;

#define	MAX_PARMS	8
#define MAX_NAME	64
#define MAX_EXTRA_PARMS 24 // Frika C

typedef struct type_s
{
	etype_t			type;
	struct def_s	*def;		// a def that points to this type
	struct type_s	*next;
// function types are more complex
	struct type_s	*aux_type;	// return type or field type
	int				num_parms;	// -1 = variable args
	struct type_s	*parm_types[MAX_PARMS + MAX_EXTRA_PARMS];	// only [num_parms] allocated
	//char			parm_names[MAX_PARMS][MAX_NAME];
	int arraysize;
} type_t;

extern char *typenames[];


typedef struct def_s
{
	type_t		*type;
	char		*name;
	struct def_s	*next;
	gofs_t		ofs;
	struct def_s	*scope;	// function the var was defined in, or NULL
	int	constant;	// 1 when a declaration included "= immediate"
	int save;
	int defined; // if constant !defined, then error
	etype_t		cast;	// used for type casting
	char		*s_file; // used for reclaration info
	int			line; // "   "
	// FrikaC: newtest

	struct def_s *tempnext;
	gofs_t	arraystart;
	// FrikaC: newtest end
} def_t;

//============================================================================

// pr_loc.h -- program local defs

#define	MAX_ERRORS		10

#define	MAX_NAME		64		// chars long

#define MAX_REGS                65536


//=============================================================================

typedef union eval_s
{
	string_t			string;
	float				_float;
	float				vector[3];
	func_t				function;
	int					_int;
	union eval_s		*ptr;
} eval_t;	

extern	int	type_size[9];
extern	def_t	*def_for_type[9];

extern	type_t	type_void, type_string, type_float, type_vector, type_entity, type_field, type_function, type_pointer, type_floatfield, type_int;

extern	def_t	def_void, def_string, def_float, def_vector, def_entity, def_field, def_function, def_pointer, def_int;

struct function_s
{
	int					builtin;	// if non 0, call an internal function
	int					code;		// first statement
	char				*file;		// source file with definition
	int					file_line;
	struct def_s		*def;
	int					parm_ofs[MAX_PARMS];	// allways contiguous, right?
};


//
// output generated by prog parsing
//
typedef struct
{
	char		*memory;
	int		max_memory;
	int		current_memory;
	type_t		*types;

	def_t		def_head;	// unused head of linked list
	def_t		*def_tail;	// add new defs after this and move it

	int		size_fields;
} pr_info_t;

extern	pr_info_t	pr;

typedef struct
{
	char	*name;
	int		op;
    int     priority;
	boolean	right_associative;
	def_t	*type_a, *type_b, *type_c;
} opcode_t;

// Frika C  begin
#ifndef macintosh
#define Sys_fopen fopen
#endif

#define MAX_DEFINES 65536

typedef struct define_s
{
	char *name;
	boolean defined;
	eval_t value;
	boolean label;
	type_t *type;

} define_t;
#define HSIZE1 16384

extern int macrohash[HSIZE1];


extern define_t	pr_defines[MAX_DEFINES];
extern int num_defines;

/*
typedef struct 
{
	char		*name;
	boolean	defined;
	int			patchloc;
} label_t;

#define MAX_LABELS 255

extern label_t		labels[MAX_LABELS];
extern int		numlabels;
*/

extern boolean	conditional; // if the expression being parse is conditional, not operational
extern boolean  dontcomplain;

extern int warninglevel;
extern int pr_warning_count;

extern int pr_global_refs[MAX_REGS]; // FrikaC


//============================================================================


extern	opcode_t	pr_opcodes[99];		// sized by initialization

extern	boolean	pr_dumpasm;

extern	def_t		*pr_global_defs[MAX_REGS];	// to find def for a global variable

typedef enum {
tt_eof,			// end of file reached
tt_name, 		// an alphanumeric name token
tt_punct, 		// code punctuation
tt_immediate,	// string, float, vector
} token_type_t;

extern	char		pr_token[2048];
extern	token_type_t	pr_token_type;
extern	type_t		*pr_immediate_type;
extern	eval_t		pr_immediate;
extern	int			pr_immediate_index;

void PR_PrintStatement (dstatement_t *s);

void PR_Lex (void);
// reads the next token into pr_token and classifies its type

type_t *PR_ParseType (void);
type_t *PR_ParseTypeFunction (type_t *type);

char *PR_ParseName (void);

void PR_ParseError (char *error, ...);
void PR_ParseWarning (int level, char *warn, ...);


extern	jmp_buf		pr_parse_abort;		// longjump with this on parse error
extern	int			pr_source_line;
extern	char		*pr_file_p;

void *PR_Malloc (long size);


#define	OFS_NULL		0
#define	OFS_RETURN		1
#define	OFS_PARM0		4		// leave 3 ofs for each parm to hold vectors
#define	OFS_PARM1		7
#define	OFS_PARM2		10
#define	OFS_PARM3		13
#define	OFS_PARM4		16
#define OFS_PARM5		19
#define OFS_PARM6		22
#define OFS_PARM7		25
#define	RESERVED_OFS	28


extern	def_t	*pr_scope;
extern	int	pr_error_count;

void PR_NewLine (void);
def_t *PR_GetDef (type_t *type, char *name, def_t *scope, boolean allocate, int constant, int save);
void PR_PrintDefs (void);

void PR_SkipToSemicolon (void);

extern	char pr_parm_names[MAX_PARMS + MAX_EXTRA_PARMS][MAX_NAME];
extern	boolean	pr_trace;

#define	G_FLOAT(o) (pr_globals[o])
#define	G_INT(o) (*(int *)&pr_globals[o])
#define	G_VECTOR(o, i) (pr_globals[o + i])
#define	G_STRING(o) (strings + *(string_t *)&pr_globals[o])
#define	G_FUNCTION(o) (*(func_t *)&pr_globals[o])

char *PR_ValueString (etype_t type, void *val);

void PR_ClearGrabMacros (void);
void Sys_mkdir (char *path);

boolean	PR_CompileFile (char *string, char *filename);

extern	boolean	pr_dumpasm;

extern	string_t	s_file;			// filename for function definition

extern	def_t	def_ret, def_parms[MAX_PARMS];

//=============================================================================

#define	MAX_STRINGS		500000
#define MAX_GLOBALS     49152
#define	MAX_FIELDS		4048
#define	MAX_STATEMENTS	200000
#define	MAX_FUNCTIONS	16384
#define MAX_TEMPS		256

#define	MAX_SOUNDS		1024
#define	MAX_MODELS		1024
#define	MAX_FILES		1024
#define	MAX_DATA_PATH	64

extern	char	strings[MAX_STRINGS];
extern	int		strofs;

extern	dstatement_t	statements[MAX_STATEMENTS];
extern	int			numstatements;
extern	int			statement_linenums[MAX_STATEMENTS];

extern	dfunction_t	functions[MAX_FUNCTIONS];
extern	int			numfunctions;

extern	float		pr_globals[MAX_REGS];
extern	int			numpr_globals;

extern	char		pr_immediate_string[2048];
extern	int			pr_immediate_strlen;

extern	char		precache_sounds[MAX_SOUNDS][MAX_DATA_PATH];
extern	int			precache_sounds_block[MAX_SOUNDS];
extern	int			numsounds;

extern	char		precache_models[MAX_MODELS][MAX_DATA_PATH];
extern	int			precache_models_block[MAX_SOUNDS];
extern	int			nummodels;

extern	char		precache_files[MAX_FILES][MAX_DATA_PATH];
extern	int			precache_files_block[MAX_SOUNDS];
extern	int			numfiles;

extern int pr_optimize_eliminate_temps;
extern int pr_optimize_shorten_ifs;
extern int pr_optimize_nonvec_parms;
extern int pr_optimize_constant_names;
extern int pr_optimize_defs;
extern int pr_optimize_hash_strings;
extern int pr_optimize_locals;
extern int pr_optimize_function_names;
extern int pr_optimize_filenames;
extern int pr_optimize_unreferenced;
extern int pr_optimize_logicops;
extern int pr_optimize_recycle;
extern int pr_optimize_constant_arithmetic;

extern int num_stores_shortened;
extern int num_ifs_shortened;
extern int num_nonvec_parms;
extern int num_constant_names;
extern int num_defs;
extern int num_strings;
extern int num_locals_saved;
extern int num_funcs_saved;
extern int num_files_saved;
extern int num_unreferenced;
extern int num_logic_jumps;
extern int num_recycled;
extern int num_constant_ops_saved;

extern boolean summary;

extern int ofstemp;
extern boolean expectint;


int	CopyString (char *str, int len);

#define NQ_PROGHEADER_CRC 5927
#define QW_PROGHEADER_CRC 54730


void InitData (void);
void	PR_BeginCompilation (void *memory, int memsize);
boolean	PR_FinishCompilation (void);
int	PR_WriteProgdefs (char *filename);
void WriteData (int crc);
void CopyFiles (void);

extern char		destfile[1024];
extern boolean logging; 
extern boolean pr_pause; 
extern void PR_Expect (char *string);
extern boolean PR_Check (char *string);

#endif

