/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;

public class CompressedFile
implements IFile {
    static final int SEGMENT_LENGTH = 131072;
    ZipFile file;
    ZipEntry[] entries;
    byte[] segment;
    ZipEntry currEntry;

    public void write(long pos, byte[] buf) {
        throw new UnsupportedOperationException("ZipFile.write");
    }

    public int read(long pos, byte[] buf) {
        try {
            int offs;
            int seg = (int)(pos / 131072L);
            ZipEntry e = this.entries[seg];
            int size = (int)e.getSize();
            if (e != this.currEntry) {
                int offs2;
                int rc;
                InputStream in = this.file.getInputStream(e);
                for (offs2 = 0; offs2 < size && (rc = in.read(this.segment, offs2, size - offs2)) >= 0; offs2 += rc) {
                }
                if (offs2 != size) {
                    throw new StorageError(3);
                }
                this.currEntry = e;
            }
            if ((offs = (int)(pos - (long)seg * 131072L)) < size) {
                int len = buf.length < size - offs ? buf.length : size - offs;
                System.arraycopy(this.segment, offs, buf, 0, len);
                return len;
            }
            return 0;
        }
        catch (IOException x) {
            throw new StorageError(3);
        }
    }

    public void sync() {
    }

    public boolean tryLock(boolean shared) {
        return true;
    }

    public void lock(boolean shared) {
    }

    public void unlock() {
    }

    public void close() {
        try {
            this.file.close();
        }
        catch (IOException x) {
            throw new StorageError(3);
        }
    }

    public long length() {
        return (long)(this.entries.length - 1) * 131072L + this.entries[this.entries.length - 1].getSize();
    }

    public CompressedFile(String path) {
        try {
            this.file = new ZipFile(path);
            int nEntries = this.file.size();
            this.entries = new ZipEntry[nEntries];
            Enumeration<? extends ZipEntry> ee = this.file.entries();
            int i = 0;
            while (ee.hasMoreElements()) {
                this.entries[i] = ee.nextElement();
                ++i;
            }
            this.segment = new byte[131072];
            this.currEntry = null;
        }
        catch (IOException x) {
            throw new StorageError(3);
        }
    }
}

