/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.garret.perst.ITable;
import org.garret.perst.IterableIterator;
import org.garret.perst.PersistentResource;
import org.garret.perst.Storage;
import org.garret.perst.impl.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class PersistentCollection<T>
extends PersistentResource
implements ITable<T> {
    @Override
    public IterableIterator<T> select(Class cls, String predicate) {
        QueryImpl query = new QueryImpl(this.getStorage());
        return query.select(cls, this.iterator(), predicate);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        while (e.hasNext()) {
            if (this.contains(e.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        boolean modified = false;
        Iterator<T> e = c.iterator();
        while (e.hasNext()) {
            if (!this.add(e.next())) continue;
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<?> i = c.iterator();
        while (i.hasNext()) {
            modified |= this.remove(i.next());
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        ArrayList toBeRemoved = new ArrayList();
        for (Object o : this) {
            if (c.contains(o)) continue;
            toBeRemoved.add(o);
        }
        int n = toBeRemoved.size();
        for (int j = 0; j < n; ++j) {
            this.remove(toBeRemoved.get(j));
        }
        return n != 0;
    }

    @Override
    public boolean contains(Object o) {
        Iterator e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        Iterator e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                e.remove();
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                e.remove();
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean add(T o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    public PersistentCollection() {
    }

    public PersistentCollection(Storage storage) {
        super(storage);
    }
}

