/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import org.garret.perst.IPersistent;
import org.garret.perst.Link;
import org.garret.perst.StorageError;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projection<From extends IPersistent, To extends IPersistent>
extends HashSet<To> {
    private Field field;

    public Projection(Class type, String fieldName) {
        this.setProjectionField(type, fieldName);
    }

    public Projection() {
    }

    public void setProjectionField(Class type, String fieldName) {
        try {
            this.field = type.getDeclaredField(fieldName);
            this.field.setAccessible(true);
        }
        catch (Exception x) {
            throw new StorageError(5, x);
        }
    }

    public void project(From[] selection) {
        for (int i = 0; i < selection.length; ++i) {
            this.map(selection[i]);
        }
    }

    public void project(From obj) {
        this.map(obj);
    }

    public void project(Iterator<From> selection) {
        while (selection.hasNext()) {
            this.map((IPersistent)selection.next());
        }
    }

    public void project(Collection<From> c) {
        for (IPersistent o : c) {
            this.map(o);
        }
    }

    public void join(Projection<From, To> prj) {
        this.retainAll(prj);
    }

    public IPersistent[] toPersistentArray() {
        return this.toArray(new IPersistent[this.size()]);
    }

    public void reset() {
        this.clear();
    }

    @Override
    public boolean add(To obj) {
        if (obj != null) {
            return super.add(obj);
        }
        return false;
    }

    protected void map(From obj) {
        if (this.field == null) {
            this.add((To)obj);
        } else {
            try {
                Object o = this.field.get(obj);
                if (o instanceof Link) {
                    Object[] arr = ((Link)o).toArray();
                    for (int i = 0; i < arr.length; ++i) {
                        this.add((To)((IPersistent)arr[i]));
                    }
                } else if (o instanceof Object[]) {
                    Object[] arr = (Object[])o;
                    for (int i = 0; i < arr.length; ++i) {
                        this.add((To)((IPersistent)arr[i]));
                    }
                } else {
                    this.add((To)((IPersistent)o));
                }
            }
            catch (Exception x) {
                throw new StorageError(17, x);
            }
        }
    }
}

