/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import org.garret.perst.Assert;
import org.garret.perst.IValue;

public class RectangleR2
implements IValue,
Cloneable {
    private double top;
    private double left;
    private double bottom;
    private double right;

    public final double getTop() {
        return this.top;
    }

    public final double getLeft() {
        return this.left;
    }

    public final double getBottom() {
        return this.bottom;
    }

    public final double getRight() {
        return this.right;
    }

    public final double area() {
        return (this.bottom - this.top) * (this.right - this.left);
    }

    public static double joinArea(RectangleR2 a, RectangleR2 b) {
        double left = a.left < b.left ? a.left : b.left;
        double right = a.right > b.right ? a.right : b.right;
        double top = a.top < b.top ? a.top : b.top;
        double bottom = a.bottom > b.bottom ? a.bottom : b.bottom;
        return (bottom - top) * (right - left);
    }

    public Object clone() {
        try {
            RectangleR2 r = (RectangleR2)super.clone();
            r.top = this.top;
            r.left = this.left;
            r.bottom = this.bottom;
            r.right = this.right;
            return r;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    public RectangleR2(RectangleR2 r) {
        this.top = r.top;
        this.left = r.left;
        this.bottom = r.bottom;
        this.right = r.right;
    }

    public RectangleR2(double top, double left, double bottom, double right) {
        Assert.that(top <= bottom && left <= right);
        this.top = top;
        this.left = left;
        this.bottom = bottom;
        this.right = right;
    }

    public RectangleR2() {
    }

    public final void join(RectangleR2 r) {
        if (this.left > r.left) {
            this.left = r.left;
        }
        if (this.right < r.right) {
            this.right = r.right;
        }
        if (this.top > r.top) {
            this.top = r.top;
        }
        if (this.bottom < r.bottom) {
            this.bottom = r.bottom;
        }
    }

    public static RectangleR2 join(RectangleR2 a, RectangleR2 b) {
        RectangleR2 r = new RectangleR2(a);
        r.join(b);
        return r;
    }

    public final boolean intersects(RectangleR2 r) {
        return this.left <= r.right && this.top <= r.bottom && this.right >= r.left && this.bottom >= r.top;
    }

    public final boolean contains(RectangleR2 r) {
        return this.left <= r.left && this.top <= r.top && this.right >= r.right && this.bottom >= r.bottom;
    }

    public boolean equals(Object o) {
        if (o instanceof RectangleR2) {
            RectangleR2 r = (RectangleR2)o;
            return this.left == r.left && this.top == r.top && this.right == r.right && this.bottom == r.bottom;
        }
        return false;
    }

    public int hashCode() {
        return (int)(Double.doubleToLongBits(this.top) ^ Double.doubleToLongBits(this.bottom) << 1 ^ Double.doubleToLongBits(this.left) << 2 ^ Double.doubleToLongBits(this.right) << 3);
    }

    public String toString() {
        return "top=" + this.top + ", left=" + this.left + ", bottom=" + this.bottom + ", right=" + this.right;
    }
}

