/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Properties;
import org.garret.perst.BitIndex;
import org.garret.perst.Blob;
import org.garret.perst.CustomAllocator;
import org.garret.perst.CustomSerializer;
import org.garret.perst.FieldIndex;
import org.garret.perst.IFile;
import org.garret.perst.INamedClassLoader;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentList;
import org.garret.perst.IPersistentMap;
import org.garret.perst.IPersistentSet;
import org.garret.perst.Index;
import org.garret.perst.Link;
import org.garret.perst.MemoryUsage;
import org.garret.perst.MultidimensionalComparator;
import org.garret.perst.MultidimensionalIndex;
import org.garret.perst.PatriciaTrie;
import org.garret.perst.PersistentComparator;
import org.garret.perst.Query;
import org.garret.perst.Relation;
import org.garret.perst.SortedCollection;
import org.garret.perst.SpatialIndex;
import org.garret.perst.SpatialIndexR2;
import org.garret.perst.StorageListener;
import org.garret.perst.TimeSeries;
import org.garret.perst.XMLImportException;
import org.garret.perst.impl.ThreadTransactionContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Storage {
    public static final int INFINITE_PAGE_POOL = 0;
    public static final int DEFAULT_PAGE_POOL_SIZE = 0x400000;
    public static final int EXCLUSIVE_TRANSACTION = 0;
    public static final int READ_WRITE_TRANSACTION = 0;
    public static final int COOPERATIVE_TRANSACTION = 1;
    public static final int READ_ONLY_TRANSACTION = 1;
    public static final int SERIALIZABLE_TRANSACTION = 2;
    public static final int REPLICATION_SLAVE_TRANSACTION = 3;

    public void open(String var1, int var2);

    public void open(IFile var1, int var2);

    public void open(IFile var1);

    public void open(String var1);

    public void open(String var1, int var2, String var3);

    public boolean isOpened();

    public IPersistent getRoot();

    public void setRoot(IPersistent var1);

    public void commit();

    public void rollback();

    public void backup(OutputStream var1) throws IOException;

    public void beginThreadTransaction(int var1);

    public void endThreadTransaction();

    public void endThreadTransaction(int var1);

    public void rollbackThreadTransaction();

    public <T> Query<T> createQuery();

    public <T extends IPersistent> IPersistentList<T> createList();

    public <T extends IPersistent> IPersistentList<T> createScalableList();

    public <T extends IPersistent> IPersistentList<T> createScalableList(int var1);

    public <K extends Comparable, V extends IPersistent> IPersistentMap<K, V> createMap(Class var1);

    public <K extends Comparable, V extends IPersistent> IPersistentMap<K, V> createMap(Class var1, int var2);

    public <T extends IPersistent> IPersistentSet<T> createSet();

    public <T extends IPersistent> IPersistentSet<T> createScalableSet();

    public <T extends IPersistent> IPersistentSet<T> createScalableSet(int var1);

    public <T extends IPersistent> Index<T> createIndex(Class var1, boolean var2);

    public <T extends IPersistent> Index<T> createIndex(Class[] var1, boolean var2);

    public <T extends IPersistent> MultidimensionalIndex<T> createMultidimensionalIndex(MultidimensionalComparator<T> var1);

    public <T extends IPersistent> MultidimensionalIndex<T> createMultidimensionalIndex(Class var1, String[] var2);

    public <T extends IPersistent> Index<T> createThickIndex(Class var1);

    public <T extends IPersistent> BitIndex<T> createBitIndex();

    public <T extends IPersistent> FieldIndex<T> createFieldIndex(Class var1, String var2, boolean var3);

    public <T extends IPersistent> FieldIndex<T> createFieldIndex(Class var1, String var2, boolean var3, boolean var4);

    public <T extends IPersistent> FieldIndex<T> createFieldIndex(Class var1, String[] var2, boolean var3);

    public <T extends IPersistent> FieldIndex<T> createFieldIndex(Class var1, String[] var2, boolean var3, boolean var4);

    public <T extends IPersistent> Index<T> createRandomAccessIndex(Class var1, boolean var2);

    public <T extends IPersistent> Index<T> createRandomAccessIndex(Class[] var1, boolean var2);

    public <T extends IPersistent> FieldIndex<T> createRandomAccessFieldIndex(Class var1, String var2, boolean var3);

    public <T extends IPersistent> FieldIndex<T> createRandomAccessFieldIndex(Class var1, String var2, boolean var3, boolean var4);

    public <T extends IPersistent> FieldIndex<T> createRandomAccessFieldIndex(Class var1, String[] var2, boolean var3);

    public <T extends IPersistent> FieldIndex<T> createRandomAccessFieldIndex(Class var1, String[] var2, boolean var3, boolean var4);

    public <T extends IPersistent> SpatialIndex<T> createSpatialIndex();

    public <T extends IPersistent> SpatialIndexR2<T> createSpatialIndexR2();

    public <T extends IPersistent> SortedCollection<T> createSortedCollection(PersistentComparator<T> var1, boolean var2);

    public <T extends IPersistent> Link<T> createLink();

    public <T extends IPersistent> Link<T> createLink(int var1);

    public <M extends IPersistent, O extends IPersistent> Relation<M, O> createRelation(O var1);

    public Blob createBlob();

    public Blob createRandomAccessBlob();

    public <T extends TimeSeries.Tick> TimeSeries<T> createTimeSeries(Class var1, long var2);

    public <T extends IPersistent> PatriciaTrie<T> createPatriciaTrie();

    public void close();

    public void setGcThreshold(long var1);

    public int gc();

    public void exportXML(Writer var1) throws IOException;

    public void importXML(Reader var1) throws XMLImportException;

    public IPersistent getObjectByOID(int var1);

    public int makePersistent(IPersistent var1);

    public void setProperty(String var1, Object var2);

    public void setProperties(Properties var1);

    public Object getProperty(String var1);

    public Properties getProperties();

    public Iterator merge(Iterator[] var1);

    public Iterator join(Iterator[] var1);

    public StorageListener setListener(StorageListener var1);

    public HashMap<Class, MemoryUsage> getMemoryDump();

    public long getUsedSize();

    public long getDatabaseSize();

    public ClassLoader setClassLoader(ClassLoader var1);

    public ClassLoader getClassLoader();

    public void registerClassLoader(INamedClassLoader var1);

    public ClassLoader findClassLoader(String var1);

    public void registerCustomAllocator(Class var1, CustomAllocator var2);

    public CustomAllocator createBitmapAllocator(int var1, long var2, long var4, long var6);

    public ThreadTransactionContext getTransactionContext();

    public ThreadTransactionContext setTransactionContext(ThreadTransactionContext var1);

    public void setCustomSerializer(CustomSerializer var1);

    public void clearObjectCache();

    public int getDatabaseFormatVersion();

    public void deallocateObject(IPersistent var1);

    public void storeObject(IPersistent var1);

    public void storeFinalizedObject(IPersistent var1);

    public void modifyObject(IPersistent var1);

    public void loadObject(IPersistent var1);

    public boolean lockObject(IPersistent var1);

    public void throwObject(IPersistent var1);
}

