/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import org.garret.perst.ReplicationMasterStorage;
import org.garret.perst.ReplicationSlaveStorage;
import org.garret.perst.Storage;
import org.garret.perst.impl.ReplicationDynamicSlaveStorageImpl;
import org.garret.perst.impl.ReplicationMasterStorageImpl;
import org.garret.perst.impl.ReplicationStaticSlaveStorageImpl;
import org.garret.perst.impl.StorageImpl;

public class StorageFactory {
    protected static final StorageFactory instance = new StorageFactory();

    public Storage createStorage() {
        return new StorageImpl();
    }

    public ReplicationMasterStorage createReplicationMasterStorage(int port, String[] replicationSlaveNodes, int asyncBufSize) {
        return new ReplicationMasterStorageImpl(port, replicationSlaveNodes, asyncBufSize);
    }

    public ReplicationSlaveStorage createReplicationSlaveStorage(int slavePort) {
        return new ReplicationStaticSlaveStorageImpl(slavePort);
    }

    public ReplicationSlaveStorage addReplicationSlaveStorage(String replicationMasterNode, int masterPort) {
        return new ReplicationDynamicSlaveStorageImpl(replicationMasterNode, masterPort);
    }

    public static StorageFactory getInstance() {
        return instance;
    }
}

