/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.TreeMap;
import org.garret.perst.Assert;
import org.garret.perst.CustomAllocator;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Bitmap;
import org.garret.perst.impl.StorageImpl;

public class BitmapCustomAllocator
extends Persistent
implements CustomAllocator {
    protected int quantum;
    protected int quantumBits;
    protected long base;
    protected long limit;
    protected Link pages;
    protected int extensionPages;
    transient int currPage;
    transient int currOffs;
    transient TreeMap reserved = new TreeMap();
    static final int BITMAP_PAGE_SIZE = 4084;
    static final int BITMAP_PAGE_BITS = 32672;

    public BitmapCustomAllocator(Storage storage, int quantum, long base, long extension, long limit) {
        super(storage);
        this.quantum = quantum;
        this.base = base;
        this.limit = limit;
        int bits = 0;
        for (int q = quantum; q != 1; q >>>= 1) {
            ++bits;
        }
        this.quantumBits = bits;
        Assert.that(1 << bits == quantum);
        this.extensionPages = (int)((extension + (32672L << this.quantumBits) - 1L) / (32672L << this.quantumBits));
        this.pages = storage.createLink();
    }

    protected BitmapCustomAllocator() {
    }

    /*
     * Enabled aggressive block sorting
     */
    public long allocate(long size) {
        size = size + (long)this.quantum - 1L & (long)(~(this.quantum - 1));
        long objBitSize = size >> this.quantumBits;
        long holeBitSize = 0L;
        int firstPage = this.currPage;
        int lastPage = this.pages.size();
        int offs = this.currOffs;
        long lastHoleSize = 0L;
        block0: while (true) {
            int i = firstPage;
            while (true) {
                BitmapPage pg;
                if (i < lastPage) {
                    pg = (BitmapPage)this.pages.get(i);
                } else {
                    if (firstPage == 0) {
                        int nPages;
                        firstPage = this.pages.size();
                        lastPage = firstPage + ((nPages = (int)(size / (long)(32672 * this.quantum))) > this.extensionPages ? nPages : this.extensionPages);
                        if ((long)lastPage * 32672L * (long)this.quantum > this.limit) {
                            throw new StorageError(10);
                        }
                        this.pages.setSize(lastPage);
                        for (int i2 = firstPage; i2 < lastPage; ++i2) {
                            BitmapPage pg2 = new BitmapPage();
                            pg2.data = new byte[4084];
                            this.pages.setObject(i2, pg2);
                        }
                        holeBitSize = lastHoleSize;
                        continue block0;
                    }
                    lastHoleSize = holeBitSize;
                    holeBitSize = 0L;
                    lastPage = firstPage + 1;
                    firstPage = 0;
                    continue block0;
                }
                while (offs < 4084) {
                    long pos;
                    int mask = pg.data[offs] & 0xFF;
                    if (holeBitSize + (long)Bitmap.firstHoleSize[mask] >= objBitSize) {
                        pos = this.base + (((long)i * 4084L + (long)offs) * 8L - holeBitSize << this.quantumBits);
                        long nextPos = this.wasReserved(pos, size);
                        if (nextPos != 0L) {
                            long quantNo = (nextPos - this.base >>> this.quantumBits) + 7L;
                            i = (int)(quantNo / 32672L);
                            offs = (int)(quantNo - (long)i * 32672L) >> 3;
                            holeBitSize = 0L;
                            continue;
                        }
                        this.currPage = i--;
                        this.currOffs = offs;
                        int n = offs;
                        pg.data[n] = (byte)(pg.data[n] | (byte)((1 << (int)(objBitSize - holeBitSize)) - 1));
                        pg.modify();
                        if (holeBitSize != 0L) {
                            if (holeBitSize > (long)(offs * 8)) {
                                BitmapCustomAllocator.memset(pg, 0, 255, offs);
                                holeBitSize -= (long)(offs * 8);
                                pg = (BitmapPage)this.pages.get(i);
                                offs = 4096;
                            }
                            while (holeBitSize > 32672L) {
                                BitmapCustomAllocator.memset(pg, 0, 255, 4084);
                                holeBitSize -= 32672L;
                                pg = (BitmapPage)this.pages.get(--i);
                            }
                            while ((holeBitSize -= 8L) > 0L) {
                                pg.data[--offs] = -1;
                            }
                            int n2 = offs - 1;
                            pg.data[n2] = (byte)(pg.data[n2] | (byte)(~((1 << -((int)holeBitSize)) - 1)));
                            pg.modify();
                        }
                        return pos;
                    }
                    if ((long)Bitmap.maxHoleSize[mask] >= objBitSize) {
                        byte holeBitOffset = Bitmap.maxHoleOffset[mask];
                        pos = this.base + (((long)i * 4084L + (long)offs) * 8L + (long)holeBitOffset << this.quantumBits);
                        long nextPos = this.wasReserved(pos, size);
                        if (nextPos == 0L) {
                            this.currPage = i;
                            this.currOffs = offs;
                            int n = offs;
                            pg.data[n] = (byte)(pg.data[n] | (byte)((1 << (int)objBitSize) - 1 << holeBitOffset));
                            pg.modify();
                            return pos;
                        }
                        long quantNo = (nextPos - this.base >>> this.quantumBits) + 7L;
                        i = (int)(quantNo / 32672L);
                        offs = (int)(quantNo - (long)i * 32672L) >> 3;
                        holeBitSize = 0L;
                        continue;
                    }
                    ++offs;
                    if (Bitmap.lastHoleSize[mask] == 8) {
                        holeBitSize += 8L;
                        continue;
                    }
                    holeBitSize = Bitmap.lastHoleSize[mask];
                }
                offs = 0;
                ++i;
            }
            break;
        }
    }

    public long reallocate(long pos, long oldSize, long newSize) {
        StorageImpl db = (StorageImpl)this.getStorage();
        if ((newSize + (long)this.quantum - 1L & (long)(~(this.quantum - 1))) > (oldSize + (long)this.quantum - 1L & (long)(~(this.quantum - 1)))) {
            long newPos = this.allocate(newSize);
            this.free0(pos, oldSize);
            pos = newPos;
        }
        return pos;
    }

    public void free(long pos, long size) {
        this.reserve(pos, size);
        this.free0(pos, size);
    }

    private long wasReserved(long pos, long size) {
        Location loc = new Location(pos, size);
        Location r = (Location)this.reserved.get(loc);
        if (r != null) {
            return Math.max(pos + size, r.pos + r.size);
        }
        return 0L;
    }

    private void reserve(long pos, long size) {
        Location loc = new Location(pos, size);
        this.reserved.put(loc, loc);
    }

    private void free0(long pos, long size) {
        long quantNo = pos - this.base >>> this.quantumBits;
        long objBitSize = size + (long)this.quantum - 1L >>> this.quantumBits;
        int pageId = (int)(quantNo / 32672L);
        int offs = (int)(quantNo - (long)pageId * 32672L) >> 3;
        BitmapPage pg = (BitmapPage)this.pages.get(pageId);
        int bitOffs = (int)quantNo & 7;
        if (objBitSize > (long)(8 - bitOffs)) {
            objBitSize -= (long)(8 - bitOffs);
            int n = offs++;
            pg.data[n] = (byte)(pg.data[n] & (1 << bitOffs) - 1);
            while (objBitSize + (long)(offs * 8) > 32672L) {
                BitmapCustomAllocator.memset(pg, offs, 0, 4084 - offs);
                pg = (BitmapPage)this.pages.get(++pageId);
                objBitSize -= (long)((4084 - offs) * 8);
                offs = 0;
            }
            while ((objBitSize -= 8L) > 0L) {
                pg.data[offs++] = 0;
            }
            int n2 = offs;
            pg.data[n2] = (byte)(pg.data[n2] & (byte)(~((1 << (int)objBitSize + 8) - 1)));
        } else {
            int n = offs;
            pg.data[n] = (byte)(pg.data[n] & (byte)(~((1 << (int)objBitSize) - 1 << bitOffs)));
        }
        pg.modify();
    }

    static final void memset(BitmapPage pg, int offs, int pattern, int len) {
        byte[] arr = pg.data;
        byte pat = (byte)pattern;
        while (--len >= 0) {
            arr[offs++] = pat;
        }
        pg.modify();
    }

    public void commit() {
        this.reserved.clear();
    }

    static class Location
    implements Comparable {
        long pos;
        long size;

        Location(long pos, long size) {
            this.pos = pos;
            this.size = size;
        }

        public int compareTo(Object o) {
            Location loc = (Location)o;
            return this.pos + this.size <= loc.pos ? -1 : (loc.pos + loc.size <= this.pos ? 1 : 0);
        }
    }

    static class BitmapPage
    extends Persistent {
        byte[] data;

        BitmapPage() {
        }
    }
}

