/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import org.garret.perst.CustomAllocator;
import org.garret.perst.CustomSerializable;
import org.garret.perst.INamedClassLoader;
import org.garret.perst.IPersistent;
import org.garret.perst.IValue;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.LoadFactory;
import org.garret.perst.impl.ReflectionProvider;
import org.garret.perst.impl.StandardReflectionProvider;
import org.garret.perst.impl.StorageImpl;

public final class ClassDescriptor
extends Persistent {
    ClassDescriptor next;
    String name;
    boolean hasReferences;
    FieldDescriptor[] allFields;
    CustomAllocator allocator;
    transient Class cls;
    transient Constructor loadConstructor;
    transient LoadFactory factory;
    transient Object[] constructorParams;
    transient boolean hasSubclasses;
    transient boolean resolved;
    static ReflectionProvider reflectionProvider;
    static boolean reverseMembersOrder;
    public static final int tpBoolean = 0;
    public static final int tpByte = 1;
    public static final int tpChar = 2;
    public static final int tpShort = 3;
    public static final int tpInt = 4;
    public static final int tpLong = 5;
    public static final int tpFloat = 6;
    public static final int tpDouble = 7;
    public static final int tpString = 8;
    public static final int tpDate = 9;
    public static final int tpObject = 10;
    public static final int tpValue = 11;
    public static final int tpRaw = 12;
    public static final int tpLink = 13;
    public static final int tpEnum = 14;
    public static final int tpCustom = 15;
    public static final int tpArrayOfBoolean = 20;
    public static final int tpArrayOfByte = 21;
    public static final int tpArrayOfChar = 22;
    public static final int tpArrayOfShort = 23;
    public static final int tpArrayOfInt = 24;
    public static final int tpArrayOfLong = 25;
    public static final int tpArrayOfFloat = 26;
    public static final int tpArrayOfDouble = 27;
    public static final int tpArrayOfString = 28;
    public static final int tpArrayOfDate = 29;
    public static final int tpArrayOfObject = 30;
    public static final int tpArrayOfValue = 31;
    public static final int tpArrayOfRaw = 32;
    public static final int tpArrayOfLink = 33;
    public static final int tpArrayOfEnum = 34;
    static final String[] signature;
    static final int[] sizeof;
    static final Class[] perstConstructorProfile;
    static boolean treateAnyNonPersistentObjectAsValue;
    static boolean serializeNonPersistentObjects;

    static ReflectionProvider getReflectionProvider() {
        if (reflectionProvider == null) {
            try {
                Class.forName("sun.misc.Unsafe");
                String cls = "org.garret.perst.impl.sun14.Sun14ReflectionProvider";
                reflectionProvider = (ReflectionProvider)Class.forName(cls).newInstance();
            }
            catch (Throwable x) {
                reflectionProvider = new StandardReflectionProvider();
            }
        }
        return reflectionProvider;
    }

    public boolean equals(ClassDescriptor cd) {
        if (cd == null || this.allFields.length != cd.allFields.length) {
            return false;
        }
        for (int i = 0; i < this.allFields.length; ++i) {
            if (this.allFields[i].equals(cd.allFields[i])) continue;
            return false;
        }
        return true;
    }

    Object newInstance() {
        if (this.factory != null) {
            return this.factory.create(this);
        }
        try {
            return this.loadConstructor.newInstance(this.constructorParams);
        }
        catch (Exception x) {
            throw new StorageError(12, this.cls, x);
        }
    }

    void buildFieldList(StorageImpl storage, Class cls, ArrayList list) {
        int i;
        Class superclass = cls.getSuperclass();
        if (superclass != null) {
            this.buildFieldList(storage, superclass, list);
        }
        Field[] flds = cls.getDeclaredFields();
        if (storage.getDatabaseFormatVersion() >= 2) {
            Arrays.sort(flds, new Comparator<Field>(){

                @Override
                public int compare(Field f1, Field f2) {
                    return f1.getName().compareTo(f2.getName());
                }
            });
        } else {
            if (ClassDescriptor.class.equals((Object)cls)) {
                for (i = 0; i < flds.length; ++i) {
                    if ((flds[i].getModifiers() & 0x88) != 0) continue;
                    if ("next".equals(flds[i].getName())) break;
                    reverseMembersOrder = true;
                    break;
                }
            }
            if (reverseMembersOrder) {
                int n = flds.length;
                for (i = 0; i < n >> 1; ++i) {
                    Field f = flds[i];
                    flds[i] = flds[n - i - 1];
                    flds[n - i - 1] = f;
                }
            }
        }
        for (i = 0; i < flds.length; ++i) {
            Field f = flds[i];
            if (f.isSynthetic() || (f.getModifiers() & 0x88) != 0) continue;
            try {
                f.setAccessible(true);
            }
            catch (Exception x) {
                // empty catch block
            }
            FieldDescriptor fd = new FieldDescriptor();
            fd.field = f;
            fd.fieldName = f.getName();
            fd.className = cls.getName();
            int type = ClassDescriptor.getTypeCode(f.getType());
            switch (type) {
                case 10: 
                case 13: 
                case 30: {
                    this.hasReferences = true;
                    break;
                }
                case 11: {
                    fd.valueDesc = storage.getClassDescriptor(f.getType());
                    this.hasReferences |= fd.valueDesc.hasReferences;
                    break;
                }
                case 31: {
                    fd.valueDesc = storage.getClassDescriptor(f.getType().getComponentType());
                    this.hasReferences |= fd.valueDesc.hasReferences;
                }
            }
            fd.type = type;
            list.add(fd);
        }
    }

    public static int getTypeCode(Class c) {
        int type;
        if (c.equals(Byte.TYPE)) {
            type = 1;
        } else if (c.equals(Short.TYPE)) {
            type = 3;
        } else if (c.equals(Character.TYPE)) {
            type = 2;
        } else if (c.equals(Integer.TYPE)) {
            type = 4;
        } else if (c.equals(Long.TYPE)) {
            type = 5;
        } else if (c.equals(Float.TYPE)) {
            type = 6;
        } else if (c.equals(Double.TYPE)) {
            type = 7;
        } else if (c.equals(String.class)) {
            type = 8;
        } else if (c.equals(Boolean.TYPE)) {
            type = 0;
        } else if (c.isEnum()) {
            type = 14;
        } else if (c.equals(Date.class)) {
            type = 9;
        } else if (IPersistent.class.isAssignableFrom(c)) {
            type = 10;
        } else if (IValue.class.isAssignableFrom(c)) {
            type = 11;
        } else if (c.equals(Link.class)) {
            type = 13;
        } else if (c.isArray()) {
            type = ClassDescriptor.getTypeCode(c.getComponentType());
            if (type >= 13) {
                throw new StorageError(7, c);
            }
            type += 20;
        } else if (CustomSerializable.class.isAssignableFrom(c)) {
            type = 15;
        } else if (c.equals(Object.class) || Comparable.class.isAssignableFrom(c)) {
            type = 12;
        } else if (serializeNonPersistentObjects) {
            type = 12;
        } else if (treateAnyNonPersistentObjectAsValue) {
            if (c.equals(Object.class)) {
                throw new StorageError(25);
            }
            type = 11;
        } else {
            throw new StorageError(7, c);
        }
        return type;
    }

    ClassDescriptor() {
    }

    private void locateConstructor() {
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(this.cls.getName() + "LoadFactory");
            this.factory = (LoadFactory)c.newInstance();
        }
        catch (Exception x1) {
            try {
                this.loadConstructor = this.cls.getDeclaredConstructor(perstConstructorProfile);
                this.constructorParams = new Object[]{this};
            }
            catch (NoSuchMethodException x2) {
                try {
                    this.loadConstructor = ClassDescriptor.getReflectionProvider().getDefaultConstructor(this.cls);
                    this.constructorParams = null;
                }
                catch (Exception x3) {
                    throw new StorageError(13, this.cls, x3);
                }
            }
            try {
                this.loadConstructor.setAccessible(true);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    ClassDescriptor(StorageImpl storage, Class cls) {
        this.cls = cls;
        this.name = ClassDescriptor.getClassName(cls);
        ArrayList list = new ArrayList();
        this.buildFieldList(storage, cls, list);
        this.allFields = list.toArray(new FieldDescriptor[list.size()]);
        this.locateConstructor();
        this.resolved = true;
    }

    protected static Field locateField(Class scope, String name) {
        try {
            while (true) {
                try {
                    Field fld = scope.getDeclaredField(name);
                    try {
                        fld.setAccessible(true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return fld;
                }
                catch (NoSuchFieldException x) {
                    if ((scope = scope.getSuperclass()) != null) continue;
                }
                break;
            }
        }
        catch (Exception x) {
            throw new StorageError(17, scope.getName() + "." + name, x);
        }
        return null;
    }

    public static String getClassName(Class cls) {
        ClassLoader loader = cls.getClassLoader();
        return loader instanceof INamedClassLoader ? ((INamedClassLoader)((Object)loader)).getName() + ':' + cls.getName() : cls.getName();
    }

    public static Class loadClass(Storage storage, String name) {
        if (storage != null) {
            ClassLoader loader;
            int col = name.indexOf(58);
            if (col >= 0) {
                loader = storage.findClassLoader(name.substring(0, col));
                if (loader == null) {
                    return null;
                }
                name = name.substring(col + 1);
            } else {
                loader = storage.getClassLoader();
            }
            if (loader != null) {
                try {
                    return loader.loadClass(name);
                }
                catch (ClassNotFoundException x) {
                    // empty catch block
                }
            }
        }
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (ClassNotFoundException x) {
            throw new StorageError(18, name, x);
        }
    }

    public void onLoad() {
        Field f;
        FieldDescriptor fd;
        int n;
        this.cls = ClassDescriptor.loadClass(this.getStorage(), this.name);
        Class scope = this.cls;
        int i = n = this.allFields.length;
        while (--i >= 0) {
            fd = this.allFields[i];
            fd.load();
            if (!fd.className.equals(scope.getName())) {
                for (scope = this.cls; scope != null && !fd.className.equals(scope.getName()); scope = scope.getSuperclass()) {
                }
            }
            if (scope != null) {
                try {
                    f = scope.getDeclaredField(fd.fieldName);
                    if ((f.getModifiers() & 0x88) != 0) continue;
                    try {
                        f.setAccessible(true);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    fd.field = f;
                }
                catch (NoSuchFieldException x) {}
                continue;
            }
            scope = this.cls;
        }
        i = n;
        block10: while (--i >= 0) {
            fd = this.allFields[i];
            if (fd.field != null) continue;
            block11: for (scope = this.cls; scope != null; scope = scope.getSuperclass()) {
                try {
                    f = scope.getDeclaredField(fd.fieldName);
                    if ((f.getModifiers() & 0x88) != 0) continue;
                    for (int j = 0; j < n; ++j) {
                        if (this.allFields[j].field == f) continue block11;
                    }
                    try {
                        f.setAccessible(true);
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    fd.field = f;
                    continue block10;
                }
                catch (NoSuchFieldException x) {
                    // empty catch block
                }
            }
        }
        this.locateConstructor();
        StorageImpl s = (StorageImpl)this.getStorage();
        if (s.classDescMap.get(this.cls) == null) {
            s.classDescMap.put(this.cls, this);
        }
    }

    void resolve() {
        if (!this.resolved) {
            StorageImpl classStorage = (StorageImpl)this.getStorage();
            ClassDescriptor desc = new ClassDescriptor(classStorage, this.cls);
            this.resolved = true;
            if (!desc.equals(this)) {
                classStorage.registerClassDescriptor(desc);
            }
        }
    }

    public boolean recursiveLoading() {
        return false;
    }

    static {
        signature = new String[]{"boolean", "byte", "char", "short", "int", "long", "float", "double", "String", "Date", "Object", "Value", "Raw", "Link", "enum", "", "", "", "", "", "", "ArrayOfBoolean", "ArrayOfByte", "ArrayOfChar", "ArrayOfShort", "ArrayOfInt", "ArrayOfLong", "ArrayOfFloat", "ArrayOfDouble", "ArrayOfEnum", "ArrayOfString", "ArrayOfDate", "ArrayOfObject", "ArrayOfValue", "ArrayOfRaw", "ArrayOfLink", "ArrayOfEnum"};
        sizeof = new int[]{1, 1, 2, 2, 4, 8, 4, 8, 0, 8, 4, 0, 0, 0, 4};
        perstConstructorProfile = new Class[]{ClassDescriptor.class};
        treateAnyNonPersistentObjectAsValue = Boolean.getBoolean("perst.implicit.values");
        serializeNonPersistentObjects = Boolean.getBoolean("perst.serialize.transient.objects");
    }

    static class FieldDescriptor
    extends Persistent
    implements Comparable {
        String fieldName;
        String className;
        int type;
        ClassDescriptor valueDesc;
        transient Field field;

        FieldDescriptor() {
        }

        public int compareTo(Object o) {
            return this.fieldName.compareTo(((FieldDescriptor)o).fieldName);
        }

        public boolean equals(FieldDescriptor fd) {
            return this.fieldName.equals(fd.fieldName) && this.className.equals(fd.className) && this.valueDesc == fd.valueDesc && this.type == fd.type;
        }
    }
}

