/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.SortedMap;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentMap;
import org.garret.perst.Index;
import org.garret.perst.Key;
import org.garret.perst.Link;
import org.garret.perst.PersistentResource;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.QueryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistentMapImpl<K extends Comparable, V extends IPersistent>
extends PersistentResource
implements IPersistentMap<K, V> {
    Index<V> index;
    Object keys;
    Link<V> values;
    int type;
    volatile transient Set<Map.Entry<K, V>> entrySet;
    volatile transient Set<K> keySet;
    volatile transient Collection<V> valuesCol;
    static final int BTREE_TRESHOLD = 128;

    PersistentMapImpl(Storage storage, Class keyType, int initialSize) {
        super(storage);
        this.type = this.getTypeCode(keyType);
        this.keys = new Comparable[initialSize];
        this.values = storage.createLink(initialSize);
    }

    PersistentMapImpl() {
    }

    protected int getTypeCode(Class c) {
        if (c.equals(Byte.TYPE) || c.equals(Byte.class)) {
            return 1;
        }
        if (c.equals(Short.TYPE) || c.equals(Short.class)) {
            return 3;
        }
        if (c.equals(Character.TYPE) || c.equals(Character.class)) {
            return 2;
        }
        if (c.equals(Integer.TYPE) || c.equals(Integer.class)) {
            return 4;
        }
        if (c.equals(Long.TYPE) || c.equals(Long.class)) {
            return 5;
        }
        if (c.equals(Float.TYPE) || c.equals(Float.class)) {
            return 6;
        }
        if (c.equals(Double.TYPE) || c.equals(Double.class)) {
            return 7;
        }
        if (c.equals(String.class)) {
            return 8;
        }
        if (c.equals(Boolean.TYPE) || c.equals(Boolean.class)) {
            return 0;
        }
        if (c.isEnum()) {
            return 14;
        }
        if (c.equals(Date.class)) {
            return 9;
        }
        if (IPersistent.class.isAssignableFrom(c)) {
            return 10;
        }
        if (Comparable.class.isAssignableFrom(c)) {
            return 12;
        }
        throw new StorageError(7, c);
    }

    @Override
    public int size() {
        return this.index != null ? this.index.size() : this.values.size();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean containsValue(Object value) {
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        if (value == null) {
            while (i.hasNext()) {
                Map.Entry<K, V> e = i.next();
                if (e.getValue() != null) continue;
                return true;
            }
        } else {
            while (i.hasNext()) {
                Map.Entry<K, V> e = i.next();
                if (!value.equals(e.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    private int binarySearch(Object key) {
        Comparable[] keys = (Comparable[])this.keys;
        int l = 0;
        int r = this.values.size();
        while (l < r) {
            int i = l + r >> 1;
            if (keys[i].compareTo(key) < 0) {
                l = i + 1;
                continue;
            }
            r = i;
        }
        return r;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.index != null) {
            Key k = this.generateKey(key);
            return this.index.entryIterator(k, k, 0).hasNext();
        }
        int i = this.binarySearch(key);
        return i < this.values.size() && ((Comparable[])this.keys)[i].equals(key);
    }

    @Override
    public V get(Object key) {
        if (this.index != null) {
            return (V)((IPersistent)this.index.get(this.generateKey(key)));
        }
        int i = this.binarySearch(key);
        if (i < this.values.size() && ((Comparable[])this.keys)[i].equals(key)) {
            return this.values.get(i);
        }
        return null;
    }

    @Override
    public V put(K key, V value) {
        V prev = null;
        if (this.index == null) {
            int size = this.values.size();
            int i = this.binarySearch(key);
            if (i < size && key.equals(((Comparable[])this.keys)[i])) {
                prev = this.values.set(i, value);
            } else if (size == 128) {
                this.index = this.getStorage().createIndex(Btree.mapKeyType(this.type), true);
                Comparable[] keys = (Comparable[])this.keys;
                for (i = 0; i < size; ++i) {
                    this.index.set(this.generateKey(keys[i]), this.values.get(i));
                }
                this.index.set(this.generateKey(key), value);
                this.keys = null;
                this.values = null;
                this.modify();
            } else {
                Object[] oldKeys = (Object[])this.keys;
                if (size >= oldKeys.length) {
                    Comparable[] newKeys = new Comparable[size + 1 > oldKeys.length * 2 ? size + 1 : oldKeys.length * 2];
                    System.arraycopy(oldKeys, 0, newKeys, 0, i);
                    System.arraycopy(oldKeys, i, newKeys, i + 1, size - i);
                    this.keys = newKeys;
                    newKeys[i] = key;
                } else {
                    System.arraycopy(oldKeys, i, oldKeys, i + 1, size - i);
                    oldKeys[i] = key;
                }
                this.values.insert(i, value);
            }
        } else {
            prev = this.index.set(this.generateKey(key), value);
        }
        return prev;
    }

    @Override
    public V remove(Object key) {
        if (this.index == null) {
            int size = this.values.size();
            int i = this.binarySearch(key);
            if (i < size && ((Comparable[])this.keys)[i].equals(key)) {
                System.arraycopy(this.keys, i + 1, this.keys, i, size - i - 1);
                ((Comparable[])this.keys)[size - 1] = null;
                return (V)((IPersistent)this.values.remove(i));
            }
            return null;
        }
        try {
            return this.index.remove(this.generateKey(key));
        }
        catch (StorageError x) {
            if (x.getErrorCode() == 5) {
                return null;
            }
            throw x;
        }
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> e : t.entrySet()) {
            this.put((K)((Comparable)e.getKey()), (V)((IPersistent)e.getValue()));
        }
    }

    @Override
    public void clear() {
        if (this.index != null) {
            this.index.clear();
        } else {
            this.values.clear();
            this.keys = new Comparable[((Comparable[])this.keys).length];
        }
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = PersistentMapImpl.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public K next() {
                            return (Comparable)this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return PersistentMapImpl.this.size();
                }

                @Override
                public boolean contains(Object k) {
                    return PersistentMapImpl.this.containsKey(k);
                }
            };
        }
        return this.keySet;
    }

    @Override
    public Collection<V> values() {
        if (this.valuesCol == null) {
            this.valuesCol = new AbstractCollection<V>(){

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = PersistentMapImpl.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return (IPersistent)this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return PersistentMapImpl.this.size();
                }

                @Override
                public boolean contains(Object v) {
                    return PersistentMapImpl.this.containsValue(v);
                }
            };
        }
        return this.valuesCol;
    }

    protected Iterator<Map.Entry<K, V>> entryIterator() {
        if (this.index != null) {
            return new Iterator<Map.Entry<K, V>>(){
                private Iterator<Map.Entry<Object, V>> i;
                {
                    this.i = PersistentMapImpl.this.index.entryIterator();
                }

                @Override
                public boolean hasNext() {
                    return this.i.hasNext();
                }

                @Override
                public Map.Entry<K, V> next() {
                    final Map.Entry e = this.i.next();
                    return new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return (Comparable)e.getKey();
                        }

                        @Override
                        public V getValue() {
                            return (IPersistent)e.getValue();
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException("Entry.Map.setValue");
                        }
                    };
                }

                @Override
                public void remove() {
                    this.i.remove();
                }
            };
        }
        return new Iterator<Map.Entry<K, V>>(){
            private int i = -1;

            @Override
            public boolean hasNext() {
                return this.i + 1 < PersistentMapImpl.this.values.size();
            }

            @Override
            public Map.Entry<K, V> next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.i;
                return new Map.Entry<K, V>(){

                    @Override
                    public K getKey() {
                        return ((Comparable[])PersistentMapImpl.this.keys)[i];
                    }

                    @Override
                    public V getValue() {
                        return PersistentMapImpl.this.values.get(i);
                    }

                    @Override
                    public V setValue(V value) {
                        throw new UnsupportedOperationException("Entry.Map.setValue");
                    }
                };
            }

            @Override
            public void remove() {
                if (this.i < 0) {
                    throw new IllegalStateException();
                }
                int size = PersistentMapImpl.this.values.size();
                System.arraycopy(PersistentMapImpl.this.keys, this.i + 1, PersistentMapImpl.this.keys, this.i, size - this.i - 1);
                ((Comparable[])PersistentMapImpl.this.keys)[size - 1] = null;
                PersistentMapImpl.this.values.removeObject(this.i);
                --this.i;
            }
        };
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        if (this.entrySet == null) {
            this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return PersistentMapImpl.this.entryIterator();
                }

                @Override
                public int size() {
                    return PersistentMapImpl.this.size();
                }

                @Override
                public boolean remove(Object o) {
                    if (!(o instanceof Map.Entry)) {
                        return false;
                    }
                    Map.Entry entry = (Map.Entry)o;
                    Comparable key = (Comparable)entry.getKey();
                    IPersistent value = (IPersistent)entry.getValue();
                    if (value != null) {
                        Object v = PersistentMapImpl.this.get(key);
                        if (value.equals(v)) {
                            PersistentMapImpl.this.remove(key);
                            return true;
                        }
                    } else if (PersistentMapImpl.this.containsKey(key) && PersistentMapImpl.this.get(key) == null) {
                        PersistentMapImpl.this.remove(key);
                        return true;
                    }
                    return false;
                }

                @Override
                public boolean contains(Object k) {
                    Map.Entry e = (Map.Entry)k;
                    if (e.getValue() != null) {
                        return ((IPersistent)e.getValue()).equals(PersistentMapImpl.this.get(e.getKey()));
                    }
                    return PersistentMapImpl.this.containsKey(e.getKey()) && PersistentMapImpl.this.get(e.getKey()) == null;
                }
            };
        }
        return this.entrySet;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map t = (Map)o;
        if (t.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> e : this.entrySet()) {
                Comparable key = (Comparable)e.getKey();
                IPersistent value = (IPersistent)e.getValue();
                if (!(value == null ? t.get(key) != null || !t.containsKey(key) : !value.equals(t.get(key)))) continue;
                return false;
            }
        }
        catch (ClassCastException unused) {
            return false;
        }
        catch (NullPointerException unused) {
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int h = 0;
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        while (i.hasNext()) {
            h += ((Object)i.next()).hashCode();
        }
        return h;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("{");
        Iterator<Map.Entry<K, V>> i = this.entrySet().iterator();
        boolean hasNext = i.hasNext();
        while (hasNext) {
            Map.Entry<K, V> e = i.next();
            Comparable key = (Comparable)e.getKey();
            IPersistent value = (IPersistent)e.getValue();
            if (key == this) {
                buf.append("(this Map)");
            } else {
                buf.append(key);
            }
            buf.append("=");
            if (value == this) {
                buf.append("(this Map)");
            } else {
                buf.append(value);
            }
            if (!(hasNext = i.hasNext())) continue;
            buf.append(", ");
        }
        buf.append("}");
        return buf.toString();
    }

    final Key generateKey(Object key) {
        return this.generateKey(key, true);
    }

    final Key generateKey(Object key, boolean inclusive) {
        if (key instanceof Integer) {
            return new Key((Integer)key, inclusive);
        }
        if (key instanceof Byte) {
            return new Key((Byte)key, inclusive);
        }
        if (key instanceof Character) {
            return new Key(((Character)key).charValue(), inclusive);
        }
        if (key instanceof Short) {
            return new Key((Short)key, inclusive);
        }
        if (key instanceof Long) {
            return new Key((Long)key, inclusive);
        }
        if (key instanceof Float) {
            return new Key(((Float)key).floatValue(), inclusive);
        }
        if (key instanceof Double) {
            return new Key((Double)key, inclusive);
        }
        if (key instanceof String) {
            return new Key((String)key, inclusive);
        }
        if (key instanceof Enum) {
            return new Key((Enum)key, inclusive);
        }
        if (key instanceof Date) {
            return new Key((Date)key, inclusive);
        }
        if (key instanceof IPersistent) {
            return new Key((IPersistent)key, inclusive);
        }
        if (key instanceof Comparable) {
            return new Key((Comparable)key, inclusive);
        }
        if (key == null) {
            return new Key((IPersistent)key, inclusive);
        }
        throw new StorageError(8, key.getClass());
    }

    @Override
    public Comparator<? super K> comparator() {
        return null;
    }

    @Override
    public SortedMap<K, V> subMap(K from, K to) {
        if (from.compareTo(to) > 0) {
            throw new IllegalArgumentException("from > to");
        }
        return new SubMap(this, from, to);
    }

    @Override
    public SortedMap<K, V> headMap(K to) {
        return new SubMap(this, null, to);
    }

    @Override
    public SortedMap<K, V> tailMap(K from) {
        return new SubMap(this, from, null);
    }

    @Override
    public K firstKey() {
        if (this.index != null) {
            return (K)((Comparable)((Map.Entry)this.index.entryIterator().next()).getKey());
        }
        Comparable[] keys = (Comparable[])this.keys;
        if (this.values.size() == 0) {
            throw new NoSuchElementException();
        }
        return (K)keys[0];
    }

    @Override
    public K lastKey() {
        if (this.index != null) {
            return (K)((Comparable)((Map.Entry)this.index.entryIterator(null, null, 1).next()).getKey());
        }
        int size = this.values.size();
        if (size == 0) {
            throw new NoSuchElementException();
        }
        return (K)((Comparable[])this.keys)[size - 1];
    }

    @Override
    public Iterator<V> select(Class cls, String predicate) {
        QueryImpl<V> query = new QueryImpl<V>(this.getStorage());
        return query.select(cls, this.values().iterator(), predicate);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SubMap
    extends AbstractMap<K, V>
    implements SortedMap<K, V> {
        private Key fromKey;
        private Key toKey;
        private K from;
        private K to;
        volatile Set<Map.Entry<K, V>> entrySet;
        final /* synthetic */ PersistentMapImpl this$0;

        SubMap(K from, K to) {
            this.this$0 = var1_1;
            this.from = from;
            this.to = to;
            this.fromKey = from != null ? var1_1.generateKey(from, true) : null;
            this.toKey = to != null ? var1_1.generateKey(to, false) : null;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.inRange((Comparable)key) && this.this$0.containsKey(key);
        }

        @Override
        public V get(Object key) {
            if (!this.inRange((Comparable)key)) {
                return null;
            }
            return this.this$0.get(key);
        }

        @Override
        public V put(K key, V value) {
            if (!this.inRange(key)) {
                throw new IllegalArgumentException("key out of range");
            }
            return this.this$0.put(key, value);
        }

        @Override
        public Comparator<? super K> comparator() {
            return null;
        }

        @Override
        public K firstKey() {
            return (Comparable)this.entryIterator(0).next().getKey();
        }

        @Override
        public K lastKey() {
            return (Comparable)this.entryIterator(1).next().getKey();
        }

        protected Iterator<Map.Entry<K, V>> entryIterator(final int order) {
            if (this.this$0.index != null) {
                return new Iterator<Map.Entry<K, V>>(){
                    private Iterator<Map.Entry<Object, V>> i;
                    {
                        this.i = SubMap.this.this$0.index.entryIterator(SubMap.this.fromKey, SubMap.this.toKey, order);
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        final Map.Entry e = this.i.next();
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return (Comparable)e.getKey();
                            }

                            @Override
                            public V getValue() {
                                return (IPersistent)e.getValue();
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException("Entry.Map.setValue");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }
                };
            }
            if (order == 0) {
                final int beg = (this.from != null ? this.this$0.binarySearch(this.from) : 0) - 1;
                final int end = this.this$0.values.size();
                return new Iterator<Map.Entry<K, V>>(){
                    private int i;
                    {
                        this.i = beg;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i + 1 < end && (SubMap.this.to == null || ((Comparable[])SubMap.this.this$0.keys)[this.i + 1].compareTo(SubMap.this.to) < 0);
                    }

                    @Override
                    public Map.Entry<K, V> next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        ++this.i;
                        return new Map.Entry<K, V>(){

                            @Override
                            public K getKey() {
                                return ((Comparable[])SubMap.this.this$0.keys)[i];
                            }

                            @Override
                            public V getValue() {
                                return SubMap.this.this$0.values.get(i);
                            }

                            @Override
                            public V setValue(V value) {
                                throw new UnsupportedOperationException("Entry.Map.setValue");
                            }
                        };
                    }

                    @Override
                    public void remove() {
                        if (this.i < 0) {
                            throw new IllegalStateException();
                        }
                        int size = SubMap.this.this$0.values.size();
                        System.arraycopy(SubMap.this.this$0.keys, this.i + 1, SubMap.this.this$0.keys, this.i, size - this.i - 1);
                        ((Comparable[])SubMap.this.this$0.keys)[size - 1] = null;
                        SubMap.this.this$0.values.removeObject(this.i);
                        --this.i;
                    }
                };
            }
            final int beg = (this.to != null ? this.this$0.binarySearch(this.to) : 0) - 1;
            return new Iterator<Map.Entry<K, V>>(){
                private int i;
                {
                    this.i = beg;
                }

                @Override
                public boolean hasNext() {
                    return this.i > 0 && (SubMap.this.from == null || ((Comparable[])SubMap.this.this$0.keys)[this.i - 1].compareTo(SubMap.this.from) >= 0);
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    --this.i;
                    return new Map.Entry<K, V>(){

                        @Override
                        public K getKey() {
                            return ((Comparable[])SubMap.this.this$0.keys)[i];
                        }

                        @Override
                        public V getValue() {
                            return SubMap.this.this$0.values.get(i);
                        }

                        @Override
                        public V setValue(V value) {
                            throw new UnsupportedOperationException("Entry.Map.setValue");
                        }
                    };
                }

                @Override
                public void remove() {
                    if (this.i < 0) {
                        throw new IllegalStateException();
                    }
                    int size = SubMap.this.this$0.values.size();
                    System.arraycopy(SubMap.this.this$0.keys, this.i + 1, SubMap.this.this$0.keys, this.i, size - this.i - 1);
                    ((Comparable[])SubMap.this.this$0.keys)[size - 1] = null;
                    SubMap.this.this$0.values.removeObject(this.i);
                }
            };
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            if (this.entrySet == null) {
                this.entrySet = new AbstractSet<Map.Entry<K, V>>(){

                    @Override
                    public Iterator<Map.Entry<K, V>> iterator() {
                        return SubMap.this.entryIterator(0);
                    }

                    @Override
                    public int size() {
                        Iterator i = this.iterator();
                        int n = 0;
                        while (i.hasNext()) {
                            ++n;
                            i.next();
                        }
                        return n;
                    }

                    @Override
                    public boolean isEmpty() {
                        return !this.iterator().hasNext();
                    }

                    @Override
                    public boolean remove(Object o) {
                        if (!(o instanceof Map.Entry)) {
                            return false;
                        }
                        Map.Entry entry = (Map.Entry)o;
                        Comparable key = (Comparable)entry.getKey();
                        if (!SubMap.this.inRange(key)) {
                            return false;
                        }
                        IPersistent value = (IPersistent)entry.getValue();
                        if (value != null) {
                            Object v = SubMap.this.this$0.get(key);
                            if (value.equals(v)) {
                                SubMap.this.this$0.remove(key);
                                return true;
                            }
                        } else if (SubMap.this.this$0.containsKey(key) && SubMap.this.this$0.get(key) == null) {
                            SubMap.this.this$0.remove(key);
                            return true;
                        }
                        return false;
                    }

                    @Override
                    public boolean contains(Object k) {
                        Map.Entry e = (Map.Entry)k;
                        if (!SubMap.this.inRange((Comparable)e.getKey())) {
                            return false;
                        }
                        if (e.getValue() != null) {
                            return ((IPersistent)e.getValue()).equals(SubMap.this.this$0.get(e.getKey()));
                        }
                        return SubMap.this.this$0.containsKey(e.getKey()) && SubMap.this.this$0.get(e.getKey()) == null;
                    }
                };
            }
            return this.entrySet;
        }

        @Override
        public SortedMap<K, V> subMap(K from, K to) {
            if (!this.inRange2(from)) {
                throw new IllegalArgumentException("'from' out of range");
            }
            if (!this.inRange2(to)) {
                throw new IllegalArgumentException("'to' out of range");
            }
            return new SubMap(this.this$0, from, to);
        }

        @Override
        public SortedMap<K, V> headMap(K to) {
            if (!this.inRange2(to)) {
                throw new IllegalArgumentException("'to' out of range");
            }
            return new SubMap(this.this$0, this.from, to);
        }

        @Override
        public SortedMap<K, V> tailMap(K from) {
            if (!this.inRange2(from)) {
                throw new IllegalArgumentException("'from' out of range");
            }
            return new SubMap(this.this$0, from, this.to);
        }

        private boolean inRange(K key) {
            return !(this.from != null && key.compareTo(this.from) < 0 || this.to != null && key.compareTo(this.to) >= 0);
        }

        private boolean inRange2(K key) {
            return !(this.from != null && key.compareTo(this.from) < 0 || this.to != null && key.compareTo(this.to) > 0);
        }
    }
}

