/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import org.garret.perst.IPersistent;
import org.garret.perst.impl.OidHashTable;

public class PinWeakHashTable
implements OidHashTable {
    Entry[] table;
    static final float loadFactor = 0.75f;
    int count;
    int threshold;
    boolean flushing;

    public PinWeakHashTable(int initialCapacity) {
        this.threshold = (int)((float)initialCapacity * 0.75f);
        this.table = new Entry[initialCapacity];
    }

    public synchronized boolean remove(int oid) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.oid == oid) {
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                e.clear();
                --this.count;
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    protected Reference createReference(Object obj) {
        return new WeakReference<Object>(obj);
    }

    public synchronized void put(int oid, IPersistent obj) {
        Reference ref = this.createReference(obj);
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                e.ref = ref;
                return;
            }
            e = e.next;
        }
        if (this.count >= this.threshold && !this.flushing) {
            this.rehash();
            tab = this.table;
            index = (oid & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = new Entry(oid, ref, tab[index]);
        ++this.count;
    }

    public synchronized IPersistent get(int oid) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                if (e.pin != null) {
                    return e.pin;
                }
                return (IPersistent)e.ref.get();
            }
            e = e.next;
        }
        return null;
    }

    public synchronized void flush() {
        this.flushing = true;
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                IPersistent obj = e.pin;
                if (obj != null) {
                    obj.store();
                    e.pin = null;
                }
                e = e.next;
            }
        }
        this.flushing = false;
        if (this.count >= this.threshold) {
            this.rehash();
        }
    }

    public synchronized void invalidate() {
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                IPersistent obj = e.pin;
                if (obj != null) {
                    e.pin = null;
                    obj.invalidate();
                }
                e = e.next;
            }
            this.table[i] = null;
        }
        this.count = 0;
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.count = 0;
    }

    void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int i = oldCapacity;
        while (--i >= 0) {
            Entry prev = null;
            Entry e = oldMap[i];
            while (e != null) {
                Entry next = e.next;
                IPersistent obj = (IPersistent)e.ref.get();
                if ((obj == null || obj.isDeleted()) && e.pin == null) {
                    --this.count;
                    e.clear();
                    if (prev == null) {
                        oldMap[i] = next;
                    } else {
                        prev.next = next;
                    }
                } else {
                    prev = e;
                }
                e = next;
            }
        }
        if (this.count <= this.threshold >>> 1) {
            return;
        }
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newMap;
        i = oldCapacity;
        while (--i >= 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.oid & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized void setDirty(IPersistent obj) {
        int oid = obj.getOid();
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                e.pin = obj;
                return;
            }
            e = e.next;
        }
    }

    public synchronized void clearDirty(IPersistent obj) {
        int oid = obj.getOid();
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                e.pin = null;
                return;
            }
            e = e.next;
        }
    }

    public int size() {
        return this.count;
    }

    static class Entry {
        Entry next;
        Reference ref;
        int oid;
        IPersistent pin;

        void clear() {
            this.ref.clear();
            this.ref = null;
            this.pin = null;
            this.next = null;
        }

        Entry(int oid, Reference ref, Entry chain) {
            this.next = chain;
            this.oid = oid;
            this.ref = ref;
        }
    }
}

