/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.IFile;
import org.garret.perst.impl.OSFile;

public class Rc4File
implements IFile {
    private IFile file;
    private byte[] cipherBuf = new byte[4096];
    private byte[] initState = new byte[256];
    private byte[] state = new byte[256];
    private int x;
    private int y;
    private long length;
    private byte[] zeroPage;

    public void write(long pos, byte[] buf) {
        if (pos > this.length) {
            if (this.zeroPage == null) {
                this.zeroPage = new byte[4096];
                this.encrypt(this.zeroPage, 0, this.zeroPage, 0, 4096);
            }
            do {
                this.file.write(this.length, this.zeroPage);
            } while ((this.length += 4096L) < pos);
        }
        if (pos == this.length) {
            this.length += 4096L;
        }
        this.encrypt(buf, 0, this.cipherBuf, 0, buf.length);
        this.file.write(pos, this.cipherBuf);
    }

    public int read(long pos, byte[] buf) {
        if (pos < this.length) {
            int rc = this.file.read(pos, buf);
            this.decrypt(buf, 0, buf, 0, rc);
            return rc;
        }
        return 0;
    }

    public Rc4File(String filePath, boolean readOnly, boolean noFlush, String key) {
        this.file = new OSFile(filePath, readOnly, noFlush);
        this.length = this.file.length() & 0xFFFFFFFFFFFFF000L;
        this.setKey(key.getBytes());
    }

    public Rc4File(IFile file, String key) {
        this.file = file;
        this.length = file.length() & 0xFFFFFFFFFFFFF000L;
        this.setKey(key.getBytes());
    }

    private void setKey(byte[] key) {
        for (int counter = 0; counter < 256; ++counter) {
            this.initState[counter] = (byte)counter;
        }
        int index1 = 0;
        int index2 = 0;
        for (int counter = 0; counter < 256; ++counter) {
            index2 = key[index1] + this.initState[counter] + index2 & 0xFF;
            byte temp = this.initState[counter];
            this.initState[counter] = this.initState[index2];
            this.initState[index2] = temp;
            index1 = (index1 + 1) % key.length;
        }
    }

    private final void encrypt(byte[] clearText, int clearOff, byte[] cipherText, int cipherOff, int len) {
        this.y = 0;
        this.x = 0;
        System.arraycopy(this.initState, 0, this.state, 0, this.state.length);
        for (int i = 0; i < len; ++i) {
            cipherText[cipherOff + i] = (byte)(clearText[clearOff + i] ^ this.state[this.nextState()]);
        }
    }

    private final void decrypt(byte[] cipherText, int cipherOff, byte[] clearText, int clearOff, int len) {
        this.y = 0;
        this.x = 0;
        System.arraycopy(this.initState, 0, this.state, 0, this.state.length);
        for (int i = 0; i < len; ++i) {
            clearText[clearOff + i] = (byte)(cipherText[cipherOff + i] ^ this.state[this.nextState()]);
        }
    }

    private final int nextState() {
        this.x = this.x + 1 & 0xFF;
        this.y = this.y + this.state[this.x] & 0xFF;
        byte temp = this.state[this.x];
        this.state[this.x] = this.state[this.y];
        this.state[this.y] = temp;
        return this.state[this.x] + this.state[this.y] & 0xFF;
    }

    public void close() {
        this.file.close();
    }

    public boolean tryLock(boolean shared) {
        return this.file.tryLock(shared);
    }

    public void lock(boolean shared) {
        this.file.lock(shared);
    }

    public void unlock() {
        this.file.unlock();
    }

    public void sync() {
        this.file.sync();
    }

    public long length() {
        return this.file.length();
    }
}

