/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.RectangleR2;
import org.garret.perst.Storage;

public class RtreeR2Page
extends Persistent {
    static final int card = 113;
    static final int minFill = 56;
    int n;
    RectangleR2[] b;
    Link branch;

    RtreeR2Page(Storage storage, IPersistent obj, RectangleR2 r) {
        this.branch = storage.createLink(113);
        this.branch.setSize(113);
        this.b = new RectangleR2[113];
        this.setBranch(0, new RectangleR2(r), obj);
        this.n = 1;
        for (int i = 1; i < 113; ++i) {
            this.b[i] = new RectangleR2();
        }
    }

    RtreeR2Page(Storage storage, RtreeR2Page root, RtreeR2Page p) {
        this.branch = storage.createLink(113);
        this.branch.setSize(113);
        this.b = new RectangleR2[113];
        this.n = 2;
        this.setBranch(0, root.cover(), root);
        this.setBranch(1, p.cover(), p);
        for (int i = 2; i < 113; ++i) {
            this.b[i] = new RectangleR2();
        }
    }

    RtreeR2Page() {
    }

    RtreeR2Page insert(Storage storage, RectangleR2 r, IPersistent obj, int level) {
        this.modify();
        if (--level != 0) {
            int mini = 0;
            double minIncr = Double.MAX_VALUE;
            double minArea = Double.MAX_VALUE;
            for (int i = 0; i < this.n; ++i) {
                double area = this.b[i].area();
                double incr = RectangleR2.joinArea(this.b[i], r) - area;
                if (incr < minIncr) {
                    minIncr = incr;
                    minArea = area;
                    mini = i;
                    continue;
                }
                if (incr != minIncr || !(area < minArea)) continue;
                minArea = area;
                mini = i;
            }
            RtreeR2Page p = (RtreeR2Page)this.branch.get(mini);
            RtreeR2Page q = p.insert(storage, r, obj, level);
            if (q == null) {
                this.b[mini].join(r);
                return null;
            }
            this.setBranch(mini, p.cover(), p);
            return this.addBranch(storage, q.cover(), q);
        }
        return this.addBranch(storage, new RectangleR2(r), obj);
    }

    int remove(RectangleR2 r, IPersistent obj, int level, ArrayList reinsertList) {
        if (--level != 0) {
            for (int i = 0; i < this.n; ++i) {
                RtreeR2Page pg;
                int reinsertLevel;
                if (!r.intersects(this.b[i]) || (reinsertLevel = (pg = (RtreeR2Page)this.branch.get(i)).remove(r, obj, level, reinsertList)) < 0) continue;
                if (pg.n >= 56) {
                    this.setBranch(i, pg.cover(), pg);
                    this.modify();
                } else {
                    reinsertList.add(pg);
                    reinsertLevel = level - 1;
                    this.removeBranch(i);
                }
                return reinsertLevel;
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                if (!this.branch.containsElement(i, obj)) continue;
                this.removeBranch(i);
                return 0;
            }
        }
        return -1;
    }

    void find(RectangleR2 r, ArrayList result, int level) {
        if (--level != 0) {
            for (int i = 0; i < this.n; ++i) {
                if (!r.intersects(this.b[i])) continue;
                ((RtreeR2Page)this.branch.get(i)).find(r, result, level);
            }
        } else {
            for (int i = 0; i < this.n; ++i) {
                if (!r.intersects(this.b[i])) continue;
                result.add(this.branch.get(i));
            }
        }
    }

    void purge(int level) {
        if (--level != 0) {
            for (int i = 0; i < this.n; ++i) {
                ((RtreeR2Page)this.branch.get(i)).purge(level);
            }
        }
        this.deallocate();
    }

    final void setBranch(int i, RectangleR2 r, IPersistent obj) {
        this.b[i] = r;
        this.branch.setObject(i, obj);
    }

    final void removeBranch(int i) {
        --this.n;
        System.arraycopy(this.b, i + 1, this.b, i, this.n - i);
        this.branch.remove(i);
        this.branch.setSize(113);
        this.modify();
    }

    final RtreeR2Page addBranch(Storage storage, RectangleR2 r, IPersistent obj) {
        if (this.n < 113) {
            this.setBranch(this.n++, r, obj);
            return null;
        }
        return this.splitPage(storage, r, obj);
    }

    final RtreeR2Page splitPage(Storage storage, RectangleR2 r, IPersistent obj) {
        RtreeR2Page pg;
        RectangleR2 group0;
        int j;
        int i;
        int seed0 = 0;
        int seed1 = 0;
        double[] rectArea = new double[114];
        double worstWaste = Double.MIN_VALUE;
        rectArea[0] = r.area();
        for (i = 0; i < 113; ++i) {
            rectArea[i + 1] = this.b[i].area();
        }
        RectangleR2 bp = r;
        for (i = 0; i < 113; ++i) {
            for (j = i + 1; j <= 113; ++j) {
                double waste = RectangleR2.joinArea(bp, this.b[j - 1]) - rectArea[i] - rectArea[j];
                if (!(waste > worstWaste)) continue;
                worstWaste = waste;
                seed0 = i;
                seed1 = j;
            }
            bp = this.b[i];
        }
        byte[] taken = new byte[113];
        taken[seed1 - 1] = 2;
        RectangleR2 group1 = new RectangleR2(this.b[seed1 - 1]);
        if (seed0 == 0) {
            group0 = new RectangleR2(r);
            pg = new RtreeR2Page(storage, obj, r);
        } else {
            group0 = new RectangleR2(this.b[seed0 - 1]);
            pg = new RtreeR2Page(storage, this.branch.getRaw(seed0 - 1), group0);
            this.setBranch(seed0 - 1, r, obj);
        }
        int groupCard1 = 1;
        int groupCard0 = 1;
        double groupArea0 = rectArea[seed0];
        double groupArea1 = rectArea[seed1];
        while (groupCard0 + groupCard1 < 114 && groupCard0 < 58 && groupCard1 < 58) {
            int betterGroup = -1;
            int chosen = -1;
            double biggestDiff = -1.0;
            for (i = 0; i < 113; ++i) {
                double diff;
                if (taken[i] != 0 || !((diff = RectangleR2.joinArea(group0, this.b[i]) - groupArea0 - (RectangleR2.joinArea(group1, this.b[i]) - groupArea1)) > biggestDiff) && !(-diff > biggestDiff)) continue;
                chosen = i;
                if (diff < 0.0) {
                    betterGroup = 0;
                    biggestDiff = -diff;
                    continue;
                }
                betterGroup = 1;
                biggestDiff = diff;
            }
            Assert.that(chosen >= 0);
            if (betterGroup == 0) {
                group0.join(this.b[chosen]);
                groupArea0 = group0.area();
                taken[chosen] = 1;
                pg.setBranch(groupCard0++, this.b[chosen], this.branch.getRaw(chosen));
                continue;
            }
            ++groupCard1;
            group1.join(this.b[chosen]);
            groupArea1 = group1.area();
            taken[chosen] = 2;
        }
        if (groupCard0 + groupCard1 < 114) {
            for (i = 0; i < 113; ++i) {
                if (taken[i] != 0) continue;
                if (groupCard0 >= groupCard1) {
                    taken[i] = 2;
                    ++groupCard1;
                    continue;
                }
                taken[i] = 1;
                pg.setBranch(groupCard0++, this.b[i], this.branch.getRaw(i));
            }
        }
        pg.n = groupCard0;
        this.n = groupCard1;
        i = 0;
        j = 0;
        while (i < groupCard1) {
            if (taken[j] == 2) {
                this.setBranch(i++, this.b[j], this.branch.getRaw(j));
            }
            ++j;
        }
        return pg;
    }

    final RectangleR2 cover() {
        RectangleR2 r = new RectangleR2(this.b[0]);
        for (int i = 1; i < this.n; ++i) {
            r.join(this.b[i]);
        }
        return r;
    }
}

