/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentList;
import org.garret.perst.Link;
import org.garret.perst.PersistentCollection;
import org.garret.perst.Storage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ScalableList<E extends IPersistent>
extends PersistentCollection<E>
implements IPersistentList<E> {
    Link<E> small;
    IPersistentList<E> large;
    static final int BTREE_THRESHOLD = 128;

    ScalableList(Storage storage, int initialSize) {
        super(storage);
        if (initialSize <= 128) {
            this.small = storage.createLink(initialSize);
        } else {
            this.large = storage.createList();
        }
    }

    ScalableList() {
    }

    @Override
    public E get(int i) {
        return (E)(this.small != null ? this.small.get(i) : (IPersistent)this.large.get(i));
    }

    @Override
    public E set(int i, E obj) {
        return (E)(this.small != null ? this.small.set(i, obj) : (IPersistent)this.large.set(i, obj));
    }

    @Override
    public boolean isEmpty() {
        return this.small != null ? this.small.isEmpty() : this.large.isEmpty();
    }

    @Override
    public int size() {
        return this.small != null ? this.small.size() : this.large.size();
    }

    @Override
    public boolean contains(Object o) {
        if (o instanceof IPersistent) {
            IPersistent p = (IPersistent)o;
            return this.small != null ? this.small.contains(p) : this.large.contains(p);
        }
        return false;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.small != null ? this.small.toArray(a) : this.large.toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.small != null ? this.small.toArray() : this.large.toArray();
    }

    @Override
    public boolean add(E o) {
        this.add(this.size(), o);
        return true;
    }

    @Override
    public void add(int i, E o) {
        if (this.small != null) {
            if (this.small.size() == 128) {
                this.large = this.getStorage().createList();
                this.large.addAll(this.small);
                this.large.add(i, o);
                this.modify();
                this.small = null;
            } else {
                this.small.add(i, o);
            }
        } else {
            this.large.add(i, o);
        }
    }

    @Override
    public E remove(int i) {
        return (E)(this.small != null ? (IPersistent)this.small.remove(i) : (IPersistent)this.large.remove(i));
    }

    @Override
    public void clear() {
        if (this.large != null) {
            this.large.clear();
        } else {
            this.small.clear();
        }
    }

    @Override
    public int indexOf(Object o) {
        return this.small != null ? this.small.indexOf(o) : this.large.indexOf(o);
    }

    @Override
    public int lastIndexOf(Object o) {
        return this.small != null ? this.small.lastIndexOf(o) : this.large.lastIndexOf(o);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> e = c.iterator();
        while (e.hasNext()) {
            this.add(index++, (E)((IPersistent)e.next()));
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator<E> iterator() {
        return this.small != null ? this.small.iterator() : this.large.iterator();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return this.small != null ? this.small.listIterator(index) : this.large.listIterator(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return this.small != null ? this.small.subList(fromIndex, toIndex) : this.large.subList(fromIndex, toIndex);
    }
}

