/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.Core;
import frost.boards.Board;
import frost.boards.TofTreeModel;
import frost.messages.UnsentMessagesManager;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class BoardUpdateBoardSelector {
    private static Board lastSelectedBoard = null;
    private static final Comparator<Board> lastUpdateStartMillisCmp = new Comparator<Board>(){

        @Override
        public int compare(Board value1, Board value2) {
            if (value1.getLastUpdateStartMillis() > value2.getLastUpdateStartMillis()) {
                return 1;
            }
            if (value1.getLastUpdateStartMillis() < value2.getLastUpdateStartMillis()) {
                return -1;
            }
            return 0;
        }
    };

    public static Board selectNextBoard(TofTreeModel tofTreeModel) {
        LinkedList<Board> allBoards;
        List<Board> boardsWithSendableMsgs = UnsentMessagesManager.getBoardsWithSendableMessages();
        if (!boardsWithSendableMsgs.isEmpty()) {
            Collections.sort(boardsWithSendableMsgs, lastUpdateStartMillisCmp);
            for (Board board : boardsWithSendableMsgs) {
                if (board == lastSelectedBoard) continue;
                lastSelectedBoard = board;
                return board;
            }
        }
        if ((allBoards = tofTreeModel.getAllBoards()).size() == 0) {
            lastSelectedBoard = null;
            return null;
        }
        Collections.sort(allBoards, lastUpdateStartMillisCmp);
        long curTime = System.currentTimeMillis();
        int minUpdateInterval = Core.frostSettings.getIntValue("automaticUpdate.boardsMinimumUpdateInterval");
        long minUpdateIntervalMillis = (long)minUpdateInterval * 60L * 1000L;
        Board nextBoard = null;
        for (Board lBoard : allBoards) {
            if (nextBoard != null || !lBoard.isAutomaticUpdateAllowed() || curTime - minUpdateIntervalMillis <= lBoard.getLastUpdateStartMillis() || (!lBoard.isConfigured() || !lBoard.getAutoUpdateEnabled()) && lBoard.isConfigured()) continue;
            nextBoard = lBoard;
            break;
        }
        lastSelectedBoard = nextBoard;
        return nextBoard;
    }
}

