/*
 * Decompiled with CFR 0.152.
 */
package frost.boards;

import frost.Core;
import frost.MainFrame;
import frost.SettingsClass;
import frost.boards.AbstractNode;
import frost.boards.Board;
import frost.boards.BoardSettingsFrame;
import frost.boards.BoardUpdateInformation;
import frost.boards.Folder;
import frost.boards.SentMessagesFolder;
import frost.boards.TOF;
import frost.boards.TofTreeModel;
import frost.boards.TofTreeXmlIO;
import frost.boards.UnsentMessagesFolder;
import frost.fcp.FcpHandler;
import frost.gui.MessagePanel;
import frost.gui.NewBoardDialog;
import frost.storage.AutoSavable;
import frost.storage.ExitSavable;
import frost.storage.StorageException;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadListener;
import frost.threads.RunningBoardUpdateThreads;
import frost.util.gui.FrostSwingWorker;
import frost.util.gui.JDragTree;
import frost.util.gui.JSkinnablePopupMenu;
import frost.util.gui.MiscToolkit;
import frost.util.gui.StartupMessage;
import frost.util.gui.search.TreeFindAction;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreePath;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class TofTree
extends JDragTree
implements AutoSavable,
ExitSavable,
PropertyChangeListener {
    private static final String FROST_ANNOUNCE_NAME = "frost-announce";
    private static final String FREENET_05_FROST_ANNOUNCE_PUBKEY = "SSK@7i~oLj~57mQVRrKfMxYgLULJ2r0PAgM";
    private static final String FREENET_07_FROST_ANNOUNCE_PUBKEY = "SSK@l4YxTKAc-sCho~6w-unV6pl-uxIbfuGnGRzo3BJH0ck,4N48yl8E4rh9UPPV26Ev1ZGrRRgeGOTgw1Voka6lk4g,AQACAAE";
    private boolean showBoardDescriptionToolTips;
    private boolean showBoardUpdatedCount;
    private boolean showBoardUpdateVisualization;
    private boolean showFlaggedStarredIndicators;
    private boolean stopBoardUpdatesWhenDOSed;
    private int maxInvalidMessagesPerDayThreshold;
    private Language language;
    private SettingsClass settings;
    private MainFrame mainFrame;
    private final Listener listener = new Listener();
    private PopupMenuTofTree popupMenuTofTree;
    private static final Logger logger = Logger.getLogger(TofTree.class.getName());
    private final TofTreeModel model;
    private final JMenuItem configBoardMenuItem = new JMenuItem();
    private AbstractNode clipboard = null;
    private RunningBoardUpdateThreads runningBoardUpdateThreads = null;

    public TofTree(TofTreeModel model) {
        super(model);
        this.model = model;
        this.showBoardDescriptionToolTips = Core.frostSettings.getBoolValue("showBoardDescriptionTooltips");
        this.showBoardUpdatedCount = Core.frostSettings.getBoolValue("showBoardUpdatedCount");
        this.showBoardUpdateVisualization = Core.frostSettings.getBoolValue("boardUpdateVisualization");
        this.showFlaggedStarredIndicators = Core.frostSettings.getBoolValue("showBoardtreeFlaggedStarredIndicators");
        this.stopBoardUpdatesWhenDOSed = Core.frostSettings.getBoolValue("dos.stopBoardUpdatesWhenDosed");
        this.maxInvalidMessagesPerDayThreshold = Core.frostSettings.getIntValue("dos.invalidSubsequentMessagesThreshold");
        this.setRowHeight(18);
    }

    private PopupMenuTofTree getPopupMenuTofTree() {
        if (this.popupMenuTofTree == null) {
            this.popupMenuTofTree = new PopupMenuTofTree();
            this.language.addLanguageListener(this.popupMenuTofTree);
        }
        return this.popupMenuTofTree;
    }

    public void initialize() {
        this.language = Language.getInstance();
        this.language.addLanguageListener(this.listener);
        new TreeFindAction().install(this);
        Core.frostSettings.addPropertyChangeListener("showBoardDescriptionTooltips", this);
        Core.frostSettings.addPropertyChangeListener("showBoardUpdatedCount", this);
        Core.frostSettings.addPropertyChangeListener("boardUpdateVisualization", this);
        Core.frostSettings.addPropertyChangeListener("showBoardtreeFlaggedStarredIndicators", this);
        this.configBoardMenuItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/document-properties.png", 16, 16));
        this.refreshLanguage();
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setRootVisible(true);
        this.setCellRenderer(new CellRenderer());
        this.setSelectionModel(this.model.getSelectionModel());
        this.getSelectionModel().setSelectionMode(1);
        this.addKeyListener(this.listener);
        this.addMouseListener(this.listener);
        this.configBoardMenuItem.addActionListener(this.listener);
        ToolTipManager.sharedInstance().registerComponent(this);
        this.loadTree();
        this.addTreeExpansionListener(new TreeExpansionListener(){

            public void treeCollapsed(TreeExpansionEvent event) {
                TreePath selectedPath = TofTree.this.getSelectionPath();
                TreePath collapsedPath = event.getPath();
                if (collapsedPath.isDescendant(selectedPath)) {
                    TofTree.this.setSelectionPath(event.getPath());
                }
            }

            public void treeExpanded(TreeExpansionEvent event) {
            }
        });
        this.runningBoardUpdateThreads = new RunningBoardUpdateThreads();
    }

    private void cutNode(AbstractNode node) {
        if (node != null) {
            this.clipboard = node;
        }
    }

    private void pasteNode(AbstractNode position) {
        if (this.clipboard == null) {
            return;
        }
        if (position == null || !position.isFolder()) {
            return;
        }
        this.model.removeNode(this.clipboard, false);
        position.add(this.clipboard);
        this.clipboard = null;
        int[] insertedIndex = new int[]{position.getChildCount() - 1};
        this.model.nodesWereInserted(position, insertedIndex);
    }

    private void refreshLanguage() {
        this.configBoardMenuItem.setText(this.language.getString("BoardTree.popupmenu.configureSelectedBoard"));
    }

    public void pressedKey(char key) {
        if (!this.isEditing()) {
            if (key == 'x' || key == 'X') {
                this.cutNode(this.model.getSelectedNode());
            }
            if (key == 'v' || key == 'V') {
                this.pasteNode(this.model.getSelectedNode());
            }
        }
    }

    protected void processKeyEvent(KeyEvent e) {
        if (e.getID() == 400 && (e.getKeyChar() == 'n' || e.getKeyChar() == 'N')) {
            MainFrame.getInstance().getMessagePanel().selectNextUnreadMessage();
        } else if (e.getID() == 400 && (e.getKeyChar() == 'b' || e.getKeyChar() == 'B')) {
            MainFrame.getInstance().getMessagePanel().setTrustState_actionPerformed(MessagePanel.IdentityState.BAD);
        } else if (e.getID() == 400 && (e.getKeyChar() == 'c' || e.getKeyChar() == 'C')) {
            MainFrame.getInstance().getMessagePanel().setTrustState_actionPerformed(MessagePanel.IdentityState.CHECK);
        } else if (e.getID() == 400 && (e.getKeyChar() == 'o' || e.getKeyChar() == 'O')) {
            MainFrame.getInstance().getMessagePanel().setTrustState_actionPerformed(MessagePanel.IdentityState.OBSERVE);
        } else if (e.getID() == 400 && (e.getKeyChar() == 'g' || e.getKeyChar() == 'G')) {
            MainFrame.getInstance().getMessagePanel().setTrustState_actionPerformed(MessagePanel.IdentityState.GOOD);
        } else if (e.getID() == 400 && (e.getKeyChar() == 'f' || e.getKeyChar() == 'F')) {
            MainFrame.getInstance().getMessagePanel().updateBooleanState(MessagePanel.BooleanState.FLAGGED);
        } else if (e.getID() == 400 && (e.getKeyChar() == 's' || e.getKeyChar() == 'S')) {
            MainFrame.getInstance().getMessagePanel().updateBooleanState(MessagePanel.BooleanState.STARRED);
        } else if (e.getID() == 400 && (e.getKeyChar() == 'j' || e.getKeyChar() == 'J')) {
            MainFrame.getInstance().getMessagePanel().updateBooleanState(MessagePanel.BooleanState.JUNK);
        } else if (!Character.isLetter(e.getKeyChar()) && !Character.isDigit(e.getKeyChar())) {
            super.processKeyEvent(e);
        }
    }

    private boolean loadTree() {
        SentMessagesFolder sentMsgs;
        TofTreeXmlIO xmlio = new TofTreeXmlIO();
        String boardIniFilename = this.settings.getValue("config.dir") + "boards.xml";
        File iniFile = new File(boardIniFilename);
        if (!iniFile.exists()) {
            logger.warning("boards.xml file not found, reading default file (will be saved to boards.xml on exit).");
            String defaultBoardsFile = FcpHandler.isFreenet05() ? "boards.xml.default" : "boards.xml.default07";
            boardIniFilename = this.settings.getValue("config.dir") + defaultBoardsFile;
        }
        String unsentName = this.language.getString("UnsentMessages.folderName");
        String sentName = this.language.getString("SentMessages.folderName");
        UnsentMessagesFolder unsentMsgs = new UnsentMessagesFolder("[" + unsentName + "]");
        boolean loadWasOk = xmlio.loadBoardTree(this, this.model, boardIniFilename, unsentMsgs, sentMsgs = new SentMessagesFolder("[" + sentName + "]"));
        if (!loadWasOk) {
            return loadWasOk;
        }
        String expectedPubkey = FcpHandler.isFreenet05() ? FREENET_05_FROST_ANNOUNCE_PUBKEY : FREENET_07_FROST_ANNOUNCE_PUBKEY;
        LinkedList<Board> existingBoards = this.model.getAllBoards();
        boolean boardFound = false;
        for (Board board : existingBoards) {
            if (!board.getName().equals(FROST_ANNOUNCE_NAME)) continue;
            boardFound = true;
            if (board.getPublicKey() != null && board.getPublicKey().equals(expectedPubkey)) break;
            board.setPublicKey(expectedPubkey);
            break;
        }
        if (!boardFound) {
            Board newBoard = new Board(FROST_ANNOUNCE_NAME, "Announcement of new Frost versions");
            newBoard.setPublicKey(expectedPubkey);
            Folder root = (Folder)this.model.getRoot();
            this.model.addNodeToTree(newBoard, root);
        }
        if (FcpHandler.isFreenet07()) {
            ArrayList<String> boardsWithObsoleteKeys = new ArrayList<String>();
            for (Board board : existingBoards) {
                if (board.getPublicKey() == null || !board.getPublicKey().endsWith("AQABAAE")) continue;
                boardsWithObsoleteKeys.add(board.getName());
            }
            if (boardsWithObsoleteKeys.size() > 0) {
                String title = this.language.getString("StartupMessage.uploadFile.boardsWithObsoleteKeysFound.title");
                for (String boardName : boardsWithObsoleteKeys) {
                    String text = this.language.formatMessage("StartupMessage.uploadFile.boardsWithObsoleteKeysFound.text", boardName);
                    StartupMessage sm = new StartupMessage(StartupMessage.MessageType.BoardsWithObsoleteKeysFound, title, text, 0, true);
                    MainFrame.enqueueStartupMessage(sm);
                    logger.severe("Board with obsolete public key found: " + boardName);
                }
            }
        }
        return loadWasOk;
    }

    public void autoSave() throws StorageException {
        this.save();
    }

    public void exitSave() throws StorageException {
        this.save();
    }

    public void save() throws StorageException {
        String configDir = this.settings.getValue("config.dir");
        File xmlFile = new File(configDir + "boards.xml");
        File bakFile = new File(configDir + "boards.xml.bak");
        File bak2File = new File(configDir + "boards.xml.bak2");
        File bak3File = new File(configDir + "boards.xml.bak3");
        File bak4File = new File(configDir + "boards.xml.bak4");
        File oldFile = new File(configDir + "boards.xml.old");
        TofTreeXmlIO xmlio = new TofTreeXmlIO();
        File newFile = new File(configDir + "boards.new");
        if (!xmlio.saveBoardTree(this, this.model, newFile)) {
            throw new StorageException("Error while saving the TofTree.");
        }
        oldFile.delete();
        if (bak4File.isFile()) {
            bak3File.renameTo(oldFile);
        }
        if (bak3File.isFile()) {
            bak3File.renameTo(bak4File);
        }
        if (bak2File.isFile()) {
            bak2File.renameTo(bak3File);
        }
        if (bakFile.isFile()) {
            bakFile.renameTo(bak2File);
        }
        if (xmlFile.isFile()) {
            xmlFile.renameTo(bakFile);
        }
        newFile.renameTo(xmlFile);
        oldFile.delete();
    }

    public void createNewBoard(Frame parent) {
        boolean isDone = false;
        while (!isDone) {
            NewBoardDialog dialog = new NewBoardDialog(parent);
            dialog.setVisible(true);
            if (dialog.getChoice() == NewBoardDialog.CHOICE_CANCEL) {
                isDone = true;
                continue;
            }
            String boardName = dialog.getBoardName();
            String boardDescription = dialog.getBoardDescription();
            if (this.model.getBoardByName(boardName) != null) {
                JOptionPane.showMessageDialog(parent, this.language.formatMessage("BoardTree.duplicateNewBoardNameError.body", boardName), this.language.getString("BoardTree.duplicateNewBoardNameError.title"), 0);
                continue;
            }
            Board newBoard = new Board(boardName, boardDescription);
            this.model.addNodeToTree(newBoard);
            TOF.getInstance().searchNewMessages(newBoard);
            isDone = true;
        }
    }

    private void addNewBoard(String bname, String bpubkey, String bprivkey, String description) {
        Board existingBoard = this.model.getBoardByName(bname);
        if (existingBoard != null) {
            int answer = JOptionPane.showConfirmDialog(this.getTopLevelAncestor(), this.language.formatMessage("BoardTree.overWriteBoardConfirmation.body", bname), this.language.getString("BoardTree.overWriteBoardConfirmation.title"), 0, 2);
            if (answer == 0) {
                existingBoard.setPublicKey(bpubkey);
                existingBoard.setPrivateKey(bprivkey);
                existingBoard.setDescription(description);
                this.model.nodeChanged(existingBoard);
            }
        } else {
            Board newBoard = new Board(bname, bpubkey, bprivkey, description);
            this.model.addNodeToTree(newBoard);
            TOF.getInstance().searchNewMessages(newBoard);
        }
    }

    public void addNewBoard(Board fbobj) {
        this.addNewBoard(fbobj.getName(), fbobj.getPublicKey(), fbobj.getPrivateKey(), fbobj.getDescription());
    }

    public void createNewFolder(Frame parent) {
        String nodeName = null;
        do {
            Object nodeNameOb;
            String string = nodeName = (nodeNameOb = JOptionPane.showInputDialog(parent, this.language.getString("BoardTree.newFolderDialog.body") + ":", this.language.getString("BoardTree.newFolderDialog.title"), 3, null, null, this.language.getString("BoardTree.newFolderDialog.defaultName"))) == null ? null : nodeNameOb.toString();
            if (nodeName != null) continue;
            return;
        } while (nodeName.length() == 0);
        this.model.addNodeToTree(new Folder(nodeName));
    }

    public void removeNode(AbstractNode node) {
        int answer;
        if (node.isFolder()) {
            answer = JOptionPane.showConfirmDialog(this, this.language.formatMessage("BoardTree.removeFolderConfirmation.body", node.getName()), this.language.formatMessage("BoardTree.removeFolderConfirmation.title", node.getName()), 0);
        } else if (node.isBoard()) {
            answer = JOptionPane.showConfirmDialog(this, this.language.formatMessage("BoardTree.removeBoardConfirmation.body", node.getName()), this.language.formatMessage("BoardTree.removeBoardConfirmation.title", node.getName()), 0);
        } else {
            return;
        }
        if (answer == 1) {
            return;
        }
        this.model.removeNode(node, true);
    }

    public void setSettings(SettingsClass settings) {
        this.settings = settings;
    }

    public void setMainFrame(MainFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    private void showTofTreePopupMenu(MouseEvent e) {
        this.getPopupMenuTofTree().show(e.getComponent(), e.getX(), e.getY());
    }

    private void refreshNode(AbstractNode node) {
        if (node == null) {
            return;
        }
        if (node.isBoard()) {
            if (((Board)node).isManualUpdateAllowed()) {
                this.updateBoard((Board)node);
            }
        } else if (node.isFolder()) {
            Enumeration<AbstractNode> leafs = node.children();
            while (leafs.hasMoreElements()) {
                this.refreshNode(leafs.nextElement());
            }
        }
    }

    public RunningBoardUpdateThreads getRunningBoardUpdateThreads() {
        return this.runningBoardUpdateThreads;
    }

    public void configureBoard(AbstractNode board) {
        if (board == null) {
            return;
        }
        BoardSettingsFrame newFrame = new BoardSettingsFrame(this.mainFrame, board);
        newFrame.runDialog();
    }

    public void updateBoard(Board board) {
        if (board == null || !board.isBoard()) {
            return;
        }
        if (!Core.isFreenetOnline()) {
            return;
        }
        boolean threadStarted = false;
        if (!this.getRunningBoardUpdateThreads().isThreadOfTypeRunning(board, 1)) {
            this.getRunningBoardUpdateThreads().startMessageDownloadToday(board, this.settings, this.listener);
            logger.info("Starting update (MSG_TODAY) of " + board.getName());
            threadStarted = true;
        }
        long now = System.currentTimeMillis();
        if (!this.getRunningBoardUpdateThreads().isThreadOfTypeRunning(board, 2)) {
            long before12hours = now - 43200000L;
            boolean downloadCompleteBackload = Core.frostSettings.getBoolValue("alwaysDownloadMessagesBackload") || before12hours >= board.getLastBackloadUpdateFinishedMillis();
            this.getRunningBoardUpdateThreads().startMessageDownloadBack(board, this.settings, this.listener, downloadCompleteBackload);
            logger.info("Starting update (MSG_BACKLOAD) of " + board.getName());
            threadStarted = true;
        }
        if (threadStarted) {
            board.setLastUpdateStartMillis(now);
            board.incTimesUpdatedCount();
        }
    }

    public void updateTree() {
        Enumeration<AbstractNode> e = this.model.getRoot().depthFirstEnumeration();
        while (e.hasMoreElements()) {
            this.model.nodeChanged(e.nextElement());
        }
    }

    protected JMenuItem getConfigBoardMenuItem() {
        return this.configBoardMenuItem;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("showBoardDescriptionTooltips")) {
            this.showBoardDescriptionToolTips = Core.frostSettings.getBoolValue("showBoardDescriptionTooltips");
        } else if (evt.getPropertyName().equals("showBoardUpdatedCount")) {
            this.showBoardUpdatedCount = Core.frostSettings.getBoolValue("showBoardUpdatedCount");
            this.updateTree();
        } else if (evt.getPropertyName().equals("showBoardtreeFlaggedStarredIndicators")) {
            this.showFlaggedStarredIndicators = Core.frostSettings.getBoolValue("showBoardtreeFlaggedStarredIndicators");
            this.updateTree();
        } else if (evt.getPropertyName().equals("boardUpdateVisualization")) {
            this.showBoardUpdateVisualization = Core.frostSettings.getBoolValue("boardUpdateVisualization");
            this.updateTree();
        } else if (evt.getPropertyName().equals("dos.stopBoardUpdatesWhenDosed")) {
            this.stopBoardUpdatesWhenDOSed = Core.frostSettings.getBoolValue("dos.stopBoardUpdatesWhenDosed");
            this.updateAllBoardDosStatus();
            this.updateTree();
        } else if (evt.getPropertyName().equals("dos.invalidSubsequentMessagesThreshold")) {
            this.maxInvalidMessagesPerDayThreshold = Core.frostSettings.getIntValue("dos.invalidSubsequentMessagesThreshold");
        }
    }

    public boolean isStopBoardUpdatesWhenDOSed() {
        return this.stopBoardUpdatesWhenDOSed;
    }

    public int getMaxInvalidMessagesPerDayThreshold() {
        return this.maxInvalidMessagesPerDayThreshold;
    }

    private void updateAllBoardDosStatus() {
        long todayDateTime = MainFrame.getInstance().getTodaysDateMillis();
        for (Board board : this.model.getAllBoards()) {
            int maxDaysBack = board.getMaxMessageDownload();
            LocalDate localDate = new LocalDate(DateTimeZone.UTC).minusDays(maxDaysBack);
            long minDateTime = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
            board.updateDosStatus(this.stopBoardUpdatesWhenDOSed, minDateTime, todayDateTime);
        }
    }

    private class CellRenderer
    extends DefaultTreeCellRenderer {
        private final Border borderFlaggedAndStarredMsgs = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.red), BorderFactory.createMatteBorder(0, 2, 0, 0, Color.blue));
        private final Border borderStarredMsgs = BorderFactory.createCompoundBorder(BorderFactory.createEmptyBorder(0, 2, 0, 0), BorderFactory.createMatteBorder(0, 2, 0, 0, Color.blue));
        private final Border borderFlaggedMsgs = BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 2, 0, 0, Color.red), BorderFactory.createEmptyBorder(0, 2, 0, 0));
        private final Border borderEmpty = BorderFactory.createEmptyBorder(0, 4, 0, 0);
        private final ImageIcon sentMessagesFolderIcon = MiscToolkit.loadImageIcon("/data/book_open.png");
        private final ImageIcon unsentMessagesFolderIcon = MiscToolkit.loadImageIcon("/data/book_next.png");
        private Font boldFont = null;
        private Font normalFont = null;

        public CellRenderer() {
            this.setLeafIcon(MiscToolkit.loadImageIcon("/data/comments.png"));
            this.setClosedIcon(MiscToolkit.loadImageIcon("/data/folder.png"));
            this.setOpenIcon(MiscToolkit.loadImageIcon("/data/folder-open.png"));
            JTable dummyTable = new JTable();
            this.normalFont = dummyTable.getFont();
            this.boldFont = this.normalFont.deriveFont(1);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean isSelected, boolean expanded, boolean leaf, int row, boolean localHasFocus) {
            AbstractNode folder;
            super.getTreeCellRendererComponent(tree, value, isSelected, expanded, leaf, row, localHasFocus);
            AbstractNode node = (AbstractNode)value;
            boolean containsNewMessage = node.containsNewMessages();
            Board board = null;
            if (node.isFolder()) {
                folder = (Folder)node;
                this.setText(folder.getName());
                if (containsNewMessage) {
                    this.setFont(this.boldFont);
                } else {
                    this.setFont(this.normalFont);
                }
                if (TofTree.this.showFlaggedStarredIndicators) {
                    this.setBorder(this.borderEmpty);
                } else {
                    this.setBorder(null);
                }
            } else if (node.isBoard()) {
                StringBuilder sb;
                board = (Board)node;
                if (containsNewMessage) {
                    this.setFont(this.boldFont);
                    if (TofTree.this.showBoardUpdatedCount) {
                        sb = new StringBuilder();
                        sb.append(board.getName()).append(" (").append(board.getNewMessageCount()).append(") [");
                        sb.append(board.getTimesUpdatedCount()).append("]");
                        this.setText(sb.toString());
                    } else {
                        sb = new StringBuilder();
                        sb.append(board.getName()).append(" (").append(board.getNewMessageCount()).append(")");
                        this.setText(sb.toString());
                    }
                } else {
                    this.setFont(this.normalFont);
                    if (TofTree.this.showBoardUpdatedCount) {
                        sb = new StringBuilder();
                        sb.append(board.getName()).append(" [").append(board.getTimesUpdatedCount()).append("]");
                        this.setText(sb.toString());
                    } else {
                        this.setText(board.getName());
                    }
                }
                this.setIcon(board.getStateIcon());
                if (TofTree.this.showFlaggedStarredIndicators) {
                    boolean hasStarred = board.hasStarredMessages();
                    boolean hasFlagged = board.hasFlaggedMessages();
                    if (hasStarred && !hasFlagged) {
                        this.setBorder(this.borderStarredMsgs);
                    } else if (!hasStarred && hasFlagged) {
                        this.setBorder(this.borderFlaggedMsgs);
                    } else if (!hasStarred && !hasFlagged) {
                        this.setBorder(this.borderEmpty);
                    } else {
                        this.setBorder(this.borderFlaggedAndStarredMsgs);
                    }
                } else {
                    this.setBorder(null);
                }
            } else {
                folder = node;
                this.setText(folder.getName());
                this.setFont(this.normalFont);
                if (folder.isSentMessagesFolder()) {
                    this.setIcon(this.sentMessagesFolderIcon);
                } else if (folder.isUnsentMessagesFolder()) {
                    this.setIcon(this.unsentMessagesFolderIcon);
                }
                if (TofTree.this.showFlaggedStarredIndicators) {
                    this.setBorder(this.borderEmpty);
                } else {
                    this.setBorder(null);
                }
            }
            if (TofTree.this.showBoardUpdateVisualization && board != null && board.isUpdating()) {
                Color c = (Color)TofTree.this.settings.getObjectValue("boardUpdatingNonSelectedBackgroundColor");
                this.setBackgroundNonSelectionColor(c);
                c = (Color)TofTree.this.settings.getObjectValue("boardUpdatingSelectedBackgroundColor");
                this.setBackgroundSelectionColor(c);
            } else {
                this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
                this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
            }
            boolean isDosed = board != null && board.isDosForToday();
            if (isDosed) {
                this.setForeground(Color.red);
            } else if (isSelected) {
                this.setForeground(UIManager.getColor("Tree.selectionForeground"));
            } else {
                this.setForeground(UIManager.getColor("Tree.textForeground"));
            }
            if (TofTree.this.showBoardDescriptionToolTips && board != null && board.getDescription() != null && board.getDescription().length() > 0) {
                String newToolTipText = isDosed ? "<html>" + board.getDescription() + "<br>" + "<br>" + "This board is currently the target of a DoS attack.<br>" + "Most likely you can't post messages to this board today." + "</html>" : board.getDescription();
                this.setToolTipText(newToolTipText);
            } else {
                String newToolTipText = isDosed ? "<html>This board is currently the target of a DoS attack.<br>Most likely you can't post messages to this board today.</html>" : null;
                this.setToolTipText(newToolTipText);
            }
            return this;
        }
    }

    private class Listener
    extends MouseAdapter
    implements LanguageListener,
    ActionListener,
    KeyListener,
    BoardUpdateThreadListener {
        private Listener() {
        }

        public void languageChanged(LanguageEvent event) {
            TofTree.this.refreshLanguage();
        }

        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == TofTree.this.configBoardMenuItem) {
                TofTree.this.configureBoard(TofTree.this.model.getSelectedNode());
            }
        }

        public void keyPressed(KeyEvent e) {
            char key = e.getKeyChar();
            TofTree.this.pressedKey(key);
        }

        public void keyTyped(KeyEvent e) {
        }

        public void keyReleased(KeyEvent e) {
        }

        public void mousePressed(MouseEvent e) {
            if (e.isPopupTrigger() && e.getSource() == TofTree.this) {
                TofTree.this.showTofTreePopupMenu(e);
            }
        }

        public void mouseReleased(MouseEvent e) {
            if (e.isPopupTrigger() && e.getSource() == TofTree.this) {
                TofTree.this.showTofTreePopupMenu(e);
            }
        }

        public void boardUpdateThreadFinished(final BoardUpdateThread thread) {
            int running = TofTree.this.getRunningBoardUpdateThreads().getDownloadThreadsForBoard(thread.getTargetBoard()).size();
            if (running == 0) {
                thread.getTargetBoard().setUpdating(false);
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        TofTree.this.mainFrame.updateTofTree(thread.getTargetBoard());
                    }
                });
            }
        }

        public void boardUpdateThreadStarted(final BoardUpdateThread thread) {
            thread.getTargetBoard().setUpdating(true);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TofTree.this.mainFrame.updateTofTree(thread.getTargetBoard());
                }
            });
        }

        public void boardUpdateInformationChanged(BoardUpdateThread thread, BoardUpdateInformation bui) {
            final Board board = thread.getTargetBoard();
            if (!TofTree.this.stopBoardUpdatesWhenDOSed) {
                return;
            }
            int maxDaysBack = board.getMaxMessageDownload();
            LocalDate localDate = new LocalDate(DateTimeZone.UTC).minusDays(maxDaysBack);
            long minDateTime = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
            long todayDateTime = MainFrame.getInstance().getTodaysDateMillis();
            board.updateDosStatus(TofTree.this.stopBoardUpdatesWhenDOSed, minDateTime, todayDateTime);
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    TofTree.this.mainFrame.updateTofTree(board);
                }
            });
        }
    }

    private class PopupMenuTofTree
    extends JSkinnablePopupMenu
    implements LanguageListener,
    ActionListener {
        private final JMenuItem addBoardItem = new JMenuItem();
        private final JMenuItem addFolderItem = new JMenuItem();
        private final JMenuItem configureBoardItem = new JMenuItem();
        private final JMenuItem configureFolderItem = new JMenuItem();
        private final JMenuItem cutNodeItem = new JMenuItem();
        private final JMenuItem descriptionItem = new JMenuItem();
        private final JMenuItem pasteNodeItem = new JMenuItem();
        private final JMenuItem refreshItem = new JMenuItem();
        private final JMenuItem removeNodeItem = new JMenuItem();
        private final JMenuItem renameFolderItem = new JMenuItem();
        private final JMenuItem searchMessagesItem = new JMenuItem();
        private final JMenuItem sendMessageItem = new JMenuItem();
        private final JMenuItem markAllReadItem = new JMenuItem();
        private AbstractNode selectedTreeNode = null;
        private final JMenuItem sortFolderItem = new JMenuItem();

        public PopupMenuTofTree() {
            this.initialize();
        }

        public void actionPerformed(ActionEvent e) {
            final Object source = e.getSource();
            FrostSwingWorker worker = new FrostSwingWorker(this){

                protected void doNonUILogic() throws RuntimeException {
                    if (source == PopupMenuTofTree.this.refreshItem) {
                        PopupMenuTofTree.this.refreshSelected();
                    } else if (source == PopupMenuTofTree.this.addBoardItem) {
                        PopupMenuTofTree.this.addBoardSelected();
                    } else if (source == PopupMenuTofTree.this.addFolderItem) {
                        PopupMenuTofTree.this.addFolderSelected();
                    } else if (source == PopupMenuTofTree.this.removeNodeItem) {
                        PopupMenuTofTree.this.removeNodeSelected();
                    } else if (source == PopupMenuTofTree.this.cutNodeItem) {
                        PopupMenuTofTree.this.cutNodeSelected();
                    } else if (source == PopupMenuTofTree.this.pasteNodeItem) {
                        PopupMenuTofTree.this.pasteNodeSelected();
                    } else if (source == PopupMenuTofTree.this.configureBoardItem || source == PopupMenuTofTree.this.configureFolderItem) {
                        PopupMenuTofTree.this.configureBoardSelected();
                    } else if (source == PopupMenuTofTree.this.sortFolderItem) {
                        PopupMenuTofTree.this.sortFolderSelected();
                    } else if (source == PopupMenuTofTree.this.markAllReadItem) {
                        PopupMenuTofTree.this.markAllReadSelected();
                    } else if (source == PopupMenuTofTree.this.renameFolderItem) {
                        PopupMenuTofTree.this.renameFolderSelected();
                    } else if (source == PopupMenuTofTree.this.searchMessagesItem) {
                        PopupMenuTofTree.this.searchMessagesSelected();
                    } else if (source == PopupMenuTofTree.this.sendMessageItem) {
                        PopupMenuTofTree.this.sendMessageSelected();
                    }
                }

                protected void doUIUpdateLogic() throws RuntimeException {
                }
            };
            worker.start();
        }

        private void addBoardSelected() {
            TofTree.this.createNewBoard(TofTree.this.mainFrame);
        }

        private void addFolderSelected() {
            TofTree.this.createNewFolder(TofTree.this.mainFrame);
        }

        private void configureBoardSelected() {
            TofTree.this.configureBoard(this.selectedTreeNode);
        }

        private void cutNodeSelected() {
            TofTree.this.cutNode(this.selectedTreeNode);
        }

        private void initialize() {
            this.refreshLanguage();
            this.addBoardItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/internet-group-chat.png", 16, 16));
            this.addFolderItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/folder-new.png", 16, 16));
            this.configureBoardItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/document-properties.png", 16, 16));
            this.configureFolderItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/document-properties.png", 16, 16));
            this.cutNodeItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/edit-cut.png", 16, 16));
            this.pasteNodeItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/edit-paste.png", 16, 16));
            this.refreshItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/view-refresh.png", 16, 16));
            this.removeNodeItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/user-trash.png", 16, 16));
            this.sortFolderItem.setIcon(MiscToolkit.getScaledImage("/data/sort.gif", 16, 16));
            this.renameFolderItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/edit-select-all.png", 16, 16));
            this.searchMessagesItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/edit-find.png", 16, 16));
            this.sendMessageItem.setIcon(MiscToolkit.getScaledImage("/data/toolbar/mail-message-new.png", 16, 16));
            this.descriptionItem.setEnabled(false);
            this.refreshItem.addActionListener(this);
            this.addBoardItem.addActionListener(this);
            this.addFolderItem.addActionListener(this);
            this.removeNodeItem.addActionListener(this);
            this.cutNodeItem.addActionListener(this);
            this.pasteNodeItem.addActionListener(this);
            this.configureBoardItem.addActionListener(this);
            this.configureFolderItem.addActionListener(this);
            this.sortFolderItem.addActionListener(this);
            this.markAllReadItem.addActionListener(this);
            this.renameFolderItem.addActionListener(this);
            this.searchMessagesItem.addActionListener(this);
            this.sendMessageItem.addActionListener(this);
        }

        public void languageChanged(LanguageEvent event) {
            this.refreshLanguage();
        }

        private void pasteNodeSelected() {
            if (TofTree.this.clipboard != null) {
                TofTree.this.pasteNode(this.selectedTreeNode);
            }
        }

        private void refreshLanguage() {
            this.addBoardItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.addNewBoard"));
            this.addFolderItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.addNewFolder"));
            this.configureBoardItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.configureSelectedBoard"));
            this.configureFolderItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.configureSelectedFolder"));
            this.sortFolderItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.sortFolder"));
            this.markAllReadItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.markAllMessagesRead"));
            this.renameFolderItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.renameFolder"));
            this.searchMessagesItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.searchMessages") + "...");
            this.sendMessageItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.sendMessage"));
        }

        private void refreshSelected() {
            TofTree.this.refreshNode(this.selectedTreeNode);
        }

        private void sendMessageSelected() {
            if (this.selectedTreeNode == null || !this.selectedTreeNode.isBoard()) {
                return;
            }
            Board board = (Board)this.selectedTreeNode;
            MainFrame.getInstance().getMessagePanel().composeNewMessage(board);
        }

        private void markAllReadSelected() {
            TOF.getInstance().markAllMessagesRead(this.selectedTreeNode);
        }

        private void removeNodeSelected() {
            TofTree.this.removeNode(this.selectedTreeNode);
        }

        private void searchMessagesSelected() {
            ArrayList<Board> boardsToSearch = new ArrayList<Board>();
            if (this.selectedTreeNode.isBoard()) {
                boardsToSearch.add((Board)this.selectedTreeNode);
            } else {
                Enumeration<AbstractNode> e = this.selectedTreeNode.breadthFirstEnumeration();
                while (e.hasMoreElements()) {
                    AbstractNode n = e.nextElement();
                    if (!n.isBoard()) continue;
                    boardsToSearch.add((Board)n);
                }
            }
            if (!boardsToSearch.isEmpty()) {
                MainFrame.getInstance().startSearchMessagesDialog(boardsToSearch);
            }
        }

        public void show(Component invoker, int x, int y) {
            int selRow = TofTree.this.getRowForLocation(x, y);
            if (selRow != -1) {
                this.removeAll();
                TreePath selPath = TofTree.this.getPathForLocation(x, y);
                this.selectedTreeNode = (AbstractNode)selPath.getLastPathComponent();
                if (!this.selectedTreeNode.isFolder() && !this.selectedTreeNode.isBoard()) {
                    return;
                }
                String folderOrBoard1 = this.selectedTreeNode.isFolder() ? TofTree.this.language.getString("BoardTree.popupmenu.Folder") : TofTree.this.language.getString("BoardTree.popupmenu.Board");
                String folderOrBoard2 = this.selectedTreeNode.isFolder() ? TofTree.this.language.getString("BoardTree.popupmenu.folder") : TofTree.this.language.getString("BoardTree.popupmenu.board");
                this.descriptionItem.setText(folderOrBoard1 + " : " + this.selectedTreeNode.getName());
                this.refreshItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.refresh") + " " + folderOrBoard2);
                this.removeNodeItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.remove") + " " + folderOrBoard2);
                this.cutNodeItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.cut") + " " + folderOrBoard2);
                this.add(this.descriptionItem);
                this.addSeparator();
                this.add(this.refreshItem);
                if (!this.selectedTreeNode.isFolder() && !((Board)this.selectedTreeNode).isReadAccessBoard()) {
                    this.add(this.sendMessageItem);
                }
                this.add(this.searchMessagesItem);
                this.addSeparator();
                this.add(this.markAllReadItem);
                this.addSeparator();
                if (this.selectedTreeNode.isFolder()) {
                    this.add(this.renameFolderItem);
                    this.add(this.configureFolderItem);
                    this.add(this.sortFolderItem);
                } else {
                    this.add(this.configureBoardItem);
                }
                this.addSeparator();
                this.add(this.addBoardItem);
                this.add(this.addFolderItem);
                if (!this.selectedTreeNode.isRoot()) {
                    this.add(this.removeNodeItem);
                }
                this.addSeparator();
                if (!this.selectedTreeNode.isRoot()) {
                    this.add(this.cutNodeItem);
                }
                if (TofTree.this.clipboard != null && this.selectedTreeNode.isFolder()) {
                    String folderOrBoard3 = TofTree.this.clipboard.isFolder() ? TofTree.this.language.getString("BoardTree.popupmenu.folder") : TofTree.this.language.getString("BoardTree.popupmenu.board");
                    this.pasteNodeItem.setText(TofTree.this.language.getString("BoardTree.popupmenu.paste") + " " + folderOrBoard3 + " '" + TofTree.this.clipboard.getName() + "'");
                    this.add(this.pasteNodeItem);
                }
                super.show(invoker, x, y);
            }
        }

        private void sortFolderSelected() {
            ((Folder)this.selectedTreeNode).sortChildren();
            TofTree.this.model.nodeStructureChanged(this.selectedTreeNode);
        }

        private void renameFolderSelected() {
            MainFrame.getInstance().renameFolder((Folder)this.selectedTreeNode);
        }
    }
}

