/*
 * Decompiled with CFR 0.152.
 */
package frost.components;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Browser
extends JPanel {
    private static final Logger logger = Logger.getLogger(Browser.class.getName());
    String[] imageExtensions = new String[]{".jpg", ".gif", ".jpeg", ".png", ".bmp"};
    JFrame parent;
    JPanel contentPanel;
    JPanel buttonPanel = new JPanel(new FlowLayout(0));
    JButton backButton = new JButton("<");
    JButton forwardButton = new JButton(">");
    JButton homeButton = new JButton("~");
    JButton addPageButton = new JButton(": )");
    JButton removePageButton = new JButton(": (");
    JEditorPane editorPane = new JEditorPane();
    JComboBox urlComboBox = new JComboBox();
    JComboBox favComboBox = new JComboBox();
    JScrollPane scrollPane = new JScrollPane(this.editorPane);

    private void init() {
        this.urlComboBox.setEditable(true);
        this.editorPane.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent e) {
                Browser.this.parent.setTitle(e.getURL().toString());
                Browser.this.hyperlink_actionPerformed(e);
            }
        });
        this.backButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = Browser.this.urlComboBox.getSelectedIndex();
                if (i > 0) {
                    Browser.this.urlComboBox.setSelectedIndex(--i);
                }
            }
        });
        this.forwardButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                int i = Browser.this.urlComboBox.getSelectedIndex();
                if (i < Browser.this.urlComboBox.getItemCount() - 1) {
                    Browser.this.urlComboBox.setSelectedIndex(++i);
                }
            }
        });
        this.homeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Browser.this.editorPane.setText(Browser.this.makeStartPage());
            }
        });
        this.addPageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                String url = Browser.this.editorPane.getPage().toString();
                boolean exists = false;
                for (int i = 0; i < Browser.this.favComboBox.getItemCount(); ++i) {
                    if (!((String)Browser.this.favComboBox.getItemAt(i)).equals(url)) continue;
                    exists = true;
                    Browser.this.favComboBox.setSelectedItem(url);
                }
                if (!exists) {
                    Browser.this.favComboBox.addItem(url);
                    Browser.this.favComboBox.setSelectedItem(url);
                    Browser.this.writeSettings(new File("browser.ini"));
                }
            }
        });
        this.removePageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Browser.this.favComboBox.removeItem(Browser.this.editorPane.getPage().toString());
                Browser.this.writeSettings(new File("browser.ini"));
            }
        });
        this.urlComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Browser.this.setPage((String)Browser.this.urlComboBox.getSelectedItem());
            }
        });
        this.favComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                Browser.this.setPage((String)Browser.this.favComboBox.getSelectedItem());
            }
        });
        this.contentPanel = this;
        this.contentPanel.setLayout(new BorderLayout());
        this.buttonPanel.add(this.backButton);
        this.buttonPanel.add(this.forwardButton);
        this.buttonPanel.add(this.homeButton);
        this.buttonPanel.add(this.addPageButton);
        this.buttonPanel.add(this.removePageButton);
        this.buttonPanel.add(this.favComboBox);
        this.editorPane.setEditable(false);
        this.contentPanel.add((Component)this.scrollPane, "Center");
        this.contentPanel.add((Component)this.buttonPanel, "North");
        this.contentPanel.add((Component)this.urlComboBox, "South");
        this.readSettings(new File("browser.ini"));
        this.setPage("http://localhost:8888");
    }

    String makeStartPage() {
        String html = new String();
        html = "<html><body>";
        for (int i = 0; i < this.favComboBox.getItemCount(); ++i) {
            html = html + "<a href=\"" + (String)this.favComboBox.getItemAt(i) + "\">" + (String)this.favComboBox.getItemAt(i) + "</a><br>";
        }
        html = html + "</body></html>";
        return html;
    }

    void setPage(String url) {
        if (url != null) {
            int i;
            if (!url.startsWith("http://")) {
                url = "http://" + url;
            }
            boolean exists = false;
            for (i = 0; i < this.urlComboBox.getItemCount(); ++i) {
                if (!((String)this.urlComboBox.getItemAt(i)).equals(url)) continue;
                exists = true;
                this.urlComboBox.setSelectedItem(url);
            }
            if (!exists) {
                i = this.urlComboBox.getSelectedIndex();
                i = i == -1 || this.urlComboBox.getItemCount() == 0 ? 0 : ++i;
                this.urlComboBox.insertItemAt(url, i);
                this.urlComboBox.setSelectedItem(url);
            }
            boolean image = false;
            for (String element : this.imageExtensions) {
                if (!url.endsWith(element)) continue;
                image = true;
            }
            try {
                if (image) {
                    String html = "<html><img src=\"" + url + "\"></html>";
                    this.editorPane.setText(html);
                } else {
                    this.editorPane.setPage(url);
                }
            }
            catch (Throwable exception) {
                // empty catch block
            }
        }
    }

    void hyperlink_actionPerformed(HyperlinkEvent e) {
        if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
            this.setPage(e.getURL().toString());
        }
    }

    void readSettings(File file) {
        Vector<String> favs = this.readLines(file);
        for (int i = 0; i < favs.size(); ++i) {
            this.favComboBox.addItem(favs.elementAt(i));
        }
    }

    void writeSettings(File file) {
        String output = new String();
        for (int i = 0; i < this.favComboBox.getItemCount(); ++i) {
            output = output + (String)this.favComboBox.getItemAt(i) + "\r\n";
        }
        this.writeFile(output, file);
    }

    Vector<String> readLines(File file) {
        return this.readLines(file.getPath());
    }

    Vector<String> readLines(String path) {
        String line = "";
        Vector<String> data = new Vector<String>();
        try {
            BufferedReader f = new BufferedReader(new FileReader(path));
            while ((line = f.readLine()) != null) {
                data.add(line.trim());
            }
            f.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Read Error: " + path, e);
        }
        return data;
    }

    void writeFile(String content, File file) {
        this.writeFile(content, file.getPath());
    }

    void writeFile(String content, String filename) {
        try {
            FileWriter f1 = new FileWriter(filename);
            f1.write(content);
            f1.close();
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Write Error: " + filename, e);
        }
    }

    public Browser(JFrame parent) {
        this.parent = parent;
        this.init();
    }
}

