/*
 * Decompiled with CFR 0.152.
 */
package frost.components.translate;

import frost.MainFrame;
import frost.util.gui.MiscToolkit;
import frost.util.gui.translation.FrostResourceBundle;
import frost.util.gui.translation.LanguageGuiSupport;
import frost.util.gui.translation.TranslateableFrostResourceBundle;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.swing.AbstractListModel;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListCellRenderer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TranslationDialog
extends JFrame {
    private JPanel jContentPane = null;
    private JLabel jLabel = null;
    private JList Lkeys = null;
    private JLabel Lsource = null;
    private JTextArea TAsource = null;
    private JLabel Ltranslation = null;
    private JTextArea TAtranslation = null;
    private JPanel Pbuttons = null;
    private JPanel jPanel = null;
    private JButton BdeleteKey = null;
    private JRadioButton RBshowAll = null;
    private JRadioButton RBshowMissing = null;
    private JButton BapplyChanges = null;
    private JButton BrevertChanges = null;
    private JButton Bsave = null;
    private JButton Bclose = null;
    private JScrollPane jScrollPane = null;
    private JScrollPane jScrollPane1 = null;
    private JScrollPane jScrollPane2 = null;
    private final ButtonGroup radioButtons;
    private FrostResourceBundle rootBundle;
    private FrostResourceBundle sourceBundle;
    private String sourceLanguageName;
    private TranslateableFrostResourceBundle targetBundle;
    private String targetLanguageName;
    private final ImageIcon missingIcon;
    private final ImageIcon existingIcon;

    public TranslationDialog() {
        this.initialize();
        this.radioButtons = new ButtonGroup();
        this.radioButtons.add(this.getRBshowAll());
        this.radioButtons.add(this.getRBshowMissing());
        this.setLocationRelativeTo(MainFrame.getInstance());
        this.setDefaultCloseOperation(0);
        this.enableEvents(64L);
        this.missingIcon = MiscToolkit.getScaledImage("/data/help.png", 10, 10);
        this.existingIcon = MiscToolkit.getScaledImage("/data/trust.gif", 10, 10);
    }

    private void initialize() {
        this.setSize(750, 550);
        this.setContentPane(this.getJContentPane());
        this.setTitle("JFrame");
    }

    private JPanel getJContentPane() {
        if (this.jContentPane == null) {
            GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
            gridBagConstraints5.fill = 1;
            gridBagConstraints5.gridy = 1;
            gridBagConstraints5.weightx = 1.0;
            gridBagConstraints5.weighty = 0.4;
            gridBagConstraints5.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints5.gridx = 0;
            GridBagConstraints gridBagConstraints41 = new GridBagConstraints();
            gridBagConstraints41.fill = 1;
            gridBagConstraints41.gridy = 5;
            gridBagConstraints41.weightx = 1.0;
            gridBagConstraints41.weighty = 0.2;
            gridBagConstraints41.anchor = 18;
            gridBagConstraints41.gridwidth = 2;
            gridBagConstraints41.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints41.gridx = 0;
            GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
            gridBagConstraints3.fill = 1;
            gridBagConstraints3.gridy = 3;
            gridBagConstraints3.weightx = 1.0;
            gridBagConstraints3.weighty = 0.2;
            gridBagConstraints3.gridwidth = 2;
            gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints3.anchor = 18;
            gridBagConstraints3.gridx = 0;
            GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
            gridBagConstraints7.gridx = 1;
            gridBagConstraints7.insets = new Insets(5, 0, 5, 5);
            gridBagConstraints7.fill = 3;
            gridBagConstraints7.anchor = 18;
            gridBagConstraints7.gridy = 1;
            GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
            gridBagConstraints6.gridx = 0;
            gridBagConstraints6.fill = 2;
            gridBagConstraints6.gridwidth = 2;
            gridBagConstraints6.gridy = 6;
            GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
            gridBagConstraints4.gridx = 0;
            gridBagConstraints4.anchor = 18;
            gridBagConstraints4.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints4.gridy = 4;
            this.Ltranslation = new JLabel();
            this.Ltranslation.setText("Translation");
            GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.anchor = 18;
            gridBagConstraints2.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints2.gridy = 2;
            this.Lsource = new JLabel();
            this.Lsource.setText("Source");
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 18;
            gridBagConstraints.insets = new Insets(5, 5, 0, 0);
            gridBagConstraints.gridy = 0;
            this.jLabel = new JLabel();
            this.jLabel.setText("Translateable keys");
            this.jContentPane = new JPanel();
            this.jContentPane.setLayout(new GridBagLayout());
            this.jContentPane.add((Component)this.jLabel, gridBagConstraints);
            this.jContentPane.add((Component)this.Lsource, gridBagConstraints2);
            this.jContentPane.add((Component)this.Ltranslation, gridBagConstraints4);
            this.jContentPane.add((Component)this.getPbuttons(), gridBagConstraints6);
            this.jContentPane.add((Component)this.getJPanel(), gridBagConstraints7);
            this.jContentPane.add((Component)this.getJScrollPane(), gridBagConstraints3);
            this.jContentPane.add((Component)this.getJScrollPane1(), gridBagConstraints41);
            this.jContentPane.add((Component)this.getJScrollPane2(), gridBagConstraints5);
        }
        return this.jContentPane;
    }

    @Override
    protected void processWindowEvent(WindowEvent e) {
        if (e.getID() == 201) {
            this.closeDialog();
        }
        super.processWindowEvent(e);
    }

    private JList getLkeys() {
        if (this.Lkeys == null) {
            this.Lkeys = new JList();
            this.Lkeys.setSelectionMode(0);
            this.Lkeys.setCellRenderer(new ListRenderer());
            this.Lkeys.setSelectionModel(new DefaultListSelectionModel(){

                public void setSelectionInterval(int index0, int index1) {
                    String oldKey;
                    int oldIndex = this.getMinSelectionIndex();
                    super.setSelectionInterval(index0, index1);
                    int newIndex = this.getMinSelectionIndex();
                    if (oldIndex > -1 && oldIndex != newIndex && (oldKey = (String)TranslationDialog.this.getLkeys().getModel().getElementAt(oldIndex)) != null) {
                        TranslationDialog.this.applyChanges(oldKey, oldIndex);
                    }
                    TranslationDialog.this.keySelectionChanged();
                }
            });
        }
        return this.Lkeys;
    }

    private JTextArea getTAsource() {
        if (this.TAsource == null) {
            this.TAsource = new JTextArea();
            this.TAsource.setPreferredSize(new Dimension(0, 16));
            this.TAsource.setLineWrap(true);
            this.TAsource.setEditable(false);
            this.TAsource.setWrapStyleWord(true);
            this.TAsource.setRows(0);
        }
        return this.TAsource;
    }

    private JTextArea getTAtranslation() {
        if (this.TAtranslation == null) {
            this.TAtranslation = new JTextArea();
            this.TAtranslation.setPreferredSize(new Dimension(0, 16));
            this.TAtranslation.setLineWrap(true);
            this.TAtranslation.setWrapStyleWord(true);
        }
        return this.TAtranslation;
    }

    private JPanel getPbuttons() {
        if (this.Pbuttons == null) {
            FlowLayout flowLayout = new FlowLayout();
            flowLayout.setAlignment(2);
            this.Pbuttons = new JPanel();
            this.Pbuttons.setLayout(flowLayout);
            this.Pbuttons.add((Component)this.getBsave(), null);
            this.Pbuttons.add((Component)this.getBclose(), null);
        }
        return this.Pbuttons;
    }

    private JPanel getJPanel() {
        if (this.jPanel == null) {
            GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
            gridBagConstraints12.gridx = 0;
            gridBagConstraints12.insets = new Insets(0, 5, 5, 5);
            gridBagConstraints12.fill = 2;
            gridBagConstraints12.anchor = 18;
            gridBagConstraints12.gridy = 1;
            GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
            gridBagConstraints11.gridy = 2;
            gridBagConstraints11.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints11.anchor = 18;
            gridBagConstraints11.fill = 2;
            GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
            gridBagConstraints10.gridx = 0;
            gridBagConstraints10.insets = new Insets(5, 5, 5, 5);
            gridBagConstraints10.fill = 2;
            gridBagConstraints10.anchor = 18;
            gridBagConstraints10.gridy = 0;
            GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
            gridBagConstraints9.gridx = 0;
            gridBagConstraints9.insets = new Insets(0, 5, 0, 5);
            gridBagConstraints9.anchor = 18;
            gridBagConstraints9.weighty = 1.0;
            gridBagConstraints9.fill = 0;
            gridBagConstraints9.gridy = 4;
            GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
            gridBagConstraints8.gridx = 0;
            gridBagConstraints8.insets = new Insets(5, 5, 0, 5);
            gridBagConstraints8.anchor = 18;
            gridBagConstraints8.gridy = 3;
            this.jPanel = new JPanel();
            this.jPanel.setLayout(new GridBagLayout());
            this.jPanel.setBorder(BorderFactory.createEtchedBorder(1));
            this.jPanel.add((Component)this.getBdeleteKey(), gridBagConstraints11);
            this.jPanel.add((Component)this.getRBshowAll(), gridBagConstraints8);
            this.jPanel.add((Component)this.getRBshowMissing(), gridBagConstraints9);
            this.jPanel.add((Component)this.getBapplyChanges(), gridBagConstraints10);
            this.jPanel.add((Component)this.getBrevertChanges(), gridBagConstraints12);
        }
        return this.jPanel;
    }

    private JScrollPane getJScrollPane() {
        if (this.jScrollPane == null) {
            this.jScrollPane = new JScrollPane();
            this.jScrollPane.setViewportView(this.getTAsource());
        }
        return this.jScrollPane;
    }

    private JScrollPane getJScrollPane1() {
        if (this.jScrollPane1 == null) {
            this.jScrollPane1 = new JScrollPane();
            this.jScrollPane1.setViewportView(this.getTAtranslation());
        }
        return this.jScrollPane1;
    }

    private JScrollPane getJScrollPane2() {
        if (this.jScrollPane2 == null) {
            this.jScrollPane2 = new JScrollPane();
            this.jScrollPane2.setViewportView(this.getLkeys());
        }
        return this.jScrollPane2;
    }

    private JButton getBdeleteKey() {
        if (this.BdeleteKey == null) {
            this.BdeleteKey = new JButton();
            this.BdeleteKey.setText("Delete key");
            this.BdeleteKey.setMnemonic(68);
            this.BdeleteKey.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String selectedKey = (String)TranslationDialog.this.getLkeys().getSelectedValue();
                    TranslationDialog.this.deleteKey(selectedKey);
                }
            });
        }
        return this.BdeleteKey;
    }

    private JRadioButton getRBshowAll() {
        if (this.RBshowAll == null) {
            this.RBshowAll = new JRadioButton();
            this.RBshowAll.setText("Show all keys");
            this.RBshowAll.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TranslationDialog.this.showKeysChanged();
                }
            });
        }
        return this.RBshowAll;
    }

    private JRadioButton getRBshowMissing() {
        if (this.RBshowMissing == null) {
            this.RBshowMissing = new JRadioButton();
            this.RBshowMissing.setText("Show missing keys");
            this.RBshowMissing.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    TranslationDialog.this.showKeysChanged();
                }
            });
        }
        return this.RBshowMissing;
    }

    private JButton getBapplyChanges() {
        if (this.BapplyChanges == null) {
            this.BapplyChanges = new JButton();
            this.BapplyChanges.setText("Apply changes");
            this.BapplyChanges.setMnemonic(65);
            this.BapplyChanges.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    String selectedKey = (String)TranslationDialog.this.getLkeys().getSelectedValue();
                    if (selectedKey == null) {
                        return;
                    }
                    int selectedIx = TranslationDialog.this.getLkeys().getSelectedIndex();
                    TranslationDialog.this.applyChanges(selectedKey, selectedIx);
                }
            });
        }
        return this.BapplyChanges;
    }

    private JButton getBrevertChanges() {
        if (this.BrevertChanges == null) {
            this.BrevertChanges = new JButton();
            this.BrevertChanges.setText("Revert changes");
            this.BrevertChanges.setMnemonic(82);
            this.BrevertChanges.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TranslationDialog.this.revertChanges();
                }
            });
        }
        return this.BrevertChanges;
    }

    private JButton getBsave() {
        if (this.Bsave == null) {
            this.Bsave = new JButton();
            this.Bsave.setText("Save");
            this.Bsave.setMnemonic(83);
            this.Bsave.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TranslationDialog.this.saveBundle(false);
                }
            });
        }
        return this.Bsave;
    }

    private JButton getBclose() {
        if (this.Bclose == null) {
            this.Bclose = new JButton();
            this.Bclose.setText("Close");
            this.Bclose.setMnemonic(67);
            this.Bclose.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    TranslationDialog.this.closeDialog();
                }
            });
        }
        return this.Bclose;
    }

    private void closeDialog() {
        int answer = JOptionPane.showConfirmDialog(this, "Do you want to save before closing the dialog?", "Save before close", 1, 3);
        if (answer == 2) {
            return;
        }
        if (answer == 0 && !this.saveBundle(true)) {
            return;
        }
        LanguageGuiSupport.getInstance().updateLanguageMenu();
        this.setVisible(false);
        this.dispose();
    }

    public void startDialog(FrostResourceBundle rootResBundle, FrostResourceBundle sourceResBundle, String sourceLangName, TranslateableFrostResourceBundle targetResBundle, String targetLangName) {
        this.rootBundle = rootResBundle;
        this.sourceBundle = sourceResBundle;
        this.sourceLanguageName = sourceLangName;
        this.targetBundle = targetResBundle;
        this.targetLanguageName = targetLangName;
        this.setTitle("Translate Frost - (" + this.sourceLanguageName + ") into (" + this.targetLanguageName + ")");
        this.Lsource.setText("Source (" + this.sourceLanguageName + "):");
        this.Ltranslation.setText("Translation (" + this.targetLanguageName + "):");
        this.radioButtons.setSelected(this.getRBshowAll().getModel(), true);
        List<String> allKeys = this.getAllKeys();
        this.getLkeys().setModel(new ItemListModel(allKeys));
        this.setVisible(true);
    }

    private List<String> getAllKeys() {
        TreeMap<String, String> sorter = new TreeMap<String, String>();
        Iterator<String> i$ = this.rootBundle.getKeys().iterator();
        while (i$.hasNext()) {
            String string;
            String key = string = i$.next();
            sorter.put(key, key);
        }
        ArrayList<String> itemList = new ArrayList<String>();
        Iterator i$2 = sorter.keySet().iterator();
        while (i$2.hasNext()) {
            String string;
            String key = string = (String)i$2.next();
            itemList.add(key);
        }
        return itemList;
    }

    private List<String> getMissingKeys() {
        TreeMap<String, String> sorter = new TreeMap<String, String>();
        for (String string : this.rootBundle.getKeys()) {
            String key = string;
            if (this.targetBundle.containsKey(key)) continue;
            sorter.put(key, key);
        }
        ArrayList<String> itemList = new ArrayList<String>();
        Iterator i$ = sorter.keySet().iterator();
        while (i$.hasNext()) {
            String string;
            String key = string = (String)i$.next();
            itemList.add(key);
        }
        return itemList;
    }

    private boolean saveBundle(boolean quiet) {
        boolean wasOk = this.targetBundle.saveBundleToFile(this.targetLanguageName);
        if (!wasOk) {
            JOptionPane.showMessageDialog(this, "Error saving bundle! Check the log file.", "Error", 0);
        } else if (!quiet) {
            JOptionPane.showMessageDialog(this, "Bundle was successfully saved.", "Save successful", 1);
        }
        return wasOk;
    }

    private void showKeysChanged() {
        List<String> items = this.getRBshowAll().isSelected() ? this.getAllKeys() : this.getMissingKeys();
        this.getLkeys().setModel(new ItemListModel(items));
    }

    private void applyChanges(String selectedKey, int ix) {
        String txt = this.getTAtranslation().getText().trim();
        if (txt.length() == 0) {
            this.deleteKey(selectedKey);
            return;
        }
        this.targetBundle.setKey(selectedKey, txt);
        if (this.getRBshowAll().isSelected()) {
            ((ItemListModel)this.getLkeys().getModel()).itemChanged(ix);
        } else {
            ((ItemListModel)this.getLkeys().getModel()).removeItem(ix);
            if (this.getLkeys().getSelectedValue() == null) {
                this.getTAsource().setText("");
                this.getTAtranslation().setText("");
            }
        }
    }

    private void revertChanges() {
        String selectedKey = (String)this.getLkeys().getSelectedValue();
        if (selectedKey == null) {
            return;
        }
        String val = this.targetBundle.containsKey(selectedKey) ? this.targetBundle.getString(selectedKey) : "";
        this.getTAtranslation().setText(val);
    }

    private void deleteKey(String selectedKey) {
        if (selectedKey == null) {
            return;
        }
        this.targetBundle.removeKey(selectedKey);
        this.getTAtranslation().setText("");
        int ix = this.getLkeys().getSelectedIndex();
        ((ItemListModel)this.getLkeys().getModel()).itemChanged(ix);
    }

    private void keySelectionChanged() {
        String selectedKey = (String)this.getLkeys().getSelectedValue();
        if (selectedKey == null) {
            this.getTAsource().setText("");
            this.getTAtranslation().setText("");
            return;
        }
        String txt = this.sourceBundle.getString(selectedKey);
        this.getTAsource().setText(txt);
        txt = this.targetBundle.containsKey(selectedKey) ? this.targetBundle.getString(selectedKey) : "";
        this.getTAtranslation().setText(txt);
    }

    private class ListRenderer
    extends DefaultListCellRenderer {
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
            String key = (String)value;
            if (TranslationDialog.this.targetBundle.containsKey(key)) {
                this.setIcon(TranslationDialog.this.existingIcon);
            } else {
                this.setIcon(TranslationDialog.this.missingIcon);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ItemListModel
    extends AbstractListModel {
        List<String> items;

        public ItemListModel(List<String> i) {
            this.items = i;
        }

        @Override
        public int getSize() {
            return this.items.size();
        }

        @Override
        public Object getElementAt(int x) {
            return this.items.get(x);
        }

        public void itemChanged(int ix) {
            this.fireContentsChanged(this, ix, ix);
        }

        public void removeItem(int ix) {
            this.items.remove(ix);
            this.fireIntervalRemoved(this, ix, ix);
        }
    }
}

