/*
 * Decompiled with CFR 0.152.
 */
package frost.ext;

import frost.Core;
import frost.gui.MessageFrame;
import frost.util.FileAccess;
import frost.util.gui.translation.Language;
import java.awt.Frame;
import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AltEdit
extends Thread {
    private static final Logger logger = Logger.getLogger(AltEdit.class.getName());
    private final Language language = Language.getInstance();
    private final Frame parentFrame;
    private final String linesep = System.getProperty("line.separator");
    private final String oldSubject;
    private final String oldText;
    private final String SUBJECT_MARKER = this.language.getString("AltEdit.markerLine.subject");
    private final String TEXT_MARKER = this.language.getString("AltEdit.markerLine.text");
    private final Object transferObject;
    private final MessageFrame callbackTarget;

    public AltEdit(String subject, String text, Frame parentFrame, Object transferObject, MessageFrame callbackTarget) {
        this.parentFrame = parentFrame;
        this.oldSubject = subject;
        this.oldText = text;
        this.transferObject = transferObject;
        this.callbackTarget = callbackTarget;
    }

    private void callbackMessageFrame(final String newSubject, final String newText) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                AltEdit.this.callbackTarget.altEditCallback(AltEdit.this.transferObject, newSubject, newText);
            }
        });
    }

    @Override
    public void run() {
        if (!Core.frostSettings.getBoolValue("useAltEdit")) {
            this.callbackMessageFrame(null, null);
            return;
        }
        String editor = Core.frostSettings.getValue("altEdit");
        if (editor == null || editor.length() == 0) {
            JOptionPane.showMessageDialog(this.parentFrame, this.language.getString("AltEdit.errorDialog.noAlternateEditorConfigured"), this.language.getString("AltEdit.errorDialogs.title"), 0);
            this.callbackMessageFrame(null, null);
            return;
        }
        if (editor.indexOf("%f") == -1) {
            JOptionPane.showMessageDialog(this.parentFrame, this.language.getString("AltEdit.errorDialog.missingPlaceholder"), this.language.getString("AltEdit.errorDialogs.title"), 0);
            this.callbackMessageFrame(null, null);
            return;
        }
        String editor_pre_file = editor.substring(0, editor.indexOf("%f"));
        String editor_post_file = editor.substring(editor.indexOf("%f") + 2, editor.length());
        File editFile = FileAccess.createTempFile("frostmsg", ".txt");
        editFile.deleteOnExit();
        StringBuilder sb = new StringBuilder();
        sb.append(this.language.getString("AltEdit.textFileMessage.1")).append(this.linesep);
        sb.append(this.language.getString("AltEdit.textFileMessage.2")).append(this.linesep);
        sb.append(this.language.getString("AltEdit.textFileMessage.3")).append(this.linesep).append(this.linesep);
        sb.append(this.SUBJECT_MARKER).append(this.linesep);
        sb.append(this.oldSubject).append(this.linesep).append(this.linesep);
        sb.append(this.oldText).append(this.linesep);
        sb.append(this.TEXT_MARKER).append(this.linesep);
        if (!FileAccess.writeFile(sb.toString(), editFile, "UTF-8")) {
            JOptionPane.showMessageDialog(this.parentFrame, this.language.getString("AltEdit.errorDialog.couldNotCreateMessageFile") + ": " + editFile.getPath(), this.language.getString("AltEdit.errorDialogs.title"), 0);
            this.callbackMessageFrame(null, null);
            return;
        }
        sb = null;
        String editorCmdLine = editor_pre_file + editFile.getPath() + editor_post_file;
        try {
            AltEdit.run_wait(editorCmdLine);
        }
        catch (Throwable t) {
            JOptionPane.showMessageDialog(this.parentFrame, this.language.getString("AltEdit.errorDialog.couldNotStartEditorUsingCommand") + ": " + editorCmdLine + "\n" + t.toString(), this.language.getString("AltEdit.errorDialogs.title"), 0);
            editFile.delete();
            this.callbackMessageFrame(null, null);
            return;
        }
        List<String> lines = FileAccess.readLines(editFile, "UTF-8");
        if (lines.size() < 4) {
            JOptionPane.showMessageDialog(this.parentFrame, this.language.getString("AltEdit.errorDialog.invalidReturnedMessageFile"), this.language.getString("AltEdit.errorDialogs.title"), 0);
            editFile.delete();
            this.callbackMessageFrame(null, null);
            return;
        }
        String newSubject = null;
        StringBuilder newTextSb = new StringBuilder();
        boolean inNewText = false;
        Iterator<String> it = lines.iterator();
        while (it.hasNext()) {
            String line = it.next();
            if (inNewText) {
                newTextSb.append(line).append(this.linesep);
                continue;
            }
            if (line.equals(this.SUBJECT_MARKER)) {
                if (!it.hasNext()) {
                    JOptionPane.showMessageDialog(this.parentFrame, this.language.getString("AltEdit.errorDialog.invalidReturnedMessageFile"), this.language.getString("AltEdit.errorDialogs.title"), 0);
                    editFile.delete();
                    this.callbackMessageFrame(null, null);
                    return;
                }
                line = it.next();
                if (line.equals(this.TEXT_MARKER)) {
                    JOptionPane.showMessageDialog(this.parentFrame, this.language.getString("AltEdit.errorDialog.invalidReturnedMessageFile"), this.language.getString("AltEdit.errorDialogs.title"), 0);
                    editFile.delete();
                    this.callbackMessageFrame(null, null);
                    return;
                }
                newSubject = line.trim();
                continue;
            }
            if (!line.equals(this.TEXT_MARKER)) continue;
            inNewText = true;
        }
        if (newSubject == null) {
            JOptionPane.showMessageDialog(this.parentFrame, this.language.getString("AltEdit.errorDialog.invalidReturnedMessageFile"), this.language.getString("AltEdit.errorDialogs.title"), 0);
            editFile.delete();
            this.callbackMessageFrame(null, null);
            return;
        }
        this.callbackMessageFrame(newSubject, newTextSb.toString());
    }

    public static List<String> run_wait(String order) throws Throwable {
        logger.info("-------------------------------------------------------------------\nExecute: " + order + "\n" + "-------------------------------------------------------------------");
        ArrayList<String> result = new ArrayList<String>();
        Process p = Runtime.getRuntime().exec(order);
        InputStream stdOut = p.getInputStream();
        InputStream stdErr = p.getErrorStream();
        ArrayList<String> tmpList = FileAccess.readLines(stdOut, "UTF-8");
        if (tmpList != null) {
            result.addAll(tmpList);
        }
        if ((tmpList = FileAccess.readLines(stdErr, "UTF-8")) != null) {
            result.addAll(tmpList);
        }
        p.waitFor();
        return result;
    }
}

