/*
 * Decompiled with CFR 0.152.
 */
package frost.ext;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;

public class DefaultMIMETypes {
    public static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static List<String> mimeTypesByNumber = new Vector<String>();
    private static Map<String, Short> mimeTypesByName = new HashMap<String, Short>();
    private static Map<String, Short> mimeTypesByExtension = new HashMap<String, Short>();
    private static Map<Short, String> primaryExtensionByMimeNumber = new HashMap<Short, String>();

    protected static synchronized void addMIMEType(short number, String type) {
        if (mimeTypesByNumber.size() > number) {
            String s = mimeTypesByNumber.get(number);
            if (s != null) {
                throw new IllegalArgumentException("Already used: " + number);
            }
        } else {
            mimeTypesByNumber.add(number, null);
        }
        mimeTypesByNumber.set(number, type);
        mimeTypesByName.put(type, new Short(number));
    }

    protected static synchronized void addMIMEType(short number, String type, String[] extensions, String outExtension) {
        DefaultMIMETypes.addMIMEType(number, type);
        Short t = new Short(number);
        if (extensions != null) {
            for (String element : extensions) {
                String ext = element.toLowerCase();
                if (mimeTypesByExtension.containsKey(ext)) continue;
                if (outExtension == null && extensions.length == 1) {
                    primaryExtensionByMimeNumber.put(t, ext);
                }
                mimeTypesByExtension.put(ext, t);
            }
        }
        if (outExtension != null) {
            primaryExtensionByMimeNumber.put(t, outExtension);
        }
    }

    protected static synchronized void addMIMEType(short number, String type, String extensions) {
        DefaultMIMETypes.addMIMEType(number, type, extensions.split(" "), null);
    }

    protected static synchronized void addMIMEType(short number, String type, String extensions, String outExtension) {
        DefaultMIMETypes.addMIMEType(number, type, extensions.split(" "), outExtension);
    }

    public static String byNumber(short x) {
        if (x > mimeTypesByNumber.size() || x < 0) {
            return null;
        }
        return mimeTypesByNumber.get(x);
    }

    public static short byName(String s) {
        Short x = mimeTypesByName.get(s);
        if (x != null) {
            return x;
        }
        return -1;
    }

    public static String guessMIMEType(String arg) {
        int x = arg.lastIndexOf(46);
        if (x == -1 || x == arg.length() - 1) {
            return DEFAULT_MIME_TYPE;
        }
        String ext = arg.substring(x + 1).toLowerCase();
        Short mimeIndexOb = mimeTypesByExtension.get(ext);
        if (mimeIndexOb != null) {
            return mimeTypesByNumber.get(mimeIndexOb.intValue());
        }
        return DEFAULT_MIME_TYPE;
    }

    public static String getExtension(String type) {
        short typeNumber = DefaultMIMETypes.byName(type);
        if (typeNumber < 0) {
            return null;
        }
        return primaryExtensionByMimeNumber.get(new Short(typeNumber));
    }

    public static String[] getAllMIMETypes() {
        return mimeTypesByNumber.toArray(new String[mimeTypesByNumber.size()]);
    }

    static {
        DefaultMIMETypes.addMIMEType((short)0, "application/activemessage");
        DefaultMIMETypes.addMIMEType((short)1, "application/andrew-inset", "ez");
        DefaultMIMETypes.addMIMEType((short)2, "application/applefile");
        DefaultMIMETypes.addMIMEType((short)3, "application/atomicmail");
        DefaultMIMETypes.addMIMEType((short)4, "application/batch-SMTP");
        DefaultMIMETypes.addMIMEType((short)5, "application/beep+xml");
        DefaultMIMETypes.addMIMEType((short)6, "application/cals-1840");
        DefaultMIMETypes.addMIMEType((short)7, "application/commonground");
        DefaultMIMETypes.addMIMEType((short)8, "application/cu-seeme", "cu");
        DefaultMIMETypes.addMIMEType((short)9, "application/cybercash");
        DefaultMIMETypes.addMIMEType((short)10, "application/dca-rft");
        DefaultMIMETypes.addMIMEType((short)11, "application/dec-dx");
        DefaultMIMETypes.addMIMEType((short)12, "application/docbook+xml");
        DefaultMIMETypes.addMIMEType((short)13, "application/dsptype", "tsp");
        DefaultMIMETypes.addMIMEType((short)14, "application/dvcs");
        DefaultMIMETypes.addMIMEType((short)15, "application/edi-consent");
        DefaultMIMETypes.addMIMEType((short)16, "application/edi-x12");
        DefaultMIMETypes.addMIMEType((short)17, "application/edifact");
        DefaultMIMETypes.addMIMEType((short)18, "application/eshop");
        DefaultMIMETypes.addMIMEType((short)19, "application/font-tdpfr");
        DefaultMIMETypes.addMIMEType((short)20, "application/futuresplash", "spl");
        DefaultMIMETypes.addMIMEType((short)21, "application/ghostview");
        DefaultMIMETypes.addMIMEType((short)22, "application/hta", "hta");
        DefaultMIMETypes.addMIMEType((short)23, "application/http");
        DefaultMIMETypes.addMIMEType((short)24, "application/hyperstudio");
        DefaultMIMETypes.addMIMEType((short)25, "application/iges");
        DefaultMIMETypes.addMIMEType((short)26, "application/index");
        DefaultMIMETypes.addMIMEType((short)27, "application/index.cmd");
        DefaultMIMETypes.addMIMEType((short)28, "application/index.obj");
        DefaultMIMETypes.addMIMEType((short)29, "application/index.response");
        DefaultMIMETypes.addMIMEType((short)30, "application/index.vnd");
        DefaultMIMETypes.addMIMEType((short)31, "application/iotp");
        DefaultMIMETypes.addMIMEType((short)32, "application/ipp");
        DefaultMIMETypes.addMIMEType((short)33, "application/isup");
        DefaultMIMETypes.addMIMEType((short)34, "application/java-archive", "jar");
        DefaultMIMETypes.addMIMEType((short)35, "application/java-serialized-object", "ser");
        DefaultMIMETypes.addMIMEType((short)36, "application/java-vm", "class");
        DefaultMIMETypes.addMIMEType((short)37, "application/mac-binhex40", "hqx");
        DefaultMIMETypes.addMIMEType((short)38, "application/mac-compactpro", "cpt");
        DefaultMIMETypes.addMIMEType((short)39, "application/macwriteii");
        DefaultMIMETypes.addMIMEType((short)40, "application/marc");
        DefaultMIMETypes.addMIMEType((short)41, "application/mathematica", "nb");
        DefaultMIMETypes.addMIMEType((short)42, "application/mathematica-old");
        DefaultMIMETypes.addMIMEType((short)43, "application/msaccess", "mdb");
        DefaultMIMETypes.addMIMEType((short)44, "application/msword", "doc dot");
        DefaultMIMETypes.addMIMEType((short)45, "application/news-message-id");
        DefaultMIMETypes.addMIMEType((short)46, "application/news-transmission");
        DefaultMIMETypes.addMIMEType((short)47, "application/ocsp-request");
        DefaultMIMETypes.addMIMEType((short)48, "application/ocsp-response");
        DefaultMIMETypes.addMIMEType((short)49, DEFAULT_MIME_TYPE, "bin");
        DefaultMIMETypes.addMIMEType((short)50, "application/oda", "oda");
        DefaultMIMETypes.addMIMEType((short)51, "application/ogg", "ogg");
        DefaultMIMETypes.addMIMEType((short)52, "application/parityfec");
        DefaultMIMETypes.addMIMEType((short)53, "application/pdf", "pdf");
        DefaultMIMETypes.addMIMEType((short)54, "application/pgp-encrypted");
        DefaultMIMETypes.addMIMEType((short)55, "application/pgp-keys", "key");
        DefaultMIMETypes.addMIMEType((short)56, "application/pgp-signature", "pgp");
        DefaultMIMETypes.addMIMEType((short)57, "application/pics-rules", "prf");
        DefaultMIMETypes.addMIMEType((short)58, "application/pkcs10");
        DefaultMIMETypes.addMIMEType((short)59, "application/pkcs7-mime");
        DefaultMIMETypes.addMIMEType((short)60, "application/pkcs7-signature");
        DefaultMIMETypes.addMIMEType((short)61, "application/pkix-cert");
        DefaultMIMETypes.addMIMEType((short)62, "application/pkix-crl");
        DefaultMIMETypes.addMIMEType((short)63, "application/pkixcmp");
        DefaultMIMETypes.addMIMEType((short)64, "application/postscript", "ps ai eps");
        DefaultMIMETypes.addMIMEType((short)65, "application/prs.alvestrand.titrax-sheet");
        DefaultMIMETypes.addMIMEType((short)66, "application/prs.cww");
        DefaultMIMETypes.addMIMEType((short)67, "application/prs.nprend");
        DefaultMIMETypes.addMIMEType((short)68, "application/qsig");
        DefaultMIMETypes.addMIMEType((short)69, "application/rar", "rar");
        DefaultMIMETypes.addMIMEType((short)70, "application/rdf+xml", "rdf");
        DefaultMIMETypes.addMIMEType((short)71, "application/remote-printing");
        DefaultMIMETypes.addMIMEType((short)72, "application/riscos");
        DefaultMIMETypes.addMIMEType((short)73, "application/rss+xml", "rss");
        DefaultMIMETypes.addMIMEType((short)74, "application/rtf");
        DefaultMIMETypes.addMIMEType((short)75, "application/sdp");
        DefaultMIMETypes.addMIMEType((short)76, "application/set-payment");
        DefaultMIMETypes.addMIMEType((short)77, "application/set-payment-initiation");
        DefaultMIMETypes.addMIMEType((short)78, "application/set-registration");
        DefaultMIMETypes.addMIMEType((short)79, "application/set-registration-initiation");
        DefaultMIMETypes.addMIMEType((short)80, "application/sgml");
        DefaultMIMETypes.addMIMEType((short)81, "application/sgml-open-catalog");
        DefaultMIMETypes.addMIMEType((short)82, "application/sieve");
        DefaultMIMETypes.addMIMEType((short)83, "application/slate");
        DefaultMIMETypes.addMIMEType((short)84, "application/smil", "smi smil");
        DefaultMIMETypes.addMIMEType((short)85, "application/timestamp-query");
        DefaultMIMETypes.addMIMEType((short)86, "application/timestamp-reply");
        DefaultMIMETypes.addMIMEType((short)87, "application/vemmi");
        DefaultMIMETypes.addMIMEType((short)88, "application/whoispp-query");
        DefaultMIMETypes.addMIMEType((short)89, "application/whoispp-response");
        DefaultMIMETypes.addMIMEType((short)90, "application/wita");
        DefaultMIMETypes.addMIMEType((short)91, "application/wordperfect", "wpd");
        DefaultMIMETypes.addMIMEType((short)92, "application/wordperfect5.1", "wp5");
        DefaultMIMETypes.addMIMEType((short)93, "application/x400-bp");
        DefaultMIMETypes.addMIMEType((short)94, "application/xhtml+xml", "xhtml xht");
        DefaultMIMETypes.addMIMEType((short)95, "application/xml", "xml xsl");
        DefaultMIMETypes.addMIMEType((short)96, "application/xml-dtd");
        DefaultMIMETypes.addMIMEType((short)97, "application/xml-external-parsed-entity");
        DefaultMIMETypes.addMIMEType((short)98, "application/zip", "zip");
        DefaultMIMETypes.addMIMEType((short)99, "application/vnd.3M.Post-it-Notes");
        DefaultMIMETypes.addMIMEType((short)100, "application/vnd.accpac.simply.aso");
        DefaultMIMETypes.addMIMEType((short)101, "application/vnd.accpac.simply.imp");
        DefaultMIMETypes.addMIMEType((short)102, "application/vnd.acucobol");
        DefaultMIMETypes.addMIMEType((short)103, "application/vnd.aether.imp");
        DefaultMIMETypes.addMIMEType((short)104, "application/vnd.anser-web-certificate-issue-initiation");
        DefaultMIMETypes.addMIMEType((short)105, "application/vnd.anser-web-funds-transfer-initiation");
        DefaultMIMETypes.addMIMEType((short)106, "application/vnd.audiograph");
        DefaultMIMETypes.addMIMEType((short)107, "application/vnd.bmi");
        DefaultMIMETypes.addMIMEType((short)108, "application/vnd.businessobjects");
        DefaultMIMETypes.addMIMEType((short)109, "application/vnd.canon-cpdl");
        DefaultMIMETypes.addMIMEType((short)110, "application/vnd.canon-lips");
        DefaultMIMETypes.addMIMEType((short)111, "application/vnd.cinderella", "cdy");
        DefaultMIMETypes.addMIMEType((short)112, "application/vnd.claymore");
        DefaultMIMETypes.addMIMEType((short)113, "application/vnd.commerce-battelle");
        DefaultMIMETypes.addMIMEType((short)114, "application/vnd.commonspace");
        DefaultMIMETypes.addMIMEType((short)115, "application/vnd.comsocaller");
        DefaultMIMETypes.addMIMEType((short)116, "application/vnd.contact.cmsg");
        DefaultMIMETypes.addMIMEType((short)117, "application/vnd.cosmocaller");
        DefaultMIMETypes.addMIMEType((short)118, "application/vnd.ctc-posml");
        DefaultMIMETypes.addMIMEType((short)119, "application/vnd.cups-postscript");
        DefaultMIMETypes.addMIMEType((short)120, "application/vnd.cups-raster");
        DefaultMIMETypes.addMIMEType((short)121, "application/vnd.cups-raw");
        DefaultMIMETypes.addMIMEType((short)122, "application/vnd.cybank");
        DefaultMIMETypes.addMIMEType((short)123, "application/vnd.dna");
        DefaultMIMETypes.addMIMEType((short)124, "application/vnd.dpgraph");
        DefaultMIMETypes.addMIMEType((short)125, "application/vnd.dxr");
        DefaultMIMETypes.addMIMEType((short)126, "application/vnd.ecdis-update");
        DefaultMIMETypes.addMIMEType((short)127, "application/vnd.ecowin.chart");
        DefaultMIMETypes.addMIMEType((short)128, "application/vnd.ecowin.filerequest");
        DefaultMIMETypes.addMIMEType((short)129, "application/vnd.ecowin.fileupdate");
        DefaultMIMETypes.addMIMEType((short)130, "application/vnd.ecowin.series");
        DefaultMIMETypes.addMIMEType((short)131, "application/vnd.ecowin.seriesrequest");
        DefaultMIMETypes.addMIMEType((short)132, "application/vnd.ecowin.seriesupdate");
        DefaultMIMETypes.addMIMEType((short)133, "application/vnd.enliven");
        DefaultMIMETypes.addMIMEType((short)134, "application/vnd.epson.esf");
        DefaultMIMETypes.addMIMEType((short)135, "application/vnd.epson.msf");
        DefaultMIMETypes.addMIMEType((short)136, "application/vnd.epson.quickanime");
        DefaultMIMETypes.addMIMEType((short)137, "application/vnd.epson.salt");
        DefaultMIMETypes.addMIMEType((short)138, "application/vnd.epson.ssf");
        DefaultMIMETypes.addMIMEType((short)139, "application/vnd.ericsson.quickcall");
        DefaultMIMETypes.addMIMEType((short)140, "application/vnd.eudora.data");
        DefaultMIMETypes.addMIMEType((short)141, "application/vnd.fdf");
        DefaultMIMETypes.addMIMEType((short)142, "application/vnd.ffsns");
        DefaultMIMETypes.addMIMEType((short)143, "application/vnd.flographit");
        DefaultMIMETypes.addMIMEType((short)144, "application/vnd.framemaker");
        DefaultMIMETypes.addMIMEType((short)145, "application/vnd.fsc.weblaunch");
        DefaultMIMETypes.addMIMEType((short)146, "application/vnd.fujitsu.oasys");
        DefaultMIMETypes.addMIMEType((short)147, "application/vnd.fujitsu.oasys2");
        DefaultMIMETypes.addMIMEType((short)148, "application/vnd.fujitsu.oasys3");
        DefaultMIMETypes.addMIMEType((short)149, "application/vnd.fujitsu.oasysgp");
        DefaultMIMETypes.addMIMEType((short)150, "application/vnd.fujitsu.oasysprs");
        DefaultMIMETypes.addMIMEType((short)151, "application/vnd.fujixerox.ddd");
        DefaultMIMETypes.addMIMEType((short)152, "application/vnd.fujixerox.docuworks");
        DefaultMIMETypes.addMIMEType((short)153, "application/vnd.fujixerox.docuworks.binder");
        DefaultMIMETypes.addMIMEType((short)154, "application/vnd.fut-misnet");
        DefaultMIMETypes.addMIMEType((short)155, "application/vnd.grafeq");
        DefaultMIMETypes.addMIMEType((short)156, "application/vnd.groove-account");
        DefaultMIMETypes.addMIMEType((short)157, "application/vnd.groove-identity-message");
        DefaultMIMETypes.addMIMEType((short)158, "application/vnd.groove-injector");
        DefaultMIMETypes.addMIMEType((short)159, "application/vnd.groove-tool-message");
        DefaultMIMETypes.addMIMEType((short)160, "application/vnd.groove-tool-template");
        DefaultMIMETypes.addMIMEType((short)161, "application/vnd.groove-vcard");
        DefaultMIMETypes.addMIMEType((short)162, "application/vnd.hhe.lesson-player");
        DefaultMIMETypes.addMIMEType((short)163, "application/vnd.hp-HPGL");
        DefaultMIMETypes.addMIMEType((short)164, "application/vnd.hp-PCL");
        DefaultMIMETypes.addMIMEType((short)165, "application/vnd.hp-PCLXL");
        DefaultMIMETypes.addMIMEType((short)166, "application/vnd.hp-hpid");
        DefaultMIMETypes.addMIMEType((short)167, "application/vnd.hp-hps");
        DefaultMIMETypes.addMIMEType((short)168, "application/vnd.httphone");
        DefaultMIMETypes.addMIMEType((short)169, "application/vnd.hzn-3d-crossword");
        DefaultMIMETypes.addMIMEType((short)170, "application/vnd.ibm.MiniPay");
        DefaultMIMETypes.addMIMEType((short)171, "application/vnd.ibm.afplinedata");
        DefaultMIMETypes.addMIMEType((short)172, "application/vnd.ibm.modcap");
        DefaultMIMETypes.addMIMEType((short)173, "application/vnd.informix-visionary");
        DefaultMIMETypes.addMIMEType((short)174, "application/vnd.intercon.formnet");
        DefaultMIMETypes.addMIMEType((short)175, "application/vnd.intertrust.digibox");
        DefaultMIMETypes.addMIMEType((short)176, "application/vnd.intertrust.nncp");
        DefaultMIMETypes.addMIMEType((short)177, "application/vnd.intu.qbo");
        DefaultMIMETypes.addMIMEType((short)178, "application/vnd.intu.qfx");
        DefaultMIMETypes.addMIMEType((short)179, "application/vnd.irepository.package+xml");
        DefaultMIMETypes.addMIMEType((short)180, "application/vnd.is-xpr");
        DefaultMIMETypes.addMIMEType((short)181, "application/vnd.japannet-directory-service");
        DefaultMIMETypes.addMIMEType((short)182, "application/vnd.japannet-jpnstore-wakeup");
        DefaultMIMETypes.addMIMEType((short)183, "application/vnd.japannet-payment-wakeup");
        DefaultMIMETypes.addMIMEType((short)184, "application/vnd.japannet-registration");
        DefaultMIMETypes.addMIMEType((short)185, "application/vnd.japannet-registration-wakeup");
        DefaultMIMETypes.addMIMEType((short)186, "application/vnd.japannet-setstore-wakeup");
        DefaultMIMETypes.addMIMEType((short)187, "application/vnd.japannet-verification");
        DefaultMIMETypes.addMIMEType((short)188, "application/vnd.japannet-verification-wakeup");
        DefaultMIMETypes.addMIMEType((short)189, "application/vnd.koan");
        DefaultMIMETypes.addMIMEType((short)190, "application/vnd.lotus-1-2-3");
        DefaultMIMETypes.addMIMEType((short)191, "application/vnd.lotus-approach");
        DefaultMIMETypes.addMIMEType((short)192, "application/vnd.lotus-freelance");
        DefaultMIMETypes.addMIMEType((short)193, "application/vnd.lotus-notes");
        DefaultMIMETypes.addMIMEType((short)194, "application/vnd.lotus-organizer");
        DefaultMIMETypes.addMIMEType((short)195, "application/vnd.lotus-screencam");
        DefaultMIMETypes.addMIMEType((short)196, "application/vnd.lotus-wordpro");
        DefaultMIMETypes.addMIMEType((short)197, "application/vnd.mcd");
        DefaultMIMETypes.addMIMEType((short)198, "application/vnd.mediastation.cdkey");
        DefaultMIMETypes.addMIMEType((short)199, "application/vnd.meridian-slingshot");
        DefaultMIMETypes.addMIMEType((short)200, "application/vnd.mif");
        DefaultMIMETypes.addMIMEType((short)201, "application/vnd.minisoft-hp3000-save");
        DefaultMIMETypes.addMIMEType((short)202, "application/vnd.mitsubishi.misty-guard.trustweb");
        DefaultMIMETypes.addMIMEType((short)203, "application/vnd.mobius.daf");
        DefaultMIMETypes.addMIMEType((short)204, "application/vnd.mobius.dis");
        DefaultMIMETypes.addMIMEType((short)205, "application/vnd.mobius.msl");
        DefaultMIMETypes.addMIMEType((short)206, "application/vnd.mobius.plc");
        DefaultMIMETypes.addMIMEType((short)207, "application/vnd.mobius.txf");
        DefaultMIMETypes.addMIMEType((short)208, "application/vnd.motorola.flexsuite");
        DefaultMIMETypes.addMIMEType((short)209, "application/vnd.motorola.flexsuite.adsi");
        DefaultMIMETypes.addMIMEType((short)210, "application/vnd.motorola.flexsuite.fis");
        DefaultMIMETypes.addMIMEType((short)211, "application/vnd.motorola.flexsuite.gotap");
        DefaultMIMETypes.addMIMEType((short)212, "application/vnd.motorola.flexsuite.kmr");
        DefaultMIMETypes.addMIMEType((short)213, "application/vnd.motorola.flexsuite.ttc");
        DefaultMIMETypes.addMIMEType((short)214, "application/vnd.motorola.flexsuite.wem");
        DefaultMIMETypes.addMIMEType((short)215, "application/vnd.mozilla.xul+xml", "xul");
        DefaultMIMETypes.addMIMEType((short)216, "application/vnd.ms-artgalry");
        DefaultMIMETypes.addMIMEType((short)217, "application/vnd.ms-asf");
        DefaultMIMETypes.addMIMEType((short)218, "application/vnd.ms-excel", "xls xlb xlt");
        DefaultMIMETypes.addMIMEType((short)219, "application/vnd.ms-lrm");
        DefaultMIMETypes.addMIMEType((short)220, "application/vnd.ms-pki.seccat", "cat");
        DefaultMIMETypes.addMIMEType((short)221, "application/vnd.ms-pki.stl", "stl");
        DefaultMIMETypes.addMIMEType((short)222, "application/vnd.ms-powerpoint", "ppt pps");
        DefaultMIMETypes.addMIMEType((short)223, "application/vnd.ms-project");
        DefaultMIMETypes.addMIMEType((short)224, "application/vnd.ms-tnef");
        DefaultMIMETypes.addMIMEType((short)225, "application/vnd.ms-works");
        DefaultMIMETypes.addMIMEType((short)226, "application/vnd.mseq");
        DefaultMIMETypes.addMIMEType((short)227, "application/vnd.msign");
        DefaultMIMETypes.addMIMEType((short)228, "application/vnd.music-niff");
        DefaultMIMETypes.addMIMEType((short)229, "application/vnd.musician");
        DefaultMIMETypes.addMIMEType((short)230, "application/vnd.netfpx");
        DefaultMIMETypes.addMIMEType((short)231, "application/vnd.noblenet-directory");
        DefaultMIMETypes.addMIMEType((short)232, "application/vnd.noblenet-sealer");
        DefaultMIMETypes.addMIMEType((short)233, "application/vnd.noblenet-web");
        DefaultMIMETypes.addMIMEType((short)234, "application/vnd.novadigm.EDM");
        DefaultMIMETypes.addMIMEType((short)235, "application/vnd.novadigm.EDX");
        DefaultMIMETypes.addMIMEType((short)236, "application/vnd.novadigm.EXT");
        DefaultMIMETypes.addMIMEType((short)237, "application/vnd.oasis.opendocument.chart", "odc");
        DefaultMIMETypes.addMIMEType((short)238, "application/vnd.oasis.opendocument.database", "odb");
        DefaultMIMETypes.addMIMEType((short)239, "application/vnd.oasis.opendocument.formula", "odf");
        DefaultMIMETypes.addMIMEType((short)240, "application/vnd.oasis.opendocument.graphics", "odg");
        DefaultMIMETypes.addMIMEType((short)241, "application/vnd.oasis.opendocument.graphics-template", "otg");
        DefaultMIMETypes.addMIMEType((short)242, "application/vnd.oasis.opendocument.image", "odi");
        DefaultMIMETypes.addMIMEType((short)243, "application/vnd.oasis.opendocument.presentation", "odp");
        DefaultMIMETypes.addMIMEType((short)244, "application/vnd.oasis.opendocument.presentation-template", "otp");
        DefaultMIMETypes.addMIMEType((short)245, "application/vnd.oasis.opendocument.spreadsheet", "ods");
        DefaultMIMETypes.addMIMEType((short)246, "application/vnd.oasis.opendocument.spreadsheet-template", "ots");
        DefaultMIMETypes.addMIMEType((short)247, "application/vnd.oasis.opendocument.text", "odt");
        DefaultMIMETypes.addMIMEType((short)248, "application/vnd.oasis.opendocument.text-master", "odm");
        DefaultMIMETypes.addMIMEType((short)249, "application/vnd.oasis.opendocument.text-template", "ott");
        DefaultMIMETypes.addMIMEType((short)250, "application/vnd.oasis.opendocument.text-web", "oth");
        DefaultMIMETypes.addMIMEType((short)251, "application/vnd.osa.netdeploy");
        DefaultMIMETypes.addMIMEType((short)252, "application/vnd.palm");
        DefaultMIMETypes.addMIMEType((short)253, "application/vnd.pg.format");
        DefaultMIMETypes.addMIMEType((short)254, "application/vnd.pg.osasli");
        DefaultMIMETypes.addMIMEType((short)255, "application/vnd.powerbuilder6");
        DefaultMIMETypes.addMIMEType((short)256, "application/vnd.powerbuilder6-s");
        DefaultMIMETypes.addMIMEType((short)257, "application/vnd.powerbuilder7");
        DefaultMIMETypes.addMIMEType((short)258, "application/vnd.powerbuilder7-s");
        DefaultMIMETypes.addMIMEType((short)259, "application/vnd.powerbuilder75");
        DefaultMIMETypes.addMIMEType((short)260, "application/vnd.powerbuilder75-s");
        DefaultMIMETypes.addMIMEType((short)261, "application/vnd.previewsystems.box");
        DefaultMIMETypes.addMIMEType((short)262, "application/vnd.publishare-delta-tree");
        DefaultMIMETypes.addMIMEType((short)263, "application/vnd.pvi.ptid1");
        DefaultMIMETypes.addMIMEType((short)264, "application/vnd.pwg-xhtml-print+xml");
        DefaultMIMETypes.addMIMEType((short)265, "application/vnd.rapid");
        DefaultMIMETypes.addMIMEType((short)266, "application/vnd.rim.cod", "cod");
        DefaultMIMETypes.addMIMEType((short)267, "application/vnd.s3sms");
        DefaultMIMETypes.addMIMEType((short)268, "application/vnd.seemail");
        DefaultMIMETypes.addMIMEType((short)269, "application/vnd.shana.informed.formdata");
        DefaultMIMETypes.addMIMEType((short)270, "application/vnd.shana.informed.formtemplate");
        DefaultMIMETypes.addMIMEType((short)271, "application/vnd.shana.informed.interchange");
        DefaultMIMETypes.addMIMEType((short)272, "application/vnd.shana.informed.package");
        DefaultMIMETypes.addMIMEType((short)273, "application/vnd.smaf", "mmf");
        DefaultMIMETypes.addMIMEType((short)274, "application/vnd.sss-cod");
        DefaultMIMETypes.addMIMEType((short)275, "application/vnd.sss-dtf");
        DefaultMIMETypes.addMIMEType((short)276, "application/vnd.sss-ntf");
        DefaultMIMETypes.addMIMEType((short)277, "application/vnd.stardivision.calc", "sdc");
        DefaultMIMETypes.addMIMEType((short)278, "application/vnd.stardivision.draw", "sda");
        DefaultMIMETypes.addMIMEType((short)279, "application/vnd.stardivision.impress", "sdd sdp");
        DefaultMIMETypes.addMIMEType((short)280, "application/vnd.stardivision.math", "smf");
        DefaultMIMETypes.addMIMEType((short)281, "application/vnd.stardivision.writer", "sdw vor");
        DefaultMIMETypes.addMIMEType((short)282, "application/vnd.stardivision.writer-global", "sgl");
        DefaultMIMETypes.addMIMEType((short)283, "application/vnd.street-stream");
        DefaultMIMETypes.addMIMEType((short)284, "application/vnd.sun.xml.calc", "sxc");
        DefaultMIMETypes.addMIMEType((short)285, "application/vnd.sun.xml.calc.template", "stc");
        DefaultMIMETypes.addMIMEType((short)286, "application/vnd.sun.xml.draw", "sxd");
        DefaultMIMETypes.addMIMEType((short)287, "application/vnd.sun.xml.draw.template", "std");
        DefaultMIMETypes.addMIMEType((short)288, "application/vnd.sun.xml.impress", "sxi");
        DefaultMIMETypes.addMIMEType((short)289, "application/vnd.sun.xml.impress.template", "sti");
        DefaultMIMETypes.addMIMEType((short)290, "application/vnd.sun.xml.math", "sxm");
        DefaultMIMETypes.addMIMEType((short)291, "application/vnd.sun.xml.writer", "sxw");
        DefaultMIMETypes.addMIMEType((short)292, "application/vnd.sun.xml.writer.global", "sxg");
        DefaultMIMETypes.addMIMEType((short)293, "application/vnd.sun.xml.writer.template", "stw");
        DefaultMIMETypes.addMIMEType((short)294, "application/vnd.svd");
        DefaultMIMETypes.addMIMEType((short)295, "application/vnd.swiftview-ics");
        DefaultMIMETypes.addMIMEType((short)296, "application/vnd.symbian.install", "sis");
        DefaultMIMETypes.addMIMEType((short)297, "application/vnd.triscape.mxs");
        DefaultMIMETypes.addMIMEType((short)298, "application/vnd.trueapp");
        DefaultMIMETypes.addMIMEType((short)299, "application/vnd.truedoc");
        DefaultMIMETypes.addMIMEType((short)300, "application/vnd.tve-trigger");
        DefaultMIMETypes.addMIMEType((short)301, "application/vnd.ufdl");
        DefaultMIMETypes.addMIMEType((short)302, "application/vnd.uplanet.alert");
        DefaultMIMETypes.addMIMEType((short)303, "application/vnd.uplanet.alert-wbxml");
        DefaultMIMETypes.addMIMEType((short)304, "application/vnd.uplanet.bearer-choice");
        DefaultMIMETypes.addMIMEType((short)305, "application/vnd.uplanet.bearer-choice-wbxml");
        DefaultMIMETypes.addMIMEType((short)306, "application/vnd.uplanet.cacheop");
        DefaultMIMETypes.addMIMEType((short)307, "application/vnd.uplanet.cacheop-wbxml");
        DefaultMIMETypes.addMIMEType((short)308, "application/vnd.uplanet.channel");
        DefaultMIMETypes.addMIMEType((short)309, "application/vnd.uplanet.channel-wbxml");
        DefaultMIMETypes.addMIMEType((short)310, "application/vnd.uplanet.list");
        DefaultMIMETypes.addMIMEType((short)311, "application/vnd.uplanet.list-wbxml");
        DefaultMIMETypes.addMIMEType((short)312, "application/vnd.uplanet.listcmd");
        DefaultMIMETypes.addMIMEType((short)313, "application/vnd.uplanet.listcmd-wbxml");
        DefaultMIMETypes.addMIMEType((short)314, "application/vnd.uplanet.signal");
        DefaultMIMETypes.addMIMEType((short)315, "application/vnd.vcx");
        DefaultMIMETypes.addMIMEType((short)316, "application/vnd.vectorworks");
        DefaultMIMETypes.addMIMEType((short)317, "application/vnd.vidsoft.vidconference");
        DefaultMIMETypes.addMIMEType((short)318, "application/vnd.visio", "vsd");
        DefaultMIMETypes.addMIMEType((short)319, "application/vnd.vividence.scriptfile");
        DefaultMIMETypes.addMIMEType((short)320, "application/vnd.wap.sic");
        DefaultMIMETypes.addMIMEType((short)321, "application/vnd.wap.slc");
        DefaultMIMETypes.addMIMEType((short)322, "application/vnd.wap.wbxml", "wbxml");
        DefaultMIMETypes.addMIMEType((short)323, "application/vnd.wap.wmlc", "wmlc");
        DefaultMIMETypes.addMIMEType((short)324, "application/vnd.wap.wmlscriptc", "wmlsc");
        DefaultMIMETypes.addMIMEType((short)325, "application/vnd.webturbo");
        DefaultMIMETypes.addMIMEType((short)326, "application/vnd.wrq-hp3000-labelled");
        DefaultMIMETypes.addMIMEType((short)327, "application/vnd.wt.stf");
        DefaultMIMETypes.addMIMEType((short)328, "application/vnd.xara");
        DefaultMIMETypes.addMIMEType((short)329, "application/vnd.xfdl");
        DefaultMIMETypes.addMIMEType((short)330, "application/vnd.yellowriver-custom-menu");
        DefaultMIMETypes.addMIMEType((short)331, "application/x-123", "wk");
        DefaultMIMETypes.addMIMEType((short)332, "application/x-abiword", "abw");
        DefaultMIMETypes.addMIMEType((short)333, "application/x-apple-diskimage", "dmg");
        DefaultMIMETypes.addMIMEType((short)334, "application/x-bcpio", "bcpio");
        DefaultMIMETypes.addMIMEType((short)335, "application/x-bittorrent", "torrent");
        DefaultMIMETypes.addMIMEType((short)336, "application/x-cdf", "cdf");
        DefaultMIMETypes.addMIMEType((short)337, "application/x-cdlink", "vcd");
        DefaultMIMETypes.addMIMEType((short)338, "application/x-chess-pgn", "pgn");
        DefaultMIMETypes.addMIMEType((short)339, "application/x-core");
        DefaultMIMETypes.addMIMEType((short)340, "application/x-cpio", "cpio");
        DefaultMIMETypes.addMIMEType((short)341, "application/x-csh", "csh");
        DefaultMIMETypes.addMIMEType((short)342, "application/x-debian-package", "deb udeb");
        DefaultMIMETypes.addMIMEType((short)343, "application/x-director", "dcr dir dxr");
        DefaultMIMETypes.addMIMEType((short)344, "application/x-dms", "dms");
        DefaultMIMETypes.addMIMEType((short)345, "application/x-doom", "wad");
        DefaultMIMETypes.addMIMEType((short)346, "application/x-dvi", "dvi");
        DefaultMIMETypes.addMIMEType((short)347, "application/x-executable");
        DefaultMIMETypes.addMIMEType((short)348, "application/x-flac", "flac");
        DefaultMIMETypes.addMIMEType((short)349, "application/x-font", "pfa pfb gsf pcf pcf.Z");
        DefaultMIMETypes.addMIMEType((short)350, "application/x-freemind", "mm");
        DefaultMIMETypes.addMIMEType((short)351, "application/x-futuresplash", "spl");
        DefaultMIMETypes.addMIMEType((short)352, "application/x-gnumeric", "gnumeric");
        DefaultMIMETypes.addMIMEType((short)353, "application/x-go-sgf", "sgf");
        DefaultMIMETypes.addMIMEType((short)354, "application/x-graphing-calculator", "gcf");
        DefaultMIMETypes.addMIMEType((short)355, "application/x-gtar", "gtar tgz taz");
        DefaultMIMETypes.addMIMEType((short)356, "application/x-hdf", "hdf");
        DefaultMIMETypes.addMIMEType((short)357, "application/x-httpd-php", "phtml pht php");
        DefaultMIMETypes.addMIMEType((short)358, "application/x-httpd-php-source", "phps");
        DefaultMIMETypes.addMIMEType((short)359, "application/x-httpd-php3", "php3");
        DefaultMIMETypes.addMIMEType((short)360, "application/x-httpd-php3-preprocessed", "php3p");
        DefaultMIMETypes.addMIMEType((short)361, "application/x-httpd-php4", "php4");
        DefaultMIMETypes.addMIMEType((short)362, "application/x-ica", "ica");
        DefaultMIMETypes.addMIMEType((short)363, "application/x-internet-signup", "ins isp");
        DefaultMIMETypes.addMIMEType((short)364, "application/x-iphone", "iii");
        DefaultMIMETypes.addMIMEType((short)365, "application/x-iso9660-image", "iso");
        DefaultMIMETypes.addMIMEType((short)366, "application/x-java-applet");
        DefaultMIMETypes.addMIMEType((short)367, "application/x-java-bean");
        DefaultMIMETypes.addMIMEType((short)368, "application/x-java-jnlp-file", "jnlp");
        DefaultMIMETypes.addMIMEType((short)369, "application/x-javascript", "js");
        DefaultMIMETypes.addMIMEType((short)370, "application/x-jmol", "jmz");
        DefaultMIMETypes.addMIMEType((short)371, "application/x-kchart", "chrt");
        DefaultMIMETypes.addMIMEType((short)372, "application/x-kdelnk");
        DefaultMIMETypes.addMIMEType((short)373, "application/x-killustrator", "kil");
        DefaultMIMETypes.addMIMEType((short)374, "application/x-koan", "skp skd skt skm");
        DefaultMIMETypes.addMIMEType((short)375, "application/x-kpresenter", "kpr kpt");
        DefaultMIMETypes.addMIMEType((short)376, "application/x-kspread", "ksp");
        DefaultMIMETypes.addMIMEType((short)377, "application/x-kword", "kwd kwt");
        DefaultMIMETypes.addMIMEType((short)378, "application/x-latex", "latex");
        DefaultMIMETypes.addMIMEType((short)379, "application/x-lha", "lha");
        DefaultMIMETypes.addMIMEType((short)380, "application/x-lzh", "lzh");
        DefaultMIMETypes.addMIMEType((short)381, "application/x-lzx", "lzx");
        DefaultMIMETypes.addMIMEType((short)382, "application/x-maker", "frm maker frame fm fb book fbdoc");
        DefaultMIMETypes.addMIMEType((short)383, "application/x-mif", "mif");
        DefaultMIMETypes.addMIMEType((short)384, "application/x-ms-wmd", "wmd");
        DefaultMIMETypes.addMIMEType((short)385, "application/x-ms-wmz", "wmz");
        DefaultMIMETypes.addMIMEType((short)386, "application/x-msdos-program", "com exe bat dll");
        DefaultMIMETypes.addMIMEType((short)387, "application/x-msi", "msi");
        DefaultMIMETypes.addMIMEType((short)388, "application/x-netcdf", "nc");
        DefaultMIMETypes.addMIMEType((short)389, "application/x-ns-proxy-autoconfig", "pac");
        DefaultMIMETypes.addMIMEType((short)390, "application/x-nwc", "nwc");
        DefaultMIMETypes.addMIMEType((short)391, "application/x-object", "o");
        DefaultMIMETypes.addMIMEType((short)392, "application/x-oz-application", "oza");
        DefaultMIMETypes.addMIMEType((short)393, "application/x-pkcs7-certreqresp", "p7r");
        DefaultMIMETypes.addMIMEType((short)394, "application/x-pkcs7-crl", "crl");
        DefaultMIMETypes.addMIMEType((short)395, "application/x-python-code", "pyc pyo");
        DefaultMIMETypes.addMIMEType((short)396, "application/x-quicktimeplayer", "qtl");
        DefaultMIMETypes.addMIMEType((short)397, "application/x-redhat-package-manager", "rpm");
        DefaultMIMETypes.addMIMEType((short)398, "application/x-rx");
        DefaultMIMETypes.addMIMEType((short)399, "application/x-sh", "sh");
        DefaultMIMETypes.addMIMEType((short)400, "application/x-shar", "shar");
        DefaultMIMETypes.addMIMEType((short)401, "application/x-shellscript");
        DefaultMIMETypes.addMIMEType((short)402, "application/x-shockwave-flash", "swf swfl");
        DefaultMIMETypes.addMIMEType((short)403, "application/x-stuffit", "sit");
        DefaultMIMETypes.addMIMEType((short)404, "application/x-sv4cpio", "sv4cpio");
        DefaultMIMETypes.addMIMEType((short)405, "application/x-sv4crc", "sv4crc");
        DefaultMIMETypes.addMIMEType((short)406, "application/x-tar", "tar");
        DefaultMIMETypes.addMIMEType((short)407, "application/x-tcl", "tcl");
        DefaultMIMETypes.addMIMEType((short)408, "application/x-tex-gf", "gf");
        DefaultMIMETypes.addMIMEType((short)409, "application/x-tex-pk", "pk");
        DefaultMIMETypes.addMIMEType((short)410, "application/x-texinfo", "texinfo texi");
        DefaultMIMETypes.addMIMEType((short)411, "application/x-trash", "~ % bak old sik");
        DefaultMIMETypes.addMIMEType((short)412, "application/x-troff", "t tr roff");
        DefaultMIMETypes.addMIMEType((short)413, "application/x-troff-man", "man");
        DefaultMIMETypes.addMIMEType((short)414, "application/x-troff-me", "me");
        DefaultMIMETypes.addMIMEType((short)415, "application/x-troff-ms", "ms");
        DefaultMIMETypes.addMIMEType((short)416, "application/x-ustar", "ustar");
        DefaultMIMETypes.addMIMEType((short)417, "application/x-videolan");
        DefaultMIMETypes.addMIMEType((short)418, "application/x-wais-source", "src");
        DefaultMIMETypes.addMIMEType((short)419, "application/x-wingz", "wz");
        DefaultMIMETypes.addMIMEType((short)420, "application/x-x509-ca-cert", "crt");
        DefaultMIMETypes.addMIMEType((short)421, "application/x-xcf", "xcf");
        DefaultMIMETypes.addMIMEType((short)422, "application/x-xfig", "fig");
        DefaultMIMETypes.addMIMEType((short)423, "application/x-xpinstall", "xpi");
        DefaultMIMETypes.addMIMEType((short)424, "audio/32kadpcm");
        DefaultMIMETypes.addMIMEType((short)425, "audio/basic", "au snd");
        DefaultMIMETypes.addMIMEType((short)426, "audio/g.722.1");
        DefaultMIMETypes.addMIMEType((short)427, "audio/l16");
        DefaultMIMETypes.addMIMEType((short)428, "audio/midi", "mid midi kar");
        DefaultMIMETypes.addMIMEType((short)429, "audio/mp4a-latm");
        DefaultMIMETypes.addMIMEType((short)430, "audio/mpa-robust");
        DefaultMIMETypes.addMIMEType((short)431, "audio/mpeg", "mpga mpega mp2 mp3 m4a");
        DefaultMIMETypes.addMIMEType((short)432, "audio/mpegurl", "m3u");
        DefaultMIMETypes.addMIMEType((short)433, "audio/parityfec");
        DefaultMIMETypes.addMIMEType((short)434, "audio/prs.sid", "sid");
        DefaultMIMETypes.addMIMEType((short)435, "audio/telephone-event");
        DefaultMIMETypes.addMIMEType((short)436, "audio/tone");
        DefaultMIMETypes.addMIMEType((short)437, "audio/vnd.cisco.nse");
        DefaultMIMETypes.addMIMEType((short)438, "audio/vnd.cns.anp1");
        DefaultMIMETypes.addMIMEType((short)439, "audio/vnd.cns.inf1");
        DefaultMIMETypes.addMIMEType((short)440, "audio/vnd.digital-winds");
        DefaultMIMETypes.addMIMEType((short)441, "audio/vnd.everad.plj");
        DefaultMIMETypes.addMIMEType((short)442, "audio/vnd.lucent.voice");
        DefaultMIMETypes.addMIMEType((short)443, "audio/vnd.nortel.vbk");
        DefaultMIMETypes.addMIMEType((short)444, "audio/vnd.nuera.ecelp4800");
        DefaultMIMETypes.addMIMEType((short)445, "audio/vnd.nuera.ecelp7470");
        DefaultMIMETypes.addMIMEType((short)446, "audio/vnd.nuera.ecelp9600");
        DefaultMIMETypes.addMIMEType((short)447, "audio/vnd.octel.sbc");
        DefaultMIMETypes.addMIMEType((short)448, "audio/vnd.qcelp");
        DefaultMIMETypes.addMIMEType((short)449, "audio/vnd.rhetorex.32kadpcm");
        DefaultMIMETypes.addMIMEType((short)450, "audio/vnd.vmx.cvsd");
        DefaultMIMETypes.addMIMEType((short)451, "audio/x-aiff", "aif aiff aifc");
        DefaultMIMETypes.addMIMEType((short)452, "audio/x-gsm", "gsm");
        DefaultMIMETypes.addMIMEType((short)453, "audio/x-mpegurl", "m3u");
        DefaultMIMETypes.addMIMEType((short)454, "audio/x-ms-wma", "wma");
        DefaultMIMETypes.addMIMEType((short)455, "audio/x-ms-wax", "wax");
        DefaultMIMETypes.addMIMEType((short)456, "audio/x-pn-realaudio-plugin");
        DefaultMIMETypes.addMIMEType((short)457, "audio/x-pn-realaudio", "ra rm ram");
        DefaultMIMETypes.addMIMEType((short)458, "audio/x-realaudio", "ra");
        DefaultMIMETypes.addMIMEType((short)459, "audio/x-scpls", "pls");
        DefaultMIMETypes.addMIMEType((short)460, "audio/x-sd2", "sd2");
        DefaultMIMETypes.addMIMEType((short)461, "audio/x-wav", "wav");
        DefaultMIMETypes.addMIMEType((short)462, "chemical/x-alchemy", "alc");
        DefaultMIMETypes.addMIMEType((short)463, "chemical/x-cache", "cac cache");
        DefaultMIMETypes.addMIMEType((short)464, "chemical/x-cache-csf", "csf");
        DefaultMIMETypes.addMIMEType((short)465, "chemical/x-cactvs-binary", "cbin cascii ctab");
        DefaultMIMETypes.addMIMEType((short)466, "chemical/x-cdx", "cdx");
        DefaultMIMETypes.addMIMEType((short)467, "chemical/x-cerius", "cer");
        DefaultMIMETypes.addMIMEType((short)468, "chemical/x-chem3d", "c3d");
        DefaultMIMETypes.addMIMEType((short)469, "chemical/x-chemdraw", "chm");
        DefaultMIMETypes.addMIMEType((short)470, "chemical/x-cif", "cif");
        DefaultMIMETypes.addMIMEType((short)471, "chemical/x-cmdf", "cmdf");
        DefaultMIMETypes.addMIMEType((short)472, "chemical/x-cml", "cml");
        DefaultMIMETypes.addMIMEType((short)473, "chemical/x-compass", "cpa");
        DefaultMIMETypes.addMIMEType((short)474, "chemical/x-crossfire", "bsd");
        DefaultMIMETypes.addMIMEType((short)475, "chemical/x-csml", "csml csm");
        DefaultMIMETypes.addMIMEType((short)476, "chemical/x-ctx", "ctx");
        DefaultMIMETypes.addMIMEType((short)477, "chemical/x-cxf", "cxf cef");
        DefaultMIMETypes.addMIMEType((short)478, "chemical/x-embl-dl-nucleotide", "emb embl");
        DefaultMIMETypes.addMIMEType((short)479, "chemical/x-galactic-spc", "spc");
        DefaultMIMETypes.addMIMEType((short)480, "chemical/x-gamess-input", "inp gam gamin");
        DefaultMIMETypes.addMIMEType((short)481, "chemical/x-gaussian-checkpoint", "fch fchk");
        DefaultMIMETypes.addMIMEType((short)482, "chemical/x-gaussian-cube", "cub");
        DefaultMIMETypes.addMIMEType((short)483, "chemical/x-gaussian-input", "gau gjc gjf");
        DefaultMIMETypes.addMIMEType((short)484, "chemical/x-gaussian-log", "gal");
        DefaultMIMETypes.addMIMEType((short)485, "chemical/x-gcg8-sequence", "gcg");
        DefaultMIMETypes.addMIMEType((short)486, "chemical/x-genbank", "gen");
        DefaultMIMETypes.addMIMEType((short)487, "chemical/x-hin", "hin");
        DefaultMIMETypes.addMIMEType((short)488, "chemical/x-isostar", "istr ist");
        DefaultMIMETypes.addMIMEType((short)489, "chemical/x-jcamp-dx", "jdx dx");
        DefaultMIMETypes.addMIMEType((short)490, "chemical/x-kinemage", "kin");
        DefaultMIMETypes.addMIMEType((short)491, "chemical/x-macmolecule", "mcm");
        DefaultMIMETypes.addMIMEType((short)492, "chemical/x-macromodel-input", "mmd mmod");
        DefaultMIMETypes.addMIMEType((short)493, "chemical/x-mdl-molfile", "mol");
        DefaultMIMETypes.addMIMEType((short)494, "chemical/x-mdl-rdfile", "rd");
        DefaultMIMETypes.addMIMEType((short)495, "chemical/x-mdl-rxnfile", "rxn");
        DefaultMIMETypes.addMIMEType((short)496, "chemical/x-mdl-sdfile", "sd sdf");
        DefaultMIMETypes.addMIMEType((short)497, "chemical/x-mdl-tgf", "tgf");
        DefaultMIMETypes.addMIMEType((short)498, "chemical/x-mmcif", "mcif");
        DefaultMIMETypes.addMIMEType((short)499, "chemical/x-mol2", "mol2");
        DefaultMIMETypes.addMIMEType((short)500, "chemical/x-molconn-Z", "b");
        DefaultMIMETypes.addMIMEType((short)501, "chemical/x-mopac-graph", "gpt");
        DefaultMIMETypes.addMIMEType((short)502, "chemical/x-mopac-input", "mop mopcrt mpc dat zmt");
        DefaultMIMETypes.addMIMEType((short)503, "chemical/x-mopac-out", "moo");
        DefaultMIMETypes.addMIMEType((short)504, "chemical/x-mopac-vib", "mvb");
        DefaultMIMETypes.addMIMEType((short)505, "chemical/x-ncbi-asn1", "asn");
        DefaultMIMETypes.addMIMEType((short)506, "chemical/x-ncbi-asn1-ascii", "prt ent");
        DefaultMIMETypes.addMIMEType((short)507, "chemical/x-ncbi-asn1-binary", "val aso");
        DefaultMIMETypes.addMIMEType((short)508, "chemical/x-ncbi-asn1-spec", "asn");
        DefaultMIMETypes.addMIMEType((short)509, "chemical/x-pdb", "pdb ent");
        DefaultMIMETypes.addMIMEType((short)510, "chemical/x-rosdal", "ros");
        DefaultMIMETypes.addMIMEType((short)511, "chemical/x-swissprot", "sw");
        DefaultMIMETypes.addMIMEType((short)512, "chemical/x-vamas-iso14976", "vms");
        DefaultMIMETypes.addMIMEType((short)513, "chemical/x-vmd", "vmd");
        DefaultMIMETypes.addMIMEType((short)514, "chemical/x-xtel", "xtel");
        DefaultMIMETypes.addMIMEType((short)515, "chemical/x-xyz", "xyz");
        DefaultMIMETypes.addMIMEType((short)516, "image/cgm");
        DefaultMIMETypes.addMIMEType((short)517, "image/g3fax");
        DefaultMIMETypes.addMIMEType((short)518, "image/gif", "gif");
        DefaultMIMETypes.addMIMEType((short)519, "image/ief", "ief");
        DefaultMIMETypes.addMIMEType((short)520, "image/jpeg", "jpeg jpg jpe");
        DefaultMIMETypes.addMIMEType((short)521, "image/naplps");
        DefaultMIMETypes.addMIMEType((short)522, "image/pcx", "pcx");
        DefaultMIMETypes.addMIMEType((short)523, "image/png", "png");
        DefaultMIMETypes.addMIMEType((short)524, "image/prs.btif");
        DefaultMIMETypes.addMIMEType((short)525, "image/prs.pti");
        DefaultMIMETypes.addMIMEType((short)526, "image/svg+xml", "svg svgz");
        DefaultMIMETypes.addMIMEType((short)527, "image/tiff", "tiff tif");
        DefaultMIMETypes.addMIMEType((short)528, "image/vnd.cns.inf2");
        DefaultMIMETypes.addMIMEType((short)529, "image/vnd.djvu", "djvu djv");
        DefaultMIMETypes.addMIMEType((short)530, "image/vnd.dwg");
        DefaultMIMETypes.addMIMEType((short)531, "image/vnd.dxf");
        DefaultMIMETypes.addMIMEType((short)532, "image/vnd.fastbidsheet");
        DefaultMIMETypes.addMIMEType((short)533, "image/vnd.fpx");
        DefaultMIMETypes.addMIMEType((short)534, "image/vnd.fst");
        DefaultMIMETypes.addMIMEType((short)535, "image/vnd.fujixerox.edmics-mmr");
        DefaultMIMETypes.addMIMEType((short)536, "image/vnd.fujixerox.edmics-rlc");
        DefaultMIMETypes.addMIMEType((short)537, "image/vnd.mix");
        DefaultMIMETypes.addMIMEType((short)538, "image/vnd.net-fpx");
        DefaultMIMETypes.addMIMEType((short)539, "image/vnd.svf");
        DefaultMIMETypes.addMIMEType((short)540, "image/vnd.wap.wbmp", "wbmp");
        DefaultMIMETypes.addMIMEType((short)541, "image/vnd.xiff");
        DefaultMIMETypes.addMIMEType((short)542, "image/x-cmu-raster", "ras");
        DefaultMIMETypes.addMIMEType((short)543, "image/x-coreldraw", "cdr");
        DefaultMIMETypes.addMIMEType((short)544, "image/x-coreldrawpattern", "pat");
        DefaultMIMETypes.addMIMEType((short)545, "image/x-coreldrawtemplate", "cdt");
        DefaultMIMETypes.addMIMEType((short)546, "image/x-corelphotopaint", "cpt");
        DefaultMIMETypes.addMIMEType((short)547, "image/x-icon", "ico");
        DefaultMIMETypes.addMIMEType((short)548, "image/x-jg", "art");
        DefaultMIMETypes.addMIMEType((short)549, "image/x-jng", "jng");
        DefaultMIMETypes.addMIMEType((short)550, "image/x-ms-bmp", "bmp");
        DefaultMIMETypes.addMIMEType((short)551, "image/x-photoshop", "psd");
        DefaultMIMETypes.addMIMEType((short)552, "image/x-portable-anymap", "pnm");
        DefaultMIMETypes.addMIMEType((short)553, "image/x-portable-bitmap", "pbm");
        DefaultMIMETypes.addMIMEType((short)554, "image/x-portable-graymap", "pgm");
        DefaultMIMETypes.addMIMEType((short)555, "image/x-portable-pixmap", "ppm");
        DefaultMIMETypes.addMIMEType((short)556, "image/x-rgb", "rgb");
        DefaultMIMETypes.addMIMEType((short)557, "image/x-xbitmap", "xbm");
        DefaultMIMETypes.addMIMEType((short)558, "image/x-xpixmap", "xpm");
        DefaultMIMETypes.addMIMEType((short)559, "image/x-xwindowdump", "xwd");
        DefaultMIMETypes.addMIMEType((short)560, "inode/chardevice");
        DefaultMIMETypes.addMIMEType((short)561, "inode/blockdevice");
        DefaultMIMETypes.addMIMEType((short)562, "inode/directory-locked");
        DefaultMIMETypes.addMIMEType((short)563, "inode/directory");
        DefaultMIMETypes.addMIMEType((short)564, "inode/fifo");
        DefaultMIMETypes.addMIMEType((short)565, "inode/socket");
        DefaultMIMETypes.addMIMEType((short)566, "message/delivery-status");
        DefaultMIMETypes.addMIMEType((short)567, "message/disposition-notification");
        DefaultMIMETypes.addMIMEType((short)568, "message/external-body");
        DefaultMIMETypes.addMIMEType((short)569, "message/http");
        DefaultMIMETypes.addMIMEType((short)570, "message/s-http");
        DefaultMIMETypes.addMIMEType((short)571, "message/news");
        DefaultMIMETypes.addMIMEType((short)572, "message/partial");
        DefaultMIMETypes.addMIMEType((short)573, "message/rfc822");
        DefaultMIMETypes.addMIMEType((short)574, "model/iges", "igs iges");
        DefaultMIMETypes.addMIMEType((short)575, "model/mesh", "msh mesh silo");
        DefaultMIMETypes.addMIMEType((short)576, "model/vnd.dwf");
        DefaultMIMETypes.addMIMEType((short)577, "model/vnd.flatland.3dml");
        DefaultMIMETypes.addMIMEType((short)578, "model/vnd.gdl");
        DefaultMIMETypes.addMIMEType((short)579, "model/vnd.gs-gdl");
        DefaultMIMETypes.addMIMEType((short)580, "model/vnd.gtw");
        DefaultMIMETypes.addMIMEType((short)581, "model/vnd.mts");
        DefaultMIMETypes.addMIMEType((short)582, "model/vnd.vtu");
        DefaultMIMETypes.addMIMEType((short)583, "model/vrml", "wrl vrml");
        DefaultMIMETypes.addMIMEType((short)584, "multipart/alternative");
        DefaultMIMETypes.addMIMEType((short)585, "multipart/appledouble");
        DefaultMIMETypes.addMIMEType((short)586, "multipart/byteranges");
        DefaultMIMETypes.addMIMEType((short)587, "multipart/digest");
        DefaultMIMETypes.addMIMEType((short)588, "multipart/encrypted");
        DefaultMIMETypes.addMIMEType((short)589, "multipart/form-data");
        DefaultMIMETypes.addMIMEType((short)590, "multipart/header-set");
        DefaultMIMETypes.addMIMEType((short)591, "multipart/mixed");
        DefaultMIMETypes.addMIMEType((short)592, "multipart/parallel");
        DefaultMIMETypes.addMIMEType((short)593, "multipart/related");
        DefaultMIMETypes.addMIMEType((short)594, "multipart/report");
        DefaultMIMETypes.addMIMEType((short)595, "multipart/signed");
        DefaultMIMETypes.addMIMEType((short)596, "multipart/voice-message");
        DefaultMIMETypes.addMIMEType((short)597, "text/calendar", "ics icz");
        DefaultMIMETypes.addMIMEType((short)598, "text/comma-separated-values", "csv");
        DefaultMIMETypes.addMIMEType((short)599, "text/css", "css");
        DefaultMIMETypes.addMIMEType((short)600, "text/directory");
        DefaultMIMETypes.addMIMEType((short)601, "text/english");
        DefaultMIMETypes.addMIMEType((short)602, "text/enriched");
        DefaultMIMETypes.addMIMEType((short)603, "text/h323", "323");
        DefaultMIMETypes.addMIMEType((short)604, "text/html", "html htm shtml");
        DefaultMIMETypes.addMIMEType((short)605, "text/iuls", "uls");
        DefaultMIMETypes.addMIMEType((short)606, "text/mathml", "mml");
        DefaultMIMETypes.addMIMEType((short)607, "text/parityfec");
        DefaultMIMETypes.addMIMEType((short)608, "text/plain", "asc txt text diff pot");
        DefaultMIMETypes.addMIMEType((short)609, "text/prs.lines.tag");
        DefaultMIMETypes.addMIMEType((short)610, "text/x-psp", "psp");
        DefaultMIMETypes.addMIMEType((short)611, "text/rfc822-headers");
        DefaultMIMETypes.addMIMEType((short)612, "text/richtext", "rtx");
        DefaultMIMETypes.addMIMEType((short)613, "text/rtf", "rtf");
        DefaultMIMETypes.addMIMEType((short)614, "text/scriptlet", "sct wsc");
        DefaultMIMETypes.addMIMEType((short)615, "text/t140");
        DefaultMIMETypes.addMIMEType((short)616, "text/texmacs", "tm ts");
        DefaultMIMETypes.addMIMEType((short)617, "text/tab-separated-values", "tsv");
        DefaultMIMETypes.addMIMEType((short)618, "text/uri-list");
        DefaultMIMETypes.addMIMEType((short)619, "text/vnd.abc");
        DefaultMIMETypes.addMIMEType((short)620, "text/vnd.curl");
        DefaultMIMETypes.addMIMEType((short)621, "text/vnd.DMClientScript");
        DefaultMIMETypes.addMIMEType((short)622, "text/vnd.flatland.3dml");
        DefaultMIMETypes.addMIMEType((short)623, "text/vnd.fly");
        DefaultMIMETypes.addMIMEType((short)624, "text/vnd.fmi.flexstor");
        DefaultMIMETypes.addMIMEType((short)625, "text/vnd.in3d.3dml");
        DefaultMIMETypes.addMIMEType((short)626, "text/vnd.in3d.spot");
        DefaultMIMETypes.addMIMEType((short)627, "text/vnd.IPTC.NewsML");
        DefaultMIMETypes.addMIMEType((short)628, "text/vnd.IPTC.NITF");
        DefaultMIMETypes.addMIMEType((short)629, "text/vnd.latex-z");
        DefaultMIMETypes.addMIMEType((short)630, "text/vnd.motorola.reflex");
        DefaultMIMETypes.addMIMEType((short)631, "text/vnd.ms-mediapackage");
        DefaultMIMETypes.addMIMEType((short)632, "text/vnd.sun.j2me.app-descriptor", "jad");
        DefaultMIMETypes.addMIMEType((short)633, "text/vnd.wap.si");
        DefaultMIMETypes.addMIMEType((short)634, "text/vnd.wap.sl");
        DefaultMIMETypes.addMIMEType((short)635, "text/vnd.wap.wml", "wml");
        DefaultMIMETypes.addMIMEType((short)636, "text/vnd.wap.wmlscript", "wmls");
        DefaultMIMETypes.addMIMEType((short)637, "text/x-bibtex", "bib");
        DefaultMIMETypes.addMIMEType((short)638, "text/x-c++hdr", "h++ hpp hxx hh");
        DefaultMIMETypes.addMIMEType((short)639, "text/x-c++src", "c++ cpp cxx cc");
        DefaultMIMETypes.addMIMEType((short)640, "text/x-chdr", "h");
        DefaultMIMETypes.addMIMEType((short)641, "text/x-crontab");
        DefaultMIMETypes.addMIMEType((short)642, "text/x-csh", "csh");
        DefaultMIMETypes.addMIMEType((short)643, "text/x-csrc", "c");
        DefaultMIMETypes.addMIMEType((short)644, "text/x-haskell", "hs");
        DefaultMIMETypes.addMIMEType((short)645, "text/x-java", "java");
        DefaultMIMETypes.addMIMEType((short)646, "text/x-literate-haskell", "lhs");
        DefaultMIMETypes.addMIMEType((short)647, "text/x-makefile");
        DefaultMIMETypes.addMIMEType((short)648, "text/x-moc", "moc");
        DefaultMIMETypes.addMIMEType((short)649, "text/x-pascal", "p pas");
        DefaultMIMETypes.addMIMEType((short)650, "text/x-pcs-gcd", "gcd");
        DefaultMIMETypes.addMIMEType((short)651, "text/x-perl", "pl pm");
        DefaultMIMETypes.addMIMEType((short)652, "text/x-python", "py");
        DefaultMIMETypes.addMIMEType((short)653, "text/x-server-parsed-html");
        DefaultMIMETypes.addMIMEType((short)654, "text/x-setext", "etx");
        DefaultMIMETypes.addMIMEType((short)655, "text/x-sh", "sh");
        DefaultMIMETypes.addMIMEType((short)656, "text/x-tcl", "tcl tk");
        DefaultMIMETypes.addMIMEType((short)657, "text/x-tex", "tex ltx sty cls");
        DefaultMIMETypes.addMIMEType((short)658, "text/x-vcalendar", "vcs");
        DefaultMIMETypes.addMIMEType((short)659, "text/x-vcard", "vcf");
        DefaultMIMETypes.addMIMEType((short)660, "video/dl", "dl");
        DefaultMIMETypes.addMIMEType((short)661, "video/dv", "dif dv");
        DefaultMIMETypes.addMIMEType((short)662, "video/fli", "fli");
        DefaultMIMETypes.addMIMEType((short)663, "video/gl", "gl");
        DefaultMIMETypes.addMIMEType((short)664, "video/mpeg", "mpeg mpg mpe");
        DefaultMIMETypes.addMIMEType((short)665, "video/mp4", "mp4");
        DefaultMIMETypes.addMIMEType((short)666, "video/quicktime", "qt mov");
        DefaultMIMETypes.addMIMEType((short)667, "video/mp4v-es");
        DefaultMIMETypes.addMIMEType((short)668, "video/parityfec");
        DefaultMIMETypes.addMIMEType((short)669, "video/pointer");
        DefaultMIMETypes.addMIMEType((short)670, "video/vnd.fvt");
        DefaultMIMETypes.addMIMEType((short)671, "video/vnd.motorola.video");
        DefaultMIMETypes.addMIMEType((short)672, "video/vnd.motorola.videop");
        DefaultMIMETypes.addMIMEType((short)673, "video/vnd.mpegurl", "mxu");
        DefaultMIMETypes.addMIMEType((short)674, "video/vnd.mts");
        DefaultMIMETypes.addMIMEType((short)675, "video/vnd.nokia.interleaved-multimedia");
        DefaultMIMETypes.addMIMEType((short)676, "video/vnd.vivo");
        DefaultMIMETypes.addMIMEType((short)677, "video/x-la-asf", "lsf lsx");
        DefaultMIMETypes.addMIMEType((short)678, "video/x-mng", "mng");
        DefaultMIMETypes.addMIMEType((short)679, "video/x-ms-asf", "asf asx");
        DefaultMIMETypes.addMIMEType((short)680, "video/x-ms-wm", "wm");
        DefaultMIMETypes.addMIMEType((short)681, "video/x-ms-wmv", "wmv");
        DefaultMIMETypes.addMIMEType((short)682, "video/x-ms-wmx", "wmx");
        DefaultMIMETypes.addMIMEType((short)683, "video/x-ms-wvx", "wvx");
        DefaultMIMETypes.addMIMEType((short)684, "video/x-msvideo", "avi");
        DefaultMIMETypes.addMIMEType((short)685, "video/x-sgi-movie", "movie");
        DefaultMIMETypes.addMIMEType((short)686, "x-conference/x-cooltalk", "ice");
        DefaultMIMETypes.addMIMEType((short)687, "x-world/x-vrml", "vrm vrml wrl");
    }
}

