/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp;

import frost.fcp.FcpHandler;

public class FreenetKeys {
    private static String[] freenetKeyTypes = null;
    protected static final int KEYTYPE_CHK = 0;
    protected static final int KEYTYPE_KSK = 1;
    protected static final int KEYTYPE_SSK = 2;
    protected static final int KEYTYPE_USK = 3;
    protected static final int KEYLEN_05_CHK = 58;
    protected static final int KEYLEN_05_SSK_PUB = 35;
    protected static final int KEYLEN_05_SSK_PRIV = 31;
    protected static final int KEYLEN_05_SSK_PUB_LONG = 55;
    protected static final int KEYLEN_05_SSK_PRIV_LONG = 51;
    protected static final int KEYLEN_07_CHK = 99;
    protected static final int KEYLEN_07_SSK_PUB = 99;
    protected static final int KEYLEN_07_SSK_PRIV = 91;

    public static void initializeFor05() {
        freenetKeyTypes = new String[3];
        FreenetKeys.freenetKeyTypes[0] = "CHK@";
        FreenetKeys.freenetKeyTypes[1] = "KSK@";
        FreenetKeys.freenetKeyTypes[2] = "SSK@";
    }

    public static void initializeFor07() {
        freenetKeyTypes = new String[4];
        FreenetKeys.freenetKeyTypes[0] = "CHK@";
        FreenetKeys.freenetKeyTypes[1] = "KSK@";
        FreenetKeys.freenetKeyTypes[2] = "SSK@";
        FreenetKeys.freenetKeyTypes[3] = "USK@";
    }

    public static String[] getFreenetKeyTypes() {
        return freenetKeyTypes;
    }

    public static boolean isValidKey(String key) {
        if (key == null || key.length() < 5) {
            return false;
        }
        int keytype = -1;
        for (int i = 0; i < FreenetKeys.getFreenetKeyTypes().length; ++i) {
            if (!key.startsWith(FreenetKeys.getFreenetKeyTypes()[i])) continue;
            if (i == 1) {
                return true;
            }
            keytype = i;
            break;
        }
        if (keytype < 0) {
            return false;
        }
        int length = key.length();
        int pos = key.indexOf("/");
        if (pos > 0) {
            length -= length - pos;
        }
        boolean isKeyLenOk = false;
        if (FcpHandler.isFreenet05()) {
            if (keytype == 0) {
                if (length == 58) {
                    isKeyLenOk = true;
                }
            } else if (keytype == 2 && (length == 31 || length == 35 || length == 51 || length == 55 || length == 32 || length == 52 || length == 36 || length == 56)) {
                isKeyLenOk = true;
            }
        } else if (FcpHandler.isFreenet07()) {
            if (keytype == 0) {
                if (length == 99) {
                    isKeyLenOk = true;
                }
            } else if (!(keytype != 2 && keytype != 3 || length != 91 && length != 99)) {
                isKeyLenOk = true;
            }
        }
        return isKeyLenOk;
    }

    public static boolean isOld07ChkKey(String key) {
        if (key == null || key.length() < 4) {
            return false;
        }
        try {
            if (key.startsWith("CHK@")) {
                String s;
                int pos = key.indexOf(44);
                pos = key.indexOf(44, pos + 1);
                if ((s = key.substring(++pos, pos + 7)).startsWith("AAE")) {
                    return true;
                }
                if (s.startsWith("AAI")) {
                    return false;
                }
                return false;
            }
            return false;
        }
        catch (Throwable t) {
            return false;
        }
    }
}

