/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp05;

import freenet.support.Bucket;
import frost.fcp.DataNotFoundException;
import frost.fcp.FcpResultGet;
import frost.fcp.FcpToolsException;
import frost.fcp.NodeAddress;
import frost.fcp.fcp05.FcpKeyword;
import frost.fcp.fcp05.FecTools;
import frost.fcp.fcp05.FreenetKey;
import frost.util.FileAccess;
import frost.util.Logging;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.ConnectException;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpConnection {
    private static Logger logger = Logger.getLogger(FcpConnection.class.getName());
    private static final int TIMEOUT = 3600000;
    private final NodeAddress nodeAddress;
    private Socket fcpSock;
    private BufferedInputStream fcpIn;
    private PrintStream fcpOut;
    private static final byte[] header = new byte[]{0, 0, 0, 2};

    public FcpConnection(NodeAddress na) throws UnknownHostException, IOException {
        this.nodeAddress = na;
        this.doHandshake();
    }

    public void abortConnection() {
        if (this.fcpSock != null) {
            try {
                this.fcpSock.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public List<String> getNodeInfo() throws IOException {
        String tmp;
        ArrayList<String> result = new ArrayList<String>();
        this.fcpSock = new Socket(this.nodeAddress.getHost(), this.nodeAddress.getPort());
        this.fcpSock.setSoTimeout(3600000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        BufferedReader in = new BufferedReader(new InputStreamReader(this.fcpSock.getInputStream()));
        this.fcpOut.write(header, 0, header.length);
        this.fcpOut.println("ClientInfo");
        this.fcpOut.println("EndMessage");
        while ((tmp = in.readLine()).compareTo("EndMessage") != 0) {
            result.add(tmp);
            if (tmp.compareTo("EndMessage") != 0) continue;
        }
        in.close();
        this.fcpOut.close();
        this.fcpSock.close();
        if (result.isEmpty()) {
            logger.warning("No ClientInfo response!");
            return null;
        }
        return result;
    }

    public boolean getKeyToBucket(String keyString, Bucket bucket, int htl) throws IOException, FcpToolsException, InterruptedIOException {
        FreenetKey key = new FreenetKey(keyString);
        logger.fine("KeyString = " + keyString + "\n" + "Key =       " + key + "\n" + "KeyType =   " + key.getKeyType() + "\n" + "HTL =       " + htl);
        OutputStream fileOut = bucket.getOutputStream();
        this.fcpSock = new Socket(this.nodeAddress.getHost(), this.nodeAddress.getPort());
        this.fcpSock.setSoTimeout(3600000);
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpOut.write(header, 0, header.length);
        this.fcpOut.println("ClientGet");
        this.fcpOut.println("URI=" + key);
        this.fcpOut.println("HopsToLive=" + Integer.toHexString(htl));
        this.fcpOut.println("EndMessage");
        boolean receivedFinalByte = false;
        long totalDataLength = 0L;
        long metadataLength = 0L;
        int dataChunkLength = 0;
        boolean expectingData = false;
        boolean flagRestarted = false;
        boolean errorOccured = false;
        int integrityBufferSize = 0;
        while (!receivedFinalByte && !errorOccured) {
            int bytesRead;
            int count;
            if (!expectingData) {
                FcpKeyword kw = FcpKeyword.getFcpKeyword(this.fcpIn);
                switch (kw.getId()) {
                    case 5: {
                        if (!flagRestarted) break;
                        fileOut.close();
                        bucket.resetWrite();
                        fileOut = bucket.getOutputStream();
                        totalDataLength = 0L;
                        metadataLength = 0L;
                        dataChunkLength = 0;
                        flagRestarted = false;
                        break;
                    }
                    case 6: {
                        totalDataLength = kw.getLongVal();
                        integrityBufferSize = (int)totalDataLength;
                        if (totalDataLength == bucket.size()) break;
                        throw new IOException("Size of data is bigger than size of provided Bucket");
                    }
                    case 9: {
                        errorOccured = true;
                        break;
                    }
                    case 27: {
                        errorOccured = true;
                        break;
                    }
                    case 22: {
                        flagRestarted = true;
                        break;
                    }
                    case 7: {
                        this.fcpIn.close();
                        this.fcpOut.close();
                        this.fcpSock.close();
                        fileOut.close();
                        throw new DataNotFoundException();
                    }
                    case 23: {
                        errorOccured = true;
                        break;
                    }
                    case 28: {
                        errorOccured = true;
                        break;
                    }
                    case -1: {
                        errorOccured = true;
                        break;
                    }
                    case 15: {
                        metadataLength = kw.getLongVal();
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 14: {
                        dataChunkLength = (int)kw.getLongVal();
                        break;
                    }
                    case 3: {
                        expectingData = true;
                        break;
                    }
                }
                continue;
            }
            logger.fine("Expecting " + dataChunkLength + " bytes, " + totalDataLength + " total.");
            byte[] b = new byte[dataChunkLength];
            for (bytesRead = 0; bytesRead < dataChunkLength && (count = this.fcpIn.read(b, bytesRead, dataChunkLength - bytesRead)) >= 0; bytesRead += count) {
            }
            fileOut.write(b);
            expectingData = false;
            if ((totalDataLength -= (long)bytesRead) > 0L) continue;
            receivedFinalByte = true;
        }
        this.fcpIn.close();
        this.fcpOut.close();
        this.fcpSock.close();
        fileOut.close();
        if (receivedFinalByte) {
            if (metadataLength > 0L) {
                logger.severe("Unexpected metadata received in getKeyToBucket().");
                return false;
            }
            boolean valid = this.checkIntegrity(bucket, integrityBufferSize, keyString);
            if (!valid) {
                logger.warning("Invalid bucket received in getKeyToBucket(). Retrying.");
                return false;
            }
            return true;
        }
        return false;
    }

    private boolean checkIntegrity(Bucket bucket, int bucketSize, String chkKey) throws IOException {
        int length;
        InputStream fileIn = bucket.getInputStream();
        byte[] dataBuffer = new byte[bucketSize];
        int offset = 0;
        while ((length = fileIn.read(dataBuffer, offset, 262144)) > -1) {
            offset += length;
        }
        String generatedCHK = FecTools.generateCHK(dataBuffer);
        return chkKey.equalsIgnoreCase(generatedCHK);
    }

    public FcpResultGet getKeyToFile(String keyString, String filename, int htl, boolean fastDownload) throws IOException, FcpToolsException, InterruptedIOException {
        File checkSize;
        FreenetKey key = new FreenetKey(keyString);
        logger.fine("KeyString = " + keyString + "\n" + "Key =       " + key + "\n" + "KeyType =   " + key.getKeyType() + "\n" + "HTL =       " + htl);
        FileOutputStream fileOut = new FileOutputStream(filename);
        this.fcpSock = new Socket(this.nodeAddress.getHost(), this.nodeAddress.getPort());
        this.fcpSock.setSoTimeout(3600000);
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpOut.write(header, 0, header.length);
        this.fcpOut.println("ClientGet");
        this.fcpOut.println("URI=" + key);
        this.fcpOut.println("HopsToLive=" + Integer.toHexString(htl));
        this.fcpOut.println("EndMessage");
        boolean receivedFinalByte = false;
        long totalDataLength = 0L;
        long metadataLength = 0L;
        int dataChunkLength = 0;
        boolean expectingData = false;
        boolean flagRestarted = false;
        long expectedTotalDataLength = 0L;
        while (!receivedFinalByte) {
            int bytesRead;
            int count;
            if (!expectingData) {
                FcpKeyword kw = FcpKeyword.getFcpKeyword(this.fcpIn);
                logger.fine("FcpKeyword: " + kw + " for file " + filename);
                switch (kw.getId()) {
                    case 5: {
                        if (!flagRestarted) break;
                        fileOut.close();
                        new File(filename).delete();
                        fileOut = new FileOutputStream(filename);
                        totalDataLength = 0L;
                        expectedTotalDataLength = 0L;
                        metadataLength = 0L;
                        dataChunkLength = 0;
                        flagRestarted = false;
                        break;
                    }
                    case 6: {
                        expectedTotalDataLength = totalDataLength = kw.getLongVal();
                        break;
                    }
                    case 9: {
                        receivedFinalByte = true;
                        break;
                    }
                    case 27: {
                        receivedFinalByte = true;
                        break;
                    }
                    case 22: {
                        flagRestarted = true;
                        break;
                    }
                    case 7: {
                        this.fcpIn.close();
                        this.fcpOut.close();
                        this.fcpSock.close();
                        fileOut.close();
                        checkSize = new File(filename);
                        if (checkSize.length() == 0L) {
                            checkSize.delete();
                        }
                        throw new DataNotFoundException();
                    }
                    case 23: {
                        receivedFinalByte = true;
                        break;
                    }
                    case 28: {
                        receivedFinalByte = true;
                        break;
                    }
                    case -1: {
                        receivedFinalByte = true;
                        break;
                    }
                    case 15: {
                        metadataLength = kw.getLongVal();
                        break;
                    }
                    case 8: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 14: {
                        dataChunkLength = (int)kw.getLongVal();
                        break;
                    }
                    case 3: {
                        expectingData = true;
                        break;
                    }
                    case 30: {
                        if (!fastDownload) break;
                        receivedFinalByte = true;
                    }
                }
                continue;
            }
            logger.fine("Expecting " + dataChunkLength + " bytes, " + totalDataLength + " total.");
            byte[] b = new byte[dataChunkLength];
            for (bytesRead = 0; bytesRead < dataChunkLength && (count = this.fcpIn.read(b, bytesRead, dataChunkLength - bytesRead)) >= 0; bytesRead += count) {
            }
            fileOut.write(b);
            expectingData = false;
            if ((totalDataLength -= (long)bytesRead) > 0L) continue;
            receivedFinalByte = true;
        }
        this.fcpIn.close();
        this.fcpOut.close();
        this.fcpSock.close();
        fileOut.flush();
        fileOut.close();
        checkSize = new File(filename);
        if (Logging.inst().doLogFcp2Messages()) {
            System.out.print("expectedTotalDataLength=" + expectedTotalDataLength + "; filesize=" + checkSize.length() + "; mdlen=" + metadataLength);
        }
        FcpResultGet result = null;
        if (metadataLength > 0L && checkSize.length() > 0L) {
            result = new FcpResultGet(true);
            if (metadataLength == checkSize.length()) {
                byte[] content = FileAccess.readByteArray(checkSize);
                result.setRawMetadata(content);
                checkSize.delete();
                FileAccess.writeFile(new byte[0], checkSize);
            } else {
                byte[] content = FileAccess.readByteArray(checkSize);
                byte[] metadata = new byte[(int)metadataLength];
                System.arraycopy(content, 0, metadata, 0, (int)metadataLength);
                result.setRawMetadata(metadata);
                int datalen = (int)(checkSize.length() - metadataLength);
                byte[] rawdata = new byte[datalen];
                System.arraycopy(content, (int)metadataLength, rawdata, 0, datalen);
                FileAccess.writeFile(rawdata, checkSize);
            }
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("; finalFileSize=" + checkSize.length());
            }
        } else if (metadataLength == 0L && checkSize.length() == 0L) {
            result = new FcpResultGet(false);
            checkSize.delete();
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("; deleted!");
            }
        } else {
            result = new FcpResultGet(true);
            if (Logging.inst().doLogFcp2Messages()) {
                System.out.println("; finalFileSize=" + checkSize.length());
            }
        }
        return result;
    }

    public String putKeyFromArray(String key, byte[] data, byte[] metadata, int htl, boolean removeLocalKey) throws IOException {
        int c;
        this.fcpSock = new Socket(this.nodeAddress.getHost(), this.nodeAddress.getPort());
        this.fcpSock.setSoTimeout(3600000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        DataOutputStream dOut = new DataOutputStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut.write(header, 0, header.length);
        this.fcpOut.println("ClientPut");
        if (removeLocalKey) {
            this.fcpOut.println("RemoveLocalKey=true");
        }
        this.fcpOut.println("HopsToLive=" + Integer.toHexString(htl));
        this.fcpOut.println("URI=" + key);
        int dataLength = 0;
        int metadataLength = 0;
        if (data != null) {
            dataLength = data.length;
        }
        if (metadata != null) {
            metadataLength = metadata.length;
        }
        this.fcpOut.println("DataLength=" + Integer.toHexString(dataLength + metadataLength));
        if (metadata != null) {
            this.fcpOut.println("MetadataLength=" + Integer.toHexString(metadataLength));
        }
        this.fcpOut.println("Data");
        this.fcpOut.flush();
        if (metadata != null) {
            dOut.write(metadata);
        }
        if (data != null) {
            dOut.write(data);
        }
        dOut.flush();
        StringBuilder output = new StringBuilder();
        while ((c = this.fcpIn.read()) != -1) {
            output.append((char)c);
            if (output.toString().indexOf("EndMessage") == -1) continue;
            output.append('\u0000');
            if (output.indexOf("Pending") == -1 && output.indexOf("Restarted") == -1) break;
            output = new StringBuilder();
        }
        dOut.close();
        this.fcpOut.close();
        this.fcpIn.close();
        this.fcpSock.close();
        return output.toString();
    }

    public void doHandshake() throws IOException, ConnectException {
        FcpKeyword response;
        this.fcpSock = new Socket(this.nodeAddress.getHost(), this.nodeAddress.getPort());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpSock.setSoTimeout(3600000);
        this.fcpOut.write(header, 0, header.length);
        this.fcpOut.println("ClientHello");
        logger.fine("ClientHello");
        this.fcpOut.println("EndMessage");
        logger.fine("EndMessage");
        int timeout = 0;
        do {
            response = FcpKeyword.getFcpKeyword(this.fcpIn);
            logger.fine(response.getFullString());
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (response.getId() != 8 && ++timeout < 32);
        if (timeout == 32) {
            throw new ConnectException();
        }
        this.fcpSock.close();
    }

    public String[] getKeyPair() throws IOException {
        int c;
        this.fcpSock = new Socket(this.nodeAddress.getHost(), this.nodeAddress.getPort());
        this.fcpSock.setSoTimeout(3600000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut.write(header, 0, header.length);
        this.fcpOut.println("GenerateSVKPair");
        this.fcpOut.println("EndMessage");
        StringBuilder output = new StringBuilder();
        while ((c = this.fcpIn.read()) != -1) {
            output.append((char)c);
        }
        logger.fine(output.toString());
        this.fcpOut.close();
        this.fcpIn.close();
        this.fcpSock.close();
        String[] result = new String[]{"SSK@", "SSK@"};
        String outString = output.toString();
        int privateKeyPos = outString.indexOf("PrivateKey=");
        int publicKeyPos = outString.indexOf("PublicKey=");
        if (privateKeyPos != -1 && publicKeyPos != -1) {
            int privateKeyEnd = outString.indexOf(10, privateKeyPos += 11);
            int publicKeyEnd = outString.indexOf(10, publicKeyPos += 10);
            if (privateKeyEnd != -1 && publicKeyEnd != -1) {
                result[0] = result[0] + outString.substring(privateKeyPos, privateKeyEnd);
                result[1] = result[1] + outString.substring(publicKeyPos, publicKeyEnd) + "PAgM";
            }
        }
        return result;
    }
}

