/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp05;

import frost.fcp.fcp05.FcpFECUtilsSegmentHeader;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Vector;
import java.util.logging.Logger;

public class FcpFECUtils {
    static String description = "FEC file inserted by FROST";
    private static final Logger logger = Logger.getLogger(FcpFECUtils.class.getName());
    private InetAddress host;
    private int port;
    private Socket fcpSock;
    private BufferedInputStream fcpIn;
    private PrintStream fcpOut;

    public String FECMakeMetadata(Vector headers, Vector chunkMaps, Vector checkMaps, String mimeType) throws UnknownHostException, IOException, SocketException {
        String currentLine;
        String listString = "";
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(10000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        for (int i = 0; i < headers.size(); ++i) {
            FcpFECUtilsSegmentHeader header = (FcpFECUtilsSegmentHeader)headers.get(i);
            listString = listString + "SegmentHeader\n";
            listString = listString + header.reconstruct();
            listString = listString + "EndMessage\n";
            listString = listString + "BlockMap\n";
            String[][] chunkMap = (String[][])chunkMaps.get(i);
            for (int j = 0; j < chunkMap.length; ++j) {
                logger.fine("chunkMap: " + j + chunkMap[j][0] + " " + chunkMap[j][1]);
                listString = listString + "Block." + Integer.toHexString(j) + "=" + chunkMap[j][1] + "\n";
            }
            String[][] checkMap = (String[][])checkMaps.get(i);
            for (int j = 0; j < checkMap.length; ++j) {
                logger.fine("checkMap: " + j + checkMap[j][0] + " " + checkMap[j][1]);
                listString = listString + "Check." + Integer.toHexString(j) + "=" + checkMap[j][1] + "\n";
            }
            listString = listString + "EndMessage\n";
        }
        this.fcpOut.println("\u0000\u0000\u0000\u0002FECMakeMetadata");
        this.fcpOut.println("Segments=" + Integer.toHexString(headers.size()));
        this.fcpOut.println("Description=" + description);
        this.fcpOut.println("MimeType=Frost/FEC");
        this.fcpOut.println("DataLength=" + Integer.toHexString(listString.length()));
        this.fcpOut.println("Data");
        this.fcpOut.print(listString);
        int length = 0;
        int dataLength = 0;
        int currentRead = 0;
        byte[] buffer = null;
        do {
            currentLine = this.getLine(this.fcpIn).trim();
            logger.fine(currentLine);
            if (currentLine.startsWith("DataLength=")) {
                dataLength = Integer.parseInt(currentLine.split("=")[1], 16);
                buffer = new byte[dataLength];
                continue;
            }
            if (currentLine.equals("DataChunk")) continue;
            if (currentLine.startsWith("Length=")) {
                length = Integer.parseInt(currentLine.split("=")[1], 16);
                continue;
            }
            if (!currentLine.equals("Data")) continue;
            while (length > 0) {
                int thisread = this.fcpIn.read(buffer, currentRead, length);
                length -= thisread;
                currentRead += thisread;
            }
        } while (currentLine.length() > 0);
        return new String(buffer);
    }

    public Vector FECSegmentFile(String algorithm, long length) throws UnknownHostException, IOException, SocketException {
        String currentLine;
        FcpFECUtilsSegmentHeader currentHeader = null;
        String request = "\u0000\u0000\u0000\u0002FECSegmentFile\nAlgoName=" + algorithm + "\nFileLength=" + Long.toHexString(length) + "\nEndMessage\n";
        this.fcpSock = new Socket(this.host, this.port);
        this.fcpSock.setSoTimeout(10000);
        this.fcpOut = new PrintStream(this.fcpSock.getOutputStream());
        this.fcpIn = new BufferedInputStream(this.fcpSock.getInputStream());
        this.fcpOut.print(request);
        Vector<FcpFECUtilsSegmentHeader> outData = new Vector<FcpFECUtilsSegmentHeader>();
        do {
            if ((currentLine = this.getLine(this.fcpIn).trim()).equals("SegmentHeader")) {
                currentHeader = new FcpFECUtilsSegmentHeader();
                continue;
            }
            if (currentLine.equals("EndMessage")) {
                outData.add(currentHeader);
                currentHeader = null;
            }
            if (currentHeader == null) continue;
            currentHeader.insertValue(currentLine);
        } while (currentLine.length() > 0);
        this.fcpOut.close();
        this.fcpIn.close();
        this.fcpSock.close();
        return outData;
    }

    public String getLine(InputStream in) throws IOException {
        int b;
        byte[] bytes = new byte[64];
        for (int count = 0; (b = in.read()) != 10 && b != -1 && b != 0 && count < 64; ++count) {
            bytes[count] = (byte)b;
        }
        return new String(bytes).trim();
    }

    public FcpFECUtils(String node, int port) {
        try {
            this.host = InetAddress.getByName(node);
        }
        catch (UnknownHostException e) {
            try {
                this.host = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            }
            catch (UnknownHostException e2) {
                // empty catch block
            }
        }
        this.port = port;
        logger.info("Generated FcpFECUtils host " + this.host.getHostAddress());
    }
}

