/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp05;

import frost.Core;
import frost.MainFrame;
import frost.fcp.FcpResultPut;
import frost.fcp.fcp05.FcpConnection;
import frost.fcp.fcp05.FcpFactory;
import frost.fcp.fcp05.FecBlock;
import frost.fcp.fcp05.FecSplitfile;
import frost.fileTransfer.upload.FrostUploadItem;
import frost.util.FileAccess;
import frost.util.Mixed;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FcpInsert {
    private static final Logger logger = Logger.getLogger(FcpInsert.class.getName());
    public static final int smallestChunk = 786432;
    private static Map<String, Integer> putKeywords = null;

    private static Map<String, Integer> getKeywords() {
        if (putKeywords == null) {
            putKeywords = new HashMap<String, Integer>();
            putKeywords.put("Success", new Integer(1));
            putKeywords.put("RouteNotFound", new Integer(4));
            putKeywords.put("KeyCollision", new Integer(2));
            putKeywords.put("SizeError", new Integer(3));
            putKeywords.put("DataNotFound", new Integer(3));
        }
        return putKeywords;
    }

    private static FcpResultPut result(String text) {
        logger.info("*** FcpInsert.result: text='" + text + "'");
        if (text == null || text.length() == 0) {
            return FcpResultPut.ERROR_RESULT;
        }
        int result = 3;
        for (String keyword : FcpInsert.getKeywords().keySet()) {
            if (text.indexOf(keyword) < 0) continue;
            result = FcpInsert.getKeywords().get(keyword);
            break;
        }
        String chkKey = null;
        int pos = text.indexOf("CHK@");
        if (pos > -1) {
            chkKey = text.substring(pos);
            chkKey = chkKey.substring(0, chkKey.indexOf(10));
        }
        return new FcpResultPut(result, chkKey);
    }

    public static FcpResultPut putFile(String uri, File file, byte[] metadata, int htl, boolean doRedirect, boolean removeLocalKey, FrostUploadItem ulItem) {
        if (file.length() == 0L) {
            logger.log(Level.SEVERE, "Error: Can't upload empty file: " + file.getPath());
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "FcpInsert: File " + file.getPath() + " is empty!", "Warning", 2);
            return FcpResultPut.ERROR_RESULT;
        }
        long insertLength = file.length();
        if (metadata != null) {
            insertLength += (long)metadata.length;
        }
        if (insertLength > 32767L && (uri.startsWith("KSK@") || uri.startsWith("SSK@"))) {
            if (doRedirect) {
                return FcpInsert.putFECSplitFile(uri, file, htl, ulItem);
            }
            logger.log(Level.SEVERE, "Error: Data too large for direct KSK/SSK key, 32767 allowed: " + insertLength);
            JOptionPane.showMessageDialog(MainFrame.getInstance(), "<html>FcpInsert: Data of file " + file.getPath() + " too large for direct KSK key, 32767 allowed: " + insertLength + "<br>Please report this to a Frost developer!</html>", "Insert Error", 0);
            return FcpResultPut.ERROR_RESULT;
        }
        if (file.length() <= 786432L) {
            try {
                FcpConnection connection = FcpFactory.getFcpConnectionInstance();
                if (connection == null) {
                    return FcpResultPut.NO_CONNECTION_RESULT;
                }
                byte[] data = FileAccess.readByteArray(file);
                String output = FcpInsert.workaroundPutKeyFromArray(connection, uri, data, metadata, htl, removeLocalKey);
                return FcpInsert.result(output);
            }
            catch (UnknownHostException e) {
                logger.log(Level.SEVERE, "UnknownHostException", e);
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Throwable", e);
            }
            return FcpResultPut.ERROR_RESULT;
        }
        return FcpInsert.putFECSplitFile(uri, file, htl, ulItem);
    }

    private static String workaroundPutKeyFromArray(FcpConnection connection, String key, byte[] data, byte[] metadata, int htl, boolean removeLocalKey) throws IOException {
        String output;
        int loop = 0;
        int maxLoops = 16;
        while ((output = connection.putKeyFromArray(key, data, metadata, htl, removeLocalKey)).length() < 3) {
            if (loop < 16) {
                logger.warning("Freenet insert failed, maybe a freenet bug (output=" + output + "). Loop " + loop + ". Trying again...");
                ++loop;
                Mixed.wait(10000);
                continue;
            }
            logger.severe("Freenet insert failed due to freenet bug, tried " + loop + " times (output=" + output + ").");
            return null;
        }
        logger.info("Freenet insert ended, loop=" + loop + ", output from fcp insert : " + output);
        return output;
    }

    public static void updateProgress(FrostUploadItem ulItem) {
        if (ulItem == null || ulItem.getKey() == null) {
            return;
        }
        FecSplitfile splitfile = new FecSplitfile(ulItem.getFile());
        boolean alreadyEncoded = splitfile.uploadInit();
        if (!alreadyEncoded) {
            return;
        }
        int totalAvailableBlocks = splitfile.getDataBlocks().size() + splitfile.getCheckBlocks().size();
        int totalFinishedBlocks = 0;
        for (int segmentNo = 0; segmentNo < splitfile.getSegmentCount(); ++segmentNo) {
            FecSplitfile.SingleSegmentValues seginf = splitfile.getValuesForSegment(segmentNo);
            int blocksToUploadCount = 0;
            blocksToUploadCount += FcpInsert.getFecBlocksInSegmentWithState(splitfile.getDataBlocks(), segmentNo, 1).size();
            int segmentBlockCount = seginf.dataBlockCount + seginf.checkBlockCount;
            totalFinishedBlocks += segmentBlockCount - (blocksToUploadCount += FcpInsert.getFecBlocksInSegmentWithState(splitfile.getCheckBlocks(), segmentNo, 1).size());
        }
        splitfile.closeBuckets();
        ulItem.setTotalBlocks(totalAvailableBlocks);
        ulItem.setDoneBlocks(totalFinishedBlocks);
        ulItem.fireValueChanged();
    }

    private static FcpResultPut putFECSplitFile(String uri, File file, int htl, FrostUploadItem ulItem) {
        FcpConnection connection;
        FecSplitfile splitfile = null;
        splitfile = new FecSplitfile(file);
        boolean alreadyEncoded = splitfile.uploadInit();
        if (!alreadyEncoded) {
            try {
                splitfile.encode();
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Encoding failed", t);
                return FcpResultPut.ERROR_RESULT;
            }
        }
        logger.info("Starting upload of " + file.getName());
        int totalAvailableBlocks = splitfile.getDataBlocks().size() + splitfile.getCheckBlocks().size();
        int totalFinishedBlocks = 0;
        if (ulItem != null && ulItem.getKey() != null) {
            ulItem.setTotalBlocks(totalAvailableBlocks);
            ulItem.setDoneBlocks(0);
            ulItem.setState(4);
        }
        LinkedList<FecBlock> allBlocksToUpload = new LinkedList<FecBlock>();
        for (int segmentNo = 0; segmentNo < splitfile.getSegmentCount(); ++segmentNo) {
            FecSplitfile.SingleSegmentValues seginf = splitfile.getValuesForSegment(segmentNo);
            List<FecBlock> blocksToUpload = FcpInsert.getFecBlocksInSegmentWithState(splitfile.getDataBlocks(), segmentNo, 1);
            blocksToUpload.addAll(FcpInsert.getFecBlocksInSegmentWithState(splitfile.getCheckBlocks(), segmentNo, 1));
            int blocksToUploadCount = blocksToUpload.size();
            int segmentBlockCount = seginf.dataBlockCount + seginf.checkBlockCount;
            totalFinishedBlocks += segmentBlockCount - blocksToUploadCount;
            if (ulItem != null && ulItem.getKey() != null) {
                ulItem.setDoneBlocks(totalFinishedBlocks);
                ulItem.fireValueChanged();
            }
            if (blocksToUploadCount == 0) {
                logger.info("Segment " + segmentNo + " is already inserted");
                continue;
            }
            allBlocksToUpload.addAll(blocksToUpload);
        }
        ArrayList<PutKeyThread> runningThreads = new ArrayList<PutKeyThread>();
        while (allBlocksToUpload.size() > 0 || runningThreads.size() > 0) {
            boolean threadsFinished = false;
            for (int y = runningThreads.size() - 1; y >= 0; --y) {
                PutKeyThread pkt = (PutKeyThread)runningThreads.get(y);
                if (pkt.isAlive()) continue;
                if (pkt.getSuccess()) {
                    ++totalFinishedBlocks;
                    if (ulItem != null && ulItem.getKey() != null) {
                        ulItem.setDoneBlocks(totalFinishedBlocks);
                        ulItem.fireValueChanged();
                    }
                } else {
                    allBlocksToUpload.addLast(pkt.getBlock());
                }
                runningThreads.remove(y);
                threadsFinished = true;
            }
            if (threadsFinished) continue;
            int maxThreads = Core.frostSettings.getIntValue("splitfileUploadThreads");
            int maxThreadsNeeded = allBlocksToUpload.size();
            int threadCountAllowedToStart = maxThreads - runningThreads.size();
            if (maxThreadsNeeded > 0 && threadCountAllowedToStart > 0) {
                FecBlock block = (FecBlock)allBlocksToUpload.removeFirst();
                PutKeyThread thread = new PutKeyThread(splitfile, block, htl, uri);
                runningThreads.add(thread);
                thread.start();
                Mixed.waitRandom(3000);
                continue;
            }
            Mixed.wait(2500);
        }
        String chkKey = null;
        if (ulItem != null) {
            chkKey = ulItem.getKey();
        }
        boolean success = false;
        try {
            connection = FcpFactory.getFcpConnectionInstance();
        }
        catch (ConnectException e1) {
            connection = null;
        }
        if (connection == null) {
            logger.severe("Got no FcpConnection, redirect file can not be uploaded!");
        } else {
            try {
                byte[] metadata;
                try {
                    metadata = splitfile.getRedirectFileContent(false).getBytes("ISO-8859-1");
                }
                catch (UnsupportedEncodingException e) {
                    metadata = splitfile.getRedirectFileContent(false).getBytes();
                }
                String resultstr = FcpInsert.workaroundPutKeyFromArray(connection, uri, null, metadata, htl, true);
                FcpResultPut result = FcpInsert.result(resultstr);
                if (chkKey != null && result.getChkKey() != null && result.getChkKey().indexOf(chkKey) < 0) {
                    logger.severe("Error: the CHK keys for redirect file generated by frost and freenet differ:\nFreeNet Key ='" + result.getChkKey() + "'\n" + "Frost Key   ='" + chkKey + "'");
                    chkKey = result.getChkKey();
                } else if (chkKey == null) {
                    chkKey = result.getChkKey();
                }
                if (result.isSuccess() || result.isKeyCollision()) {
                    success = true;
                    splitfile.createRedirectFile(false);
                } else {
                    logger.severe("Could not upload redirect file: " + resultstr + " (" + result + ")");
                }
            }
            catch (Throwable e) {
                success = false;
                logger.log(Level.SEVERE, "Error uploading redirect file", e);
            }
        }
        splitfile.closeBuckets();
        if (ulItem == null) {
            splitfile.finishUpload(true);
        }
        if (success) {
            logger.info("Redirect successfully uploaded.");
            if (ulItem != null) {
                splitfile.finishUpload(false);
            }
            return new FcpResultPut(1, chkKey);
        }
        return FcpResultPut.ERROR_RESULT;
    }

    private static List<FecBlock> getFecBlocksInSegmentWithState(List<FecBlock> allBlocks, int segno, int state) {
        ArrayList<FecBlock> l = new ArrayList<FecBlock>();
        for (FecBlock b : allBlocks) {
            if (b.getSegmentNo() != segno || b.getCurrentState() != state) continue;
            l.add(b);
        }
        return l;
    }

    private static class PutKeyThread
    extends Thread {
        FecBlock block;
        int htl;
        boolean success;
        String uri;
        FecSplitfile splitfile;

        public PutKeyThread(FecSplitfile sf, FecBlock b, int h, String u) {
            this.block = b;
            this.htl = h;
            this.uri = u;
            this.splitfile = sf;
        }

        public void run() {
            FcpConnection connection;
            this.block.setCurrentState(2);
            this.success = false;
            try {
                connection = FcpFactory.getFcpConnectionInstance();
            }
            catch (ConnectException e1) {
                connection = null;
            }
            if (connection != null) {
                try {
                    String result = FcpInsert.workaroundPutKeyFromArray(connection, this.uri, this.block.getPaddedMemoryArray(), null, this.htl, true);
                    if (result.indexOf("Success") > -1 || result.indexOf("KeyCollision") > -1) {
                        this.success = true;
                    }
                }
                catch (Throwable e) {
                    logger.log(Level.WARNING, "Error during insert: ", e);
                    this.success = false;
                }
            }
            if (this.success) {
                this.block.setCurrentState(3);
                this.splitfile.createRedirectFile(true);
                this.block.close();
            } else {
                this.block.setCurrentState(1);
            }
        }

        public boolean getSuccess() {
            return this.success;
        }

        public synchronized FecBlock getBlock() {
            return this.block;
        }
    }
}

