/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp05;

import java.io.IOException;
import java.io.InputStream;
import java.util.logging.Logger;

public final class FcpKeyword {
    private static final Logger logger = Logger.getLogger(FcpKeyword.class.getName());
    public static final int UnknownError = -1;
    public static final int ClientGet = 0;
    public static final int ClientHello = 1;
    public static final int ClientPut = 2;
    public static final int Data = 3;
    public static final int DataChunk = 4;
    public static final int DataFound = 5;
    public static final int DataLength = 6;
    public static final int DataNotFound = 7;
    public static final int EndMessage = 8;
    public static final int FormatError = 9;
    public static final int GenerateCHK = 10;
    public static final int GenerateSVKPair = 11;
    public static final int HopsToLive = 12;
    public static final int KeyCollision = 13;
    public static final int Length = 14;
    public static final int MetadataLength = 15;
    public static final int NodeHello = 16;
    public static final int Node = 17;
    public static final int PrivateKey = 18;
    public static final int Protocol = 19;
    public static final int PublicKey = 20;
    public static final int Reason = 21;
    public static final int Restarted = 22;
    public static final int RouteNotFound = 23;
    public static final int SizeError = 24;
    public static final int Success = 25;
    public static final int URI = 26;
    public static final int URIError = 27;
    public static final int Failed = 28;
    public static final int ClientInfo = 29;
    public static final int Timeout = 30;
    private String fullString;
    private String keyword;
    private long longVal;
    private int kwId;

    public String toString() {
        return this.fullString;
    }

    public FcpKeyword(String s) {
        logger.fine("in " + s);
        this.fullString = s;
        this.keyword = FcpKeyword.getFcpKeyword(s);
        logger.fine("kw " + this.keyword);
        this.kwId = FcpKeyword.getFcpId(s);
        try {
            if (this.keyword != null && this.fullString != null) {
                if (this.keyword.length() < this.fullString.length()) {
                    String number = s.substring(this.keyword.length() + 1);
                    logger.fine("Getting longval for *" + number + "*");
                    this.longVal = Long.parseLong(number, 16);
                } else {
                    this.longVal = -1L;
                }
            }
        }
        catch (NumberFormatException e) {
            this.longVal = -1L;
        }
    }

    private static int getFcpId(String s) {
        if (s.startsWith("ClientGet")) {
            return 0;
        }
        if (s.startsWith("ClientHello")) {
            return 1;
        }
        if (s.startsWith("ClientPut")) {
            return 2;
        }
        if (s.startsWith("DataChunk")) {
            return 4;
        }
        if (s.startsWith("DataFound")) {
            return 5;
        }
        if (s.startsWith("DataLength")) {
            return 6;
        }
        if (s.startsWith("DataNotFound")) {
            return 7;
        }
        if (s.startsWith("Data")) {
            return 3;
        }
        if (s.startsWith("EndMessage")) {
            return 8;
        }
        if (s.startsWith("FormatError")) {
            return 9;
        }
        if (s.startsWith("GenerateCHK")) {
            return 10;
        }
        if (s.startsWith("GenerateSVKPair")) {
            return 11;
        }
        if (s.startsWith("HopsToLive")) {
            return 12;
        }
        if (s.startsWith("KeyCollision")) {
            return 13;
        }
        if (s.startsWith("Length")) {
            return 14;
        }
        if (s.startsWith("MetadataLength")) {
            return 15;
        }
        if (s.startsWith("NodeHello")) {
            return 16;
        }
        if (s.startsWith("Node")) {
            return 17;
        }
        if (s.startsWith("PrivateKey")) {
            return 18;
        }
        if (s.startsWith("Protocol")) {
            return 19;
        }
        if (s.startsWith("PublicKey")) {
            return 20;
        }
        if (s.startsWith("Reason")) {
            return 21;
        }
        if (s.startsWith("Restarted")) {
            return 22;
        }
        if (s.startsWith("RouteNotFound")) {
            return 23;
        }
        if (s.startsWith("SizeError")) {
            return 24;
        }
        if (s.startsWith("Success")) {
            return 25;
        }
        if (s.startsWith("URIError")) {
            return 27;
        }
        if (s.startsWith("URI")) {
            return 26;
        }
        if (s.startsWith("Failed")) {
            return 28;
        }
        if (s.startsWith("ClientInfo")) {
            return 29;
        }
        if (s.startsWith("Timeout")) {
            return 30;
        }
        return -1;
    }

    private static String getFcpKeyword(String s) {
        if (s.startsWith("Timeout")) {
            return "Timeout";
        }
        if (s.startsWith("ClientGet")) {
            return "ClientGet";
        }
        if (s.startsWith("ClientHello")) {
            return "ClientHello";
        }
        if (s.startsWith("ClientPut")) {
            return "ClientPut";
        }
        if (s.startsWith("DataChunk")) {
            return "DataChunk";
        }
        if (s.startsWith("DataFound")) {
            return "DataFound";
        }
        if (s.startsWith("DataLength")) {
            return "DataLength";
        }
        if (s.startsWith("DataNotFound")) {
            return "DataNotFound";
        }
        if (s.startsWith("Data")) {
            return "Data";
        }
        if (s.startsWith("EndMessage")) {
            return "EndMessage";
        }
        if (s.startsWith("FormatError")) {
            return "FormatError";
        }
        if (s.startsWith("GenerateCHK")) {
            return "GenerateCHK";
        }
        if (s.startsWith("GenerateSVKPair")) {
            return "GenerateSVKPair";
        }
        if (s.startsWith("HopsToLive")) {
            return "HopsToLive";
        }
        if (s.startsWith("KeyCollision")) {
            return "KeyCollision";
        }
        if (s.startsWith("Length")) {
            return "Length";
        }
        if (s.startsWith("MetadataLength")) {
            return "MetadataLength";
        }
        if (s.startsWith("NodeHello")) {
            return "NodeHello";
        }
        if (s.startsWith("Node")) {
            return "Node";
        }
        if (s.startsWith("PrivateKey")) {
            return "PrivateKey";
        }
        if (s.startsWith("Protocol")) {
            return "Protocol";
        }
        if (s.startsWith("PublicKey")) {
            return "PublicKey";
        }
        if (s.startsWith("Reason")) {
            return "Reason";
        }
        if (s.startsWith("Restarted")) {
            return "Restarted";
        }
        if (s.startsWith("RouteNotFound")) {
            return "RouteNotFound";
        }
        if (s.startsWith("SizeError")) {
            return "SizeError";
        }
        if (s.startsWith("Success")) {
            return "Success";
        }
        if (s.startsWith("URIError")) {
            return "URIError";
        }
        if (s.startsWith("URI")) {
            return "URI";
        }
        if (s.startsWith("Failed")) {
            return "Failed";
        }
        return null;
    }

    public static FcpKeyword getFcpKeyword(InputStream in) throws IOException {
        int b;
        int count;
        byte[] bytes = new byte[256];
        for (count = 0; (b = in.read()) != 10 && b != -1 && count < 256 && b != 0; ++count) {
            bytes[count] = (byte)b;
        }
        return new FcpKeyword(new String(bytes, 0, count));
    }

    public long getLongVal() {
        return this.longVal;
    }

    public int getId() {
        return this.kwId;
    }

    public String getFullString() {
        return this.fullString;
    }

    public String getStringVal() {
        return this.fullString.substring(this.keyword.length());
    }
}

