/*
 * Decompiled with CFR 0.152.
 */
package frost.fcp.fcp05;

import fecimpl.OnionFECBase;
import fecimpl.OnionFECDecoder;
import fecimpl.OnionFECEncoder;
import freenet.support.Bucket;
import freenet.support.BucketFactory;
import freenet.support.RandomAccessFileBucket;
import freenet.support.RandomAccessFileBucket2;
import frost.Core;
import frost.fcp.fcp05.FecBlock;
import frost.fcp.fcp05.FecTools;
import frost.util.FileAccess;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FecSplitfile {
    public static final int MODE_UPLOAD = 1;
    public static final int MODE_DOWNLOAD = 2;
    public static final int MODE_FINISHED = 3;
    private static final String FROST_TRANSFER_INDICATOR = "namespace.frost.transferInProgress";
    private static final String FROST_TRANSFER_FINISHED_INDICATOR = "namespace.frost.transferFinished.";
    public static final String FILE_CHECKBLOCKS_EXTENSION = ".checkblocks";
    public static final String FILE_DATA_EXTENSION = ".data";
    public static final String FILE_REDIRECT_EXTENSION = ".redirect";
    private static Logger logger = Logger.getLogger(FecSplitfile.class.getName());
    protected int transferMode;
    protected ArrayList<SingleSegmentValues> segmentValues;
    protected File dataFile;
    protected long dataFileSize;
    protected File checkBlocksFile;
    protected long checkBlocksFileSize;
    protected File redirectFile;
    protected int fileDataBlockCount;
    protected int fileCheckBlockCount;
    protected File downloadTargetFile;
    protected OnionFECEncoder encoder = null;
    protected FrostFECEncodeBucketFactory fecEncodeFactory = null;
    protected OnionFECDecoder decoder = null;
    protected FrostFECDecodeBucketFactory fecDecodeFactory = null;
    protected ArrayList<FecBlock> dataBlocks;
    protected ArrayList<FecBlock> checkBlocks;

    public FecSplitfile(File downloadFile, File redirectFile) throws IllegalStateException, Exception {
        this.transferMode = 2;
        this.downloadTargetFile = downloadFile;
        this.dataFile = new File(this.downloadTargetFile.getPath() + FILE_DATA_EXTENSION);
        this.redirectFile = redirectFile;
        this.checkBlocksFile = new File(this.downloadTargetFile.getPath() + FILE_CHECKBLOCKS_EXTENSION);
        this.initFromRedirectFile();
    }

    public FecSplitfile(File uploadFile) {
        this.transferMode = 1;
        this.dataFile = uploadFile;
        this.dataFileSize = uploadFile.length();
        this.encoder = new OnionFECEncoder();
        this.fecEncodeFactory = new FrostFECEncodeBucketFactory();
        this.encoder.init(this.dataFileSize, this.fecEncodeFactory);
        this.fillSegmentValues(this.encoder);
        String filename = FecSplitfile.convertUploadFilename(uploadFile);
        this.checkBlocksFile = new File(filename + FILE_CHECKBLOCKS_EXTENSION);
        this.redirectFile = new File(filename + FILE_REDIRECT_EXTENSION);
    }

    public static String convertUploadFilename(File uploadFile) {
        int pos;
        String filename = uploadFile.getPath();
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") >= 0 && (pos = filename.indexOf(":")) > -1) {
            String newfilename;
            filename = newfilename = filename.substring(0, pos) + filename.substring(pos + 1);
        }
        filename = filename.replace(File.separatorChar, '_');
        filename = Core.frostSettings.getValue("localdata.dir") + "_" + filename;
        return filename;
    }

    protected void initFromRedirectFile() throws IllegalStateException, Exception {
        String isBlockFinished;
        FecBlock b;
        String blockParameter;
        int x;
        long fileSize;
        int checkBlockCount;
        int dataBlockCount;
        List<String> lines = FileAccess.readLines(this.redirectFile);
        if (lines.size() == 0) {
            throw new IllegalStateException("Empty redirect file");
        }
        String v1 = FecSplitfile.getValue(lines, "SplitFile.BlockCount");
        String v2 = FecSplitfile.getValue(lines, "SplitFile.CheckBlockCount");
        String v3 = FecSplitfile.getValue(lines, "SplitFile.Size");
        try {
            dataBlockCount = Integer.parseInt(v1, 16);
            checkBlockCount = Integer.parseInt(v2, 16);
            fileSize = Long.parseLong(v3, 16);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "ERROR: One of the following 3 values is invalid in received redirect file:\n(SplitFile.BlockCount='" + v1 + "')\n" + "(SplitFile.CheckBlockCount='" + v2 + "')\n" + "(SplitFile.Size='" + v3 + "')", e);
            throw new IllegalStateException("Could not parse block count from redirect file: " + e.getMessage());
        }
        if (dataBlockCount == 0 || fileSize == 0L) {
            throw new IllegalStateException("Invalid data block count of 0");
        }
        if (this.transferMode == 2) {
            this.dataFileSize = fileSize;
            this.decoder = new OnionFECDecoder();
            this.fecDecodeFactory = new FrostFECDecodeBucketFactory();
            this.decoder.init(this.dataFileSize, this.fecDecodeFactory);
            this.fillSegmentValues(this.decoder);
        } else if (this.transferMode == 1) {
            this.encoder = new OnionFECEncoder();
            this.fecEncodeFactory = new FrostFECEncodeBucketFactory();
            this.encoder.init(this.dataFileSize, this.fecEncodeFactory);
            this.fillSegmentValues(this.encoder);
        } else {
            throw new IllegalStateException("transferMode is invalid");
        }
        if (this.fileDataBlockCount != dataBlockCount || this.fileCheckBlockCount != checkBlockCount) {
            throw new IllegalStateException("Block counts from redirect file and from decoder do not match");
        }
        boolean transferContinues = FecSplitfile.getValue(lines, FROST_TRANSFER_INDICATOR).toLowerCase().equals("true");
        if (!transferContinues && this.transferMode == 2) {
            boolean created;
            long addedDataBlockSize = 0L;
            for (int x2 = 0; x2 < this.getSegmentCount(); ++x2) {
                SingleSegmentValues seginf = this.getValuesForSegment(x2);
                addedDataBlockSize += (long)(seginf.dataBlockCount * seginf.dataBlockSize);
            }
            logger.info("First time download, create target files");
            if (!this.dataFile.isFile() || this.dataFileSize != addedDataBlockSize) {
                this.dataFile.delete();
                created = this.createFileOfLength(this.dataFile, addedDataBlockSize);
                if (!created) {
                    throw new Exception("Could not create the data file");
                }
            }
            if (!this.checkBlocksFile.isFile() || this.checkBlocksFileSize != this.checkBlocksFile.length()) {
                this.checkBlocksFile.delete();
                created = this.createFileOfLength(this.checkBlocksFile, this.checkBlocksFileSize);
                if (!created) {
                    throw new Exception("Could not create the checkblocks file");
                }
            }
        }
        logger.info("Reading CHK keys from redirect file");
        this.buildFecBlocks(false);
        for (x = 0; x < this.fileDataBlockCount; ++x) {
            blockParameter = "SplitFile.Block." + Integer.toHexString(x + 1);
            String blockChk = FecSplitfile.getValue(lines, blockParameter);
            if (blockChk == null) {
                throw new IllegalStateException("Redirect file contains an invalid CHK for a data block");
            }
            b = this.dataBlocks.get(x);
            if (b == null || b.getIndexInFile() != x) {
                throw new IllegalStateException("Could not find the data block");
            }
            if (blockChk.length() < 58) {
                b.setCurrentState(4);
                if (blockChk.indexOf("Error") < 0) {
                    logger.warning("Warning: Found invalid key in redirect file: " + blockChk);
                }
                blockChk = null;
            } else if (transferContinues && (isBlockFinished = FecSplitfile.getValue(lines, FROST_TRANSFER_FINISHED_INDICATOR + blockParameter)) != null && isBlockFinished.toLowerCase().equals("true")) {
                b.setCurrentState(3);
            }
            b.setChkKey(blockChk);
        }
        for (x = 0; x < this.fileCheckBlockCount; ++x) {
            blockParameter = "SplitFile.CheckBlock." + Integer.toHexString(x + 1);
            String blockChk = FecSplitfile.getValue(lines, blockParameter);
            if (blockChk == null) {
                throw new IllegalStateException("Redirect file contains an invalid CHK for a check block");
            }
            b = this.checkBlocks.get(x);
            if (b == null || b.getIndexInFile() != x) {
                throw new IllegalStateException("Could not find the checkBlock");
            }
            if (blockChk.length() < 58) {
                b.setCurrentState(4);
                if (blockChk.indexOf("Error") < 0) {
                    logger.warning("Warning: Found invalid key in redirect file: " + blockChk);
                }
                blockChk = null;
            } else if (transferContinues && (isBlockFinished = FecSplitfile.getValue(lines, FROST_TRANSFER_FINISHED_INDICATOR + blockParameter)) != null && isBlockFinished.toLowerCase().equals("true")) {
                b.setCurrentState(3);
            }
            b.setChkKey(blockChk);
        }
        logger.info("Download prepared");
    }

    public boolean isDecodeable(int segmentNo) {
        FecBlock b;
        int x;
        SingleSegmentValues segval = this.segmentValues.get(segmentNo);
        int neededBlocks = segval.dataBlockCount;
        int providedBlocks = 0;
        for (x = 0; x < this.dataBlocks.size(); ++x) {
            b = this.dataBlocks.get(x);
            if (b.getSegmentNo() != segmentNo || b.getCurrentState() != 3) continue;
            ++providedBlocks;
        }
        for (x = 0; x < this.checkBlocks.size(); ++x) {
            b = this.checkBlocks.get(x);
            if (b.getSegmentNo() != segmentNo || b.getCurrentState() != 3) continue;
            ++providedBlocks;
        }
        return providedBlocks >= neededBlocks;
    }

    public boolean isDecodeNeeded(int segmentNo) {
        SingleSegmentValues segval = this.segmentValues.get(segmentNo);
        int neededBlocks = segval.dataBlockCount;
        int providedBlocks = 0;
        for (int x = 0; x < this.dataBlocks.size(); ++x) {
            FecBlock b = this.dataBlocks.get(x);
            if (b.getSegmentNo() != segmentNo || b.getCurrentState() != 3) continue;
            ++providedBlocks;
        }
        return providedBlocks < neededBlocks;
    }

    public void decode(int segmentNo) throws Throwable {
        FecBlock b;
        int x;
        if (!this.isDecodeNeeded(segmentNo)) {
            return;
        }
        if (!this.isDecodeable(segmentNo)) {
            throw new IllegalStateException("Can't decode the segment, too less blocks provided");
        }
        logger.info("Starting to decode segment " + segmentNo);
        SingleSegmentValues segval = this.segmentValues.get(segmentNo);
        int dataBlocksInSegment = segval.dataBlockCount;
        this.decoder.setSegment(segmentNo);
        ArrayList<Integer> requestedDataBlocksIxList = new ArrayList<Integer>();
        ArrayList<RandomAccessFileBucket> requestedDataBlocksBucketList = new ArrayList<RandomAccessFileBucket>();
        for (x = 0; x < this.dataBlocks.size(); ++x) {
            b = this.dataBlocks.get(x);
            if (b.getSegmentNo() != segmentNo) continue;
            if (b.getCurrentState() == 3) {
                this.decoder.putBucket(b.getRandomAccessFileBucket(true), b.getIndexInSegment());
                continue;
            }
            requestedDataBlocksIxList.add(new Integer(b.getIndexInSegment()));
            requestedDataBlocksBucketList.add(b.getRandomAccessFileBucket(false));
        }
        for (x = 0; x < this.checkBlocks.size(); ++x) {
            b = this.checkBlocks.get(x);
            if (b.getSegmentNo() != segmentNo || b.getCurrentState() != 3) continue;
            this.decoder.putBucket(b.getRandomAccessFileBucket(true), dataBlocksInSegment + b.getIndexInSegment());
        }
        int[] missingDataBlockIx = new int[requestedDataBlocksIxList.size()];
        for (int x2 = 0; x2 < missingDataBlockIx.length; ++x2) {
            missingDataBlockIx[x2] = (Integer)requestedDataBlocksIxList.get(x2);
        }
        this.fecDecodeFactory.init(requestedDataBlocksBucketList);
        Bucket[] targetBuckets = new Bucket[missingDataBlockIx.length];
        this.decoder.decode(missingDataBlockIx, targetBuckets);
        logger.info("Finished decoding segment " + segmentNo);
    }

    public boolean uploadInit() {
        long fsize;
        List<String> lines;
        String slen;
        boolean splitfileExists = false;
        if (this.redirectFile.isFile() && this.redirectFile.length() > 0L && this.checkBlocksFile.isFile() && this.checkBlocksFile.length() > 0L && (slen = FecSplitfile.getValue(lines = FileAccess.readLines(this.redirectFile), "SplitFile.Size")).length() > 0 && (fsize = Long.parseLong(slen, 16)) == this.dataFile.length()) {
            splitfileExists = true;
            logger.info("Splitfile is already encoded.");
            try {
                this.initFromRedirectFile();
            }
            catch (IllegalStateException e) {
                logger.log(Level.SEVERE, "Exception thrown in uploadInit()", e);
            }
            catch (Exception e) {
                logger.log(Level.SEVERE, "Exception thrown in uploadInit()", e);
            }
        }
        if (!splitfileExists) {
            logger.info("Splitfile needs encoding.");
            this.redirectFile.delete();
            this.checkBlocksFile.delete();
        }
        return splitfileExists;
    }

    public void encode() throws Throwable {
        logger.info("Splitfile encode starts ...");
        this.fecEncodeFactory.init(this.checkBlocksFile, this.getCheckBlocksFileSize());
        RandomAccessFile raf = new RandomAccessFile(this.dataFile, "r");
        int segmentCount = this.getSegmentCount();
        for (int actSegment = 0; actSegment < segmentCount; ++actSegment) {
            int blockCount = this.getValuesForSegment((int)actSegment).dataBlockCount;
            int blockSize = this.getValuesForSegment((int)actSegment).dataBlockSize;
            long segmentStartOffset = this.getValuesForSegment((int)actSegment).segmentStartOffset;
            Bucket[] actSegmentsDataBlocks = RandomAccessFileBucket2.segment(this.dataFile, blockSize, segmentStartOffset, blockCount, true, raf);
            this.encoder.encode(actSegment, actSegmentsDataBlocks, null);
        }
        this.buildFecBlocks(true);
        if (!this.createRedirectFile(true)) {
            String emsg = "Error: Could not create the redirect file.";
            logger.severe("Error: Could not create the redirect file.");
            throw new Exception("Error: Could not create the redirect file.");
        }
        logger.info("Splitfile encode finished.");
    }

    public void closeBuckets() {
        if (this.dataBlocks != null) {
            for (FecBlock fb : this.dataBlocks) {
                fb.close();
            }
        }
        if (this.checkBlocks != null) {
            for (FecBlock fb : this.checkBlocks) {
                fb.close();
            }
        }
    }

    protected void buildFecBlocks(boolean encodeBlocks) throws Exception {
        this.dataBlocks = new ArrayList();
        this.checkBlocks = new ArrayList();
        int dataBlockIndexInFile = 0;
        int checkBlockIndexInFile = 0;
        long dataBlockOffset = 0L;
        long checkBlockOffset = 0L;
        int segmentCount = this.getSegmentCount();
        for (int actSegment = 0; actSegment < segmentCount; ++actSegment) {
            String chkKey;
            Bucket blockdata;
            FecBlock b;
            int x;
            int dataBlockIndexInSegment = 0;
            int checkBlockIndexInSegment = 0;
            int blockCount = this.getValuesForSegment((int)actSegment).dataBlockCount;
            int blockSize = this.getValuesForSegment((int)actSegment).dataBlockSize;
            int checkBlockCount = this.getValuesForSegment((int)actSegment).checkBlockCount;
            int checkBlockSize = this.getValuesForSegment((int)actSegment).checkBlockSize;
            if (encodeBlocks) {
                logger.info("Creating CHK keys for " + blockCount + " blocks...");
            }
            for (x = 0; x < blockCount; ++x) {
                b = new FecBlock(1, this.dataFile, actSegment, dataBlockIndexInSegment, dataBlockIndexInFile, blockSize, dataBlockOffset);
                if (encodeBlocks) {
                    blockdata = b.getPaddedMemoryBucket();
                    chkKey = FecTools.generateCHK(blockdata);
                    if (chkKey == null) {
                        String msg = "ERROR: could NOT generate CHK key of a splitfile data block!!!";
                        logger.severe("ERROR: could NOT generate CHK key of a splitfile data block!!!");
                        throw new Exception("ERROR: could NOT generate CHK key of a splitfile data block!!!");
                    }
                    b.setChkKey(chkKey);
                }
                dataBlockOffset += (long)blockSize;
                ++dataBlockIndexInFile;
                ++dataBlockIndexInSegment;
                this.dataBlocks.add(b);
            }
            if (encodeBlocks) {
                logger.fine("Creating CHK keys for " + checkBlockCount + " check blocks...");
            }
            for (x = 0; x < checkBlockCount; ++x) {
                b = new FecBlock(2, this.checkBlocksFile, actSegment, checkBlockIndexInSegment, checkBlockIndexInFile, checkBlockSize, checkBlockOffset);
                if (encodeBlocks) {
                    blockdata = b.getPaddedMemoryBucket();
                    chkKey = FecTools.generateCHK(blockdata);
                    if (chkKey == null) {
                        String msg = "ERROR: could NOT generate CHK key of a splitfile check block!!!";
                        logger.severe("ERROR: could NOT generate CHK key of a splitfile check block!!!");
                        throw new Exception("ERROR: could NOT generate CHK key of a splitfile check block!!!");
                    }
                    b.setChkKey(chkKey);
                }
                checkBlockOffset += (long)checkBlockSize;
                ++checkBlockIndexInFile;
                ++checkBlockIndexInSegment;
                this.checkBlocks.add(b);
            }
        }
    }

    public synchronized boolean createRedirectFile(boolean transferInProgress) {
        String s = this.getRedirectFileContent(transferInProgress);
        FileAccess.writeFile(s, this.redirectFile);
        return true;
    }

    public synchronized String getRedirectFileContent(boolean transferInProgress) {
        String blockChk;
        FecBlock fb;
        int x;
        StringBuilder redirect = new StringBuilder(512);
        redirect.append("Version\n");
        redirect.append("Revision=1\n");
        redirect.append("EndPart\n");
        redirect.append("Document\n");
        if (transferInProgress) {
            redirect.append(FROST_TRANSFER_INDICATOR).append("=true\n");
        }
        redirect.append("SplitFile.AlgoName=OnionFEC_a_1_2\n");
        redirect.append("SplitFile.Size=").append(Long.toHexString(this.dataFileSize).toLowerCase()).append("\n");
        redirect.append("SplitFile.BlockCount=").append(Integer.toHexString(this.dataBlocks.size())).append("\n");
        for (x = 0; x < this.dataBlocks.size(); ++x) {
            fb = this.dataBlocks.get(x);
            blockChk = fb.getChkKey();
            if (blockChk == null) {
                blockChk = "Error";
            }
            redirect.append("SplitFile.Block.").append(Integer.toHexString(x + 1)).append("=").append(blockChk).append("\n");
            if (!transferInProgress || fb.getCurrentState() != 3) continue;
            redirect.append(FROST_TRANSFER_FINISHED_INDICATOR).append("SplitFile.Block.").append(Integer.toHexString(x + 1)).append("=true\n");
        }
        redirect.append("SplitFile.CheckBlockCount=").append(Integer.toHexString(this.checkBlocks.size())).append("\n");
        for (x = 0; x < this.checkBlocks.size(); ++x) {
            fb = this.checkBlocks.get(x);
            blockChk = fb.getChkKey();
            if (blockChk == null) {
                blockChk = "Error";
            }
            redirect.append("SplitFile.CheckBlock.").append(Integer.toHexString(x + 1)).append("=").append(blockChk).append("\n");
            if (!transferInProgress || fb.getCurrentState() != 3) continue;
            redirect.append(FROST_TRANSFER_FINISHED_INDICATOR).append("SplitFile.CheckBlock.").append(Integer.toHexString(x + 1)).append("=true\n");
        }
        redirect.append("End\n");
        return redirect.toString();
    }

    protected void fillSegmentValues(OnionFECBase myEncoder) {
        int segmentCount = myEncoder.getSegmentCount();
        this.segmentValues = new ArrayList(segmentCount);
        this.checkBlocksFileSize = 0L;
        this.fileDataBlockCount = 0;
        this.fileCheckBlockCount = 0;
        long tmpSegmentStartOffset = 0L;
        for (int z = 0; z < segmentCount; ++z) {
            SingleSegmentValues sval = new SingleSegmentValues();
            sval.checkBlockSize = myEncoder.getCheckBlockSize(z);
            sval.checkBlockCount = myEncoder.getN(z) - myEncoder.getK(z);
            sval.dataBlockSize = myEncoder.getBlockSize(z);
            sval.dataBlockCount = myEncoder.getK(z);
            sval.segmentSize = myEncoder.getSegmentSize(z);
            sval.segmentStartOffset = tmpSegmentStartOffset;
            this.segmentValues.add(sval);
            tmpSegmentStartOffset += sval.segmentSize;
            this.checkBlocksFileSize += (long)(sval.checkBlockSize * sval.checkBlockCount);
            this.fileDataBlockCount += sval.dataBlockCount;
            this.fileCheckBlockCount += sval.checkBlockCount;
        }
    }

    public long getCheckBlocksFileSize() {
        return this.checkBlocksFileSize;
    }

    public SingleSegmentValues getValuesForSegment(int ix) {
        if (ix < 0 || ix > this.segmentValues.size()) {
            return null;
        }
        return this.segmentValues.get(ix);
    }

    public int getSegmentCount() {
        return this.segmentValues.size();
    }

    public List<FecBlock> getCheckBlocks() {
        return this.checkBlocks;
    }

    public List<FecBlock> getDataBlocks() {
        return this.dataBlocks;
    }

    public void setCorrectDatafileSize() {
        this.transferMode = 3;
        try {
            RandomAccessFile f = new RandomAccessFile(this.dataFile, "rw");
            if (f.length() > this.dataFileSize) {
                f.setLength(this.dataFileSize);
            }
            f.close();
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Exception thrown in setCorrectDatafileSize()", ex);
        }
    }

    public void finishDownload(boolean removeWorkFiles) {
        boolean ret;
        if (this.transferMode == 3 && !(ret = this.dataFile.renameTo(this.downloadTargetFile))) {
            logger.severe("ERROR: Could not move file '" + this.dataFile.getPath() + "' to '" + this.downloadTargetFile.getPath() + "'.\n" + "Maybe the locations are on different filesystems where a move is not allowed.\n" + "Please try change the location of 'temp.dir' in the frost.ini file.");
            this.dataFile = null;
        }
        if (removeWorkFiles) {
            if (this.dataFile != null && !this.dataFile.getPath().equals(this.downloadTargetFile)) {
                this.dataFile.delete();
            }
            this.redirectFile.delete();
            this.checkBlocksFile.delete();
        }
    }

    public void finishUpload(boolean removeWorkFiles) {
        this.transferMode = 3;
        if (removeWorkFiles) {
            this.redirectFile.delete();
            this.checkBlocksFile.delete();
        }
    }

    public long getDataFileSize() {
        return this.dataFileSize;
    }

    public File getRedirectFile() {
        return this.redirectFile;
    }

    protected boolean createFileOfLength(File newfile, long filelength) {
        try {
            RandomAccessFile raf = new RandomAccessFile(newfile, "rw");
            boolean fileLengthSet = false;
            try {
                raf.setLength(filelength);
                fileLengthSet = true;
                raf.close();
            }
            catch (IOException ex) {
                String msgtxt = ex.getMessage();
                try {
                    raf.close();
                }
                catch (Exception ex2) {
                    // empty catch block
                }
                newfile.delete();
                if (msgtxt.equals("There is not enough space on the disk") || msgtxt.equals("An attempt was made to move the file pointer before the beginning of the file")) {
                    logger.severe("ERROR: Could not create the work file: " + msgtxt);
                    newfile.delete();
                    return false;
                }
                logger.warning("Warning: Could not create a work file, error=" + msgtxt);
            }
            if (!fileLengthSet) {
                logger.info("Trying to use a slower creating method, starting ...");
                BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(newfile));
                for (long written = 0L; written < filelength; ++written) {
                    out.write(0);
                }
                out.close();
                logger.info("... finished to create the work file using slower creation method.");
            }
            return true;
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "createFileOfLength(File newfile, long filelength)", ex);
            newfile.delete();
            logger.severe("ERROR: Could not create the work file " + newfile.getPath());
            return false;
        }
    }

    private static String getValue(List<String> lines, String value) {
        for (int i = 0; i < lines.size(); ++i) {
            String line = lines.get(i);
            if (!line.startsWith(value + "=") && !line.startsWith(value + " ") || line.indexOf("=") == -1) continue;
            return line.substring(line.indexOf("=") + 1, line.length()).trim();
        }
        logger.fine("Setting not found: " + value);
        return "";
    }

    public class SingleSegmentValues {
        public long segmentSize;
        public long segmentStartOffset;
        public int dataBlockSize;
        public int dataBlockCount;
        public int checkBlockSize;
        public int checkBlockCount;
    }

    private class FrostFECDecodeBucketFactory
    implements BucketFactory {
        int actualIndexInBucketList;
        List bucketList;

        private FrostFECDecodeBucketFactory() {
        }

        public void init(List blist) throws IOException {
            this.bucketList = blist;
            this.actualIndexInBucketList = 0;
        }

        public Bucket makeBucket(long size) throws IOException {
            Bucket b = (Bucket)this.bucketList.get(this.actualIndexInBucketList);
            ++this.actualIndexInBucketList;
            if (b.size() != size) {
                throw new IOException("Bucket size (" + b.size() + ") differs of requested size (" + size + ") " + this.actualIndexInBucketList);
            }
            return b;
        }

        public void freeBucket(Bucket b) throws IOException {
        }
    }

    private class FrostFECEncodeBucketFactory
    implements BucketFactory {
        int checkBlockCounter = 0;
        File factoryCheckBlocksFile;
        long actFileOffset = 0L;
        RandomAccessFile raf = null;

        private FrostFECEncodeBucketFactory() {
        }

        public void init(File cBlocksFile, long myCheckBlocksFileSize) throws IOException {
            this.factoryCheckBlocksFile = cBlocksFile;
            if (this.factoryCheckBlocksFile.exists() && this.factoryCheckBlocksFile.length() == myCheckBlocksFileSize) {
                return;
            }
            this.factoryCheckBlocksFile.delete();
            boolean created = FecSplitfile.this.createFileOfLength(cBlocksFile, myCheckBlocksFileSize);
            this.raf = new RandomAccessFile(this.factoryCheckBlocksFile, "rw");
        }

        public Bucket makeBucket(long size) throws IOException {
            RandomAccessFileBucket2 b = new RandomAccessFileBucket2(this.factoryCheckBlocksFile, this.actFileOffset, size, false, this.raf);
            this.actFileOffset += size;
            return b;
        }

        public void freeBucket(Bucket b) throws IOException {
        }
    }
}

